/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.scenecfg.upgrade;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class SceneDataUpgradeService {
    private static final Log LOG = LogFactory.getLog(SceneDataUpgradeService.class);
    private static final String FIELDNUMBER = "Name";
    private static final String FIELDDISNAME = "fDName";
    private static final String FIELDPROP = "dynprop";

    public static void updateSceneData(Map<Long, Long> sceneIdMap, Map<Long, Map<String, String>> diffMatchMap) {
        LOG.info("SceneDataUpgradeService updateSceneData start");
        if (sceneIdMap == null || sceneIdMap.size() == 0) {
            LOG.info("SceneDataUpgradeService updateSceneData sceneIdMap no data");
            return;
        }
        DynamicObject[] wtcSceneInfos = SceneDataUpgradeService.getWTCSceneInfo(Lists.newArrayList(sceneIdMap.keySet()));
        DynamicObject[] hrSceneInfos = SceneDataUpgradeService.getHRSceneInfo(Lists.newArrayList(sceneIdMap.values()));
        if (wtcSceneInfos.length == 0 || hrSceneInfos.length == 0) {
            LOG.info("SceneDataUpgradeService updateSceneData query no scene data,wtcSceneInfos.size:{},hrSceneInfos.size:{}", (Object)wtcSceneInfos.length, (Object)hrSceneInfos.length);
            return;
        }
        Map wtcSceneMap = Arrays.stream(wtcSceneInfos).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        Map<Long, DynamicObjectCollection> hrSceneEntryMap = Arrays.stream(hrSceneInfos).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getDynamicObjectCollection("sceneinputparams")));
        for (Map.Entry wtcSceneEntry : wtcSceneMap.entrySet()) {
            Long wtcSceneId = wtcSceneEntry.getKey();
            Long hrSceneId = sceneIdMap.get(wtcSceneId);
            if (hrSceneId == null) {
                LOG.info("SceneDataUpgradeService no hr scene data, wtcSceneId:{},hrSceneId:{}", (Object)wtcSceneId, (Object)hrSceneId);
                continue;
            }
            DynamicObjectCollection hrSceneEntry = hrSceneEntryMap.get(hrSceneId);
            if (CollectionUtils.isEmpty((Collection)hrSceneEntry)) {
                LOG.info("SceneDataUpgradeService no hr scene entry data, wtcSceneId:{},hrSceneId:{}", (Object)wtcSceneId, (Object)hrSceneId);
                continue;
            }
            Map<String, String> sceneDiffMatchMap = diffMatchMap.get(hrSceneId);
            Map<String, String> fieldDisplayNameMap = SceneDataUpgradeService.convertDisplayNameMap(hrSceneEntry, sceneDiffMatchMap);
            SceneDataUpgradeService.updateWTCFieldDisplayName((DynamicObject)wtcSceneEntry.getValue(), fieldDisplayNameMap);
        }
        HRBaseServiceHelper.create((String)"wtbd_scenerulecfg").update(wtcSceneInfos);
        LOG.info("SceneDataUpgradeService updateSceneData end");
    }

    private static void updateWTCFieldDisplayName(DynamicObject wtcScene, Map<String, String> fieldDisplayNameMap) {
        DynamicObjectCollection wtcSceneEntry = wtcScene.getDynamicObjectCollection("entryentity");
        wtcSceneEntry.forEach(entry -> {
            String dynProp = entry.getString(FIELDPROP);
            if (HRStringUtils.isNotEmpty((String)dynProp)) {
                List dynPropList = SerializationUtils.fromJsonStringToList((String)dynProp, Map.class);
                dynPropList.forEach(item -> {
                    String displayName;
                    String fieldName = (String)item.get(FIELDNUMBER);
                    if (fieldDisplayNameMap != null && fieldDisplayNameMap.size() > 0 && HRStringUtils.isNotEmpty((String)(displayName = (String)fieldDisplayNameMap.get(fieldName)))) {
                        item.put(FIELDDISNAME, displayName);
                    }
                });
                entry.set(FIELDPROP, (Object)SerializationUtils.toJsonString((Object)dynPropList));
            }
        });
    }

    private static Map<String, String> convertDisplayNameMap(DynamicObjectCollection hrSceneEntry, Map<String, String> sceneDiffMatchMap) {
        HashMap fieldDisplayNameMap = Maps.newHashMapWithExpectedSize((int)16);
        hrSceneEntry.forEach(entry -> {
            String inputDynProp = entry.getString("inputdynprop");
            if (HRStringUtils.isNotEmpty((String)inputDynProp)) {
                List dynPropList = SerializationUtils.fromJsonStringToList((String)inputDynProp, Map.class);
                dynPropList.forEach(item -> {
                    String wtcFieldName;
                    String fieldName = (String)item.get(FIELDNUMBER);
                    String displayName = (String)item.get(FIELDDISNAME);
                    if (HRStringUtils.isEmpty((String)displayName)) {
                        displayName = (String)item.get("fName");
                    }
                    if (sceneDiffMatchMap != null && sceneDiffMatchMap.size() > 0 && HRStringUtils.isNotEmpty((String)(wtcFieldName = (String)sceneDiffMatchMap.get(fieldName)))) {
                        fieldName = wtcFieldName;
                    }
                    fieldDisplayNameMap.put(fieldName, displayName);
                });
            }
        });
        return fieldDisplayNameMap;
    }

    private static DynamicObject[] getWTCSceneInfo(List<Long> wtcSceneIds) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenerulecfg");
        QFilter qFilter = new QFilter("id", "in", wtcSceneIds);
        DynamicObject[] sceneDys = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        return sceneDys;
    }

    private static DynamicObject[] getHRSceneInfo(List<Long> hrSceneIds) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"brm_scene");
        QFilter qFilter = new QFilter("id", "in", hrSceneIds);
        DynamicObject[] sceneDys = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        return sceneDys;
    }
}

