/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.scenecfg.upgrade;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.business.scenecfg.upgrade.SceneDynPropVo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class SceneInputMultiLangUpgradeService {
    private static final Log LOG = LogFactory.getLog(SceneInputMultiLangUpgradeService.class);
    private static final HRBaseServiceHelper SCENE_HELPER = new HRBaseServiceHelper("brm_scene");
    private static final HRBaseServiceHelper WTC_SCENEINPUTLOG_HELPER = new HRBaseServiceHelper("wtbd_sceneinputlog");
    private static final List<String> NUMBER_LIST = new ArrayList<String>(16);

    public void process() {
        LOG.info("SceneInputDataMultiLangUpgradeImpl start process...");
        ArrayList<DynamicObject> logDyList = new ArrayList<DynamicObject>(100);
        ArrayList<DynamicObject> needUpdateSceneInputList = new ArrayList<DynamicObject>(20);
        this.querySceneInputData(logDyList, needUpdateSceneInputList);
        if (WTCCollections.isEmpty(needUpdateSceneInputList)) {
            LOG.info("SceneInputDataMultiLangUpgradeImpl without data need to update ...");
            return;
        }
        try {
            LOG.info("SceneInputDataMultiLangUpgradeImpl start ...");
            SCENE_HELPER.updateDatas(needUpdateSceneInputList.toArray(new DynamicObject[0]));
            LOG.info("SceneInputDataMultiLangUpgradeImpl end ...");
        }
        catch (Exception exception) {
            LOG.warn("SceneInputDataMultiLangUpgradeImpl process  error ...", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
        }
        if (CollectionUtils.isEmpty(logDyList)) {
            LOG.info("SceneInputDataMultiLangUpgradeImpl.upgrade LogDyList is empty");
            return;
        }
        WTC_SCENEINPUTLOG_HELPER.updateDatas(logDyList.toArray(new DynamicObject[0]));
        LOG.info("SceneInputDataMultiLangUpgradeImpl.upgrade t_wtbd_sceneinputlog is success ");
    }

    private void querySceneInputData(List<DynamicObject> logDyList, List<DynamicObject> needUpdateSceneInputList) {
        QFilter filter = new QFilter("issyspreset", "=", (Object)true);
        filter.and(new QFilter("number", "in", NUMBER_LIST));
        filter.and(new QFilter("sceneinputparams.inputparamstype", "=", (Object)"dynamicObject"));
        filter.and(new QFilter("sceneinputparams.inputissyspreset", "=", (Object)true));
        DynamicObject[] dyArr = SCENE_HELPER.query("id,number,sceneinputparams,sceneinputparams.id,sceneinputparams.inputdynprop", new QFilter[]{filter});
        if (dyArr == null || dyArr.length == 0) {
            return;
        }
        Date date = new Date();
        for (DynamicObject dy : dyArr) {
            String number = dy.getString("number");
            DynamicObjectCollection collection = dy.getDynamicObjectCollection("sceneinputparams");
            if (WTCCollections.isEmpty((Collection)collection)) continue;
            boolean needUpdateDy = false;
            for (DynamicObject sceneInputParam : collection) {
                long entryId = sceneInputParam.getLong("id");
                boolean needUpdate = false;
                String oldInputDynProp = sceneInputParam.getString("inputdynprop");
                List sceneDynPropVoList = JSONArray.parseArray((String)oldInputDynProp, SceneDynPropVo.class);
                if (WTCCollections.isEmpty((Collection)sceneDynPropVoList)) continue;
                ArrayList mapList = new ArrayList(10);
                for (SceneDynPropVo sceneDynPropVo : sceneDynPropVoList) {
                    String fDName = sceneDynPropVo.getfDName();
                    String fName = sceneDynPropVo.getfName();
                    if (fName.equals(fDName)) {
                        needUpdate = true;
                        sceneDynPropVo.setfDName("");
                    }
                    HashMap<String, String> map = new HashMap<String, String>(6);
                    map.put("fDName", sceneDynPropVo.getfDName());
                    map.put("_Type_", sceneDynPropVo.get_Type_());
                    map.put("fName", sceneDynPropVo.getfName());
                    map.put("Name", sceneDynPropVo.getName());
                    mapList.add(map);
                }
                if (!needUpdate) continue;
                String newDynProp = JSONArray.toJSONString(mapList);
                needUpdateDy = true;
                sceneInputParam.set("inputdynprop", (Object)newDynProp);
                DynamicObject logDy = WTC_SCENEINPUTLOG_HELPER.generateEmptyDynamicObject();
                logDy.set("number", (Object)number);
                logDy.set("entryid", (Object)entryId);
                logDy.set("oldinputdynprop", (Object)oldInputDynProp);
                logDy.set("newinputdynprop", (Object)newDynProp);
                logDy.set("type", (Object)"sceneinput_upgrade");
                logDy.set("modifytime", (Object)date);
                logDyList.add(logDy);
            }
            if (!needUpdateDy) continue;
            needUpdateSceneInputList.add(dy);
        }
    }

    static {
        NUMBER_LIST.add("coordination_bd_country");
        NUMBER_LIST.add("coordination_hbss_empgroup");
        NUMBER_LIST.add("coordination_hbss_workplace");
        NUMBER_LIST.add("coordination_inte_timezone");
        NUMBER_LIST.add("coordination_wtbd_attendtag");
        NUMBER_LIST.add("coordination_wtbd_workschedule");
        NUMBER_LIST.add("coordination_wtp_attendplan");
        NUMBER_LIST.add("coordination_wtp_attperiod");
        NUMBER_LIST.add("coordination_wtp_cardschedule");
        NUMBER_LIST.add("coordination_wtp_exscheme");
        NUMBER_LIST.add("coordination_wtp_foscheme");
        NUMBER_LIST.add("coordination_wtp_incdecplan");
        NUMBER_LIST.add("coordination_wtp_modeschedule");
        NUMBER_LIST.add("coordination_wtp_otplan");
        NUMBER_LIST.add("coordination_wtp_qtscheme");
        NUMBER_LIST.add("coordination_wtp_suppleplan");
        NUMBER_LIST.add("coordination_wtp_swshiftscheme");
        NUMBER_LIST.add("coordination_wtp_taplan");
        NUMBER_LIST.add("coordination_wtp_vacationplan");
        NUMBER_LIST.add("ex_config_limitedcondition");
        NUMBER_LIST.add("ex_config_settingcondition");
        NUMBER_LIST.add("wtc_msgcountrule");
        NUMBER_LIST.add("wtc_scene_ad_v2");
        NUMBER_LIST.add("wtc_scene_attendplan_v2");
        NUMBER_LIST.add("wtc_scene_exception");
        NUMBER_LIST.add("wtc_scene_exception_v2");
        NUMBER_LIST.add("wtc_scene_formula");
        NUMBER_LIST.add("wtc_scene_idp_v2");
        NUMBER_LIST.add("wtc_scene_limitscope");
        NUMBER_LIST.add("wtc_scene_mobilescheme");
        NUMBER_LIST.add("wtc_scene_orgfilter");
        NUMBER_LIST.add("wtc_scene_otp_v2");
        NUMBER_LIST.add("wtc_scene_otp_v3");
        NUMBER_LIST.add("wtc_scene_peoplefilter");
        NUMBER_LIST.add("wtc_scene_quota_v2");
        NUMBER_LIST.add("wtc_scene_swshift");
        NUMBER_LIST.add("wtc_scene_tp_v2");
        NUMBER_LIST.add("wtc_scene_vacation");
        NUMBER_LIST.add("wtc_scene_vacation_v2");
        NUMBER_LIST.add("wtc_wtbd_daterange");
        NUMBER_LIST.add("wtc_wtbd_simpledaterange");
        NUMBER_LIST.add("wtc_wtp_otdaterange");
        NUMBER_LIST.add("wtc_wtte_attcalculate");
        NUMBER_LIST.add("wtc_wtte_pairtime");
        NUMBER_LIST.add("wtp_attendconfig_shiftcondition");
        NUMBER_LIST.add("wtp_otruledatereange");
        NUMBER_LIST.add("wtp_qtgencondition");
        NUMBER_LIST.add("wtp_traveldaterangestd");
        NUMBER_LIST.add("wtp_travelsimpledaterange");
        NUMBER_LIST.add("wtp_vadaterangestd");
        NUMBER_LIST.add("wtp_vasimpledaterange");
        NUMBER_LIST.add("wtc_scene_cul");
        NUMBER_LIST.add("wtc_sense_work_overtime");
        NUMBER_LIST.add("wtc_scene_mobilescheme");
        NUMBER_LIST.add("wtc_scene_attendplan");
        NUMBER_LIST.add("wtc_scene_idp");
        NUMBER_LIST.add("wtc_scene_ad");
        NUMBER_LIST.add("wtc_scene_otp");
        NUMBER_LIST.add("wtc_scene_tp");
    }
}

