/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.scenecfg.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.business.scenecfg.upgrade.ChangeValueLogVo;
import kd.wtc.wtbd.common.constants.retrieval.PreDataRetrievalGroup;
import kd.wtc.wtbd.common.constants.retrieval.PreDataRetrievalRule;
import kd.wtc.wtbd.common.constants.retrieval.PreDataScene;
import kd.wtc.wtbs.common.util.WTCCollections;
import org.apache.commons.lang3.StringUtils;

public class SceneToRetrievalItemUpgradeService {
    private static final Log LOG = LogFactory.getLog(SceneToRetrievalItemUpgradeService.class);
    private final HRBaseServiceHelper retrievalGroupHelper = new HRBaseServiceHelper("wtbd_retrievalgroup");
    private final HRBaseServiceHelper sceneBaseHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private final HRBaseServiceHelper sceneRuleHelper = new HRBaseServiceHelper("wtbd_scenerulecfg");
    private final HRBaseServiceHelper brmSceneHelper = new HRBaseServiceHelper("brm_scene");
    private static final String INSERT_SQL = "insert into t_wtbd_sceneinputlog(fid,fnumber,fentryid,folddynprop,fnewdynprop,ftype,fmodifytime) values(?,?,?,?,?,?,?);";
    private static final Long PRE_RULE_SCENE_CONDITION_ID = 1925628769997948928L;
    private static final String SCENE_NAME = "Name";
    private static final String SCENE_FNAME = "fName";
    private static final String SCENE_FDNAME = "fDName";
    private final Map<Long, Long> sceneToRetrievalRuleIdMap = new HashMap<Long, Long>(){
        {
            this.put(PreDataScene.SCENE_1010_S, PreDataRetrievalRule.PD_1090_S);
            this.put(PreDataScene.SCENE_1020_S, PreDataRetrievalRule.PD_1100_S);
            this.put(PreDataScene.SCENE_1030_S, PreDataRetrievalRule.PD_1110_S);
            this.put(PreDataScene.SCENE_1040_S, PreDataRetrievalRule.PD_1120_S);
            this.put(PreDataScene.SCENE_1050_S, PreDataRetrievalRule.PD_1130_S);
            this.put(PreDataScene.SCENE_1060_S, PreDataRetrievalRule.PD_1140_S);
            this.put(PreDataScene.SCENE_1070_S, PreDataRetrievalRule.PD_1150_S);
            this.put(PreDataScene.SCENE_1080_S, PreDataRetrievalRule.PD_1160_S);
            this.put(PreDataScene.SCENE_1090_S, PreDataRetrievalRule.PD_1170_S);
        }
    };
    private final Map<Long, Long> sceneToBasePropertyGroupIdMap = new HashMap<Long, Long>(){
        {
            this.put(PreDataScene.SCENE_1010_S, PreDataRetrievalGroup.CT_1300_S);
            this.put(PreDataScene.SCENE_1020_S, PreDataRetrievalGroup.CT_1302_S);
            this.put(PreDataScene.SCENE_1030_S, PreDataRetrievalGroup.CT_1302_S);
            this.put(PreDataScene.SCENE_1040_S, PreDataRetrievalGroup.CT_1302_S);
            this.put(PreDataScene.SCENE_1050_S, PreDataRetrievalGroup.CT_1306_S);
            this.put(PreDataScene.SCENE_1060_S, PreDataRetrievalGroup.CT_1306_S);
            this.put(PreDataScene.SCENE_1070_S, PreDataRetrievalGroup.CT_1306_S);
            this.put(PreDataScene.SCENE_1080_S, PreDataRetrievalGroup.CT_1304_S);
            this.put(PreDataScene.SCENE_1090_S, PreDataRetrievalGroup.CT_1304_S);
        }
    };
    private final Map<Long, Long> sceneToBaseDataGroupIdMap = new HashMap<Long, Long>(){
        {
            this.put(PreDataScene.SCENE_1010_S, PreDataRetrievalGroup.CT_1301_S);
            this.put(PreDataScene.SCENE_1020_S, PreDataRetrievalGroup.CT_1303_S);
            this.put(PreDataScene.SCENE_1030_S, PreDataRetrievalGroup.CT_1303_S);
            this.put(PreDataScene.SCENE_1040_S, PreDataRetrievalGroup.CT_1303_S);
            this.put(PreDataScene.SCENE_1050_S, PreDataRetrievalGroup.CT_1307_S);
            this.put(PreDataScene.SCENE_1060_S, PreDataRetrievalGroup.CT_1307_S);
            this.put(PreDataScene.SCENE_1070_S, PreDataRetrievalGroup.CT_1307_S);
            this.put(PreDataScene.SCENE_1080_S, PreDataRetrievalGroup.CT_1305_S);
            this.put(PreDataScene.SCENE_1090_S, PreDataRetrievalGroup.CT_1305_S);
        }
    };
    private final Map<Long, Long> conditionIdMap = new HashMap<Long, Long>(){
        {
            this.put(PreDataScene.SCENE_1070_S, PreDataScene.SCENE_1040_S);
        }
    };
    private final Map<Long, String> sceneToUnicodePrefixMap = new HashMap<Long, String>(){
        {
            this.put(PreDataScene.SCENE_1010_S, "QT$");
            this.put(PreDataScene.SCENE_1020_S, "TP$");
            this.put(PreDataScene.SCENE_1030_S, "TP$");
            this.put(PreDataScene.SCENE_1040_S, "TP$");
            this.put(PreDataScene.SCENE_1050_S, "VA$");
            this.put(PreDataScene.SCENE_1060_S, "VA$");
            this.put(PreDataScene.SCENE_1070_S, "VA$");
            this.put(PreDataScene.SCENE_1080_S, "EX$");
            this.put(PreDataScene.SCENE_1090_S, "EX$");
        }
    };
    private static final String REPEAT_NUMBERX_SUFFIX = ".*_\\d{4}$";
    private final SecureRandom random = new SecureRandom();

    public boolean process() {
        LOG.info("SceneToRetrievalItemUpgradeService start process...");
        return this.upgradeSceneToRetrievalRule();
    }

    private boolean upgradeSceneToRetrievalRule() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ids.addAll(Lists.newArrayList((Object[])new Long[]{PreDataScene.SCENE_1010_S}));
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] baseDys = this.brmSceneHelper.loadDynamicObjectArray(qFilters);
        if (baseDys == null) {
            return true;
        }
        DynamicObject[] existItemDys = this.sceneBaseHelper.query("id,numberx", new QFilter[0]);
        HashMap<String, List<Long>> numberxMap = new HashMap<String, List<Long>>();
        Arrays.stream(existItemDys).forEach(itemDy -> {
            String numberx = itemDy.getString("numberx");
            if (!numberxMap.containsKey(numberx)) {
                numberxMap.put(numberx, new ArrayList(1));
            }
            ((List)numberxMap.get(numberx)).add(itemDy.getLong("id"));
        });
        HashMap<Long, DynamicObject> sceneDyMaps = new HashMap<Long, DynamicObject>(16);
        Arrays.stream(baseDys).forEach(baseDy -> sceneDyMaps.put(baseDy.getLong("id"), (DynamicObject)baseDy));
        Map<Long, Map<String, Map<String, String>>> idToParamInfoMap = this.getIdToParamInfoMap(ids, sceneDyMaps);
        LOG.info("idToParamInfoMap={}", (Object)SerializationUtils.toJsonString(idToParamInfoMap));
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            try (TXHandle txHandle = TX.required();){
                this.upgradeSceneToRetrievalRule((DynamicObject)sceneDyMaps.get(id), idToParamInfoMap, id, numberxMap);
                this.upgradeConditionValue(id, idToParamInfoMap);
                DynamicObject sceneDy = (DynamicObject)sceneDyMaps.get(id);
                ArrayList<ChangeValueLogVo> changeValueLogVoList = new ArrayList<ChangeValueLogVo>(1);
                changeValueLogVoList.add(new ChangeValueLogVo(sceneDy.getString("number"), sceneDy.getLong("id"), "", SerializationUtils.toJsonString((Object)sceneDy)));
                this.insertLog(changeValueLogVoList, "scenejson_upgrade");
            }
        }
        return true;
    }

    private void upgradeConditionValue(long sourceSceneId, Map<Long, Map<String, Map<String, String>>> idToParamInfoMap) {
        if (sourceSceneId == PreDataScene.SCENE_1010_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_qtgenconfig", "entryentity", new String[]{"conditionfilter"});
            return;
        }
        if (sourceSceneId == PreDataScene.SCENE_1030_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_travelmeter", new String[]{"daterangecondition"});
            return;
        }
        if (sourceSceneId == PreDataScene.SCENE_1020_S || sourceSceneId == PreDataScene.SCENE_1040_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_tarvelrule", "entryentity", new String[]{"daterangecondition", "limitscope"});
            return;
        }
        if (sourceSceneId == PreDataScene.SCENE_1060_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_vabaseset", new String[]{"daterangecondition"});
            return;
        }
        if (sourceSceneId == PreDataScene.SCENE_1050_S || sourceSceneId == PreDataScene.SCENE_1070_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_varule", "entryentity", new String[]{"daterangecondition", "limitscope"});
            return;
        }
        if (sourceSceneId == PreDataScene.SCENE_1080_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_exconfig");
            return;
        }
        if (sourceSceneId == PreDataScene.SCENE_1090_S) {
            this.doUpgradeConditionValue(idToParamInfoMap, sourceSceneId, "wtp_exconfig", "entryentity", new String[]{"conditionfilter"});
        }
    }

    private void doUpgradeConditionValue(Map<Long, Map<String, Map<String, String>>> idToParamInfoMap, long sourceSceneId, String entityNumber, String entryNumber, String[] entryFields) {
        DynamicObject[] ruleDys;
        ArrayList<ChangeValueLogVo> changeValueLogVoList = new ArrayList<ChangeValueLogVo>(10);
        ArrayList<DynamicObject> upgradeDys = new ArrayList<DynamicObject>(10);
        HRBaseServiceHelper baseServiceHelper = HRBaseServiceHelper.create((String)entityNumber);
        for (DynamicObject dy : ruleDys = baseServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
            boolean needUpgrade = false;
            DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection(entryNumber);
            if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
            for (DynamicObject entry : entryEntity) {
                for (String entryField : entryFields) {
                    Map<String, Object> result = this.getParamNeedUpgradeResult(idToParamInfoMap.get(sourceSceneId), entry.getString(entryField));
                    if (!((Boolean)result.get("needUpgrade")).booleanValue()) continue;
                    changeValueLogVoList.add(new ChangeValueLogVo(entityNumber, entry.getLong("id"), result.get("conditionValue").toString(), entry.getString(entryField)));
                    entry.set(entryField, result.get("conditionValue"));
                    needUpgrade = true;
                }
            }
            if (!needUpgrade) continue;
            upgradeDys.add(dy);
        }
        if (WTCCollections.isNotEmpty(upgradeDys)) {
            baseServiceHelper.save(upgradeDys.toArray(new DynamicObject[0]));
        }
        this.insertLog(changeValueLogVoList, "rulecondition_upgrade");
    }

    private void doUpgradeConditionValue(Map<Long, Map<String, Map<String, String>>> idToParamInfoMap, long sourceSceneId, String entityNumber, String[] fields) {
        DynamicObject[] ruleDys;
        ArrayList<ChangeValueLogVo> changeValueLogVoList = new ArrayList<ChangeValueLogVo>(10);
        ArrayList<DynamicObject> upgradeDys = new ArrayList<DynamicObject>(10);
        HRBaseServiceHelper baseServiceHelper = HRBaseServiceHelper.create((String)entityNumber);
        for (DynamicObject dy : ruleDys = baseServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
            boolean needUpgrade = false;
            for (String field : fields) {
                Map<String, Object> result = this.getParamNeedUpgradeResult(idToParamInfoMap.get(sourceSceneId), dy.getString(field));
                if (!((Boolean)result.get("needUpgrade")).booleanValue()) continue;
                changeValueLogVoList.add(new ChangeValueLogVo(entityNumber, dy.getLong("id"), result.get("conditionValue").toString(), dy.getString(field)));
                dy.set(field, result.get("conditionValue"));
                needUpgrade = true;
            }
            if (!needUpgrade) continue;
            upgradeDys.add(dy);
        }
        if (WTCCollections.isNotEmpty(upgradeDys)) {
            baseServiceHelper.save(upgradeDys.toArray(new DynamicObject[0]));
        }
        this.insertLog(changeValueLogVoList, "rulecondition_upgrade");
    }

    private void doUpgradeConditionValue(Map<Long, Map<String, Map<String, String>>> idToParamInfoMap, long sourceSceneId, String entityNumber) {
        DynamicObject[] ruleDys;
        ArrayList<ChangeValueLogVo> changeValueLogVoList = new ArrayList<ChangeValueLogVo>(10);
        ArrayList<DynamicObject> upgradeDys = new ArrayList<DynamicObject>(10);
        HRBaseServiceHelper baseServiceHelper = HRBaseServiceHelper.create((String)"wtbd_daterange");
        for (DynamicObject dy : ruleDys = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("metanumber", "=", (Object)entityNumber)})) {
            boolean needUpgrade = false;
            Map<String, Object> result = this.getParamNeedUpgradeResult(idToParamInfoMap.get(sourceSceneId), dy.getString("conditions"));
            if (((Boolean)result.get("needUpgrade")).booleanValue()) {
                changeValueLogVoList.add(new ChangeValueLogVo(entityNumber, dy.getLong("id"), result.get("conditionValue").toString(), dy.getString("conditions")));
                dy.set("conditions", result.get("conditionValue"));
                needUpgrade = true;
            }
            if (!needUpgrade) continue;
            upgradeDys.add(dy);
        }
        if (WTCCollections.isNotEmpty(upgradeDys)) {
            baseServiceHelper.save(upgradeDys.toArray(new DynamicObject[0]));
        }
        this.insertLog(changeValueLogVoList, "rulecondition_upgrade");
    }

    private Map<String, Object> getParamNeedUpgradeResult(Map<String, Map<String, String>> paramInfoMaps, String conditionStr) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("needUpgrade", false);
        HashMap param1ToParamMap = new HashMap(16);
        paramInfoMaps.values().forEach(paramInfoMap -> {
            String cfr_ignored_0 = (String)param1ToParamMap.put(paramInfoMap.get("param1"), paramInfoMap.get("param"));
        });
        if (HRStringUtils.isNotEmpty((String)conditionStr)) {
            JSONObject jsObj = JSON.parseObject((String)conditionStr);
            if (jsObj.containsKey((Object)"conditionList")) {
                JSONArray conditionList = jsObj.getJSONArray("conditionList");
                for (int i = 0; i < conditionList.size(); ++i) {
                    String conditionParam = conditionList.getJSONObject(i).getString("param");
                    if (!HRStringUtils.isNotEmpty((String)conditionParam) || !param1ToParamMap.containsKey(conditionParam)) continue;
                    result.put("needUpgrade", true);
                    conditionList.getJSONObject(i).put("param1", (Object)conditionParam);
                    conditionList.getJSONObject(i).put("param", param1ToParamMap.get(conditionParam));
                }
            }
            result.put("conditionValue", jsObj.toString());
        }
        return result;
    }

    private boolean upgradeSceneToRetrievalRule(DynamicObject sceneDy, Map<Long, Map<String, Map<String, String>>> idToParamInfoMap, long sourceSceneId, Map<String, List<Long>> numberxMap) {
        List<Object> dyItemList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> dyGroupList = new ArrayList<DynamicObject>(16);
        this.buildRetrievalItem(sceneDy, dyItemList, dyGroupList, sourceSceneId, numberxMap);
        long ruleId = this.sceneToRetrievalRuleIdMap.get(sourceSceneId);
        DynamicObject ruleDy = this.sceneRuleHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
        if (ruleDy == null) {
            LOG.warn("SceneToRetrievalItemUpgradeService sceneRule is empty");
            return true;
        }
        String beforeRuleData = SerializationUtils.toJsonString((Object)ruleDy);
        dyItemList = dyItemList.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("numberx"))).collect(Collectors.toList());
        this.buildSceneRule(dyItemList, dyGroupList, ruleDy, idToParamInfoMap, sourceSceneId);
        LOG.info("SceneToRetrievalItemUpgradeService start ...");
        this.retrievalGroupHelper.save(dyGroupList.toArray(new DynamicObject[0]));
        this.sceneBaseHelper.save(dyItemList.toArray(new DynamicObject[0]));
        this.sceneRuleHelper.saveOne(ruleDy);
        LOG.info("SceneToRetrievalItemUpgradeService end ...");
        ArrayList<ChangeValueLogVo> changeValueLogVoList = new ArrayList<ChangeValueLogVo>(10);
        dyItemList.forEach(dyItem -> changeValueLogVoList.add(new ChangeValueLogVo(dyItem.getString("number"), dyItem.getLong("id"), SerializationUtils.toJsonString((Object)dyItem), "")));
        dyGroupList.forEach(dyGroup -> changeValueLogVoList.add(new ChangeValueLogVo(dyGroup.getString("number"), dyGroup.getLong("id"), SerializationUtils.toJsonString((Object)dyGroup), "")));
        changeValueLogVoList.add(new ChangeValueLogVo(ruleDy.getString("number"), ruleDy.getLong("id"), SerializationUtils.toJsonString((Object)ruleDy), beforeRuleData));
        this.insertLog(changeValueLogVoList, "rtvlrule_upgrade");
        return true;
    }

    private Map<Long, Map<String, Map<String, String>>> getIdToParamInfoMap(List<Long> sceneIds, Map<Long, DynamicObject> sceneDyMaps) {
        HashMap<Long, Map<String, Map<String, String>>> idToParamInfoMap = new HashMap<Long, Map<String, Map<String, String>>>(16);
        for (Long sceneId : sceneIds) {
            if (!sceneDyMaps.containsKey(sceneId)) continue;
            long basePropertyGroup = this.sceneToBasePropertyGroupIdMap.get(sceneId);
            long baseDataGroup = this.sceneToBaseDataGroupIdMap.get(sceneId);
            HashMap inputMap = new HashMap(16);
            DynamicObjectCollection sceneInputParams = sceneDyMaps.get(sceneId).getDynamicObjectCollection("sceneinputparams");
            for (DynamicObject sceneInputParam : sceneInputParams) {
                boolean isPreset = sceneInputParam.getBoolean("inputissyspreset");
                if (isPreset) continue;
                String inputParamType = sceneInputParam.getString("inputparamstype");
                HashMap<String, String> paramInfo = new HashMap<String, String>(5);
                switch (inputParamType) {
                    case "string": 
                    case "number": 
                    case "boolean": 
                    case "date": 
                    case "enum": {
                        DynamicObject basePropertyGroupDy = this.retrievalGroupHelper.loadSingle((Object)basePropertyGroup);
                        paramInfo.put("param", basePropertyGroupDy.get("numberx") + "." + sceneInputParam.getString("inputnumber"));
                        paramInfo.put("param1", sceneInputParam.getString("inputnumber"));
                        paramInfo.put("displayName", null);
                        paramInfo.put("sceneName", sceneInputParam.getString("inputname"));
                        paramInfo.put("type", inputParamType);
                        inputMap.put(sceneInputParam.getString("inputnumber"), paramInfo);
                        break;
                    }
                    case "basedata": {
                        DynamicObject baseDataGroupDy = this.retrievalGroupHelper.loadSingle((Object)baseDataGroup);
                        String basedataNumber = sceneInputParam.getString("inputobject.id");
                        paramInfo.put("param", baseDataGroupDy.get("numberx") + "." + basedataNumber + '.' + "id");
                        paramInfo.put("param1", sceneInputParam.getString("inputnumber") + '.' + basedataNumber + '.' + "id");
                        paramInfo.put("displayName", null);
                        paramInfo.put("sceneName", sceneInputParam.getString("inputname"));
                        paramInfo.put("type", "dynamicObject");
                        inputMap.put(sceneInputParam.getString("inputnumber"), paramInfo);
                        break;
                    }
                    case "dynamicObject": {
                        String dyNumber = sceneInputParam.getString("inputobject.id");
                        String dynProp = sceneInputParam.getString("inputdynprop");
                        List maps = SerializationUtils.fromJsonStringToList((String)dynProp, Map.class);
                        IDataEntityProperty property = null;
                        MainEntityType dataEntityType = this.getMainEntityType(dyNumber);
                        for (Map map : maps) {
                            if (null != dataEntityType) {
                                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                                property = (IDataEntityProperty)properties.get(map.get(SCENE_NAME));
                            }
                            if (null == property) continue;
                            paramInfo = new HashMap(5);
                            String fieldType = this.getFieldTypeFormProperty(property);
                            if (HRStringUtils.equals((String)"dynamicObject", (String)fieldType)) {
                                paramInfo.put("param1", sceneInputParam.getString("inputnumber") + '.' + dyNumber + '.' + (String)map.get(SCENE_NAME) + '.' + "id");
                                paramInfo.put("param", sceneInputParam.getString("inputnumber") + '.' + dyNumber + '.' + (String)map.get(SCENE_NAME) + '.' + "id");
                            } else {
                                paramInfo.put("param1", sceneInputParam.getString("inputnumber") + '.' + dyNumber + '.' + (String)map.get(SCENE_NAME));
                                paramInfo.put("param", sceneInputParam.getString("inputnumber") + '.' + dyNumber + '.' + (String)map.get(SCENE_NAME));
                            }
                            paramInfo.put("displayName", (String)map.get(SCENE_FDNAME));
                            paramInfo.put("sceneName", sceneInputParam.getString("inputname"));
                            paramInfo.put("type", fieldType);
                            inputMap.put(sceneInputParam.getString("inputnumber") + '.' + (String)map.get(SCENE_NAME), paramInfo);
                        }
                        paramInfo = new HashMap(5);
                        paramInfo.put("param", sceneInputParam.getString("inputnumber"));
                        paramInfo.put("param1", sceneInputParam.getString("inputnumber"));
                        paramInfo.put("displayName", null);
                        paramInfo.put("sceneName", sceneInputParam.getString("inputname"));
                        paramInfo.put("type", null);
                        inputMap.put(sceneInputParam.getString("inputnumber"), paramInfo);
                        break;
                    }
                }
            }
            idToParamInfoMap.put(sceneId, inputMap);
        }
        for (Long sceneId : sceneIds) {
            if (!this.conditionIdMap.containsKey(sceneId)) continue;
            idToParamInfoMap.put(sceneId, (Map<String, Map<String, String>>)idToParamInfoMap.get(this.conditionIdMap.get(sceneId)));
            sceneDyMaps.put(sceneId, sceneDyMaps.get(this.conditionIdMap.get(sceneId)));
        }
        return idToParamInfoMap;
    }

    private void buildSceneRule(List<DynamicObject> dyItemList, List<DynamicObject> dyGroupList, DynamicObject ruleDy, Map<Long, Map<String, Map<String, String>>> idToParamInfoMap, long sourceSceneId) {
        Map<Long, List<DynamicObject>> map = dyItemList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("parent")));
        if (WTCCollections.isEmpty(idToParamInfoMap.get(sourceSceneId))) {
            return;
        }
        ArrayList<Long> fixedGroupIds = new ArrayList<Long>();
        fixedGroupIds.add(this.sceneToBasePropertyGroupIdMap.get(sourceSceneId));
        fixedGroupIds.add(this.sceneToBaseDataGroupIdMap.get(sourceSceneId));
        DynamicObject[] fixedGroupDys = this.retrievalGroupHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", fixedGroupIds)});
        HashSet<DynamicObject> allDyGroupList = new HashSet<DynamicObject>(dyGroupList);
        allDyGroupList.addAll(Arrays.stream(fixedGroupDys).collect(Collectors.toSet()));
        for (DynamicObject groupDy : allDyGroupList) {
            DynamicObject dynamicObject;
            String inputNumber = groupDy.getString("numberx");
            long groupId = groupDy.getLong("id");
            List<DynamicObject> dynamicObjects = map.get(groupId);
            if (dynamicObjects == null) continue;
            DynamicObjectCollection dynamicObjectCollection = ruleDy.getDynamicObjectCollection("entryentity");
            List existGroupDys = dynamicObjectCollection.stream().filter(entry -> entry.getLong("inputobject.id") == groupId).collect(Collectors.toList());
            if (WTCCollections.isEmpty(existGroupDys)) {
                dynamicObject = dynamicObjectCollection.addNew();
                dynamicObject.set("inputnumber", (Object)inputNumber);
                dynamicObject.set("inputname", (Object)groupDy.getString("name"));
                dynamicObject.set("inputobject", (Object)groupDy);
                dynamicObject.set("inputparamstype", (Object)"dynamicObject");
                dynamicObject.set("seq", (Object)(dynamicObjectCollection.size() + 1));
            } else {
                dynamicObject = (DynamicObject)existGroupDys.get(0);
            }
            DynamicObjectCollection subEntryEntity = dynamicObject.getDynamicObjectCollection("subentryentity");
            for (DynamicObject item : dynamicObjects) {
                long itemId = item.getLong("id");
                List existItemDys = subEntryEntity.stream().filter(entry -> entry.getLong("fieldid.id") == itemId).collect(Collectors.toList());
                DynamicObject subDy = WTCCollections.isNotEmpty(existItemDys) ? (DynamicObject)existItemDys.get(0) : subEntryEntity.addNew();
                int seq = WTCCollections.isNotEmpty(existItemDys) ? ((DynamicObject)existItemDys.get(0)).getInt("seq") : subEntryEntity.size() + 1;
                subDy.set("fieldid", (Object)item);
                String key = item.getString("numberx");
                if (this.isCustomGroup(item)) {
                    key = inputNumber + "." + item.getString("number");
                } else if (key.matches(REPEAT_NUMBERX_SUFFIX) && !idToParamInfoMap.get(sourceSceneId).containsKey(key)) {
                    key = key.substring(0, key.length() - 5);
                }
                if (!idToParamInfoMap.get(sourceSceneId).containsKey(key)) continue;
                Map<String, String> paramInfo = idToParamInfoMap.get(sourceSceneId).get(key);
                if (HRStringUtils.isNotEmpty((String)paramInfo.get("displayName"))) {
                    try {
                        Map nameMap = (Map)SerializationUtils.fromJsonString((String)paramInfo.get("displayName"), Map.class);
                        subDy.set("fielddisplayname", (Object)LocaleString.fromMap((Map)nameMap));
                    }
                    catch (Exception ignore) {
                        subDy.set("fielddisplayname", (Object)new LocaleString(paramInfo.get("displayName")));
                    }
                } else {
                    subDy.set("fielddisplayname", null);
                }
                subDy.set("param1", (Object)paramInfo.get("param1"));
                subDy.set("fieldissyspreset", (Object)false);
                subDy.set("seq", (Object)seq);
            }
        }
        DynamicObjectCollection dynamicObjectCollection = ruleDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long id;
            List<DynamicObject> dynamicObjects;
            if (dynamicObject == null || (dynamicObjects = map.get(id = Long.valueOf(dynamicObject.getLong("inputobject.id")))) == null) continue;
            DynamicObjectCollection subEntryEntity = dynamicObject.getDynamicObjectCollection("subentryentity");
            for (DynamicObject item : dynamicObjects) {
                String inputNumber = dynamicObject.getString("inputobject.numberx");
                long itemId = item.getLong("id");
                List existItemDys = subEntryEntity.stream().filter(entry -> entry.getLong("fieldid.id") == itemId).collect(Collectors.toList());
                DynamicObject subDy = WTCCollections.isNotEmpty(existItemDys) ? (DynamicObject)existItemDys.get(0) : subEntryEntity.addNew();
                int seq = WTCCollections.isNotEmpty(existItemDys) ? ((DynamicObject)existItemDys.get(0)).getInt("seq") : subEntryEntity.size() + 1;
                subDy.set("fieldid", (Object)item);
                String key = item.getString("numberx");
                if (this.isCustomGroup(item)) {
                    key = inputNumber + "." + item.getString("number");
                } else if (key.matches(REPEAT_NUMBERX_SUFFIX) && !idToParamInfoMap.get(sourceSceneId).containsKey(key)) {
                    key = key.substring(0, key.length() - 5);
                }
                if (!idToParamInfoMap.get(sourceSceneId).containsKey(key)) continue;
                Map<String, String> paramInfo = idToParamInfoMap.get(sourceSceneId).get(key);
                if (HRStringUtils.isNotEmpty((String)paramInfo.get("displayName"))) {
                    try {
                        Map nameMap = (Map)SerializationUtils.fromJsonString((String)paramInfo.get("displayName"), Map.class);
                        subDy.set("fielddisplayname", (Object)LocaleString.fromMap((Map)nameMap));
                    }
                    catch (Exception ignore) {
                        subDy.set("fielddisplayname", (Object)new LocaleString(paramInfo.get("displayName")));
                    }
                } else {
                    subDy.set("fielddisplayname", null);
                }
                subDy.set("param1", (Object)paramInfo.get("param1"));
                subDy.set("fieldissyspreset", (Object)false);
                subDy.set("seq", (Object)seq);
            }
        }
    }

    private boolean isCustomGroup(DynamicObject itemDy) {
        long parentId = itemDy.getLong("parent");
        return Lists.newArrayList((Object[])new Long[]{PreDataRetrievalGroup.CT_1300_S, PreDataRetrievalGroup.CT_1301_S, PreDataRetrievalGroup.CT_1302_S, PreDataRetrievalGroup.CT_1303_S, PreDataRetrievalGroup.CT_1304_S, PreDataRetrievalGroup.CT_1305_S, PreDataRetrievalGroup.CT_1306_S, PreDataRetrievalGroup.CT_1307_S}).stream().noneMatch(id -> id == parentId);
    }

    private void buildRetrievalItem(DynamicObject sceneDy, List<DynamicObject> dyItemList, List<DynamicObject> dyGroupList, long sourceSceneId, Map<String, List<Long>> numberxMap) {
        DynamicObjectCollection dynamicObjects = sceneDy.getDynamicObjectCollection("sceneinputparams");
        for (DynamicObject dynamicObject : dynamicObjects) {
            boolean isPreset = dynamicObject.getBoolean("inputissyspreset");
            if (isPreset) continue;
            this.buildRetrieval(dynamicObject, dyItemList, dyGroupList, sourceSceneId, numberxMap);
        }
    }

    private void buildRetrieval(DynamicObject dynamicObject, List<DynamicObject> dyItemList, List<DynamicObject> dyGroupList, long sourceSceneId, Map<String, List<Long>> numberxMap) {
        String inputTyple = dynamicObject.getString("inputparamstype");
        DynamicObject dyItem = this.sceneBaseHelper.generateEmptyDynamicObject();
        switch (inputTyple) {
            case "string": {
                long groupId = this.sceneToBasePropertyGroupIdMap.get(sourceSceneId);
                this.setFiled(dyItem, dynamicObject, "string", groupId, dyItemList, sourceSceneId, numberxMap);
                break;
            }
            case "number": {
                long groupId = this.sceneToBasePropertyGroupIdMap.get(sourceSceneId);
                this.setFiled(dyItem, dynamicObject, "number", groupId, dyItemList, sourceSceneId, numberxMap);
                dyItem.set("scale", (Object)"6");
                dyItem.set("tailprocessing", (Object)"1");
                break;
            }
            case "boolean": {
                long groupId = this.sceneToBasePropertyGroupIdMap.get(sourceSceneId);
                this.setFiled(dyItem, dynamicObject, "boolean", groupId, dyItemList, sourceSceneId, numberxMap);
                break;
            }
            case "date": {
                long groupId = this.sceneToBasePropertyGroupIdMap.get(sourceSceneId);
                this.setFiled(dyItem, dynamicObject, "date", groupId, dyItemList, sourceSceneId, numberxMap);
                dyItem.set("dateformat", (Object)dynamicObject.getString("inputdateformat"));
                break;
            }
            case "enum": {
                long groupId = this.sceneToBasePropertyGroupIdMap.get(sourceSceneId);
                this.setFiled(dyItem, dynamicObject, "enum", groupId, dyItemList, sourceSceneId, numberxMap);
                dyItem.set("combofield", (Object)dynamicObject.getString("inputcombo"));
                dyItem.set("multiple", dynamicObject.get("inputmultiple"));
                break;
            }
            case "basedata": {
                long groupId = this.sceneToBaseDataGroupIdMap.get(sourceSceneId);
                this.setFiled(dyItem, dynamicObject, "dynamicObject", groupId, dyItemList, sourceSceneId, numberxMap);
                dyItem.set("belongobj", (Object)dynamicObject.getDynamicObject("inputobject"));
                dyItem.set("multiple", dynamicObject.get("inputmultiple"));
                break;
            }
            case "dynamicObject": {
                DynamicObject retrievalGroup = this.retrievalGroupHelper.generateEmptyDynamicObject();
                DynamicObject dynamicObject1 = this.retrievalGroupHelper.loadDynamicObject(new QFilter[]{new QFilter("numberx", "=", (Object)dynamicObject.getString("inputnumber"))});
                if (dynamicObject1 == null) {
                    retrievalGroup.set("id", (Object)IDService.get().genLongId());
                    retrievalGroup.set("numberx", (Object)dynamicObject.getString("inputnumber"));
                    retrievalGroup.set("number", (Object)dynamicObject.getString("inputnumber"));
                    retrievalGroup.set("name", (Object)dynamicObject.getString("inputname"));
                    retrievalGroup.set("orinumber", (Object)dynamicObject.getString("inputnumber"));
                    retrievalGroup.set("oriname", (Object)dynamicObject.getLocaleString("inputname"));
                    retrievalGroup.set("enable", (Object)"1");
                    retrievalGroup.set("status", (Object)"C");
                    retrievalGroup.set("grouptype", (Object)"1");
                    retrievalGroup.set("category", (Object)"3");
                    retrievalGroup.set("creator", (Object)RequestContext.get().getCurrUserId());
                    retrievalGroup.set("type", (Object)"dynamicObject");
                    retrievalGroup.set("parent", (Object)PRE_RULE_SCENE_CONDITION_ID);
                    dyGroupList.add(retrievalGroup);
                } else {
                    dynamicObject1.set("parent", (Object)PRE_RULE_SCENE_CONDITION_ID);
                    retrievalGroup = dynamicObject1;
                    dyGroupList.add(retrievalGroup);
                }
                String dynProp = dynamicObject.getString("inputdynprop");
                List maps = SerializationUtils.fromJsonStringToList((String)dynProp, Map.class);
                DynamicObject object = dynamicObject.getDynamicObject("inputobject");
                String belongObjId = object.getString("id");
                IDataEntityProperty property = null;
                MainEntityType dataEntityType = this.getMainEntityType(belongObjId);
                for (Map map : maps) {
                    String unicode = "CT$A$A$" + this.sceneToUnicodePrefixMap.get(sourceSceneId) + "$" + dynamicObject.getString("inputnumber") + "$" + dynamicObject.getString("inputobject.id") + "$" + (String)map.get(SCENE_NAME);
                    String numberx = (String)map.get(SCENE_NAME);
                    DynamicObject dynamicObjectItem = this.sceneBaseHelper.loadDynamicObject(new QFilter[]{new QFilter("uniquecode", "=", (Object)unicode), new QFilter("parent", "=", (Object)retrievalGroup.getLong("id"))});
                    if (dynamicObjectItem != null) {
                        numberx = this.getUniqueNumberX(numberxMap, numberx, dynamicObjectItem.getLong("id"), dynamicObjectItem.getString("numberx"));
                        dynamicObjectItem.set("numberx", (Object)numberx);
                        dynamicObjectItem.set("parent", (Object)retrievalGroup.getLong("id"));
                        dynamicObjectItem.set("uniquecode", (Object)unicode);
                        if (HRStringUtils.isEmpty((String)dynamicObjectItem.getString("assigntype"))) {
                            dynamicObjectItem.set("assigntype", (Object)"1");
                        }
                        dynamicObjectItem.set("sourcetag", (Object)"2");
                        dyItemList.add(dynamicObjectItem);
                        continue;
                    }
                    DynamicObject dyRItem = this.sceneBaseHelper.generateEmptyDynamicObject();
                    dyRItem.set("id", (Object)IDService.get().genLongId());
                    numberx = this.getUniqueNumberX(numberxMap, numberx, dyRItem.getLong("id"), null);
                    dyRItem.set("belongobj", (Object)dynamicObject.getDynamicObject("inputobject"));
                    dyRItem.set("numberx", (Object)numberx);
                    dyRItem.set("name", map.get(SCENE_FNAME));
                    dyRItem.set("number", map.get(SCENE_NAME));
                    dyRItem.set("parent", (Object)retrievalGroup.getLong("id"));
                    dyRItem.set("way", (Object)"2");
                    dyRItem.set("enable", (Object)"1");
                    dyRItem.set("status", (Object)"C");
                    dyRItem.set("uniquecode", (Object)unicode);
                    dyRItem.set("orinumber", map.get(SCENE_NAME));
                    dyRItem.set("oriname", map.get(SCENE_FNAME));
                    if (null != dataEntityType) {
                        DataEntityPropertyCollection properties = dataEntityType.getProperties();
                        property = (IDataEntityProperty)properties.get(map.get(SCENE_NAME));
                    }
                    if (null == property) continue;
                    String fieldType = this.getFieldTypeFormProperty(property);
                    if ("number".equals(fieldType)) {
                        dyRItem.set("scale", (Object)"6");
                        dyRItem.set("tailprocessing", (Object)"1");
                    }
                    dyRItem.set("type", (Object)fieldType);
                    dyRItem.set("category", (Object)"1");
                    dyRItem.set("creator", (Object)RequestContext.get().getCurrUserId());
                    dyRItem.set("assigntype", (Object)"1");
                    dyRItem.set("sourcetag", (Object)"2");
                    dyItemList.add(dyRItem);
                }
                break;
            }
        }
    }

    private MainEntityType getMainEntityType(String belongObjId) {
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = RetrievalUtil.getDataEntityType(belongObjId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataEntityType;
    }

    private void setFiled(DynamicObject dyItem, DynamicObject dynamicObject, String typle, Long groupId, List<DynamicObject> dyItemList, long sourceSceneId, Map<String, List<Long>> numberxMap) {
        String unicode = "CT$A$A$" + this.sceneToUnicodePrefixMap.get(sourceSceneId) + dynamicObject.getString("inputnumber");
        String numberx = dynamicObject.getString("inputnumber");
        DynamicObject[] dynamicObject1 = this.sceneBaseHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("uniquecode", "=", (Object)unicode), new QFilter("parent", "=", (Object)groupId)});
        if (dynamicObject1 != null && dynamicObject1.length > 0) {
            numberx = this.getUniqueNumberX(numberxMap, numberx, dynamicObject1[0].getLong("id"), dynamicObject1[0].getString("numberx"));
            dynamicObject1[0].set("numberx", (Object)numberx);
            dynamicObject1[0].set("parent", (Object)groupId);
            dynamicObject1[0].set("uniquecode", (Object)unicode);
            if (HRStringUtils.isEmpty((String)dynamicObject1[0].getString("assigntype"))) {
                dynamicObject1[0].set("assigntype", (Object)"1");
            }
            dynamicObject1[0].set("sourcetag", (Object)"2");
            dyItemList.add(dynamicObject1[0]);
            return;
        }
        dyItem.set("id", (Object)IDService.get().genLongId());
        numberx = this.getUniqueNumberX(numberxMap, numberx, dyItem.getLong("id"), null);
        dyItem.set("numberx", (Object)numberx);
        String number = "dynamicObject".equals(typle) ? "id" : numberx;
        dyItem.set("number", (Object)number);
        dyItem.set("orinumber", (Object)number);
        dyItem.set("oriname", (Object)dynamicObject.getString("inputname"));
        dyItem.set("enable", (Object)"1");
        dyItem.set("status", (Object)"C");
        dyItem.set("name", (Object)dynamicObject.getString("inputname"));
        dyItem.set("uniquecode", (Object)unicode);
        dyItem.set("way", (Object)"2");
        dyItem.set("type", (Object)typle);
        dyItem.set("parent", (Object)groupId);
        dyItem.set("creator", (Object)RequestContext.get().getCurrUserId());
        dyItem.set("category", (Object)"1");
        dyItem.set("assigntype", (Object)"1");
        dyItem.set("sourcetag", (Object)"2");
        dyItemList.add(dyItem);
    }

    private String getUniqueNumberX(Map<String, List<Long>> numberxMap, String numberx, long id, String oldNumberx) {
        if (null != oldNumberx && oldNumberx.matches(REPEAT_NUMBERX_SUFFIX)) {
            return oldNumberx;
        }
        if (numberxMap.containsKey(numberx) && (numberxMap.get(numberx).size() > 1 && numberxMap.get(numberx).contains(id) || null == oldNumberx)) {
            numberx = numberx.length() > 45 ? numberx.substring(0, 45) : numberx;
            numberx = numberx + "_" + (this.random.nextInt(9000) + 1000);
        }
        if (!numberxMap.containsKey(numberx)) {
            numberxMap.put(numberx, new ArrayList(1));
        }
        numberxMap.get(numberx).add(id);
        return numberx;
    }

    private String getFieldTypeFormProperty(IDataEntityProperty property) {
        String fieldType = property instanceof TimeProp ? "number" : (property instanceof BooleanProp ? "boolean" : (property instanceof TextProp || property instanceof AdminDivisionProp ? "string" : (property instanceof ComboProp ? "enum" : (property instanceof DateTimeProp ? "date" : (property instanceof DecimalProp ? "number" : (property instanceof BasedataProp ? "dynamicObject" : "string"))))));
        return fieldType;
    }

    private void insertLog(List<ChangeValueLogVo> changeValueLogVoList, String type) {
        if (WTCCollections.isEmpty(changeValueLogVoList)) {
            return;
        }
        long[] ids = DB.genGlobalLongIds((int)changeValueLogVoList.size());
        ArrayList<Object[]> logParamList = new ArrayList<Object[]>(changeValueLogVoList.size());
        Date modifyTime = new Date();
        for (int i = 0; i < changeValueLogVoList.size(); ++i) {
            ChangeValueLogVo value = changeValueLogVoList.get(i);
            Object[] param = new Object[]{ids[i], value.getNumber(), value.getEntryId(), value.getOldValue(), value.getNewValue(), type, modifyTime};
            logParamList.add(param);
        }
        DBRoute wtcDbRoute = new DBRoute("wtc");
        int[] batch = HRDBUtil.executeBatch((DBRoute)wtcDbRoute, (String)INSERT_SQL, logParamList);
        LOG.info("SceneToRetrievalItemUpgradeService.upgrade t_wtbd_sceneinputlog is success size:{}", (Object)batch.length);
        LOG.info("SceneToRetrievalItemUpgradeService.upgrade t_wtbd_sceneinputlog is :{}", (Object)ids);
    }
}

