/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.shift;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.common.shift.ShiftTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public abstract class ShiftServiceHelper {
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_shiftperiod");

    public static DynamicObject[] queryShiftByIdIn(List<Long> shiftIds) {
        if (CollectionUtils.isEmpty(shiftIds)) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_shift");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", shiftIds)});
    }

    public static DynamicObject queryShiftById(Long shiftId) {
        if (shiftId == null || shiftId == 0L) {
            return null;
        }
        DynamicObject[] dynamicObjects = ShiftServiceHelper.queryShiftByIdIn(Lists.newArrayList((Object[])new Long[]{shiftId}));
        if (dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    public static List<Long> getWorkShiftPeriod(ShiftTypeEnum type) {
        DynamicObject dy = serviceHelper.queryOne(new QFilter[]{new QFilter("id", "=", (Object)type.getId())});
        DynamicObject[] ids = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("parent", "=", (Object)dy.getLong("id"))});
        return Arrays.stream(ids).sorted(Comparator.comparing(a -> a.getInt("index"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }
}

