/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.takecard;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.common.vo.takecard.ShiftCardVo;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class CardtrialHelper {
    public static List<ShiftCardVo> getShiftInfoList(DynamicObject shift) {
        return CardtrialHelper.getShiftInfoListById((Long)shift.get("id"));
    }

    public static List<ShiftCardVo> getShiftInfoListById(Long shiftId) {
        HRBaseServiceHelper shiftServiceHelper = new HRBaseServiceHelper("wtbd_shift");
        DynamicObject shiftDynamicObject = shiftServiceHelper.queryOne((Object)shiftId);
        DynamicObjectCollection shiftEntryCollection = shiftDynamicObject.getDynamicObjectCollection("entryentity");
        return CardtrialHelper.transToShiftCardVo(shiftEntryCollection);
    }

    public static Date getZeroDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static List<ShiftCardVo> transToShiftCardVo(DynamicObjectCollection shiftEntryCollection) {
        ArrayList<ShiftCardVo> shiftCardVoList = new ArrayList<ShiftCardVo>();
        Date checkDate = WTCDateUtils.toDate((LocalDate)LocalDate.now());
        int num = 0;
        int lastDate = 0;
        for (DynamicObject shiftEntry : shiftEntryCollection) {
            ShiftCardVo shiftCardVo = new ShiftCardVo();
            String outWorkType = shiftEntry.getString("outworktype");
            if (StringUtils.equals((CharSequence)outWorkType, (CharSequence)"B")) continue;
            shiftCardVo.setOutWorkType(outWorkType);
            shiftCardVo.setWorkTimeEnd(Boolean.valueOf(shiftEntry.getBoolean("isworktimeend")));
            shiftCardVo.setWorkTimeStart(Boolean.valueOf(shiftEntry.getBoolean("isworktimestart")));
            shiftCardVo.setRefEndDay(shiftEntry.getString("refendday"));
            shiftCardVo.setRefStartDay(shiftEntry.getString("refstartday"));
            shiftCardVo.setShiftEndDate(shiftEntry.getInt("shiftenddate"));
            shiftCardVo.setShiftStartDate(shiftEntry.getInt("shiftstartdate"));
            shiftCardVo.setCheckDate(checkDate);
            if (num != 0) {
                ShiftCardVo upShiftCardVo = (ShiftCardVo)shiftCardVoList.get(shiftCardVoList.size() - 1);
                int startDate = shiftCardVo.getShiftStartDate();
                if (startDate == lastDate) {
                    upShiftCardVo.setWorkTimeEnd(shiftCardVo.getWorkTimeEnd());
                    lastDate = shiftCardVo.getShiftEndDate();
                    upShiftCardVo.setShiftEndDate(lastDate);
                    upShiftCardVo.setRefEndDay(shiftCardVo.getRefEndDay());
                    continue;
                }
            }
            lastDate = shiftCardVo.getShiftEndDate();
            shiftCardVoList.add(shiftCardVo);
            ++num;
        }
        return shiftCardVoList;
    }

    public static Calendar getSpecificCalendar(Date rankDate, String refstart, int startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateFormat = simpleDateFormat.format(rankDate);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(dateFormat));
            if ("C".equals(refstart)) {
                calendar.add(5, 1);
            } else if ("Q".equals(refstart)) {
                calendar.add(5, -1);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        calendar.add(13, startDate);
        return calendar;
    }

    private static boolean matchTakeCard(String takeCard, boolean isCheck) {
        boolean isNewCheck = false;
        if (!StringUtils.isEmpty((CharSequence)takeCard)) {
            isNewCheck = true;
        }
        return isNewCheck == isCheck;
    }

    public static boolean matchTakeShape(List<ShiftCardVo> shiftCardVos, List<TimeSeq> timeSeqList) {
        int num = 0;
        for (ShiftCardVo shiftCardVo : shiftCardVos) {
            TimeSeq timeSeq = timeSeqList.get(num);
            if (!CardtrialHelper.matchTakeCard(timeSeq.getStartTakeCardRule(), shiftCardVo.getWorkTimeStart())) {
                return false;
            }
            if (!CardtrialHelper.matchTakeCard(timeSeq.getEndTakeCardRule(), shiftCardVo.getWorkTimeEnd())) {
                return false;
            }
            ++num;
        }
        return true;
    }
}

