/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.task.upgrade.takecard;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.constants.takecard.CardRuleConstants;
import kd.wtc.wtbs.wtbd.common.enums.TakeCardRuleRefDayEnum;

public class TakeCardRuleDataUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(TakeCardRuleDataUpgradeImpl.class);

    protected String getJobId() {
        return "3TZCD68=XU6Y";
    }

    protected String getScheduleId() {
        return "3TZDWC16J6TF";
    }

    public boolean process() {
        LOG.info("TakeCardRuleDataUpgradeImpl start process...");
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("wtbd_takecardrule");
            QFilter filter = new QFilter("takecardstarttime", "!=", (Object)-1).and(new QFilter("takecardendtime", "!=", (Object)-1)).and(new QFilter("offrefdaystart", "is null", null).or(new QFilter("offrefdaystart", "=", (Object)""))).and(new QFilter("offrefdayend", "is null", null).or(new QFilter("offrefdayend", "=", (Object)"")));
            DynamicObject[] dys = ruleHelper.loadDynamicObjectArray(new QFilter[]{filter});
            if (null == dys || dys.length == 0) {
                LOG.info("TakeCardRuleDataUpgradeImpl, not found need upgrade take card rule data...");
                boolean bl = true;
                return bl;
            }
            for (DynamicObject dy : dys) {
                int takeCardEndTime = dy.getInt("takecardendtime");
                if (takeCardEndTime == CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT) {
                    dy.set("takecardendtime", (Object)0);
                    dy.set("offrefdaystart", (Object)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay);
                    dy.set("offrefdayend", (Object)TakeCardRuleRefDayEnum.NEXT_DAY.refDay);
                    continue;
                }
                dy.set("offrefdaystart", (Object)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay);
                dy.set("offrefdayend", (Object)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay);
            }
            ruleHelper.save(dys);
        }
        return true;
    }
}

