/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.workschedule;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchCheckReq;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchCheckRes;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchEntryReq;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchEntryRes;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

@SingletonBean
public class AttFileWorkScheduleService {
    private static final Log LOG = LogFactory.getLog(AttFileWorkScheduleService.class);
    private static final AttFileWorkScheduleService INS = (AttFileWorkScheduleService)WTCAppContextHelper.getBean(AttFileWorkScheduleService.class);
    private final HRBaseServiceHelper workScheduleHelper = HRBaseServiceHelper.create((String)"wtbd_workschedule");
    private final HRBaseServiceHelper workScheduleEntryHelper = HRBaseServiceHelper.create((String)"wtbd_workscheduleentryq");
    private final HRBaseServiceHelper shiftHelper = HRBaseServiceHelper.create((String)"wtbd_shift");

    public static AttFileWorkScheduleService getInstance() {
        return INS;
    }

    public AttFileWorkSchEntryRes queryAttFileWorkSchEntry(AttFileWorkSchEntryReq attFileWorkSchReq) {
        LOG.info("\u8c03\u7528queryAttFileWorkSchEntry\u5f00\u59cb\uff0cattFIleWorkSchReq:{}", (Object)attFileWorkSchReq);
        String message = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u6863\u6848\u6ca1\u6709\u5165\u804c/\u79bb\u804c\u5f53\u6708\u5168\u90e8\u8ba1\u5212\u6392\u73ed\u3002", (String)"AttFileWorkScheduleService_01", (String)"wtc-wtbd-business", (Object[])new Object[0]);
        AttFileScheduleServiceImpl scheduleService = AttFileScheduleServiceImpl.getInstance();
        Map attFileScheduleMap = scheduleService.queryAttFileSchedule((Collection)Lists.newArrayList((Object[])new Long[]{attFileWorkSchReq.getAttFileBoid()}), AttFileScheduleEnum.WS, false);
        List schedules = (List)attFileScheduleMap.get(attFileWorkSchReq.getAttFileBoid());
        if (CollectionUtils.isEmpty((Collection)schedules)) {
            return AttFileWorkSchEntryRes.fial((String)message);
        }
        schedules.sort(Comparator.comparing(dy -> dy.getDate("bsed")));
        int index = "DIMISSION".equals(attFileWorkSchReq.getQueryType()) ? schedules.size() - 1 : 0;
        DynamicObject attWs = (DynamicObject)schedules.get(index);
        QFilter qFilter = new QFilter("fid", "=", (Object)attWs.getLong("ws.id")).and("workdate", "<=", (Object)attFileWorkSchReq.getEndDate()).and("workdate", ">=", (Object)attFileWorkSchReq.getStartDate());
        DynamicObject[] entryList = this.workScheduleEntryHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        int daysBetween = WTCDateUtils.daysBetween((Date)attFileWorkSchReq.getStartDate(), (Date)attFileWorkSchReq.getEndDate()) + 1;
        if (entryList.length == 0 || entryList.length != daysBetween) {
            return AttFileWorkSchEntryRes.fial((String)message);
        }
        HashSet shiftIds = Sets.newHashSet();
        ArrayList workEntries = Lists.newArrayList();
        Arrays.stream(entryList).forEach(entry -> {
            shiftIds.add(entry.getLong("shiftid"));
            WorkScheduleNewEntry workEntry = new WorkScheduleNewEntry();
            workEntry.setWorkDate(entry.getDate("workdate"));
            workEntry.setDateTypeId(entry.getLong("datetype.id"));
            workEntry.setDatePropertyId(entry.getLong("datepropertyid.id"));
            workEntries.add(workEntry);
        });
        QFilter shiftFilter = new QFilter("id", "in", (Object)shiftIds);
        String shiftProperties = String.join((CharSequence)",", "id", "name", "number");
        DynamicObject[] shifts = this.shiftHelper.query(shiftProperties, new QFilter[]{shiftFilter});
        AttFileWorkSchEntryRes result = new AttFileWorkSchEntryRes().setSuccess(true).setShiftInfos(Arrays.asList(shifts)).setWorkScheduleNewEntries((List)workEntries);
        return result;
    }

    public Map<Long, AttFileWorkSchCheckRes> checkAttFileWorkSchedule(Map<Long, List<AttFileWorkSchCheckReq>> workSchCheckReqsMap) {
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)workSchCheckReqsMap.size());
        String properties = String.join((CharSequence)",", "id", "name", "floorgendate", "ceilinggendate");
        DynamicObject[] workSchDyArr = this.workScheduleHelper.queryOriginalArray(properties, new QFilter[]{new QFilter("id", "in", workSchCheckReqsMap.values().stream().flatMap(Collection::stream).map(AttFileWorkSchCheckReq::getScheduleId).collect(Collectors.toSet()))});
        Map workSchDyMap = Arrays.stream(workSchDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        for (Map.Entry<Long, List<AttFileWorkSchCheckReq>> entry : workSchCheckReqsMap.entrySet()) {
            AttFileWorkSchCheckRes attFileWorkSchCheckRes = new AttFileWorkSchCheckRes();
            attFileWorkSchCheckRes.setMessages((List)Lists.newArrayList());
            List<AttFileWorkSchCheckReq> attFileWorkSchCheckReqList = entry.getValue();
            attFileWorkSchCheckReqList.sort(Comparator.comparing(d -> d.getStartDate()));
            for (AttFileWorkSchCheckReq workSchCheckReq : attFileWorkSchCheckReqList) {
                String errMsg;
                DynamicObject workScheduleDyn = (DynamicObject)workSchDyMap.get(workSchCheckReq.getScheduleId());
                List messages = attFileWorkSchCheckRes.getMessages();
                if (workScheduleDyn == null) {
                    LOG.warn("\u6839\u636eID\u672a\u67e5\u8be2\u5230\u5de5\u4f5c\u65e5\u7a0b\u8868");
                    messages.add("workSchData is null");
                    break;
                }
                Date genStartDate = workScheduleDyn.getDate("floorgendate");
                if (genStartDate.after(workSchCheckReq.getStartDate())) {
                    Date endDate = genStartDate.compareTo(workSchCheckReq.getEndDate()) > 0 ? workSchCheckReq.getEndDate() : WTCDateUtils.addDays((Date)genStartDate, (int)-1);
                    errMsg = this.getCheckErrMgs(workSchCheckReq, workScheduleDyn, workSchCheckReq.getStartDate(), endDate);
                    messages.add(errMsg);
                    break;
                }
                Date genEndDate = workScheduleDyn.getDate("ceilinggendate");
                if (genEndDate.before(workSchCheckReq.getStartDate())) {
                    errMsg = this.getCheckErrMgs(workSchCheckReq, workScheduleDyn, workSchCheckReq.getStartDate(), workSchCheckReq.getEndDate());
                    messages.add(errMsg);
                    break;
                }
                if (workSchCheckReq.getLatest() || !genEndDate.before(workSchCheckReq.getEndDate())) continue;
                Date startDate = WTCDateUtils.addDays((Date)genEndDate, (int)1);
                String errMsg2 = this.getCheckErrMgs(workSchCheckReq, workScheduleDyn, startDate, workSchCheckReq.getEndDate());
                messages.add(errMsg2);
                break;
            }
            attFileWorkSchCheckRes.setSuccess(WTCCollections.isEmpty((Collection)attFileWorkSchCheckRes.getMessages()));
            retMap.put(entry.getKey(), attFileWorkSchCheckRes);
        }
        return retMap;
    }

    private String getCheckErrMgs(AttFileWorkSchCheckReq workSchCheckReq, DynamicObject workScheduleDyn, Date startDate, Date endDate) {
        String errMsgFmt = ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5728{0}\u81f3{1}\u65e5\u671f\u8303\u56f4\u5185\uff0c\u5de5\u4f5c\u65e5\u7a0b\u8868\u201c{2}\u201d\u672a\u751f\u6210\u73ed\u6b21\u6570\u636e\uff0c\u5c06\u4f1a\u5bfc\u81f4\u6838\u7b97\u62a5\u9519\uff0c\u8bf7\u53ca\u65f6\u66f4\u65b0\u5de5\u4f5c\u65e5\u7a0b\u8868\uff08\u9519\u8bef\u7801\uff1aE2001\uff09\u3002", (String)"AttFileWorkScheduleService_02", (String)"wtc-wtbd-business", (Object[])new Object[0]);
        String errMsg = MessageFormat.format(errMsgFmt, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate), workScheduleDyn.getString("name"));
        return errMsg;
    }
}

