/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.workschedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.business.hp.HpHolidayCalculateService;
import kd.wtc.wtbd.business.workschedule.shiftmode.ShiftModeService;
import kd.wtc.wtbd.common.entity.workschedule.CalendarModelEntry;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleEntryGenParam;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.workschdule.datetypeadj.DateTypeAdj;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WorkScheduleHelper {
    private static final Log LOG = LogFactory.getLog(WorkScheduleHelper.class);
    private static final HpHolidayCalculateService HP_HOLIDAY_CALCULATE_SERVICE = new HpHolidayCalculateService();
    public static List<String> FIELDS = Arrays.asList("fid", "workdate", "etimezoneid", "shiftid", "holidayid", "weekday", "datetype", "oridatetype", "datepropertyid", "oridatepropertyid");
    public static final int DEFAULT_LENGTH_LIMIT = 5;

    public static List<WorkScheduleNewEntry> genWorkSchedule(WorkScheduleEntryGenParam param) {
        WorkScheduleHelper.dateToMidnight(param);
        return WorkScheduleHelper.getWorkScheduleList(param);
    }

    private static List<WorkScheduleNewEntry> getWorkCirList(WorkScheduleEntryGenParam param, int beginIndex, DynamicObject calMode, Calendar currDay) {
        Map<String, Long> dateAttr = WorkScheduleHelper.getDateAttr();
        Long wordDayId = dateAttr.get(DateAttribute.WORKDAY.getCode());
        Long offDayId = dateAttr.get(DateAttribute.OFFDAY.getCode());
        Long holDayId = dateAttr.get(DateAttribute.HOLIDAY.getCode());
        List<CalendarModelEntry> calDateType = WorkScheduleHelper.getCalDateType(calMode);
        List<Boolean> calWorkDayPropertyList = WorkScheduleHelper.getCalWorkDayList(calMode);
        Map<Date, Tuple<List<Long>, Long>> holidayMap = WorkScheduleHelper.getHolidayMap(param, calMode);
        List<WorkScheduleNewEntry> shiftModeList = WorkScheduleHelper.dealByShiftMode(param, holidayMap);
        ArrayList<WorkScheduleNewEntry> resultList = new ArrayList<WorkScheduleNewEntry>(shiftModeList.size());
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        int shiftIndex = 0;
        while (currDay.getTime().getTime() <= param.getGenEndTime().getTime()) {
            if (currDay.getTime().getTime() >= param.getGenStartTime().getTime()) {
                int dayProperty = beginIndex % calWorkDayPropertyList.size();
                WorkScheduleNewEntry newEntry = new WorkScheduleNewEntry();
                newEntry.setDatePropertyId((calWorkDayPropertyList.get(dayProperty) != false ? wordDayId : offDayId).longValue());
                newEntry.setShiftId(shiftModeList.get(shiftIndex).getShiftId());
                newEntry.setWorkDate(currDay.getTime());
                newEntry.setEtimezoneid(param.getTimezoneId());
                newEntry.setWeekDay(WorkScheduleHelper.getDayOfWeek(currDay.getTime()));
                newEntry.setSelfSet("0");
                newEntry.setEcreatetime(now);
                newEntry.setEcreatorid(userId);
                WorkScheduleHelper.dealDateType(calDateType, newEntry);
                Long defaultDateTypeIdOfDateProp = (Long)DateTypeAdj.DEFAULT_DATETYPE_OF_DATEPROP_MAP.get(newEntry.getDatePropertyId());
                if (defaultDateTypeIdOfDateProp != null) {
                    newEntry.setDateTypeId(defaultDateTypeIdOfDateProp.longValue());
                }
                WorkScheduleHelper.dealHoliday(holDayId, newEntry, holidayMap);
                resultList.add(newEntry);
                ++shiftIndex;
            }
            currDay.add(5, 1);
            ++beginIndex;
        }
        return resultList;
    }

    private static Map<Date, Tuple<List<Long>, Long>> getHolidayMap(WorkScheduleEntryGenParam param, DynamicObject calMode) {
        Map conflictDateTypeMap = param.getConflictDateTypeMap();
        Map holidayDateMap = param.getHolidayDateMap();
        if (holidayDateMap == null) {
            List holidayCombineIds = calMode.getDynamicObjectCollection("holidaycombine").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)param.getHolidayPortfolioIdList())) {
                holidayCombineIds.addAll(param.getHolidayPortfolioIdList());
            }
            holidayCombineIds.addAll(param.getHolidayPortfolioIdList());
            WorkSchHolidayParam workSchHolidayParam = new WorkSchHolidayParam(param.getGenStartTime(), param.getGenEndTime(), holidayCombineIds);
            Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Tuple<Long, Long>>>> allHolidayIdTypeMap = HP_HOLIDAY_CALCULATE_SERVICE.getAllHolidayIdType(Collections.singletonList(workSchHolidayParam));
            holidayDateMap = allHolidayIdTypeMap.get(workSchHolidayParam);
        }
        HashMap holidayMap = Maps.newHashMapWithExpectedSize((int)holidayDateMap.size());
        for (Map.Entry dateListEntry : holidayDateMap.entrySet()) {
            Date currDate = (Date)dateListEntry.getKey();
            Long dateTypeId = null;
            if (conflictDateTypeMap != null) {
                dateTypeId = (Long)conflictDateTypeMap.get(currDate);
            }
            List holidayIds = ((List)dateListEntry.getValue()).stream().map(tp -> (Long)tp.item1).collect(Collectors.toList());
            if (dateTypeId == null) {
                List dateTypeIds = ((List)dateListEntry.getValue()).stream().map(tp -> (Long)tp.item2).collect(Collectors.toList());
                dateTypeId = dateTypeIds.contains(DateTypeEnum.HOLIDAY_PAID.getId()) ? DateTypeEnum.HOLIDAY_PAID.getId() : (dateTypeIds.contains(DateTypeEnum.HOLIDAY_HALF_PAID.getId()) ? DateTypeEnum.HOLIDAY_HALF_PAID.getId() : (Long)dateTypeIds.get(0));
            }
            holidayMap.put(currDate, Tuple.create(holidayIds, (Object)dateTypeId));
        }
        return holidayMap;
    }

    private static void dealHoliday(Long holDayId, WorkScheduleNewEntry newEntry, Map<Date, Tuple<List<Long>, Long>> holidayMap) {
        Tuple<List<Long>, Long> holidayTuple = holidayMap.get(newEntry.getWorkDate());
        if (holidayTuple != null && !CollectionUtils.isEmpty((Collection)((Collection)holidayTuple.item1))) {
            newEntry.setOriDatePropertyId(newEntry.getDatePropertyId());
            newEntry.setOriDateTypeId(newEntry.getDateTypeId());
            newEntry.setDateTypeId(((Long)holidayTuple.item2).longValue());
            newEntry.setDatePropertyId(holDayId.longValue());
            newEntry.setHolidayId(StringUtils.join((Iterable)((Iterable)holidayTuple.item1), (String)","));
        }
    }

    private static void dealDateType(List<CalendarModelEntry> calDateType, WorkScheduleNewEntry newEntry) {
        for (CalendarModelEntry modelEntry : calDateType) {
            if (newEntry.getWorkDate().getTime() < modelEntry.getStartDate().getTime() || newEntry.getWorkDate().getTime() > modelEntry.getEndDate().getTime()) continue;
            newEntry.setDatePropertyId(modelEntry.getDateProperty().longValue());
            newEntry.setDateTypeId(modelEntry.getDateType().longValue());
        }
    }

    private static List<CalendarModelEntry> getCalDateType(DynamicObject calMode) {
        DynamicObjectCollection exEntry = calMode.getDynamicObjectCollection("exentryentity");
        return exEntry.stream().map(dy -> {
            CalendarModelEntry modelEntry = new CalendarModelEntry();
            modelEntry.setStartDate(dy.getDate("startdate"));
            modelEntry.setEndDate(dy.getDate("enddate"));
            modelEntry.setDateProperty(Long.valueOf(dy.getLong("dateprop.id")));
            modelEntry.setDateType(Long.valueOf(dy.getLong("datetype.id")));
            return modelEntry;
        }).collect(Collectors.toList());
    }

    private static List<Boolean> getCalWorkDayList(DynamicObject calMode) {
        if ("A".equals(calMode.getString("wrokdaysetmode"))) {
            ArrayList<Boolean> list = new ArrayList<Boolean>(10);
            list.add(calMode.getBoolean("mon"));
            list.add(calMode.getBoolean("tue"));
            list.add(calMode.getBoolean("wed"));
            list.add(calMode.getBoolean("thurs"));
            list.add(calMode.getBoolean("fri"));
            list.add(calMode.getBoolean("sat"));
            list.add(calMode.getBoolean("sun"));
            return list;
        }
        if ("B".equals(calMode.getString("wrokdaysetmode"))) {
            String[] wordDayStr;
            int loopFactor = calMode.getInt("loopfactor");
            String loopMode = calMode.getString("loopmode");
            int cellCount = loopMode.equals("A") ? 7 * loopFactor : loopFactor;
            if (cellCount != (wordDayStr = calMode.getString("cycperiodtxt").split(",")).length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u5386\u751f\u6210\u89c4\u5219\u914d\u7f6e\u9519\u8bef\u3002", (String)"WorkScheduleHelper_0", (String)"wtc-wtbd-business", (Object[])new Object[0]));
            }
            return Arrays.stream(wordDayStr).map("1"::equals).collect(Collectors.toList());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5de5\u4f5c\u65e5\u8bbe\u7f6e\u65b9\u5f0f\u3002", (String)"WorkScheduleHelper_1", (String)"wtc-wtbd-business", (Object[])new Object[0]));
    }

    public static List<WorkScheduleNewEntry> dealByShiftMode(WorkScheduleEntryGenParam param) {
        return WorkScheduleHelper.dealByShiftMode(param, new HashMap<Date, Tuple<List<Long>, Long>>());
    }

    private static List<WorkScheduleNewEntry> dealByShiftMode(WorkScheduleEntryGenParam param, Map<Date, Tuple<List<Long>, Long>> holidayMap) {
        Map<LocalDate, Long> shiftModeDataMap = ShiftModeService.getInstance().genRosterShiftBoInfos(param.getBaseDate(), param.getGenStartTime(), param.getGenEndTime(), param.getShiftModeId(), holidayMap);
        ArrayList retList = Lists.newArrayListWithCapacity((int)shiftModeDataMap.size());
        for (Map.Entry<LocalDate, Long> shiftModeEntry : shiftModeDataMap.entrySet()) {
            WorkScheduleNewEntry newEntry = new WorkScheduleNewEntry();
            newEntry.setShiftId(shiftModeEntry.getValue().longValue());
            newEntry.setWorkDate(WTCDateUtils.toDate((LocalDate)shiftModeEntry.getKey()));
            retList.add(newEntry);
        }
        return retList;
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int weekDay = cal.get(7) - 1;
        if (weekDay == 0) {
            return 7;
        }
        return weekDay;
    }

    public static DynamicObject getCalMode(long calModeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_calendarmodel");
        return serviceHelper.loadSingle((Object)calModeId);
    }

    private static Map<String, Long> getDateAttr() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_dateproperty");
        List code = Arrays.stream(DateAttribute.values()).map(DateAttribute::getCode).collect(Collectors.toList());
        QFilter filter = new QFilter("number", "in", code);
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        HashMap<String, Long> res = new HashMap<String, Long>(10);
        for (DynamicObject dy : dys) {
            res.put(dy.getString("number"), dy.getLong("id"));
        }
        return res;
    }

    public static Map<Long, String> getAllDateAttrName() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_dateproperty");
        DynamicObject[] dys = serviceHelper.query("id,name", null);
        HashMap<Long, String> res = new HashMap<Long, String>(10);
        for (DynamicObject dy : dys) {
            res.put(dy.getLong("id"), dy.getString("name"));
        }
        return res;
    }

    private static void dateToMidnight(WorkScheduleEntryGenParam param) {
        param.setBaseDate(WorkScheduleHelper.setTimeToMidnight(param.getBaseDate()));
        param.setGenStartTime(WorkScheduleHelper.setTimeToMidnight(param.getGenStartTime()));
        param.setGenEndTime(WorkScheduleHelper.setTimeToMidnight(param.getGenEndTime()));
    }

    public static Date setTimeToMidnight(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private static List<WorkScheduleNewEntry> getWorkScheduleList(WorkScheduleEntryGenParam param) {
        DynamicObject calMode = WorkScheduleHelper.getCalMode(param.getCalendarModelId());
        boolean flag = "A".equals(calMode.getString("wrokdaysetmode")) || "B".equals(calMode.getString("wrokdaysetmode")) && "A".equals(calMode.getString("loopmode"));
        Calendar currDay = Calendar.getInstance();
        if (flag) {
            int dayOfWeek = WorkScheduleHelper.getDayOfWeek(param.getGenStartTime());
            int beginIndex = dayOfWeek - 1;
            currDay.setTime(param.getGenStartTime());
            return WorkScheduleHelper.getWorkCirList(param, beginIndex, calMode, currDay);
        }
        currDay.setTime(param.getBaseDate());
        return WorkScheduleHelper.getWorkCirList(param, 0, calMode, currDay);
    }

    public static Date getFloorDate(long orgId) {
        Boolean isLimitModifyHisRange = (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtbd", (String)"ismodifyhis");
        if (isLimitModifyHisRange != null && !isLimitModifyHisRange.booleanValue()) {
            return WorkScheduleHelper.getUnLimitDate();
        }
        Object floorDateObj = SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtbd", (String)"floordate");
        if (floorDateObj instanceof String) {
            Date floorDate = WTCDateUtils.str2Date((String)floorDateObj.toString(), (String)"yyyy-MM-dd HH:mm:ss");
            return WTCDateUtils.getZeroDate((Date)floorDate);
        }
        return (Date)floorDateObj;
    }

    private static Date getUnLimitDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse("1800-01-01");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void adjWorkScheduleEntry(List<WorkScheduleNewEntry> needAdjWorkScheduleEntries, Date genStartTime, Date genEndTime, DateTypeAdj dateTypeAdj) {
        if (WTCCollections.isEmpty(needAdjWorkScheduleEntries) || dateTypeAdj == null) {
            return;
        }
        Set shiftBoIds = needAdjWorkScheduleEntries.stream().map(WorkScheduleNewEntry::getShiftId).collect(Collectors.toSet());
        Map shiftHisMap = WTCHisServiceHelper.queryHisVersionDyMap((String)"wtbd_shift", shiftBoIds, (Date)genStartTime, (Date)genEndTime, (String)"isoff");
        for (WorkScheduleNewEntry newEntry : needAdjWorkScheduleEntries) {
            DynamicObject shiftHisDy = WTCHisServiceHelper.getCurrVersionDy((Map)shiftHisMap, (long)newEntry.getShiftId(), (Date)newEntry.getWorkDate());
            Tuple dateTypeTuple = dateTypeAdj.adjustDateType(newEntry.getWorkDate(), newEntry.getWeekDay(), newEntry.getDatePropertyId(), newEntry.getDateTypeId(), shiftHisDy != null && shiftHisDy.getBoolean("isoff"));
            if (dateTypeTuple == null) continue;
            if (((Long)dateTypeTuple.item2).longValue() != DateAttribute.HOLIDAY.getId()) {
                newEntry.setHolidayId(null);
            }
            newEntry.setDatePropertyId(((Long)dateTypeTuple.item2).longValue());
            newEntry.setDateTypeId(((Long)dateTypeTuple.item1).longValue());
        }
    }

    public static int getWorkSchLengthLimit() {
        Object wtpSystemParam = SystemParamQueryUtil.loadAppParameterFromCache((String)"workschlengthlimit", (String)"wtp");
        if (wtpSystemParam == null) {
            return 5;
        }
        return (Integer)wtpSystemParam;
    }

    public static List<Long> getAttFileIdsOfWsIds(Collection<Long> workSchIds, Date startDate, Date endDate) {
        LinkedList attFileBoIds = Lists.newLinkedList();
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        String genStartDateField = AttFileScheduleEnum.WS.getKey() + "." + "floorgendate";
        String genEndDateField = AttFileScheduleEnum.WS.getKey() + "." + "ceilinggendate";
        queryParam.setProperties("id, attfileid,attfileid.id,attfilevid, bsed, bsled," + genStartDateField + "," + genEndDateField);
        queryParam.setStartDate(startDate);
        queryParam.setEndDate(endDate);
        QFilter qFilter = new QFilter(AttFileScheduleEnum.WS.getKey(), "in", workSchIds);
        queryParam.setqFilter(qFilter);
        Map attFileWsMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.WS, queryParam);
        block0: for (Map.Entry entry : attFileWsMap.entrySet()) {
            for (DynamicObject wsDy : (List)entry.getValue()) {
                boolean endCross;
                Date bsed = wsDy.getDate("bsed");
                Date bsled = wsDy.getDate("bsled");
                Date genStartDate = wsDy.getDate(genStartDateField);
                Date genEndDate = wsDy.getDate(genEndDateField);
                if (bsed == null || bsled == null || genStartDate == null || genEndDate == null) {
                    LOG.warn("SyncRoster.log.warn,attFileId:{}:WorkSch.Data.err", (Object)wsDy.getLong("id"));
                    continue;
                }
                Date maxStartDate = bsed.after(genStartDate) ? bsed : genStartDate;
                Date minEndDate = bsled.before(genStartDate) ? bsled : genEndDate;
                if (minEndDate.compareTo(maxStartDate) < 0) continue;
                if (startDate == null || endDate == null) {
                    attFileBoIds.add(entry.getKey());
                    continue block0;
                }
                boolean startCross = startDate.compareTo(maxStartDate) >= 0 && startDate.compareTo(minEndDate) <= 0;
                boolean bl = endCross = endDate.compareTo(maxStartDate) >= 0 && endDate.compareTo(minEndDate) <= 0;
                if (!startCross && !endCross && (startDate.compareTo(maxStartDate) >= 0 || endDate.compareTo(minEndDate) <= 0)) continue;
                attFileBoIds.add(entry.getKey());
                continue block0;
            }
        }
        return attFileBoIds;
    }
}

