/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.workschedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.business.workschedule.WorkScheduleService;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class WorkScheduleViewService {
    private static final Log LOG = LogFactory.getLog(WorkScheduleViewService.class);
    private static final WorkScheduleViewService INS = new WorkScheduleViewService();

    public static WorkScheduleViewService getInstance() {
        return INS;
    }

    public WorkSchHolidayParam genWorkSchHolidayParam(DynamicObject dataEntity, DynamicObject workSchDy) {
        DynamicObject shiftModeDy = workSchDy.getDynamicObject("shiftmode");
        DynamicObject calendarRuleDy = dataEntity.getDynamicObject("calendarmodel");
        Date baseDate = workSchDy.getDate("basedate");
        Date startDate = dataEntity.getDate("genstarttime");
        Date endDate = dataEntity.getDate("genendtime");
        if (WorkScheduleViewService.getInstance().isCheckConflict(baseDate, startDate, endDate, calendarRuleDy, shiftModeDy)) {
            DynamicObjectCollection holidayHpDyColl = workSchDy.getDynamicObjectCollection("holidayportfolios");
            List holidayPortFolioIdsOfCalendarRule = calendarRuleDy.getDynamicObjectCollection("holidaycombine").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            List holidayPortFolioIdsOfWorkSch = holidayHpDyColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            ArrayList holidayPortFolioIds = new ArrayList(holidayPortFolioIdsOfCalendarRule.size() + holidayPortFolioIdsOfWorkSch.size());
            holidayPortFolioIds.addAll(holidayPortFolioIdsOfCalendarRule);
            holidayPortFolioIds.addAll(holidayPortFolioIdsOfWorkSch);
            return new WorkSchHolidayParam(startDate, endDate, holidayPortFolioIds);
        }
        return null;
    }

    public boolean isCheckConflict(Date baseDate, Date startDate, Date endDate, DynamicObject calendarModelDy, DynamicObject shiftModeDy) {
        return startDate != null && endDate != null && calendarModelDy != null && baseDate != null && shiftModeDy != null;
    }

    public void showReviseView(Date baseDate, Date startDate, Date endDate, String shiftModeId, String conflictMapStr, IFormView view, CloseCallBack closeCallBack, String reviseDataStr) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtbd_workschhprevise");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("revisesource", (Object)conflictMapStr);
        showParameter.setCustomParam("revisedata", (Object)reviseDataStr);
        showParameter.setCustomParam("basedate", (Object)WTCDateUtils.date2Str((Date)baseDate, (String)"yyyy-MM-dd"));
        showParameter.setCustomParam("genstarttime", (Object)WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd"));
        showParameter.setCustomParam("genendtime", (Object)WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd"));
        showParameter.setCustomParam("shiftmode", (Object)shiftModeId);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public boolean validateMaxRange(DynamicObject dataEntity, int workSchLengthLimit, Date floorGenDate, Date ceilGenDate, IFormView view) {
        if (WorkScheduleService.isExceed(floorGenDate, ceilGenDate, workSchLengthLimit)) {
            if (dataEntity.getDate("floorgendate") == null || dataEntity.getDate("ceilinggendate") == null) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u7a0b\u8868\u7684\u6700\u65e9\u751f\u6210\u5f00\u59cb\u65e5\u671f~\u6700\u665a\u7ed3\u675f\u65e5\u671f\u5f53\u524d\u9ed8\u8ba4\u8bbe\u7f6e\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7%1$s\u5e74\uff0c\u53ef\u524d\u5f80\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u516c\u5171\u8bbe\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u5de5\u65f6\u5047\u52e4\u4e91>\u5de5\u65f6\u5047\u52e4\u89c4\u5219>\u6392\u73ed\u8bbe\u7f6e\u201d\u6309\u9700\u8c03\u6574\u201c\u5de5\u4f5c\u65e5\u7a0b\u8868\u751f\u6210\u957f\u5ea6\u9650\u5236\u201d\u53c2\u6570\u7684\u9608\u503c\u3002", (String)"WorkScheduleViewService_0", (String)"wtc-wtbd-business", (Object[])new Object[0]), workSchLengthLimit));
            } else {
                Date realGenFloorDate = dataEntity.getDate("floorgendate");
                Date realGenCeilDate = dataEntity.getDate("ceilinggendate");
                Calendar instance = Calendar.getInstance();
                instance.setTime(realGenFloorDate);
                instance.add(1, workSchLengthLimit);
                instance.add(6, -1);
                Date maxEndDate = instance.getTime();
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6700\u65e9\u751f\u6210\u65e5\u671f\u81f3\u6700\u665a\u7ed3\u675f\u65e5\u671f\u9ed8\u8ba4\u8bbe\u7f6e\u4e0d\u53ef\u8d85\u8fc7%1$s\u5e74\uff0c\u53ef\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u4fee\u6539\u8be5\u8bbe\u7f6e\uff1b\u5df2\u5b58\u5728%2$s\u81f3%3$s\uff0c\u6700\u5927\u53ef\u8bbe\u7f6e\u751f\u6210\u7ed3\u675f\u65e5\u671f\u4e3a%4$s\u7684\u5de5\u4f5c\u65e5\u7a0b\u8868\u3002", (String)"WorkScheduleViewService_1", (String)"wtc-wtbd-business", (Object[])new Object[0]), workSchLengthLimit, WTCDateUtils.date2Str((Date)realGenFloorDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)realGenCeilDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)maxEndDate, (String)"yyyy-MM-dd")));
            }
            return true;
        }
        return false;
    }
}

