/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.workschedule.shiftmode;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.business.shift.ShiftServiceHelper;
import kd.wtc.wtbd.common.shiftmode.HolidayHandleEntry;
import kd.wtc.wtbd.common.shiftmode.HolidayHandleParam;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.common.model.customcontrol.shiftmode.ShiftModeCell;
import kd.wtc.wtbs.common.model.customcontrol.shiftmode.ShiftModeTable;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class ShiftModeService {
    private static final Log LOG = LogFactory.getLog(ShiftModeService.class);
    private static final ShiftModeService INS = new ShiftModeService();

    public static ShiftModeService getInstance() {
        return INS;
    }

    public Map<LocalDate, Long> genRosterShiftBoInfos(Date baseDate, Date startDate, Date endDate, Long shiftModeId, Map<Date, Tuple<List<Long>, Long>> holidayMap) {
        DynamicObjectCollection holEntries;
        LOG.info("genRosterShiftBoInfos.params:{},{},{},{}", new Object[]{baseDate, startDate, endDate, shiftModeId});
        DynamicObject shiftModeDy = this.queryShiftModeDy(shiftModeId);
        String cycleMode = shiftModeDy.getString("cyclemode");
        HolidayHandleParam holidayHandleParam = new HolidayHandleParam(shiftModeDy.getBoolean("handleholiday"));
        if (holidayHandleParam.isHandleHoliday() && WTCCollections.isNotEmpty((Collection)(holEntries = shiftModeDy.getDynamicObjectCollection("holhandleentry")))) {
            for (DynamicObject holEntry : holEntries) {
                HolidayHandleEntry holidayHandleEntry = new HolidayHandleEntry();
                holidayHandleEntry.setHandleMethod(holEntry.getString("holhandlemethod"));
                holidayHandleEntry.setHolidayDateTypeIds(holEntry.getDynamicObjectCollection("holdatetypes").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()));
                holidayHandleEntry.setAssignShiftId(holEntry.getLong("assignshift.id"));
                holidayHandleParam.getHolidayHandleEntries().add(holidayHandleEntry);
            }
        }
        return this.genRosterShiftBoInfos(baseDate, startDate, endDate, cycleMode, this.getShiftCells(shiftModeDy), holidayHandleParam, holidayMap);
    }

    private Map<LocalDate, Long> genRosterShiftBoInfos(Date baseDate, Date startDate, Date endDate, String cycleMode, List<ShiftModeCell> shiftModeCells, HolidayHandleParam holidayHandleParam, Map<Date, Tuple<List<Long>, Long>> holidayMap) {
        LocalDate refDate;
        LinkedHashMap retMap = Maps.newLinkedHashMapWithExpectedSize((int)(WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1));
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        if ("w".equals(cycleMode)) {
            calendar.setTime(baseDate);
            calendar.set(7, 2);
            refDate = WTCDateUtils.getLocalDateByCalendarIns((Calendar)calendar);
        } else {
            refDate = WTCDateUtils.toLocalDate((Date)baseDate);
        }
        LocalDate startLocalDate = WTCDateUtils.toLocalDate((Date)startDate);
        long endTime = endDate.getTime();
        LocalDate currRefStartDate = refDate;
        LocalDate nextRefStartDate = currRefStartDate.plusDays(shiftModeCells.size());
        while (!nextRefStartDate.isAfter(startLocalDate)) {
            currRefStartDate = nextRefStartDate;
            nextRefStartDate = currRefStartDate.plusDays(shiftModeCells.size());
        }
        int startIndex = (int)currRefStartDate.until(startLocalDate, ChronoUnit.DAYS);
        calendar.setTime(startDate);
        int index = startIndex % shiftModeCells.size();
        while (calendar.getTimeInMillis() <= endTime) {
            LocalDate currDate = WTCDateUtils.getLocalDateByCalendarIns((Calendar)calendar);
            ShiftModeCell shiftModeCell = shiftModeCells.get(index);
            Tuple<List<Long>, Long> currHoliday = holidayMap.get(calendar.getTime());
            boolean isHandled = false;
            if (holidayHandleParam.isHandleHoliday() && currHoliday != null && !CollectionUtils.isEmpty((Collection)((Collection)currHoliday.item1))) {
                for (HolidayHandleEntry holidayHandleEntry : holidayHandleParam.getHolidayHandleEntries()) {
                    if (!holidayHandleEntry.getHolidayDateTypeIds().contains(currHoliday.item2)) continue;
                    retMap.put(currDate, holidayHandleEntry.getAssignShiftId());
                    isHandled = true;
                    if (!"C".equals(holidayHandleEntry.getHandleMethod())) break;
                    ++index;
                    index %= shiftModeCells.size();
                    break;
                }
            }
            if (!isHandled) {
                retMap.put(currDate, shiftModeCell.getId());
                ++index;
                index %= shiftModeCells.size();
            }
            calendar.add(6, 1);
        }
        return retMap;
    }

    @Deprecated
    public Map<LocalDate, Long> genRosterShiftBoInfos(Date baseDate, Date startDate, Date endDate, Long shiftModeId) {
        LOG.info("genRosterShiftBoInfos.params:{},{},{},{}", new Object[]{baseDate, startDate, endDate, shiftModeId});
        DynamicObject shiftModeDy = this.queryShiftModeDy(shiftModeId);
        String cycleMode = shiftModeDy.getString("cyclemode");
        return this.genRosterShiftBoInfos(baseDate, startDate, endDate, cycleMode, this.getShiftCells(shiftModeDy));
    }

    @Deprecated
    public Map<LocalDate, Long> genRosterShiftBoInfos(Date baseDate, Date startDate, Date endDate, String cycleMode, List<ShiftModeCell> shiftModeCells) {
        LocalDate refDate;
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)(WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1));
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        if ("w".equals(cycleMode)) {
            calendar.setTime(baseDate);
            calendar.set(7, 2);
            refDate = WTCDateUtils.getLocalDateByCalendarIns((Calendar)calendar);
        } else {
            refDate = WTCDateUtils.toLocalDate((Date)baseDate);
        }
        LocalDate startLocalDate = WTCDateUtils.toLocalDate((Date)startDate);
        long endTime = endDate.getTime();
        LocalDate currRefStartDate = refDate;
        LocalDate nextRefStartDate = currRefStartDate.plusDays(shiftModeCells.size());
        while (!nextRefStartDate.isAfter(startLocalDate)) {
            currRefStartDate = nextRefStartDate;
            nextRefStartDate = currRefStartDate.plusDays(shiftModeCells.size());
        }
        int startIndex = (int)currRefStartDate.until(startLocalDate, ChronoUnit.DAYS);
        calendar.setTime(startDate);
        int index = startIndex % shiftModeCells.size();
        while (calendar.getTimeInMillis() <= endTime) {
            LocalDate currDate = WTCDateUtils.getLocalDateByCalendarIns((Calendar)calendar);
            ShiftModeCell shiftModeCell = shiftModeCells.get(index);
            retMap.put(currDate, shiftModeCell.getId());
            ++index;
            index %= shiftModeCells.size();
            calendar.add(6, 1);
        }
        return retMap;
    }

    public List<ShiftModeCell> getShiftCells(DynamicObject shiftModeDy) {
        DynamicObjectCollection dyColl = shiftModeDy.getDynamicObjectCollection("wtbd_shiftmodeentry");
        ArrayList withClazzCells = Lists.newArrayListWithCapacity((int)dyColl.size());
        String mode = shiftModeDy.getString("cyclemode");
        for (DynamicObject dyno : dyColl) {
            int index;
            long shiftid = dyno.getLong("shiftid");
            if (shiftid == 0L) continue;
            ShiftModeCell shiftModeCell = new ShiftModeCell();
            if ("w".equals(mode)) {
                index = dyno.getInt("weekday");
                int nWeek = dyno.getInt("nweek");
                index = (nWeek - 1) * 7 + index;
            } else {
                index = dyno.getInt("nday");
            }
            shiftModeCell.setId(shiftid);
            shiftModeCell.setIndex(index - 1);
            withClazzCells.add(shiftModeCell);
        }
        return withClazzCells;
    }

    public DynamicObject queryShiftModeDy(Long shiftModeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_shiftmode");
        return serviceHelper.loadSingle((Object)shiftModeId);
    }

    public boolean validateShiftCross(ShiftModeTable table) {
        List shiftModeCells = table.getCells().stream().sorted(Comparator.comparingInt(ShiftModeCell::getIndex)).collect(Collectors.toList());
        int len = shiftModeCells.size();
        if (shiftModeCells.size() > 0) {
            shiftModeCells.add(shiftModeCells.get(0));
            Iterator iterator = shiftModeCells.iterator();
            ShiftModeCell currCell = (ShiftModeCell)iterator.next();
            while (iterator.hasNext()) {
                ShiftModeCell nextCell = (ShiftModeCell)iterator.next();
                if (this.isOverLap(currCell, nextCell) && (currCell.getIndex() + 1) % len == nextCell.getIndex()) {
                    return true;
                }
                currCell = nextCell;
            }
        }
        return false;
    }

    public void setCellsOverLap(Collection<ShiftModeCell> cells, int len) {
        cells.forEach(cell -> cell.setShiftTimeOverLap(Boolean.FALSE));
        List shiftModeCells = cells.stream().sorted(Comparator.comparingInt(ShiftModeCell::getIndex)).collect(Collectors.toList());
        if (shiftModeCells.size() > 0) {
            shiftModeCells.add(shiftModeCells.get(0));
            Iterator iterator = shiftModeCells.iterator();
            ShiftModeCell currCell = (ShiftModeCell)iterator.next();
            while (iterator.hasNext()) {
                ShiftModeCell nextCell = (ShiftModeCell)iterator.next();
                if (this.isOverLap(currCell, nextCell) && (currCell.getIndex() + 1) % len == nextCell.getIndex()) {
                    currCell.setShiftTimeOverLap(Boolean.TRUE);
                    nextCell.setShiftTimeOverLap(Boolean.TRUE);
                }
                currCell = nextCell;
            }
        }
    }

    public void validateShiftOverlap(ShiftModeTable table) {
        List<ShiftModeCell> shiftModeCells = table.getCells().stream().sorted(Comparator.comparingInt(ShiftModeCell::getIndex)).collect(Collectors.toList());
        shiftModeCells.forEach(cell -> cell.setShiftTimeOverLap(null));
        for (int i = 0; i < shiftModeCells.size(); ++i) {
            ShiftModeCell currCell = (ShiftModeCell)shiftModeCells.get(i);
            ShiftModeCell nextCell = null;
            if (i < shiftModeCells.size() - 1 && ((ShiftModeCell)shiftModeCells.get(i + 1)).getIndex() - currCell.getIndex() == 1) {
                nextCell = (ShiftModeCell)shiftModeCells.get(i + 1);
            } else if (i == shiftModeCells.size() - 1 && currCell.getIndex() == table.getEndindex() && ((ShiftModeCell)shiftModeCells.get(0)).getIndex() == 0) {
                nextCell = (ShiftModeCell)shiftModeCells.get(0);
            }
            if (nextCell == null || !this.isOverLap(currCell, nextCell)) continue;
            currCell.setShiftTimeOverLap(Boolean.TRUE);
            nextCell.setShiftTimeOverLap(Boolean.TRUE);
        }
    }

    public boolean isOverLap(ShiftModeCell firstCell, ShiftModeCell tailCell) {
        boolean isOverLap = firstCell.getEndTimeSecondsOfDay() - 86400 > tailCell.getStartTimeSecondsOfDay();
        boolean isAllHasDuration = (!firstCell.isOff() || firstCell.isOff() && !firstCell.isOffNoPlan()) && (!tailCell.isOff() || tailCell.isOff() && !tailCell.isOffNoPlan());
        return isOverLap && isAllHasDuration;
    }

    public ShiftModeCell getShiftModeCell(ShiftModeCell cell, DynamicObject shift) {
        cell.setNumber(shift.getString("number"));
        cell.setName(shift.getString("name"));
        cell.setColor(shift.getString("shiftcolor"));
        int startTime = shift.getInt("shiftstart");
        cell.setStarttime(WTCDateUtils.secondToTime((long)startTime, (String)"h:m"));
        cell.setStartTimeSecondsOfDay(startTime);
        int endTime = shift.getInt("shiftend");
        cell.setEndtime(WTCDateUtils.secondToTime((long)endTime, (String)"h:m"));
        cell.setEndTimeSecondsOfDay(Optional.ofNullable(RefDateType.from((String)shift.getString("referenceendday"))).map(type -> type.getAdjustSecond(endTime)).orElseGet(() -> 0).intValue());
        cell.setOff(shift.getBoolean("isoff"));
        cell.setOffNoPlan(shift.getBoolean("offnonplan"));
        cell.setShiftEntryList(ShiftService.getInstance().getShiftDetailList(shift));
        return cell;
    }

    public ShiftModeCell getShiftModeCell(ShiftModeCell cell, Shift shift) {
        cell.setNumber(shift.getNumber());
        cell.setName(shift.getName());
        cell.setColor(shift.getShiftColor());
        int startTime = shift.getLastShiftStartDate();
        cell.setStarttime(WTCDateUtils.secondToTime((long)startTime, (String)"h:m"));
        cell.setStartTimeSecondsOfDay(startTime);
        int endTime = shift.getLastShiftEndDate();
        cell.setEndtime(WTCDateUtils.secondToTime((long)endTime, (String)"h:m"));
        cell.setEndTimeSecondsOfDay(Optional.ofNullable(RefDateType.from((String)shift.getLastRefEndDay())).map(type -> type.getAdjustSecond(endTime)).orElseGet(() -> 0).intValue());
        cell.setOff(shift.isOff());
        cell.setOffNoPlan(shift.getOffNonPlan());
        return cell;
    }

    public ShiftModeTable getShiftTable(DynamicObject shiftModeDy, boolean loadShiftInfo) {
        int startIndex;
        String mode;
        DynamicObjectCollection dynamicObjectCollection = shiftModeDy.getDynamicObjectCollection("wtbd_shiftmodeentry");
        ShiftModeTable shiftModeTable = new ShiftModeTable();
        if (dynamicObjectCollection.isEmpty()) {
            return shiftModeTable;
        }
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        int entryRowCount = dynamicObjectCollection.getRowCount();
        int nday = dynamicObject.getInt("nday");
        if (nday > 0) {
            mode = "d";
            startIndex = nday - 1;
        } else {
            int weekday = dynamicObject.getInt("weekday");
            mode = "w";
            startIndex = weekday - 1;
        }
        LinkedHashSet<ShiftModeCell> withClazzCells = new LinkedHashSet<ShiftModeCell>(this.getShiftCells(shiftModeDy));
        if (loadShiftInfo) {
            this.setShiftClazz(withClazzCells);
        }
        int endIndex = startIndex + entryRowCount - 1;
        int rows = (int)Math.ceil((double)(endIndex + 1) / 7.0);
        shiftModeTable.setStartindex(startIndex);
        shiftModeTable.setEndindex(endIndex);
        shiftModeTable.setMode(mode);
        shiftModeTable.setCells(withClazzCells);
        shiftModeTable.setRows(rows);
        return shiftModeTable;
    }

    private void setShiftClazz(Set<ShiftModeCell> withClazzCells) {
        List<Long> shiftIds = withClazzCells.stream().map(ShiftModeCell::getId).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.queryShiftByIdIn(shiftIds);
        HashMap id2Dyn = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            id2Dyn.put(dynamicObject.getLong("id"), dynamicObject);
        }
        withClazzCells.forEach(cell -> {
            DynamicObject dyn = (DynamicObject)id2Dyn.get(cell.getId());
            if (dyn == null) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u73ed\u6b21\u4fe1\u606f:%s\u3002", (String)"ShiftModeEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), cell.getId()));
            }
            ShiftModeService.getInstance().getShiftModeCell((ShiftModeCell)cell, dyn);
        });
    }

    private DynamicObject[] queryShiftByIdIn(List<Long> shiftIds) {
        return ShiftServiceHelper.queryShiftByIdIn(shiftIds);
    }
}

