/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.auth;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.AuthFieldDTO;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class HRAuthService {
    private static final Log LOGGER = LogFactory.getLog(HRAuthService.class);
    public static final String PARAM_RETRIEVAL_CONFIG_F7_AUTH_ENABLE = "retrievalConfigF7AuthEnable";
    public static final String PARAM_RULE_CONDITION_F7_AUTH_ENABLE = "ruleConditionF7AuthEnable";
    private static final HRAuthService INSTANCE = (HRAuthService)WTCAppContextHelper.getBean(HRAuthService.class);

    public static HRAuthService getInstance() {
        return INSTANCE;
    }

    @Deprecated
    private Map<String, Object> convertDynamicObjectToMap(DynamicObject dataEntity) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return jser.serializeToMap((Object)dataEntity, null);
    }

    private List<DynamicObject> getAttFile(List attfileIds) {
        String fileField = "id,org,affiliateadminorg,empgroup,dependency,dependencytype,workplace,cmpemp.managingscope as managingscope";
        String empField = Stream.of("position", "job", "company", "adminorg").map(ss -> "empposorgrel." + ss + " as " + ss).collect(Collectors.joining(","));
        String personField = "attperson.agreedlocation as agreedlocation";
        String selects = String.join((CharSequence)",", fileField, empField, personField);
        return AttFileQueryServiceImpl.getInstance().queryAttFileByIds(selects, attfileIds);
    }

    public AuthFieldDTO getAuthField(long attfileId) {
        List<AuthFieldDTO> authFields = this.getAuthField(Collections.singletonList(attfileId));
        if (CollectionUtils.isEmpty(authFields)) {
            return null;
        }
        return authFields.get(0);
    }

    public List<AuthFieldDTO> getAuthField(List<Long> attfileIds) {
        List<DynamicObject> attFiles = this.getAttFile(attfileIds);
        ArrayList<AuthFieldDTO> list = new ArrayList<AuthFieldDTO>(attfileIds.size());
        for (DynamicObject attFile : attFiles) {
            Map<String, Object> map = this.convertDynamicObjectToMap(attFile);
            AuthFieldDTO dto = (AuthFieldDTO)new JSONObject(map).toJavaObject(AuthFieldDTO.class);
            list.add(dto);
        }
        return list;
    }

    public Map<Long, AuthFieldDTO> getAuthFieldMap(List<Long> attFileIds) {
        List<AuthFieldDTO> authFieldDTOList = this.getAuthField(attFileIds);
        return authFieldDTOList.stream().collect(Collectors.toMap(AuthFieldDTO::getId, Function.identity(), (oldValue, newValue) -> oldValue));
    }

    public void setAuthField(DynamicObject obj, long attfileId) {
        AuthFieldDTO dto = this.getAuthField(attfileId);
        JSONObject json = (JSONObject)JSONObject.toJSON((Object)dto);
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            if (!obj.containsProperty(key)) continue;
            obj.set(key, entry.getValue());
        }
    }

    @Deprecated
    public QFilter getDataRule(Long userId, String appNumber, String entityNumber, String perm, Map<String, Object> customParam) {
        return this.getDataRule(userId, appNumber, entityNumber, "org", perm, customParam);
    }

    @Deprecated
    public QFilter getAllPermOrgs(String appNumber, String entityNumber, String orgKey) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        QFilter orgFilter = null;
        HasPermOrgResult allPermOrg = WTCPermUtils.getAllPermOrgs(appId, entityNumber);
        if (allPermOrg != null && !allPermOrg.hasAllOrgPerm() && !allPermOrg.getHasPermOrgs().isEmpty()) {
            orgFilter = new QFilter(orgKey, "in", (Object)allPermOrg.getHasPermOrgs());
        }
        return orgFilter;
    }

    @Deprecated
    public QFilter getDataRule(Long userId, String appNumber, String entityNumber, String orgKey, String perm, Map<String, Object> customParam) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        QFilter filter = (QFilter)WTCServiceHelper.invokeHRMPService("hrcs", "IHRCSDataPermissionService", "getDataRule", userId, appId, entityNumber, perm, customParam == null ? Collections.emptyMap() : customParam);
        LOGGER.info("getDateRule userId={}, appNumber={}, entityNumber={}, perm={}, orgKey={}, customParams={}, filter={}", new Object[]{userId, appNumber, entityNumber, perm, orgKey, customParam, filter});
        QFilter orgFilter = this.getAllPermOrgs(appNumber, entityNumber, orgKey);
        if (filter == null && orgFilter == null) {
            return null;
        }
        if (filter != null && orgFilter != null) {
            return filter.and(orgFilter);
        }
        if (filter != null) {
            return filter;
        }
        return orgFilter;
    }

    public Map<Object, Boolean> matchDataRule(Long userId, String appNumber, String entityNumber, String perm, Long[] ids, Map<String, Object> customParam) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        return this.matchDataRule(userId, appNumber, entityNumber, perm, filter, customParam);
    }

    @Deprecated
    public Map<Object, Boolean> matchDataRule(Long userId, String appNumber, String entityNumber, String perm, QFilter filter, Map<String, Object> customParam) {
        Object ret = WTCServiceHelper.invokeHRMPService("hrcs", "IHRCSDataPermissionService", "matchDataRule", userId, AppMetadataCache.getAppInfo((String)appNumber).getId(), entityNumber, perm, filter, customParam == null ? Collections.emptyMap() : customParam);
        LOGGER.info("matchDataRule userId={}, appNumber={}, entityNumber={}, perm={}, filter={}, customParam={}, ret={}", new Object[]{userId, appNumber, entityNumber, perm, filter, customParam, ret});
        return (Map)ret;
    }

    @Deprecated
    public QFilter getDataRuleForBdProp(Long userId, String appNumber, String entityNumber, String propKey, String perm, Map<String, Object> customParam) {
        Object ret = WTCServiceHelper.invokeHRMPService("hrcs", "IHRCSDataPermissionService", "getDataRuleForBdProp", userId, AppMetadataCache.getAppInfo((String)appNumber).getId(), entityNumber, propKey, perm, customParam == null ? Collections.emptyMap() : customParam);
        LOGGER.info("getDataRuleForBdProp userId={}, appNumber={}, entityNumber={}, propKey={}, perm={}, customParam={}, ret={}", new Object[]{userId, appNumber, entityNumber, propKey, perm, customParam, ret});
        return (QFilter)ret;
    }

    @Deprecated
    public long getUserHasPerOrgId(String entityName, String appId) {
        boolean hasUserCurOrg;
        long userOrgID = RequestContext.get().getOrgId();
        List allOrgList = OrgUnitServiceHelper.getAllOrgByViewId((long)26L, (boolean)false);
        LOGGER.info("getUserHasPerOrgId_{}_{}, userOrgID={}", new Object[]{entityName, allOrgList.size(), userOrgID});
        if (WTCCollections.isEmpty((Collection)allOrgList)) {
            return 0L;
        }
        HasPermOrgResult hasOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"26", (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)entityName, (String)"47150e89000000ac");
        HashSet allOrg = Sets.newHashSet((Iterable)allOrgList);
        boolean bl = hasUserCurOrg = allOrg.contains(userOrgID) && hasOrg.hasAllOrgPerm() || allOrg.contains(userOrgID) && WTCCollections.isNotEmpty((Collection)hasOrg.getHasPermOrgs()) && hasOrg.getHasPermOrgs().contains(userOrgID);
        if (hasUserCurOrg) {
            return userOrgID;
        }
        if (hasOrg.hasAllOrgPerm()) {
            return (Long)allOrg.stream().min(Long::compareTo).get();
        }
        if (WTCCollections.isNotEmpty((Collection)hasOrg.getHasPermOrgs())) {
            return (Long)hasOrg.getHasPermOrgs().stream().min(Long::compare).get();
        }
        return 0L;
    }

    public void genPermOrgResultWithSubCache(ListShowParameter listParameter, boolean isCheckIgnoreConfig, PageCache cache) {
        boolean isIgnoreDataRule;
        String permEntityId = (String)listParameter.getCustomParam("customHREntityNumber");
        if (HRStringUtils.isEmpty((String)permEntityId)) {
            permEntityId = listParameter.getBillFormId();
        }
        String permItemId = (String)listParameter.getCustomParam("customHRPermItemId");
        String permProKey = (String)listParameter.getCustomParam("custom_parent_f7_prop");
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = listParameter.getAppId();
        if (isCheckIgnoreConfig && (isIgnoreDataRule = ((Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"isIgnoreEntityDataRule", (Object[])new Object[]{appId, permEntityId})).booleanValue())) {
            AuthorizedOrgResultWithSub permResult = AuthorizedOrgResultWithSub.allOrg();
            cache.put("perm_org_result", SerializationUtils.toJsonString((Object)permResult));
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, permProKey});
        cache.put("perm_org_result_withsub", SerializationUtils.toJsonString((Object)permResult));
    }

    public Optional<QFilter> getF7PermQFilterByDataRule(String entityNumber) {
        return this.getF7PermQFilterByDataRule(entityNumber, PARAM_RETRIEVAL_CONFIG_F7_AUTH_ENABLE);
    }

    public Optional<QFilter> getF7PermQFilterByDataRule(String entityNumber, String customParamKey) {
        if (!this.needF7Auth(customParamKey)) {
            return Optional.empty();
        }
        long userId = RequestContext.get().getCurrUserId();
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)userId);
        if (isSuperUser) {
            return Optional.empty();
        }
        List<String> checkedAppIds = this.getAllCheckedAppIds(entityNumber);
        if (WTCCollections.isEmpty(checkedAppIds)) {
            return Optional.empty();
        }
        QFilter dataFilter = null;
        for (String checkAppId : checkedAppIds) {
            boolean hasQueryPerm = PermissionServiceHelper.hasViewPermission((long)userId, (String)checkAppId, (String)entityNumber);
            QFilter curDataFilter = !hasQueryPerm ? new QFilter("1", "!=", (Object)1) : PermissionServiceHelper.getDataRule((long)userId, (String)checkAppId, (String)entityNumber, (String)"47150e89000000ac");
            if (null == curDataFilter) {
                curDataFilter = new QFilter("1", "=", (Object)1);
            }
            dataFilter = null == dataFilter ? curDataFilter : dataFilter.or(curDataFilter);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getPermQFilterByDataRule: entityNumber={}, appid={}, dataFilter={}", new Object[]{entityNumber, checkedAppIds, dataFilter});
        }
        return Optional.ofNullable(dataFilter);
    }

    private boolean needF7Auth(String customParamKey) {
        AppCustomParam param = new AppCustomParam();
        param.setAppId(AppMetadataCache.getAppInfo((String)"wtbd").getId());
        param.setSearchKeySet((Set)Sets.newHashSet((Object[])new String[]{customParamKey}));
        Map paramMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)param);
        return paramMap != null && HRStringUtils.equals((String)"true", (String)((String)paramMap.get(customParamKey)));
    }

    private List<String> getAllCheckedAppIds(String entityNumber) {
        MainEntityType mainEntityType = this.getDataEntityType(entityNumber);
        if (null == mainEntityType) {
            return Collections.emptyList();
        }
        ArrayList<String> checkedAppIds = new ArrayList<String>(10);
        checkedAppIds.add(mainEntityType.getAppId());
        PermissionControlType permissionControlType = EntityMetadataCache.getPermissionControlType((String)entityNumber);
        if (null != permissionControlType && WTCCollections.isNotEmpty((Collection)permissionControlType.getPublishApps())) {
            checkedAppIds.addAll(permissionControlType.getPublishApps());
        }
        return checkedAppIds;
    }

    private MainEntityType getDataEntityType(String number) {
        try {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)number);
            return mainEntity;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

