/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.auth;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuth;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class HRAuthUtil {
    private static final Integer MAP_SIZE = 18;
    public static final String ATT_FILE_ID = "id";
    public static final String ATT_FILE_BO_ID = "boid";
    public static final String ATT_PERSON_ID = "attperson.id";
    public static final String ATT_TAG_ID = "atttag.id";
    public static final String DEP_EMP_JOB_ID = "empposorgrel.id";
    public static final String POSITION = "empposorgrel.position.id";
    public static final String JOB = "empposorgrel.job.id";
    public static final String MANAGING_SCOPE = "cmpemp.managingscope.id";
    public static final String COMPANY = "empposorgrel.company.id";
    public static final String ADMIN_ORG = "empposorgrel.adminorg.id";
    public static final String AGREED_WORKPLACE = "attperson.agreedlocation.id";
    public static final String ORG = "org.id";
    public static final String AFFILIATE_ADMIN_ORG = "affiliateadminorg.id";
    public static final String EMP_GROUP = "empgroup.id";
    public static final String DEPENDENCY = "dependency.id";
    public static final String DEPENDENCY_TYPE = "dependencytype.id";
    public static final String WORKPLACE = "workplace.id";
    public static final String EFF_START_DATE = "bsed";
    public static final String ATT_FILE_SHARD_TASK_PROPERTY = String.join((CharSequence)",", "id", "boid", "attperson.id", "atttag.id", "empposorgrel.id", "empposorgrel.position.id", "empposorgrel.job.id", "cmpemp.managingscope.id", "empposorgrel.company.id", "empposorgrel.adminorg.id", "attperson.agreedlocation.id", "org.id", "affiliateadminorg.id", "empgroup.id", "dependency.id", "dependencytype.id", "workplace.id", "bsed", "attperson.number", "number");

    public static List<Map<String, Object>> getAuthFieldByAttFileDynBatch(List<DynamicObject> attFileList) {
        return attFileList.stream().map(HRAuthUtil::getAuthFieldByAttFileDyn).collect(Collectors.toList());
    }

    public static Map<String, Object> getAuthFieldByAttFileDyn(DynamicObject attFileDyn) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)MAP_SIZE);
        param.put("attFileId", attFileDyn.getLong(ATT_FILE_ID));
        param.put("attFileBoId", attFileDyn.getLong(ATT_FILE_BO_ID));
        param.put("attPersonId", attFileDyn.getLong(ATT_PERSON_ID));
        param.put("attTagId", attFileDyn.getLong(ATT_TAG_ID));
        param.put("depEmpJobId", attFileDyn.getLong(DEP_EMP_JOB_ID));
        param.put("org", attFileDyn.getLong(ORG));
        return param;
    }

    public static Map<String, Object> getAuthFieldByAttFile(AttFileAuth attFile) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)MAP_SIZE);
        param.put("attFileId", attFile.getAttFile().getVid());
        param.put("attFileBoId", attFile.getAttFile().getBoid());
        param.put("attPersonId", attFile.getAttPerson().getBoid());
        param.put("attTagId", attFile.getAttFile().getAttTag().getBoid());
        param.put("depEmpJobId", attFile.getAssign().getBoid());
        param.put("org", attFile.getAttFile().getOrg().getBoid());
        return param;
    }

    @Deprecated
    public static List<Map<String, Object>> getAuthFieldByAttFileBatch(List<AttFileAuth> attFileAuthList) {
        return attFileAuthList.stream().map(HRAuthUtil::getAuthFieldByAttFile).collect(Collectors.toList());
    }
}

