/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.auth;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.IWTCBizDataPermissionService;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.web.WTCInvokeServiceHelper;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.tuple.MutablePair;
import kd.wtc.wtbs.common.util.third.tuple.Pair;

public class WTCBizDataPermissionServiceImpl
implements IWTCBizDataPermissionService {
    private static final Log LOGGER = LogFactory.getLog(WTCBizDataPermissionServiceImpl.class);
    private static final WTCBizDataPermissionServiceImpl INSTANCE = (WTCBizDataPermissionServiceImpl)WTCAppContextHelper.getBean(WTCBizDataPermissionServiceImpl.class);

    public static WTCBizDataPermissionServiceImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public HasPermOrgResult getAllPermOrgs(String appId, String entityNum) {
        return this.getAllPermOrgs(appId, entityNum, "47150e89000000ac");
    }

    @Override
    public HasPermOrgResult getAllPermOrgs(String appId, String entityNum, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    @Override
    public QFilter getAllPermOrgsWithOrgKey(String appNumber, String entityNumber, String orgKey) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        QFilter orgFilter = null;
        HasPermOrgResult allPermOrg = WTCPermUtils.getAllPermOrgs(appId, entityNumber);
        if (allPermOrg != null && !allPermOrg.hasAllOrgPerm() && !allPermOrg.getHasPermOrgs().isEmpty()) {
            orgFilter = new QFilter(orgKey, "in", (Object)allPermOrg.getHasPermOrgs());
        }
        return orgFilter;
    }

    @Override
    public HasPermOrgResult getAllPermOrg(long userId, String appId, String entityNum, String permissionItem) {
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permissionItem);
    }

    @Override
    public List<Long> getPermAdminOrgIds(String appId, String entityId, String permKey, String permItemId, boolean isEnabled) {
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (superUser) {
            return WTCInvokeServiceHelper.getAllAdminOrgIds(isEnabled);
        }
        AuthorizedOrgResult authorizedOrgResult = WTCInvokeServiceHelper.getAuthorizedAdminOrgSet(appId, entityId, permItemId, permKey);
        return authorizedOrgResult.getHasPermOrgs();
    }

    @Override
    public long getUserHasPerOrgId(String entityName, String appId) {
        boolean hasUserCurOrg;
        long userOrgID = RequestContext.get().getOrgId();
        List allOrgList = OrgUnitServiceHelper.getAllOrgByViewId((long)26L, (boolean)false);
        LOGGER.info("getUserHasPerOrgId_{}_{}, userOrgID={}", new Object[]{entityName, allOrgList.size(), userOrgID});
        if (WTCCollections.isEmpty((Collection)allOrgList)) {
            return 0L;
        }
        HasPermOrgResult hasOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"26", (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)entityName, (String)"47150e89000000ac");
        HashSet allOrg = Sets.newHashSet((Iterable)allOrgList);
        boolean bl = hasUserCurOrg = allOrg.contains(userOrgID) && hasOrg.hasAllOrgPerm() || allOrg.contains(userOrgID) && WTCCollections.isNotEmpty((Collection)hasOrg.getHasPermOrgs()) && hasOrg.getHasPermOrgs().contains(userOrgID);
        if (hasUserCurOrg) {
            return userOrgID;
        }
        if (hasOrg.hasAllOrgPerm()) {
            return allOrg.stream().min(Long::compareTo).orElse(0L);
        }
        if (WTCCollections.isNotEmpty((Collection)hasOrg.getHasPermOrgs())) {
            return hasOrg.getHasPermOrgs().stream().min(Long::compare).orElse(0L);
        }
        return 0L;
    }

    @Override
    public Pair<Boolean, List<Long>> getAllPermOrg(String appNumber, String pageNumber, String permissionItem) {
        return this.getIntHROrgStrucViewAndUserPermOrg(appNumber, pageNumber, permissionItem);
    }

    private Pair<Boolean, List<Long>> getIntHROrgStrucViewAndUserPermOrg(String appNumber, String pageNumber, String permissionItem) {
        LOGGER.info("appNumber:{},pageNumber:{},permissionItem:{}", new Object[]{appNumber, pageNumber, permissionItem});
        HasPermOrgResult hasPermOrgResult = this.getHasPermOrgResult(appNumber, pageNumber, permissionItem);
        List<Long> orgList = this.queryHRStructureOrgByAppID();
        return this.takeOrgIntersection(hasPermOrgResult, orgList);
    }

    private Pair<Boolean, List<Long>> takeOrgIntersection(HasPermOrgResult hasPermOrgResult, List<Long> orgList) {
        MutablePair pair = new MutablePair((Object)Boolean.TRUE, orgList);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List result = orgList.stream().filter(item -> hasPermOrgResult.getHasPermOrgs().contains(item)).collect(Collectors.toList());
            pair.setLeft((Object)Boolean.FALSE);
            pair.setRight(result);
        }
        LOGGER.info("HRStructureTreeOrgHelper.takeOrgIntersection.Pair : {}", (Object)WTCSerializationUtils.toJsonString((Object)pair));
        return pair;
    }

    private List<Long> queryHRStructureOrgByAppID() {
        return this.queryDefaultHRStructureOrg();
    }

    private List<Long> queryDefaultHRStructureOrg() {
        DynamicObject dynamicObject = this.queryDefaultHRStructureDynamicObject();
        return this.queryHRStructureOrg(dynamicObject.getLong("id"));
    }

    private List<Long> queryHRStructureOrg(long viewId) {
        return OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)false);
    }

    private DynamicObject queryDefaultHRStructureDynamicObject() {
        long defaultHRViewSchemaID = this.getDefaultHRViewSchemaID();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_org_viewschema");
        return hrBaseServiceHelper.queryOne((Object)defaultHRViewSchemaID);
    }

    private long getDefaultHRViewSchemaID() {
        return OrgUnitServiceHelper.getViewIdByType((String)"26");
    }

    private HasPermOrgResult getHasPermOrgResult(String appNumber, String pageNumber, String permissionItem) {
        HasPermOrgResult result;
        LOGGER.info("appNumber:{},pageNumber:{},permissionItem:{}", new Object[]{appNumber, pageNumber, permissionItem});
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getAppIdByAppNumber(appNumber);
        String entityNum = this.getEntityNumber(pageNumber);
        if (permissionItem == null || HRStringUtils.equals((String)permissionItem, (String)"47150e89000000ac")) {
            result = this.getAllPermOrg(userId, appId, entityNum, "47150e89000000ac");
        } else {
            Set<String> entityPermSetByNumber = this.getEntityPermSetByNumber(entityNum);
            result = this.getAllPermOrg(userId, appId, entityNum, permissionItem);
            if (entityPermSetByNumber.contains("47150e89000000ac")) {
                HasPermOrgResult viewPerm = this.getAllPermOrg(userId, appId, entityNum, "47150e89000000ac");
                List hasPermOrgs = result.getHasPermOrgs().stream().filter(org -> viewPerm.getHasPermOrgs().contains(org)).collect(Collectors.toList());
                result = new HasPermOrgResultImpl(viewPerm.hasAllOrgPerm(), hasPermOrgs);
            }
        }
        return result;
    }

    private String getAppIdByAppNumber(String appNumber) {
        return AppMetadataCache.getAppInfo((String)appNumber).getId();
    }

    private String getEntityNumber(String pageNumber) {
        return FormMetadataCache.getFormConfig((String)pageNumber).getEntityTypeId();
    }

    private Set<String> getEntityPermSetByNumber(String pageNumber) {
        return EntityMetadataCache.getPermissionItems((String)pageNumber);
    }

    @Override
    public List<Long> getSubAdminOrg(List<Long> adminOrgList) {
        List<Map<String, Object>> adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        List<Long> subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
        subOrgIdList.addAll(adminOrgList);
        return subOrgIdList;
    }
}

