/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.auth;

import java.util.Collections;
import java.util.Map;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.auth.IWTCDataPermissionService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;

public class WTCDataPermissionServiceImpl
implements IWTCDataPermissionService {
    private static final WTCDataPermissionServiceImpl INSTANCE = (WTCDataPermissionServiceImpl)WTCAppContextHelper.getBean(WTCDataPermissionServiceImpl.class);

    public static WTCDataPermissionServiceImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public QFilter getDataRule(long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam) {
        HRCSMServiceImpl instance = HRCSMServiceImpl.getInstance();
        return instance.getDataRule(userId, appId, entityNum, permItemId, customParam);
    }

    @Override
    public QFilter getDataRule(Long userId, String appNumber, String entityNumber, String perm, Map<String, Object> customParam) {
        return this.getDataRule(userId, appNumber, entityNumber, "org", perm, customParam);
    }

    @Override
    public QFilter getDataRule(Long userId, String appNumber, String entityNumber, String orgKey, String perm, Map<String, Object> customParam) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        QFilter filter = HRCSMServiceImpl.getInstance().getDataRule(userId, appId, entityNumber, perm, customParam == null ? Collections.emptyMap() : customParam);
        QFilter orgFilter = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgsWithOrgKey(appNumber, entityNumber, orgKey);
        if (filter == null && orgFilter == null) {
            return null;
        }
        if (filter != null && orgFilter != null) {
            return filter.and(orgFilter);
        }
        if (filter != null) {
            return filter;
        }
        return orgFilter;
    }
}

