/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionEvent;
import kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin;
import kd.sdk.wtc.wtbs.common.access.ConditionDtoExt;
import kd.sdk.wtc.wtes.business.tie.core.chain.PreLimitCondition;
import kd.wtc.wtbs.business.bill.IAttfileLimitScopeService;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.model.attendperson.HRPIEntityPropertyConst;
import kd.wtc.wtbs.business.rulecondition.RuleConditionResultMatchService;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.rulecondition.ThreeFunction;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.business.util.ext.ConditionDtoExtBridge;
import kd.wtc.wtbs.business.util.ext.LimitConditionExpBundle;
import kd.wtc.wtbs.business.util.ext.PreLimitConditionQueryHelper;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.bill.unifybill.MatchRuleCal;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class AttfileLimitScopeServiceImpl
implements IAttfileLimitScopeService {
    private static final Map<String, Function<AttfileLimitScope, Object>> MAPPING;
    private static final String QUERYFIELD;
    private static final Log log;

    @Override
    public boolean matchLimit(AttfileLimitScope scope, String conditionJson) {
        return this.matchLimit(scope, conditionJson, null);
    }

    @Override
    public boolean matchLimit(AttfileLimitScope scope, String conditionJson, LimitConditionExpBundle limitBundle) {
        return this.matchLimit(scope, conditionJson, limitBundle, null);
    }

    @Override
    public boolean matchLimit(AttfileLimitScope scope, String conditionJson, LimitConditionExpBundle limitBundle, RuleConditionValues retrievalDimension) {
        if (HRStringUtils.isEmpty((String)conditionJson)) {
            return true;
        }
        AccessDto accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
        if (accessDto == null) {
            return true;
        }
        List<ConditionDto> conditionList = accessDto.getConditionList();
        String conditionExpressStr = accessDto.getConditionExpressStr();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        boolean hasPlugin = limitBundle != null && limitBundle.getPluginProxy() != null && limitBundle.getPluginProxy().hasPlugin();
        for (ConditionDto dto : conditionList) {
            String[] split;
            String substring;
            Function<AttfileLimitScope, Object> attfileLimitScopeObjectFunction;
            String retrievalWay = dto.getRetrievalWay();
            if (HRStringUtils.isNotEmpty((String)retrievalWay) && RetrievalTypeEnum.CONFIG.getValue().equals(retrievalWay)) {
                RuleConditionCommonService.configItemRetrieval(dto, map, retrievalDimension);
                continue;
            }
            String param = dto.getParam();
            String paramType = dto.getParamType();
            if (HRStringUtils.equals((String)paramType, (String)"dynamicObject")) {
                param = param.replace(".id", "");
            }
            if ((attfileLimitScopeObjectFunction = MAPPING.get(substring = (split = param.split("\\."))[split.length - 1])) == null) {
                if (hasPlugin && "OT".equals(limitBundle.getLimitSource())) {
                    this.limitConCutPoint(limitBundle.getLimitSource(), limitBundle.getAttFileVId(), limitBundle.getPluginProxy(), new PreLimitConditionQueryHelper(scope), dto, map);
                    continue;
                }
                log.warn("\u5b58\u5728\u4e0d\u652f\u6301\u7684\u9650\u5b9a\u6761\u4ef6\u573a\u666f,\u7f16\u7801\u4e3a\uff1a{}", (Object)substring);
                String tip = ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u652f\u6301\u7684\u9650\u5b9a\u6761\u4ef6\u573a\u666f,\u7f16\u7801\u4e3a\uff1a{0}\u3002", (String)"AttfileLimitScopeServiceImpl_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(tip, substring));
            }
            Object invoke = attfileLimitScopeObjectFunction.apply(scope);
            ThreeFunction<ConditionDto, Object, Map<String, Boolean>> paramMatchFunc = RuleConditionResultMatchService.getParamMatchFunc(dto.getParamType());
            if (paramMatchFunc == null) continue;
            paramMatchFunc.apply(dto, invoke, map);
        }
        return AttfileLimitScopeServiceImpl.getResult(conditionExpressStr, map);
    }

    @Override
    public Map<MatchRuleCal, Boolean> matchRuleCal(List<MatchRuleCal> matchRuleCalList) {
        return this.matchRuleCal(matchRuleCalList, null);
    }

    @Override
    public Map<MatchRuleCal, Boolean> matchRuleCal(List<MatchRuleCal> matchRuleCalList, LimitConditionExpBundle limitBundle) {
        HashMap<MatchRuleCal, Boolean> result = new HashMap<MatchRuleCal, Boolean>(4);
        if (CollectionUtils.isEmpty(matchRuleCalList)) {
            return Collections.emptyMap();
        }
        Set<Long> idSet = matchRuleCalList.stream().map(e -> e.getAttFileVersionDy().getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> attpersonList = new ArrayList<Long>(10);
        if (!CollectionUtils.isEmpty(matchRuleCalList)) {
            for (MatchRuleCal matchRuleCal : matchRuleCalList) {
                Object attperson;
                DynamicObject attFileVersionDy = matchRuleCal.getAttFileVersionDy();
                if (attFileVersionDy == null || (attperson = attFileVersionDy.get("attperson")) == null) continue;
                if (attperson instanceof Long) {
                    attpersonList.add((Long)attperson);
                    continue;
                }
                if (!(attperson instanceof DynamicObject)) continue;
                attpersonList.add(((DynamicObject)attperson).getLong("id"));
            }
        }
        Map<Long, AttfileLimitScope> limitScopeMap = this.queryAttfileVersionInfo(idSet, attpersonList);
        for (MatchRuleCal matchRuleCal : matchRuleCalList) {
            if (matchRuleCal.getNeedMatchTypeId() != null && matchRuleCal.getNeedMatchTypeId() != 0L) {
                boolean typeEquals;
                boolean bl = typeEquals = matchRuleCal.getRuleCalTypeId() == matchRuleCal.getNeedMatchTypeId().longValue();
                if (!typeEquals) {
                    result.put(matchRuleCal, Boolean.FALSE);
                    continue;
                }
            }
            DynamicObject attFileVersionDy = matchRuleCal.getAttFileVersionDy();
            AttfileLimitScope scope = limitScopeMap.get(attFileVersionDy.getLong("id"));
            if (limitBundle != null) {
                limitBundle = new LimitConditionExpBundle(limitBundle.getLimitSource(), limitBundle.getPluginProxy(), attFileVersionDy.getLong("id"));
            }
            boolean matchLimit = this.matchLimit(scope, matchRuleCal.getCalCulDes(), limitBundle);
            result.put(matchRuleCal, matchLimit);
        }
        return result;
    }

    @Override
    public Map<Long, AttfileLimitScope> queryAttfileVersionInfo(Set<Long> idSet, List<Long> attpersonList) {
        QFilter qFilter = CollectionUtils.isEmpty(idSet) ? new QFilter("attperson", "in", attpersonList) : new QFilter("id", "in", idSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"wtp_attfilebase", (String)QUERYFIELD, (QFilter[])new QFilter[]{qFilter}, null);
        HashMap<Long, AttfileLimitScope> limitScopeMap = new HashMap<Long, AttfileLimitScope>(4);
        HashSet<Long> personIdByAttFileSet = new HashSet<Long>(16);
        HashMap<Long, Long> attFileAndPersonId = new HashMap<Long, Long>(16);
        while (dataSet.hasNext()) {
            Row rs = dataSet.next();
            AttfileLimitScope attfileLimitScope = new AttfileLimitScope();
            Long attfileid = rs.getLong("ATTFILEID");
            Long attpersonid = rs.getLong("ATTPERSONID");
            if (attpersonid != null) {
                personIdByAttFileSet.add(attpersonid);
            }
            attfileLimitScope.setGender(rs.getLong("GENDER"));
            attfileLimitScope.setBeginservicedate(rs.getDate("BEGINSERVICEDATE"));
            attfileLimitScope.setLaborrelstatus(rs.getLong("LABORRELSTATUS"));
            attfileLimitScope.setObseq(rs.getLong("OBSEQ"));
            attfileLimitScope.setWorkplace(rs.getLong("WORKPLACE"));
            attfileLimitScope.setDependencytype(rs.getLong("DEPENDENCYTYPE"));
            attfileLimitScope.setOrg(rs.getLong("ORG"));
            attfileLimitScope.setAffiliateadminorg(rs.getLong("AFFILIATEADMINORG"));
            attFileAndPersonId.put(attfileid, attpersonid);
            limitScopeMap.put(attfileid, attfileLimitScope);
        }
        dataSet.close();
        ArrayList attPersonIds = Lists.newArrayListWithExpectedSize((int)personIdByAttFileSet.size());
        if (!CollectionUtils.isEmpty(attpersonList)) {
            attPersonIds = attpersonList;
        } else {
            attPersonIds.addAll(personIdByAttFileSet);
        }
        if (WTCCollections.isNotEmpty((Collection)attPersonIds)) {
            attPersonIds = new ArrayList(new HashSet(attPersonIds));
        }
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        List<Map<String, Object>> perNotProp = hrpimService.listBatchPersonAttachs(attPersonIds, null, "hrpi_pernontsprop");
        Map perNotPropToMap = perNotProp.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), (a, b) -> a));
        QFilter personQFilter = new QFilter("person", "in", attPersonIds);
        DynamicObject[] trialPeriodArr = hrpimService.listFieldsFilterInfo(StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.TRIALPERIOD_FIELDS), (String)","), personQFilter, "hrpi_trialperiod");
        Map trialPeriodGroupBy = Arrays.stream(trialPeriodArr).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        DynamicObject[] empJobRelArr = hrpimService.listFieldsFilterInfo(StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPJOBREL_FIELDS), (String)","), personQFilter, "hrpi_empjobrel");
        Map empJobRelGroupBy = Arrays.stream(empJobRelArr).filter(d -> "1".equals(d.getString("businessstatus"))).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        for (Map.Entry longAttfileLimitScopeEntry : limitScopeMap.entrySet()) {
            DynamicObject dy;
            AttfileLimitScope value = (AttfileLimitScope)longAttfileLimitScopeEntry.getValue();
            Long attFileVid = (Long)longAttfileLimitScopeEntry.getKey();
            Long personId = (Long)attFileAndPersonId.get(attFileVid);
            Map personInfoMap = (Map)perNotPropToMap.get(personId);
            Integer age = null;
            if (!CollectionUtils.isEmpty((Map)personInfoMap)) {
                age = (Integer)((Map)perNotPropToMap.get(personId)).get("age");
            }
            if (trialPeriodGroupBy.get(personId) != null) {
                dy = (DynamicObject)trialPeriodGroupBy.get(personId);
                value.setEntrydate(dy.getDate("entrydate"));
                value.setRegulardate(dy.getDate("realregulardate"));
            }
            if (empJobRelGroupBy.get(personId) != null) {
                dy = (DynamicObject)empJobRelGroupBy.get(personId);
                value.setJoblevel(dy.getLong("joblevel.id") == 0L ? null : Long.valueOf(dy.getLong("joblevel.id")));
                value.setJobgrade(dy.getLong("jobgrade.id") == 0L ? null : Long.valueOf(dy.getLong("jobgrade.id")));
            }
            value.setAge(age);
        }
        log.info("queryAttfileVersionInfo\u67e5\u8be2\u7ed3\u679c:{},", limitScopeMap);
        return limitScopeMap;
    }

    private static void putMap(ConditionDto dto, Integer age, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        String value = dto.getValue();
        Integer targetAge = Integer.parseInt(value);
        switch (operators) {
            case "==": {
                map.put(name, age.equals(targetAge));
                break;
            }
            case "!=": {
                map.put(name, !age.equals(targetAge));
                break;
            }
            case ">": {
                map.put(name, age > targetAge);
                break;
            }
            case "<": {
                map.put(name, age < targetAge);
                break;
            }
            case ">=": {
                map.put(name, age >= targetAge);
                break;
            }
            case "<=": {
                map.put(name, age <= targetAge);
                break;
            }
            case "is_null": {
                map.put(name, age == null);
                break;
            }
            case "is_not_null": {
                map.put(name, age != null);
                break;
            }
        }
    }

    private static void putMap(ConditionDto dto, Date date, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        String value = dto.getValue();
        Date targetDate = new Date();
        if (StringUtils.equalsAny((CharSequence)operators, (CharSequence[])new CharSequence[]{"==", "!=", ">", "<", ">=", "<="})) {
            try {
                targetDate = HRDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ("is_null".equals(operators) && date == null) {
            map.put(name, true);
            return;
        }
        if (date == null) {
            map.put(name, false);
            return;
        }
        switch (operators) {
            case "==": {
                map.put(name, targetDate.equals(date));
                break;
            }
            case "!=": {
                map.put(name, !targetDate.equals(date));
                break;
            }
            case ">": {
                map.put(name, date.after(targetDate));
                break;
            }
            case "<": {
                map.put(name, date.before(targetDate));
                break;
            }
            case ">=": {
                map.put(name, !date.before(targetDate));
                break;
            }
            case "<=": {
                map.put(name, !date.after(targetDate));
                break;
            }
            case "<=0d": {
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                map.put(name, !date.after(targetDate));
                break;
            }
            case ">=0d": {
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                map.put(name, !date.before(targetDate));
                break;
            }
            case "0d": {
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                map.put(name, date.equals(targetDate));
                break;
            }
            case "-1d": {
                targetDate = WTCDateUtils.getBeforeDate((Date)targetDate);
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                map.put(name, date.equals(targetDate));
                break;
            }
            case "1d": {
                targetDate = WTCDateUtils.getNextDate((Date)targetDate);
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                map.put(name, date.equals(targetDate));
                break;
            }
            case "0w": {
                Date beginDayOfWeek = WTCDateUtils.getBeginDayOfWeek((Date)targetDate);
                Date endDayOfWeek = WTCDateUtils.getEndDayOfWeek((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfWeek) >= 0 && date.compareTo(endDayOfWeek) <= 0);
                break;
            }
            case "-1w": {
                targetDate = WTCDateUtils.getCustomDate((Date)targetDate, (Integer)-7);
                Date beginDayOfWeek = WTCDateUtils.getBeginDayOfWeek((Date)targetDate);
                Date endDayOfWeek = WTCDateUtils.getEndDayOfWeek((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfWeek) >= 0 && date.compareTo(endDayOfWeek) <= 0);
                break;
            }
            case "1w": {
                targetDate = WTCDateUtils.getCustomDate((Date)targetDate, (Integer)7);
                Date beginDayOfWeek = WTCDateUtils.getBeginDayOfWeek((Date)targetDate);
                Date endDayOfWeek = WTCDateUtils.getEndDayOfWeek((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfWeek) >= 0 && date.compareTo(endDayOfWeek) <= 0);
                break;
            }
            case "0m": {
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)targetDate);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfMonth) >= 0 && date.compareTo(endDayOfMonth) <= 0);
                break;
            }
            case "-1m": {
                targetDate = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)-1);
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)targetDate);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfMonth) >= 0 && date.compareTo(endDayOfMonth) <= 0);
                break;
            }
            case "1m": {
                targetDate = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)1);
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)targetDate);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfMonth) >= 0 && date.compareTo(endDayOfMonth) <= 0);
                break;
            }
            case "-3~0m": {
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                Date customMouth = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)-3);
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)customMouth);
                map.put(name, date.compareTo(beginDayOfMonth) >= 0 && date.compareTo(targetDate) < 0);
                break;
            }
            case "0~3m": {
                targetDate = WTCDateUtils.getZeroDate((Date)targetDate);
                Date customMouth = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)3);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)customMouth);
                map.put(name, date.compareTo(targetDate) > 0 && date.compareTo(endDayOfMonth) <= 0);
                break;
            }
            case "0q": {
                Date startDayOfQuarter = WTCDateUtils.getStartDayOfQuarter((Date)targetDate);
                Date endDayOfQuarter = WTCDateUtils.getEndDayOfQuarter((Date)targetDate);
                map.put(name, date.compareTo(startDayOfQuarter) >= 0 && date.compareTo(endDayOfQuarter) <= 0);
                break;
            }
            case "-1q": {
                targetDate = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)-3);
                Date startDayOfQuarter = WTCDateUtils.getStartDayOfQuarter((Date)targetDate);
                Date endDayOfQuarter = WTCDateUtils.getEndDayOfQuarter((Date)targetDate);
                map.put(name, date.compareTo(startDayOfQuarter) >= 0 && date.compareTo(endDayOfQuarter) <= 0);
                break;
            }
            case "1q": {
                targetDate = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)3);
                Date startDayOfQuarter = WTCDateUtils.getStartDayOfQuarter((Date)targetDate);
                Date endDayOfQuarter = WTCDateUtils.getEndDayOfQuarter((Date)targetDate);
                map.put(name, date.compareTo(startDayOfQuarter) >= 0 && date.compareTo(endDayOfQuarter) <= 0);
                break;
            }
            case "0y": {
                Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)targetDate);
                Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfYear) >= 0 && date.compareTo(endDayOfYear) <= 0);
                break;
            }
            case "-1y": {
                targetDate = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)-12);
                Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)targetDate);
                Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfYear) >= 0 && date.compareTo(endDayOfYear) <= 0);
                break;
            }
            case "1y": {
                targetDate = WTCDateUtils.getCustomMouth((Date)targetDate, (Integer)12);
                Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)targetDate);
                Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)targetDate);
                map.put(name, date.compareTo(beginDayOfYear) >= 0 && date.compareTo(endDayOfYear) <= 0);
                break;
            }
            case "is_null": {
                map.put(name, date == null);
                break;
            }
            case "is_not_null": {
                map.put(name, date != null);
                break;
            }
        }
    }

    private static void putMap(ConditionDto dto, String bucketProp, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        String value = dto.getValue();
        switch (operators) {
            case "==": {
                map.put(name, HRStringUtils.equals((String)value, (String)bucketProp));
                break;
            }
            case "!=": {
                map.put(name, !HRStringUtils.equals((String)value, (String)bucketProp));
                break;
            }
            case "in": {
                List<String> list = AttfileLimitScopeServiceImpl.transformer2List(value);
                map.put(name, list.contains(bucketProp));
                break;
            }
            case "not_in": {
                List<String> list = AttfileLimitScopeServiceImpl.transformer2List(value);
                map.put(name, !list.contains(bucketProp));
                break;
            }
            case "is_null": {
                map.put(name, HRStringUtils.isEmpty((String)bucketProp));
                break;
            }
            case "is_not_null": {
                map.put(name, HRStringUtils.isNotEmpty((String)bucketProp));
            }
        }
    }

    private static List<String> transformer2List(String value) {
        String[] split = value.split(",");
        return Arrays.stream(split).collect(Collectors.toList());
    }

    public static boolean getResult(String str, Map<String, Boolean> params) {
        str = str.replaceAll(" +", "").replaceAll("and", "&").replace("or", "|");
        Set<Map.Entry<String, Boolean>> entrySet = params.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            str = str.replace(entry.getKey(), entry.getValue() != false ? "1" : "0");
        }
        int pro = AttfileLimitScopeServiceImpl.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    public static boolean get(String str) {
        int pro = AttfileLimitScopeServiceImpl.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    private static int pro(char[] arr, int beginIdx) {
        int idx;
        int culResult = 0x8000000;
        int preSign = 38;
        int len = arr.length;
        for (idx = beginIdx; idx < len; ++idx) {
            int c = arr[idx];
            if (c == 41) {
                return idx | culResult;
            }
            if (c == 40) {
                int pro = AttfileLimitScopeServiceImpl.pro(arr, idx + 1);
                int subAns = pro & 0x8000000;
                int newIdx = pro & 0xF7FFFFFF;
                c = subAns == 0 ? 48 : 49;
                idx = newIdx;
            }
            if (c == 124) {
                preSign = c;
                if (culResult == 0) continue;
                idx = AttfileLimitScopeServiceImpl.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (c == 38) {
                preSign = c;
                if (culResult != 0) continue;
                idx = AttfileLimitScopeServiceImpl.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (c == 49) {
                if (preSign != 124) continue;
                culResult = 0x8000000;
                continue;
            }
            if (c != 48 || preSign != 38) continue;
            culResult = 0;
        }
        return idx | culResult;
    }

    private static int getIdx4CurLevel(char[] arr, int beginIdx) {
        int idx;
        int len = arr.length;
        int count = 0;
        for (idx = beginIdx; idx < len; ++idx) {
            char c = arr[idx];
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != ')') continue;
            if (count == 0) {
                return idx;
            }
            --count;
        }
        return idx;
    }

    private void limitConCutPoint(String source, Long attFileId, WTCPluginProxy<OnLimitConditionExpPlugin> pluginProxy, PreLimitConditionQueryHelper preLimit, ConditionDto dto, Map<String, Boolean> map) {
        OnLimitConditionEvent onLimitConditionEvent = new OnLimitConditionEvent(source, attFileId, (PreLimitCondition)preLimit, (ConditionDtoExt)new ConditionDtoExtBridge(dto));
        pluginProxy.invokeReplace(locationService -> locationService.onLimitConditionEvent(onLimitConditionEvent));
        map.put(dto.getName(), onLimitConditionEvent.getResult());
    }

    static {
        log = WTCLogFactory.getLog(AttfileLimitScopeServiceImpl.class);
        MAPPING = new HashMap<String, Function<AttfileLimitScope, Object>>();
        MAPPING.put("gender", sp -> Objects.isNull(sp.getGender()) ? "" : sp.getGender().toString());
        MAPPING.put("age", sp -> Objects.isNull(sp.getAge()) ? null : sp.getAge());
        MAPPING.put("beginservicedate", sp -> sp.getBeginservicedate());
        MAPPING.put("entrydate", sp -> sp.getEntrydate());
        MAPPING.put("regulardate", sp -> sp.getRegulardate());
        MAPPING.put("org", sp -> sp.getOrg() != null ? sp.getOrg().toString() : "");
        MAPPING.put("affiliateadminorg", sp -> sp.getAffiliateadminorg() != null ? sp.getAffiliateadminorg().toString() : "");
        MAPPING.put("realregulardate", sp -> sp.getRegulardate());
        MAPPING.put("laborrelstatus", sp -> sp.getLaborrelstatus() != null ? sp.getLaborrelstatus().toString() : "");
        MAPPING.put("joblevel", sp -> sp.getJoblevel() != null ? sp.getJoblevel().toString() : "");
        MAPPING.put("jobgrade", sp -> sp.getJobgrade() != null ? sp.getJobgrade().toString() : "");
        MAPPING.put("obseq", sp -> sp.getObseq() != null ? sp.getObseq().toString() : "");
        MAPPING.put("jobseq", sp -> sp.getObseq() != null ? sp.getObseq().toString() : "");
        MAPPING.put("workplace", sp -> sp.getWorkplace() != null ? sp.getWorkplace().toString() : "");
        MAPPING.put("dependencytype", sp -> sp.getDependencytype() != null ? sp.getDependencytype().toString() : "");
        QUERYFIELD = "ID AS ATTFILEID,ATTPERSON.ID AS ATTPERSONID,ORG.ID AS ORG,AFFILIATEADMINORG.ID AS AFFILIATEADMINORG,ATTPERSON.GENDER.ID AS GENDER,ATTPERSON.BEGINSERVICEDATE AS BEGINSERVICEDATE,ATTPERSON.ENTRYDATE AS ENTRYDATE,ATTPERSON.LABORRELSTATUS.ID AS LABORRELSTATUS,ATTPERSON.JOBLEVEL.ID AS JOBLEVEL,ATTPERSON.JOBGRADE.ID AS JOBGRADE,ATTPERSON.JOBHR.JOBSEQ.ID AS OBSEQ,ATTPERSON.REGULARDATE AS REGULARDATE,WORKPLACE.ID AS WORKPLACE,DEPENDENCYTYPE.ID AS DEPENDENCYTYPE";
    }
}

