/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCBillType;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowApplyPageEvent;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.auth.WTCDataPermissionServiceImpl;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.bill.BillApplyTypePlusEnum;
import kd.wtc.wtbs.common.bill.OpenBillListParam;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEntityEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.param.WTCSystemParam;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttend;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BillCommonService {
    private static final Log LOG = LogFactory.getLog(BillCommonService.class);
    public final Map<String, WTCBillType> BILL_TYPE_MAP = BillCommonService.getBillTypeMap();
    public final Map<Integer, WTCBillType> BILL_TYPE_MAP_WTSS = BillCommonService.getBillTypeMapWTSS();
    public final Map<WTCBillType, Integer> BILL_TYPE_MAP_WTC = BillCommonService.getBillTypeMapWTC();
    private static final Set<String> OTHER_BILL_ENTITYID = new HashSet<String>(16);
    private static final Map<String, String> OTHER_BILL_CHECKRIGHT_APPID = new HashMap<String, String>(16);
    public static final String ALLOW_EXT_FIELDS_FUX = "_kxt";

    public static BillCommonService getInstance() {
        return Instance.INSTANCE;
    }

    @Deprecated
    public DynamicObject getAttFileBoTop1(long attFileBoId, String entityId) {
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileAuthField("attfilebasef7");
        attr.setAttFileF7AuthAppId("wtam");
        attr.setAttFileF7AuthEntity(entityId);
        return this.getAttFileBoTop1(attFileBoId, attr);
    }

    public DynamicObject getAttFileBoTop1(long attFileBoId, UnifyBillApplyAttr attr) {
        Map<Long, DynamicObject> attFileBoTop1Map = this.getAttFileBoTop1(Sets.newHashSet((Object[])new Long[]{attFileBoId}), attr, WTCStringUtils.joinOnComma((String[])new String[]{AttFileQueryParam.baseProperties, "attperson"}));
        if (CollectionUtils.isEmpty(attFileBoTop1Map)) {
            return null;
        }
        for (Map.Entry<Long, DynamicObject> result : attFileBoTop1Map.entrySet()) {
            if (result.getValue() == null) continue;
            return result.getValue();
        }
        return null;
    }

    public Map<Long, DynamicObject> getAttFileTop1ByPersonIds(Set<Long> personIds, UnifyBillApplyAttr attr, String baseProperties) {
        if (CollectionUtils.isEmpty(personIds) || attr == null) {
            return Collections.emptyMap();
        }
        return this.getAttFileBoTop1(Collections.emptySet(), personIds, attr, baseProperties);
    }

    public Map<Long, DynamicObject> getAttFileBoTop1(Set<Long> attFileBoId, UnifyBillApplyAttr attr, String baseProperties) {
        if (CollectionUtils.isEmpty(attFileBoId) || attr == null) {
            return Collections.emptyMap();
        }
        return this.getAttFileBoTop1(attFileBoId, Collections.emptySet(), attr, baseProperties);
    }

    public Map<Long, DynamicObject> getAttFileBoTop1(Set<Long> attFileBoIds, Set<Long> attPersonIds, UnifyBillApplyAttr attr, String baseProperties) {
        if (CollectionUtils.isEmpty(attFileBoIds) && WTCCollections.isEmpty(attPersonIds) || attr == null) {
            return Collections.emptyMap();
        }
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        if (!HRStringUtils.isEmpty((String)baseProperties)) {
            attFileQueryParam.setProperties(baseProperties);
        }
        if (WTCCollections.isNotEmpty(attPersonIds)) {
            attFileQueryParam.setPersonSetIds(attPersonIds);
        }
        if (WTCCollections.isNotEmpty(attFileBoIds)) {
            attFileQueryParam.setSetBoIds(attFileBoIds);
        }
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAppId(attr.getAttFileF7AuthAppId());
        attFileQueryParam.setFormId(attr.getAttFileF7AuthEntity());
        attFileQueryParam.setPermField(attr.getAttFileAuthField());
        attFileQueryParam.setAuthCheck(Boolean.TRUE);
        attFileQueryParam.setOrgAuthCheck(true);
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("0");
        usableStatus.add("-1");
        attFileQueryParam.setUsableStatus((Set)usableStatus);
        Page<DynamicObject> dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileQueryParam, 0, 99999);
        List attFileF7VersionDyList = dynamicObjectPage.getListRecords();
        if (CollectionUtils.isEmpty((Collection)attFileF7VersionDyList)) {
            return Collections.emptyMap();
        }
        LOG.info("BillCommonService_haveAttFileRight getAttFileBoTop1_ID.size", (Object)attFileF7VersionDyList.size());
        HashMap result = Maps.newHashMapWithExpectedSize((int)attFileF7VersionDyList.size());
        for (DynamicObject attFileF7VersionDy : attFileF7VersionDyList) {
            long boId = attFileF7VersionDy.getLong("boid");
            result.put(boId, attFileF7VersionDy);
        }
        LOG.info("BillCommonService_getAttFileBoTop1 result.size = {}", (Object)result.size());
        return result;
    }

    public boolean haveAttFileRight(long attFileBoId, String appId, String formId, String permField) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties);
        attFileQueryParam.setBoId(attFileBoId);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAuthCheck(Boolean.TRUE);
        attFileQueryParam.setOrgAuthCheck(true);
        attFileQueryParam.setAppId(appId);
        attFileQueryParam.setFormId(formId);
        attFileQueryParam.setPermField(permField);
        attFileQueryParam.setqFilter(this.getAttFileAuthQFilter(appId, formId, permField));
        LOG.info("BillCommonService_haveAttFileRight attFileQueryParam = {}", (Object)JSON.toJSONString((Object)attFileQueryParam));
        List<DynamicObject> dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        return !CollectionUtils.isEmpty(dynamicObjects);
    }

    @Deprecated
    public QFilter getAttFileAuthQFilter(String appNum, String entityNum, String permField) {
        LOG.info("BillCommonService_getAttFileAuthQFilter appNum={}, entityNum = {},permField = {}", new Object[]{appNum, entityNum, permField});
        QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(UserServiceHelper.getCurrentUserId(), appNum, entityNum, permField, "47150e89000000ac", null);
        if (dataRuleForBdProp == null) {
            return new QFilter("1", "=", (Object)1);
        }
        return dataRuleForBdProp;
    }

    @Deprecated
    public static boolean ifUnCheckAuth(String entity) {
        LOG.info("BillCommonService_ifUnCheckAuth entity={}", (Object)entity);
        return false;
    }

    private static Map<String, WTCBillType> getBillTypeMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)30);
        map.put("wtabm_vaapplyself", WTCBillType.VA);
        map.put("wtabm_vaapply", WTCBillType.VA);
        map.put("wtabm_vaapplymob_self", WTCBillType.VA);
        map.put("wtabm_vaapplymob", WTCBillType.VA);
        map.put("wtabm_vaapplyappro", WTCBillType.VA);
        map.put("wtabm_vaupdateappro", WTCBillType.VA);
        map.put("wtabm_vaapplyappro_self", WTCBillType.VA);
        map.put("wtom_otbillself", WTCBillType.OT);
        map.put("wtom_overtimeapplybill", WTCBillType.OT);
        map.put("wtom_otbillselef_m", WTCBillType.OT);
        map.put("wtom_otbillother_m", WTCBillType.OT);
        map.put("wtam_busitripselfbill", WTCBillType.BU);
        map.put("wtam_busitripbill", WTCBillType.BU);
        map.put("wtam_busitripselfbillmob", WTCBillType.BU);
        map.put("wtam_busitripbillmob", WTCBillType.BU);
        map.put("wtpm_supsignself", WTCBillType.SU);
        map.put("wtpm_supsignpc", WTCBillType.SU);
        map.put("wtpm_supsignself_m", WTCBillType.SU);
        map.put("wtpm_supsignpc_addm", WTCBillType.SU);
        map.put("wts_swshiftselfbill", WTCBillType.SW);
        map.put("wts_swshiftbill", WTCBillType.SW);
        map.put("wts_swshiftselfbill_m", WTCBillType.SW);
        map.put("wts_swshiftbill_m", WTCBillType.SW);
        return ImmutableMap.copyOf((Map)map);
    }

    private static Map<Integer, WTCBillType> getBillTypeMapWTSS() {
        HashMap map = Maps.newHashMap();
        map.put(1, WTCBillType.BU);
        map.put(2, WTCBillType.VA);
        map.put(3, WTCBillType.OT);
        map.put(4, WTCBillType.SU);
        map.put(5, WTCBillType.SW);
        return map;
    }

    private static Map<WTCBillType, Integer> getBillTypeMapWTC() {
        HashMap map = Maps.newHashMap();
        map.put(WTCBillType.BU, 1);
        map.put(WTCBillType.VA, 2);
        map.put(WTCBillType.OT, 3);
        map.put(WTCBillType.SU, 4);
        map.put(WTCBillType.SW, 5);
        return map;
    }

    public boolean hasFormId(BeforeShowApplyPageEvent event) {
        return event != null && event.getFormShowParameter() != null && StringUtils.isNotBlank((CharSequence)event.getFormShowParameter().getFormId());
    }

    public boolean hasViewRight(String appId, String formId) {
        HasPermOrgResult result = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(appId, formId);
        return result != null && (result.hasAllOrgPerm() || !CollectionUtils.isEmpty((Collection)result.getHasPermOrgs()));
    }

    public boolean hasViewRightForTeamHome(String formId) {
        HasPermOrgResult result = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtss", formId);
        return result != null && (result.hasAllOrgPerm() || !CollectionUtils.isEmpty((Collection)result.getHasPermOrgs()));
    }

    public void initBillImportData(IFormView view, List<Map<String, Object>> sourceDataList, Map<String, DynamicObject> numberTop1Map, Map<String, DynamicObject> numberPersonMap, Map<String, DynamicObject> numberAttFileBoMap) {
        String appId = view.getFormShowParameter().getAppId();
        String entityId = view.getEntityId();
        this.initBillImportData(appId, entityId, sourceDataList, numberTop1Map, numberPersonMap, numberAttFileBoMap);
    }

    public void initBillImportData(String appId, String entityId, List<Map<String, Object>> sourceDataList, Map<String, DynamicObject> numberTop1Map, Map<String, DynamicObject> numberPersonMap, Map<String, DynamicObject> numberAttFileBoMap) {
        if (CollectionUtils.isEmpty(sourceDataList)) {
            return;
        }
        HashSet queryAttFileNumber = Sets.newHashSetWithExpectedSize((int)sourceDataList.size());
        for (Map<String, Object> stringObjectMap : sourceDataList) {
            JSONObject attFileF7NumberJson = (JSONObject)stringObjectMap.get("attfilebasef7");
            if (attFileF7NumberJson == null || HRStringUtils.isEmpty((String)((String)attFileF7NumberJson.get((Object)"number")))) continue;
            queryAttFileNumber.add((String)attFileF7NumberJson.get((Object)"number"));
        }
        this.initBillImportData(appId, entityId, queryAttFileNumber, numberTop1Map, numberPersonMap, numberAttFileBoMap);
    }

    public void initBillImportData(String appId, String entityId, Set<String> queryAttFileNumber, Map<String, DynamicObject> numberTop1Map, Map<String, DynamicObject> numberPersonMap, Map<String, DynamicObject> numberAttFileBoMap) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetFileNumber(queryAttFileNumber);
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("0");
        usableStatus.add("-1");
        attFileQueryParam.setUsableStatus((Set)usableStatus);
        List<DynamicObject> attFileBoDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (CollectionUtils.isEmpty(attFileBoDyList)) {
            return;
        }
        Set<Long> boIds = attFileBoDyList.stream().map(dynamicObject -> dynamicObject.getLong("boid")).collect(Collectors.toSet());
        for (DynamicObject attFileBoDy : attFileBoDyList) {
            String number = attFileBoDy.getString("number");
            numberAttFileBoMap.put(number, attFileBoDy);
            DynamicObject attPerson = attFileBoDy.getDynamicObject("attperson");
            numberPersonMap.put(number, attPerson);
        }
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId(appId);
        attr.setAttFileF7AuthEntity(entityId);
        attr.setAttFileAuthField("attfilebasef7");
        Map<Long, DynamicObject> attFileBoTop1Map = this.getAttFileBoTop1(boIds, attr, null);
        for (Map.Entry<Long, DynamicObject> attFileBoTop1 : attFileBoTop1Map.entrySet()) {
            String number = attFileBoTop1.getValue().getString("number");
            numberTop1Map.put(number, attFileBoTop1.getValue());
        }
    }

    public Map<Long, String> getDiscardAttFileBoId(ExtendedDataEntity[] dataEntities) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            DynamicObject attFileDy = formEntity.getDynamicObject("attfile");
            if (HRObjectUtils.isEmpty((Object)attFileDy)) continue;
            set.add(attFileDy.getLong("id"));
        }
        return this.getAttFileBoDyList(set);
    }

    public Map<Long, String> getAttFileBoDyList(Set<Long> set) {
        List<DynamicObject> attFileBoDyList = this.getCurrAttFileNotAuthByBoIds(set);
        HashMap discardMap = Maps.newHashMapWithExpectedSize((int)set.size());
        for (DynamicObject attFileDy : attFileBoDyList) {
            if (HRStringUtils.equals((String)"0", (String)attFileDy.getString("usablestatus"))) continue;
            discardMap.put(attFileDy.getLong("id"), attFileDy.getString("number"));
        }
        return discardMap;
    }

    public Map<Long, Tuple<String, String>> getDiscardAttFileBoId(List<DynamicObject> billDys) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)billDys.size());
        for (DynamicObject billDy : billDys) {
            DynamicObject attFileDy = billDy.getDynamicObject("attfile");
            if (HRObjectUtils.isEmpty((Object)attFileDy)) continue;
            set.add(attFileDy.getLong("id"));
        }
        List<DynamicObject> attFileBoDyList = this.getCurrAttFileNotAuthByBoIds(set);
        HashMap discardMap = Maps.newHashMapWithExpectedSize((int)set.size());
        for (DynamicObject attFileDy : attFileBoDyList) {
            if (HRStringUtils.equals((String)"0", (String)attFileDy.getString("usablestatus"))) continue;
            Tuple<String, String> attFileNameNumber = BatchBillUnifyService.getInstance().getAttFileNameNumber(attFileDy);
            discardMap.put(attFileDy.getLong("id"), attFileNameNumber);
        }
        return discardMap;
    }

    private List<DynamicObject> getCurrAttFileNotAuthByBoIds(Set<Long> boids) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id,number,textname,usablestatus");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds(boids);
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("0");
        usableStatus.add("-1");
        attFileQueryParam.setUsableStatus((Set)usableStatus);
        List<DynamicObject> attFileBoDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return attFileBoDyList;
    }

    public String judgeAttFile(DynamicObject attFileDy, String billName) {
        if (attFileDy == null) {
            return BillUnifyKDStringHelper.emptyAttFile(billName);
        }
        if (!HRStringUtils.equals((String)"0", (String)attFileDy.getString("usablestatus"))) {
            return BillUnifyKDStringHelper.notEffAttFile(billName, attFileDy.getString("number"));
        }
        return null;
    }

    public String getAuthAppIdForFormPlugin(IFormView formView) {
        if (formView == null) {
            return "";
        }
        return this.getAuthAppIdForFormPlugin(formView.getFormShowParameter());
    }

    public String getAuthAppIdForFormPlugin(FormShowParameter showParameter) {
        Set<String> appIds;
        if (showParameter == null) {
            LOG.info("getAuthAppIdForFormPlugin showParameter is null");
            return "wtam";
        }
        String checkRightAppId = (String)showParameter.getCustomParam("checkRightAppId");
        LOG.info("getAuthAppIdForFormPlugin checkRightAppId:{}", (Object)checkRightAppId);
        String entityId = "";
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            entityId = listShowParameter.getBillFormId();
        } else if (showParameter.getFormConfig() != null) {
            entityId = showParameter.getFormConfig().getEntityTypeId();
        }
        if (HRStringUtils.isEmpty((String)checkRightAppId)) {
            checkRightAppId = showParameter.getAppId();
            LOG.info("getAuthAppIdForFormPlugin appId:{}", (Object)checkRightAppId);
            if (HRStringUtils.isEmpty((String)checkRightAppId)) {
                String string = checkRightAppId = OTHER_BILL_ENTITYID.contains(entityId) ? "wtam" : "wtss";
            }
        }
        if ((appIds = OTHER_BILL_CHECKRIGHT_APPID.keySet()).contains(checkRightAppId) && OTHER_BILL_ENTITYID.contains(entityId)) {
            checkRightAppId = OTHER_BILL_CHECKRIGHT_APPID.get(checkRightAppId);
        }
        showParameter.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        LOG.info("getAuthAppIdForFormPlugin final_checkRightAppId:{}", (Object)checkRightAppId);
        return checkRightAppId;
    }

    public String getOtherBillCheckRightAppId(String appId) {
        Set<String> appIds = OTHER_BILL_CHECKRIGHT_APPID.keySet();
        if (appIds.contains(appId)) {
            appId = OTHER_BILL_CHECKRIGHT_APPID.get(appId);
        }
        return appId;
    }

    public boolean sourceWF(IFormView formView) {
        if (formView == null) {
            return true;
        }
        Object source = formView.getFormShowParameter().getCustomParam("SOURCE");
        return "WF".equals(source);
    }

    public BillApplyTypePlusEnum getBillApplyTypePlus(DynamicObject billDy) {
        return this.getBillApplyTypePlus(billDy, 0L);
    }

    public BillApplyTypePlusEnum getBillApplyTypePlus(DynamicObject billDy, Long curAttPersonId) {
        boolean applyTypeRadio = billDy.getBoolean("applytyperadio");
        long creatorId = billDy.getLong("creator.id");
        boolean createByMe = creatorId == RequestContext.get().getCurrUserId();
        BillApplyTypePlusEnum applyTypeEnum = null;
        if (applyTypeRadio) {
            long applyPersonId = billDy.getLong("personid.id");
            long attPersonId = 0L;
            if (curAttPersonId == null || curAttPersonId == 0L) {
                Long userId = BillUnifyService.getUserId();
                if (userId != null) {
                    attPersonId = userId;
                }
            } else {
                attPersonId = curAttPersonId;
            }
            applyTypeEnum = applyPersonId == attPersonId ? BillApplyTypePlusEnum.OTHER_FOR_ME : (createByMe ? BillApplyTypePlusEnum.ME_FOR_OTHER : BillApplyTypePlusEnum.OTHER_FOR_OTHER);
        } else {
            applyTypeEnum = createByMe ? BillApplyTypePlusEnum.ME_FOR_SELF : BillApplyTypePlusEnum.OTHER_FOR_HERSELF;
        }
        return applyTypeEnum;
    }

    public void showAttFileChangeInfoAndUpdate(IFormView formView, IDataModel dataModel, UnifyBillApplyAttr unifyBillApplyAttr) {
        if (formView == null || dataModel == null) {
            LOG.warn("showAttFileChangeInfoAndUpdate formView \u4e0e dataModel \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5165\u53c2\u9519\u8bef\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u9519\u8bef\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201cformView\u201d\u3001\u201cdataModel\u201d\u3002", (String)"BillCommonService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        DynamicObject attFileBoDy = (DynamicObject)dataModel.getValue("attfile");
        Long attFileBoId = null;
        if (attFileBoDy != null) {
            attFileBoId = attFileBoDy.getLong("id");
        }
        DynamicObject attFileVersionDy = (DynamicObject)dataModel.getValue("attfilebasef7");
        Long attFileVersionId = null;
        if (attFileVersionDy != null) {
            attFileVersionId = attFileVersionDy.getLong("id");
        }
        if (attFileBoId == null || attFileVersionId == null) {
            LOG.warn("showAttFileChangeInfoAndUpdate \u6a21\u578b\u7684\u6863\u6848\u4e1a\u52a1\u7248\u672c\u4e0e\u6570\u636e\u7248\u672c\u4e0d\u53ef\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u7684\u6863\u6848\u4e1a\u52a1\u7248\u672c\u4e0e\u6570\u636e\u7248\u672c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillCommonService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        DynamicObject attFileVersion = this.getAttFileBoTop1((long)attFileBoId, unifyBillApplyAttr);
        if (attFileVersion == null) {
            String message = ResManager.loadKDString((String)"\u65e0\u8be5\u6863\u6848\u7684\u6743\u9650\u3002", (String)"BillCommonService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            formView.showErrorNotification(message);
            return;
        }
        Long newAttfile = attFileVersion.getLong("id");
        if (!newAttfile.equals(attFileVersionId)) {
            dataModel.setValue("attfilebasef7", (Object)newAttfile);
            String message = ResManager.loadKDString((String)"\u6700\u65b0\u6863\u6848\u7248\u672c\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u53d8\u66f4\u3002", (String)"BillCommonService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            formView.showConfirm(message, MessageBoxOptions.OK);
        }
    }

    public BillApplyTypeEnum billChangeOpenType(DynamicObject billDy) {
        return this.billChangeOpenType(billDy, null);
    }

    public BillApplyTypeEnum billChangeOpenType(DynamicObject billDy, IFormView view) {
        Long currentPersonId = BillUnifyService.getUserId(view);
        long cPersonId = currentPersonId == null ? 0L : currentPersonId;
        String applytype = billDy.getString("applytyperadio");
        DynamicObject personDy = billDy.getDynamicObject("personid");
        long personId = personDy == null ? 0L : personDy.getLong("id");
        LOG.info("BillCommonService_billChangeOpenType applytype ={},personId = {},cPersonId = {}", new Object[]{applytype, personId, cPersonId});
        if (personId == cPersonId && HRStringUtils.equals((String)applytype, (String)BillApplyTypeEnum.SELF.getCode())) {
            LOG.info("BillCommonService_billChangeOpenType BillApplyTypeEnum.SELF");
            return BillApplyTypeEnum.SELF;
        }
        LOG.info("BillCommonService_billChangeOpenType BillApplyTypeEnum.OTHER");
        return BillApplyTypeEnum.OTHER;
    }

    public static String generatePageIdForListOp(IFormView currentView, FormShowParameter showParameter) {
        String pageId;
        if (showParameter instanceof BillShowParameter) {
            Object pkValue = ((BillShowParameter)showParameter).getPkId();
            if (pkValue == null) {
                pageId = currentView.getPageId() + "_" + ID.genLongId();
            } else {
                if (pkValue instanceof String) {
                    pkValue = pkValue.toString().replace("/", "");
                }
                String billFormId = showParameter.getFormId();
                pageId = currentView.getPageId() + "_" + billFormId + "_" + pkValue;
            }
        } else {
            pageId = currentView.getPageId() + "_" + ID.genLongId();
        }
        return pageId;
    }

    public static ListShowParameter openBillList(OpenBillListParam param) {
        if (param == null) {
            return new ListShowParameter();
        }
        BillTypeEnum billType = param.getBillType();
        BillTypeEntityEnum billTypeEntity = BillTypeEntityEnum.getByBillType((BillTypeEnum)billType);
        if (BillTypeEntityEnum.ER_BILL == billTypeEntity) {
            return new ListShowParameter();
        }
        BillApplyTypeEnum billApplyTypeEnum = param.getBillApplyTypeEnum();
        String billEntityNumber = billTypeEntity.getListEntityId();
        if (BillApplyTypeEnum.SELF == billApplyTypeEnum) {
            billEntityNumber = billTypeEntity.getSelfListEntityId();
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billEntityNumber);
        showParameter.setFormId("bos_list");
        QFilter cusFilter = param.getCusFilter();
        if (cusFilter != null) {
            showParameter.getListFilterParameter().getQFilters().add(cusFilter);
        }
        showParameter.setCustomParam("attFileOpenBillListBoIdList", (Object)param.getAttFileBoIds());
        showParameter.setCustomParam("OPEN_LIST_LIMITED_BILL_STATUS", (Object)param.isLimitedBillStatus());
        showParameter.setCustomParam("OPEN_LIST_INIT_BILL_STATUS", (Object)param.getInitBillStatus());
        if (param.getStartDate() != null) {
            showParameter.setCustomParam("INIT_START_TIME", (Object)HRDateTimeUtils.format((Date)param.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (param.getEndDate() != null) {
            showParameter.setCustomParam("INIT_END_TIME", (Object)HRDateTimeUtils.format((Date)param.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (WTCCollections.isNotEmpty((Collection)param.getInitBillNo())) {
            showParameter.setCustomParam("INIT_BILL_NO", (Object)param.getInitBillNo());
        }
        showParameter.setCustomParam("OPEN_SOURCE", (Object)param.getOpenSource());
        if (HRStringUtils.isNotEmpty((String)param.getCheckRightAppId())) {
            showParameter.setCustomParam("checkRightAppId", (Object)param.getCheckRightAppId());
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFilterSchemeId("0");
        return showParameter;
    }

    public QFilter getExcludeAttFileLevelFilter(IFormView view, Long userId, String propKey) {
        Set<Long> attFileLevelBoIds;
        QFilter filter = null;
        String cacheKey = "excludeDepartFileFilterKey";
        IPageCache pageCache = null;
        String filterStr = null;
        if (view != null) {
            pageCache = view.getPageCache();
            filterStr = pageCache.get(cacheKey);
        }
        if (HRStringUtils.isNotEmpty(filterStr)) {
            filter = (QFilter)SerializationUtils.fromJsonString(filterStr, QFilter.class);
        } else if (Objects.nonNull(userId) && !userId.equals(0L) && WTCCollections.isNotEmpty(attFileLevelBoIds = this.getAttFileLevelBoIds(userId))) {
            filter = new QFilter(propKey, "not in", attFileLevelBoIds);
            if (pageCache != null) {
                pageCache.put(cacheKey, SerializationUtils.toJsonString((Object)filter));
            }
        }
        return filter;
    }

    public QFilter getAttFileLevelFilter(String cp) {
        return new QFilter("atttag", cp, (Object)PreDataAttend.PD_LEAVE);
    }

    public Set<Long> getAttFileLevelBoIds(Long attPersonId) {
        if (Objects.isNull(attPersonId) || attPersonId.equals(0L)) {
            return Collections.emptySet();
        }
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        AttFileQueryParam queryParam = new AttFileQueryParam("id");
        queryParam.setAttPersonId(attPersonId.longValue());
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setBeCurrent(Boolean.TRUE);
        queryParam.setAttStatus(null);
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        queryParam.setProperties("id,startdate,atttag");
        List<DynamicObject> attFiles = queryService.queryAttFiles(queryParam);
        if (WTCCollections.isNotEmpty(attFiles)) {
            List leaveAttFileStartDates = attFiles.stream().filter(item -> PreDataAttend.PD_LEAVE.equals(item.getLong("atttag"))).map(item -> item.getDate("startdate")).sorted().collect(Collectors.toList());
            HashSet leaveIds = Sets.newHashSetWithExpectedSize((int)attFiles.size());
            if (WTCCollections.isNotEmpty(leaveAttFileStartDates)) {
                Date maxStartDate = (Date)leaveAttFileStartDates.get(leaveAttFileStartDates.size() - 1);
                for (DynamicObject attFile : attFiles) {
                    Date startDate = attFile.getDate("startdate");
                    if (startDate.compareTo(maxStartDate) > 0) continue;
                    leaveIds.add(attFile.getLong("id"));
                }
            }
            return leaveIds;
        }
        return Collections.emptySet();
    }

    public List<DynamicObject> leafFilter(Long leafId, List<DynamicObject> allBills, WTCBillChangeEnum billChangeEnum) {
        HashSet<Long> parentIdSet = new HashSet<Long>(allBills.size());
        ArrayList<DynamicObject> effectBills = new ArrayList<DynamicObject>(allBills.size());
        boolean begin = false;
        for (DynamicObject dy : allBills) {
            boolean usedParent;
            long parentId = dy.getLong(billChangeEnum.getPARENT());
            if (!begin && Objects.equals(leafId, dy.getLong("id"))) {
                begin = true;
                parentIdSet.add(parentId);
                effectBills.add(dy);
                continue;
            }
            if (!begin || (usedParent = parentIdSet.contains(parentId))) continue;
            parentIdSet.add(parentId);
            effectBills.add(dy);
        }
        return effectBills;
    }

    public String getAppIdFromOp(OperateOption operation) {
        if (operation == null) {
            return "wtss";
        }
        String appId = "";
        if (operation.containsVariable("checkRightAppId")) {
            appId = operation.getVariableValue("checkRightAppId");
        }
        if (WTCStringUtils.isNotEmpty((String)appId)) {
            LOG.info("BillCommonService.getAppIdFromOp,AppId:{}", (Object)appId);
            return appId;
        }
        String currbizappid = "";
        if (operation.containsVariable("currbizappid")) {
            currbizappid = operation.getVariableValue("currbizappid");
        }
        String appNumber = "";
        if (operation.containsVariable("appnumber")) {
            appNumber = operation.getVariableValue("appnumber");
        }
        String string = appId = HRStringUtils.isNotEmpty((String)currbizappid) ? currbizappid : appNumber;
        if (WTCStringUtils.isEmpty((String)appId)) {
            appId = WTCAppContextHelper.getProjectParams().getString("kd.wtc.wtbs.bill.default.appId", "wtss");
        }
        if (WTCStringUtils.isEmpty((String)appId)) {
            appId = "wtss";
        }
        LOG.info("BillCommonService.getAppIdFromOp,AppId:{}", (Object)appId);
        return appId;
    }

    public static boolean billCheckIsStrict() {
        WTCSystemParam wtcParam = new WTCSystemParam();
        Boolean aBoolean = wtcParam.getBoolean("wtc.bill.checkmodel.strict");
        return aBoolean == null || aBoolean != false;
    }

    public static boolean billAuthCheckIsStrict() {
        WTCSystemParam wtcParam = new WTCSystemParam();
        Boolean aBoolean = wtcParam.getBoolean("wtc.bill.checkmodel.auth.strict");
        return aBoolean == null || aBoolean != false;
    }

    public static boolean billAttFileCheckStrict() {
        WTCSystemParam wtcParam = new WTCSystemParam();
        Boolean aBoolean = wtcParam.getBoolean("wtc.bill.checkmodel.attfilemustinput.strict");
        return aBoolean == null || aBoolean != false;
    }

    public static boolean billCheckForOp() {
        WTCSystemParam wtcParam = new WTCSystemParam();
        Boolean aBoolean = wtcParam.getBoolean("wtc.bill.checkmodel.forop");
        return aBoolean != null && aBoolean != false;
    }

    public static void writeInfo2Model(DynamicObject source, DynamicObject target) {
        List<Tuple<String, String>> fieldsTuple = BillCommonService.matchAllowExtBillEntryFields(source, target);
        if (source == null || target == null || WTCCollections.isEmpty(fieldsTuple)) {
            return;
        }
        LOG.info("BillCommonService.writeInfo2Model:source:{},target:{},fieldsTuple:{}", new Object[]{source.getDynamicObjectType(), target.getDynamicObjectType(), fieldsTuple});
        if (source.getDynamicObjectType() == null || target.getDynamicObjectType() == null) {
            return;
        }
        DataEntityPropertyCollection sourceProperties = source.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection targetProperties = target.getDynamicObjectType().getProperties();
        if (WTCCollections.isEmpty((Collection)sourceProperties) || WTCCollections.isEmpty((Collection)targetProperties)) {
            return;
        }
        Map<String, IDataEntityProperty> sourcePropertyNameMap = sourceProperties.stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v1));
        Map<String, IDataEntityProperty> targetPropertyNameMap = targetProperties.stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v1));
        try {
            for (Tuple<String, String> extFieldTuple : fieldsTuple) {
                boolean allSame;
                String sourceField = (String)extFieldTuple.getKey();
                String targetField = (String)extFieldTuple.getValue();
                IDataEntityProperty sourceProperty = sourcePropertyNameMap.get(sourceField);
                IDataEntityProperty targetProperty = targetPropertyNameMap.get(targetField);
                if (sourceProperty == null || targetProperty == null) continue;
                Class writePropertyType = targetProperty.getPropertyType();
                Class sourcePropertyType = sourceProperty.getPropertyType();
                if (sourcePropertyType != writePropertyType || !(allSame = targetProperty instanceof IBasedataField && sourceProperty instanceof IBasedataField && Objects.equals(((IBasedataField)targetProperty).getBaseEntityId(), ((IBasedataField)sourceProperty).getBaseEntityId()) || !(targetProperty instanceof IBasedataField) && !(sourceProperty instanceof IBasedataField))) continue;
                target.set(targetField, source.get(sourceField));
            }
        }
        catch (KDBizException e) {
            LOG.warn("BillCommonService.writeInfo2Model.error:{}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOG.warn("BillCommonService.writeInfo2Model.error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb5\u8d4b\u503c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BillCommonService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    public static void writeInfo2Model(DynamicObject source, DynamicObject target, IDataModel targetModel, Integer index) {
        List<Tuple<String, String>> fieldsTuple = BillCommonService.matchAllowExtBillEntryFields(source, target);
        if (source == null || target == null || WTCCollections.isEmpty(fieldsTuple)) {
            return;
        }
        LOG.info("BillCommonService.writeInfo2Model:source:{},target:{},fieldsTuple:{}", new Object[]{source.getDynamicObjectType(), target.getDynamicObjectType(), fieldsTuple});
        if (source.getDynamicObjectType() == null || target.getDynamicObjectType() == null) {
            return;
        }
        DataEntityPropertyCollection sourceProperties = source.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection targetProperties = target.getDynamicObjectType().getProperties();
        if (WTCCollections.isEmpty((Collection)sourceProperties) || WTCCollections.isEmpty((Collection)targetProperties)) {
            return;
        }
        Map<String, IDataEntityProperty> sourcePropertyNameMap = sourceProperties.stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v1));
        Map<String, IDataEntityProperty> targetPropertyNameMap = targetProperties.stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v1));
        try {
            for (Tuple<String, String> extFieldTuple : fieldsTuple) {
                boolean allSame;
                String sourceField = (String)extFieldTuple.getKey();
                String targetField = (String)extFieldTuple.getValue();
                IDataEntityProperty sourceProperty = sourcePropertyNameMap.get(sourceField);
                IDataEntityProperty targetProperty = targetPropertyNameMap.get(targetField);
                if (sourceProperty == null || targetProperty == null) continue;
                Class writePropertyType = targetProperty.getPropertyType();
                Class sourcePropertyType = sourceProperty.getPropertyType();
                if (sourcePropertyType != writePropertyType || !(allSame = targetProperty instanceof IBasedataField && sourceProperty instanceof IBasedataField && Objects.equals(((IBasedataField)targetProperty).getBaseEntityId(), ((IBasedataField)sourceProperty).getBaseEntityId()) || !(targetProperty instanceof IBasedataField) && !(sourceProperty instanceof IBasedataField))) continue;
                targetModel.setValue(targetField, source.get(sourceField), index.intValue());
            }
        }
        catch (KDBizException e) {
            LOG.warn("BillCommonService.writeInfo2Model.error:{}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOG.warn("BillCommonService.writeInfo2Model.error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb5\u8d4b\u503c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BillCommonService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    private static List<Tuple<String, String>> matchAllowExtBillEntryFields(DynamicObject source, DynamicObject target) {
        boolean targetIsEmpty;
        boolean sourceIsEmpty = source == null || source.getDynamicObjectType() == null || WTCCollections.isEmpty((Collection)source.getDynamicObjectType().getProperties());
        boolean bl = targetIsEmpty = target == null || target.getDynamicObjectType() == null || WTCCollections.isEmpty((Collection)target.getDynamicObjectType().getProperties());
        if (sourceIsEmpty || targetIsEmpty) {
            return Collections.emptyList();
        }
        Set sourceKeySet = source.getDynamicObjectType().getProperties().stream().filter(property -> WTCStringUtils.isNotEmpty((String)property.getName()) && property.getName().contains(ALLOW_EXT_FIELDS_FUX)).map(IMetadata::getName).collect(Collectors.toSet());
        Set targetKeySet = target.getDynamicObjectType().getProperties().stream().filter(property -> WTCStringUtils.isNotEmpty((String)property.getName()) && property.getName().contains(ALLOW_EXT_FIELDS_FUX)).map(IMetadata::getName).collect(Collectors.toSet());
        if (WTCCollections.isEmpty(sourceKeySet) || WTCCollections.isEmpty(targetKeySet)) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<String, String>> keyTupleList = new ArrayList<Tuple<String, String>>(16);
        Set<String> conventionKeys = sourceKeySet.stream().filter(sourceKey -> sourceKey.endsWith(ALLOW_EXT_FIELDS_FUX) && targetKeySet.contains(sourceKey)).collect(Collectors.toSet());
        targetKeySet.stream().filter(targetKey -> !targetKey.endsWith(ALLOW_EXT_FIELDS_FUX)).forEach(targetKey -> {
            for (String conventionKey : conventionKeys) {
                int last_Index;
                String lastStr;
                if (!targetKey.startsWith(conventionKey) || !WTCStringUtils.isNotEmpty((String)(lastStr = targetKey.substring((last_Index = targetKey.lastIndexOf("_")) + 1)))) continue;
                try {
                    Integer.valueOf(lastStr);
                    keyTupleList.add(new Tuple((Object)conventionKey, targetKey));
                }
                catch (NumberFormatException e) {
                    keyTupleList.add(new Tuple(targetKey, targetKey));
                }
            }
        });
        conventionKeys.forEach(key -> keyTupleList.add(new Tuple(key, key)));
        return keyTupleList;
    }

    public String handleTimePariInfo(List<Tuples.Tuple2<LocalDate, LocalDate>> timeInfo) {
        String result = "";
        if (WTCCollections.isEmpty(timeInfo)) {
            return result;
        }
        ArrayList<String> eachPair = new ArrayList<String>(10);
        for (Tuples.Tuple2<LocalDate, LocalDate> timePair : timeInfo) {
            if (timePair == null || timePair.item1 == null || timePair.item2 == null) continue;
            if (((LocalDate)timePair.item1).isEqual((ChronoLocalDate)timePair.item2)) {
                eachPair.add(WTCDateUtils.format((LocalDate)((LocalDate)timePair.item1)));
                continue;
            }
            String format = ResManager.loadKDString((String)"{0}\u81f3{1}", (String)"BillCommonService_5", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            eachPair.add(MessageFormat.format(format, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)((LocalDate)timePair.item1))), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)((LocalDate)timePair.item2)))));
        }
        if (WTCCollections.isNotEmpty(eachPair)) {
            result = String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCaesuraSymbol(), eachPair);
        }
        return result;
    }

    public static List<String> collectEntityAllProp(MainEntityType mainEntityType) {
        ArrayList<String> props = new ArrayList<String>(16);
        MainEntityType billEntityType = mainEntityType;
        DataEntityPropertyCollection properties = billEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                BillCommonService.getEntryEntityProp((EntryProp)property, props);
                continue;
            }
            if (HRStringUtils.isEmpty((String)property.getAlias())) continue;
            props.add(property.getName());
        }
        return props;
    }

    private static void getEntryEntityProp(EntryProp property, List<String> props) {
        if (property == null) {
            return;
        }
        IDataEntityType itemType = property.getItemType();
        DataEntityPropertyCollection properties = itemType.getProperties();
        for (IDataEntityProperty entryProp : properties) {
            if (entryProp instanceof EntryProp) {
                BillCommonService.getEntryEntityProp((EntryProp)entryProp, props);
                continue;
            }
            if (HRStringUtils.isEmpty((String)entryProp.getAlias())) continue;
            props.add(entryProp.getName());
        }
    }

    public QFilter getBillPermQFilter(long userId, String appNumber, String entityNum, String orgKey, String funcPerm, Map<String, Object> customParam) {
        LOG.info("BillCommonService_getBillPermQFilter userId={},appNumber={},entityNum={},orgKey ={},funcPerm ={}", new Object[]{userId, appNumber, entityNum, orgKey, funcPerm});
        WTCBizDataPermissionServiceImpl servicePerm = new WTCBizDataPermissionServiceImpl();
        HasPermOrgResult allPermOrgs = servicePerm.getAllPermOrgs(appNumber, entityNum);
        if (allPermOrgs != null && allPermOrgs.hasAllOrgPerm()) {
            LOG.info("BillUnifyQueryService_assembleQFilterOfPerm hasAllOrgPerm");
            return new QFilter("id", "!=", (Object)0L);
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        boolean havePerm = permissionService.checkPermission(userId, appNumber, entityNum, funcPerm);
        if (!havePerm) {
            LOG.info("BillUnifyQueryService_assembleQFilterOfPerm no view perm");
            return new QFilter("id", "=", (Object)0L);
        }
        WTCDataPermissionServiceImpl service = new WTCDataPermissionServiceImpl();
        QFilter dataRule = service.getDataRule(userId, appNumber, entityNum, orgKey, funcPerm, customParam);
        LOG.info("BillUnifyQueryService_assembleQFilterOfPerm dataRule={}", (Object)dataRule);
        return dataRule;
    }

    public void handleFilterContainerInit(FilterContainerInitArgs args, IFormView listView) {
        if (args == null || listView == null) {
            return;
        }
        boolean handleFromStopAttFile = this.handleByStopAttFileList(args, listView);
        if (handleFromStopAttFile) {
            this.handleBillStatus(args, listView);
            return;
        }
        List<Object> attFileBoIds = this.getAttFileOpenBillListBoIdList(listView);
        if (WTCCollections.isEmpty(attFileBoIds)) {
            return;
        }
        this.handleBillStatus(args, listView);
        ListShowParameter formShowParameter = (ListShowParameter)listView.getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        List<DynamicObject> attFiles = queryService.queryAttFileByIds("id,name", attFileBoIds);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(attFiles.size());
        for (DynamicObject attFile : attFiles) {
            comboItemList.add(new ComboItem(new LocaleString(attFile.getString("name")), attFile.getString("id")));
        }
        String attFileFilterProp = "attfile.id";
        if ("wtabm_batchvaapply".equals(billFormId)) {
            attFileFilterProp = "entryentity.attfile.id";
        }
        CommonFilterColumn attFileFilter = new CommonFilterColumn(attFileFilterProp);
        attFileFilter.setComboItems(comboItemList);
        LocaleString caption = ResManager.getLocaleString((String)"\u59d3\u540d", (String)"WTCApplyTypeOtherList_0", (String)"wtc-wtbs-formplugin");
        attFileFilter.setCaption(caption);
        List defaultValues = attFileBoIds.stream().map(String::valueOf).collect(Collectors.toList());
        attFileFilter.setDefaultValues(defaultValues.toArray());
        args.addFilterColumn((FilterColumn)attFileFilter);
        ArrayList orgFieldNames = Lists.newArrayList((Object[])new String[]{"org.id", "org.name", "org.number"});
        ArrayList dateFieldNames = Lists.newArrayList((Object[])new String[]{"btdate", "vadate", "wtpm_supsigninfo.signdate", "entryotdate", "swshiftquerydate", "createtime"});
        args.getCommonFilterColumns().removeIf(item -> orgFieldNames.contains(item.getFieldName()) || dateFieldNames.contains(item.getFieldName()));
    }

    private void handleBillStatus(FilterContainerInitArgs args, IFormView listView) {
        boolean limitStatus;
        Map customParams = listView.getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        Object limit = customParams.get("OPEN_LIST_LIMITED_BILL_STATUS");
        List billStatus = (List)customParams.get("OPEN_LIST_INIT_BILL_STATUS");
        boolean bl = limitStatus = limit instanceof Boolean && (Boolean)limit != false;
        if (limitStatus && WTCCollections.isEmpty((Collection)billStatus)) {
            return;
        }
        List columnList = args.getCommonFilterColumns();
        if (!limitStatus) {
            for (FilterColumn filterColumn : columnList) {
                String fieldName = filterColumn.getFieldName();
                if (!HRStringUtils.equals((String)fieldName, (String)"billstatus")) continue;
                filterColumn.setDefaultValue(null);
            }
        } else {
            for (FilterColumn filterColumn : columnList) {
                String fieldName = filterColumn.getFieldName();
                if (!HRStringUtils.equals((String)fieldName, (String)"billstatus")) continue;
                filterColumn.setDefaultValues(billStatus.toArray(new Object[0]));
            }
        }
    }

    private boolean handleByStopAttFileList(FilterContainerInitArgs args, IFormView listView) {
        List billNos;
        boolean timeValida;
        HashSet queryDateInList = Sets.newHashSet((Object[])new String[]{"entryotdate", "btdate", "vadate", "wtpm_supsigninfo.signdate", "swshiftquerydate"});
        Map customParams = listView.getFormShowParameter().getCustomParams();
        if (WTCCollections.isEmpty((Map)customParams)) {
            return false;
        }
        Object openSourceObj = customParams.get("OPEN_SOURCE");
        if (!(openSourceObj instanceof String)) {
            return false;
        }
        if (!HRStringUtils.equals((String)"OPEN_SOURCE_STOP_ATTFILE", (String)((String)openSourceObj))) {
            return false;
        }
        Object startTimeObj = customParams.get("INIT_START_TIME");
        Object endTimeObj = customParams.get("INIT_END_TIME");
        boolean bl = timeValida = startTimeObj != null && !(startTimeObj instanceof String) || endTimeObj != null && !(endTimeObj instanceof String);
        if (timeValida) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5217\u8868\u5165\u53c2\u5f00\u59cb\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\u3002", (String)"WTCApplyTypeOtherList_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        }
        String startTimeStr = (String)startTimeObj;
        String endTimeStr = (String)endTimeObj;
        if (HRStringUtils.isNotEmpty((String)startTimeStr) && HRStringUtils.isNotEmpty((String)endTimeStr)) {
            Date startTime = null;
            Date endTime = null;
            try {
                startTime = HRDateTimeUtils.parseDate((String)startTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
                endTime = HRDateTimeUtils.parseDate((String)endTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException exception) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5217\u8868\u5165\u53c2\u5f00\u59cb\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\u3002", (String)"WTCApplyTypeOtherList_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            }
            List columnList = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : columnList) {
                String fieldName = filterColumn.getFieldName();
                if (HRStringUtils.equals((String)fieldName, (String)"org") || HRStringUtils.equals((String)fieldName, (String)"org.id") || HRStringUtils.equals((String)fieldName, (String)"org.name") || HRStringUtils.equals((String)fieldName, (String)"org.number")) {
                    filterColumn.setDefaultValue(null);
                }
                if ("createtime".equals(fieldName)) {
                    filterColumn.setDefaultValue(null);
                }
                if (!queryDateInList.contains(fieldName)) continue;
                String format = "yyyy-MM-dd";
                filterColumn.setDefaultValues(new Object[]{HRDateTimeUtils.format((Date)startTime, (String)format), HRDateTimeUtils.format((Date)endTime, (String)format)});
            }
        }
        if (WTCCollections.isNotEmpty((Collection)(billNos = (List)customParams.get("INIT_BILL_NO")))) {
            List fastFilterColumns = args.getFastFilterColumns();
            for (FilterColumn filterColumn : fastFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) continue;
                filterColumn.setDefaultValues(billNos.toArray(new Object[0]));
            }
        }
        return true;
    }

    public List<Object> getAttFileOpenBillListBoIdList(IFormView listView) {
        if (listView == null) {
            return Collections.emptyList();
        }
        JSONArray attFileArray = (JSONArray)listView.getFormShowParameter().getCustomParam("attFileOpenBillListBoIdList");
        if (attFileArray == null || attFileArray.size() <= 0) {
            return new ArrayList<Object>(0);
        }
        return Lists.newArrayList((Iterable)attFileArray);
    }

    static {
        OTHER_BILL_ENTITYID.add("wtpm_supsignpc");
        OTHER_BILL_ENTITYID.add("wtpm_supsignpcquery");
        OTHER_BILL_ENTITYID.add("wtpm_supsignpcchange");
        OTHER_BILL_ENTITYID.add("wtam_busitripbill");
        OTHER_BILL_ENTITYID.add("wtam_busibillchange");
        OTHER_BILL_ENTITYID.add("wtom_overtimeapplybill");
        OTHER_BILL_ENTITYID.add("wtom_otbillchange");
        OTHER_BILL_ENTITYID.add("wtabm_vaapply");
        OTHER_BILL_ENTITYID.add("wtabm_vaupdate");
        OTHER_BILL_ENTITYID.add("wts_swshiftbill");
        OTHER_BILL_CHECKRIGHT_APPID.put("wtss", "wtam");
        OTHER_BILL_CHECKRIGHT_APPID.put("hssc", "wtam");
    }

    private static class Instance {
        private static BillCommonService INSTANCE = new BillCommonService();

        private Instance() {
        }
    }
}

