/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeUnitEnum;

public class BillDiscardService {
    private static final Log LOG = LogFactory.getLog(BillDiscardService.class);
    private static final List<String> BATCHBILLHANDLESTATUS = Lists.newArrayList((Object[])new String[]{"B", "C", "D"});

    public static BillDiscardService getInstance() {
        return Instance.INSTANCE;
    }

    public void discardBill(List<Long> attFileIdList, String formId) {
        if (attFileIdList == null || attFileIdList.isEmpty()) {
            return;
        }
        this.setAttFileDiscard(attFileIdList, formId);
    }

    private void setAttFileDiscard(List<Long> attFileIdList, String pageNumber) {
        LOG.info("BillDiscardService.setAttFileDiscard begin size={}:pageNumber={}", (Object)attFileIdList.size(), (Object)pageNumber);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageNumber);
        QFilter attFileBoId = new QFilter("attfile", "in", attFileIdList);
        String queryProp = "id,isattfilediscard,auditstatus,billstatus";
        queryProp = this.handleBatchBillQueryProp(queryProp, pageNumber);
        DynamicObject[] billDyArr = helper.query(queryProp, new QFilter[]{attFileBoId});
        HashMap midBillIdMap = Maps.newHashMapWithExpectedSize((int)billDyArr.length);
        if (billDyArr != null && billDyArr.length > 0) {
            HashSet businessKeySet = Sets.newHashSetWithExpectedSize((int)billDyArr.length);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)billDyArr.length);
            for (DynamicObject billDy : billDyArr) {
                boolean isNeed;
                boolean isAttFileDiscard = billDy.getBoolean("isattfilediscard");
                if (isAttFileDiscard || !(isNeed = this.billIsNeedHandle(pageNumber, billDy))) continue;
                this.handleBatchBillTime(pageNumber, billDy, midBillIdMap);
                businessKeySet.add(billDy.getString("id"));
                billDy.set("isattfilediscard", (Object)Boolean.TRUE);
                billDy.set("auditstatus", (Object)"F");
                billDy.set("billstatus", (Object)"F");
                list.add(billDy);
            }
            ArrayList batchBillList = Lists.newArrayListWithExpectedSize((int)billDyArr.length);
            this.handleBatchBill(pageNumber, midBillIdMap, businessKeySet, batchBillList);
            this.abandonWFByBusienssKey(businessKeySet);
            if (!list.isEmpty()) {
                helper.save(list.toArray(new DynamicObject[0]));
            }
            this.updateBatchBill(pageNumber, batchBillList);
            LOG.info("BillDiscardService.setAttFileDiscard end abandonByBusienssKey:");
        }
    }

    private boolean billIsNeedHandle(String pageNumber, DynamicObject billDy) {
        if ("wtabm_vaapply".equals(pageNumber)) {
            long mid = billDy.getLong("mid");
            String billStatus = billDy.getString("billstatus");
            if (mid != 0L && !BATCHBILLHANDLESTATUS.contains(billStatus)) {
                return false;
            }
        }
        return true;
    }

    private String handleBatchBillQueryProp(String queryProp, String pageNumber) {
        if ("wtabm_vaapply".equals(pageNumber)) {
            queryProp = queryProp + ",mid,vatime,unit,applytime,entryentity.entryvatimeday,entryentity.entryvatimehour,entryentity.entryvalidtimeday,entryentity.entryvalidtimehour";
        }
        return queryProp;
    }

    private void handleBatchBillTime(String pageNumber, DynamicObject billDy, Map<Long, List<DynamicObject>> midBillIdMap) {
        long mid;
        if ("wtabm_vaapply".equals(pageNumber) && (mid = billDy.getLong("mid")) != 0L) {
            List billIds = midBillIdMap.computeIfAbsent(mid, item -> new ArrayList());
            billIds.add(billDy);
            billDy.set("vatime", (Object)0);
            billDy.set("applytime", (Object)0);
            DynamicObjectCollection vaBillEntryColl = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject vaBillEntryDy : vaBillEntryColl) {
                vaBillEntryDy.set("entryvatimeday", (Object)0);
                vaBillEntryDy.set("entryvatimehour", (Object)0);
                vaBillEntryDy.set("entryvalidtimeday", (Object)0);
                vaBillEntryDy.set("entryvalidtimehour", (Object)0);
            }
        }
    }

    private void handleBatchBill(String pageNumber, Map<Long, List<DynamicObject>> midBillIdMap, Set<String> businessKeySet, List<DynamicObject> batchBillList) {
        if (WTCCollections.isNotEmpty(midBillIdMap) && "wtabm_vaapply".equals(pageNumber)) {
            DynamicObject[] batchVaBills;
            Set<Long> mids = midBillIdMap.keySet();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_batchvaapply");
            QFilter qFilter = new QFilter("id", "in", mids);
            qFilter.and(new QFilter("billstatus", "in", BATCHBILLHANDLESTATUS));
            for (DynamicObject batchVaBillDy : batchVaBills = serviceHelper.query("id,auditstatus,billstatus,countperson,totaltimeinday,totaltimeinhour,entryentity.isattfilediscard", qFilter.toArray())) {
                DynamicObjectCollection batchVaInfoColl = batchVaBillDy.getDynamicObjectCollection("entryentity");
                Long mid = batchVaBillDy.getLong("id");
                List<DynamicObject> billDys = midBillIdMap.get(mid);
                if (billDys == null) continue;
                List singleBills = batchVaInfoColl.stream().filter(item -> !item.getBoolean("isattfilediscard")).collect(Collectors.toList());
                if (singleBills.size() == billDys.size()) {
                    businessKeySet.add(String.valueOf(mid));
                    batchVaBillDy.set("auditstatus", (Object)"F");
                    batchVaBillDy.set("billstatus", (Object)"F");
                }
                int countPerson = batchVaBillDy.getInt("countperson");
                countPerson = Math.max(countPerson - billDys.size(), 0);
                batchVaBillDy.set("countperson", (Object)countPerson);
                BigDecimal totalTimeInDay = batchVaBillDy.getBigDecimal("totaltimeinday");
                BigDecimal totalTimeInHour = batchVaBillDy.getBigDecimal("totaltimeinhour");
                for (DynamicObject billDy : billDys) {
                    BigDecimal vaTime = billDy.getBigDecimal("vatime");
                    String unit = billDy.getString("unit");
                    if (StringUtils.equals((CharSequence)BaseSetTimeUnitEnum.DATE.code, (CharSequence)unit)) {
                        totalTimeInDay = totalTimeInDay.subtract(vaTime);
                        continue;
                    }
                    totalTimeInHour = totalTimeInHour.subtract(vaTime);
                }
                batchVaBillDy.set("totaltimeinday", (Object)totalTimeInDay);
                batchVaBillDy.set("totaltimeinhour", (Object)totalTimeInHour);
                batchBillList.add(batchVaBillDy);
            }
        }
    }

    private void updateBatchBill(String pageNumber, List<DynamicObject> batchBillList) {
        if ("wtabm_vaapply".equals(pageNumber) && WTCCollections.isNotEmpty(batchBillList)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_batchvaapply");
            serviceHelper.update(batchBillList.toArray(new DynamicObject[0]));
        }
    }

    private void abandonWFByBusienssKey(Set<String> businessKeySet) {
        LOG.info("BillDiscardService.setAttFileDiscard begin abandonByBusienssKey:size={}", (Object)businessKeySet.size());
        Map inWorkflowBillMap = WorkflowServiceHelper.getBizProcessStatus((String[])businessKeySet.toArray(new String[0]));
        if (WTCMaps.isNotEmpty((Map)inWorkflowBillMap)) {
            inWorkflowBillMap.keySet().forEach(businessKey -> {
                if (businessKey != null) {
                    try {
                        WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
                    }
                    catch (Exception ex) {
                        LOG.warn("BillDiscardService.setAttFileDiscard error, businessKey={}", businessKey);
                    }
                }
            });
        }
    }

    private static class Instance {
        private static BillDiscardService INSTANCE = new BillDiscardService();

        private Instance() {
        }
    }
}

