/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;

public class BillStyleService {
    private static final Log Log = LogFactory.getLog(BillStyleService.class);
    private static final String SINGLE_FLEX = "single_flex";

    private BillStyleService() {
    }

    public static BillStyleService getInstance() {
        return SingletonInstance.SINGLETON;
    }

    public void openSingleFlex(IFormView formView, Map<String, Object> customParam, DynamicObject billDy, String openFlexEntity, Set<String> unVisKey) {
        if (formView == null || HRStringUtils.isBlank((CharSequence)openFlexEntity)) {
            return;
        }
        if (!CollectionUtils.isEmpty(unVisKey)) {
            formView.setVisible(Boolean.FALSE, unVisKey.toArray(new String[0]));
        }
        if (customParam == null) {
            customParam = new HashMap<String, Object>(16);
        }
        customParam.putAll(this.convertBillAttr(billDy));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(SINGLE_FLEX);
        showParameter.setFormId(openFlexEntity);
        showParameter.setPageId(UUID.randomUUID().toString());
        showParameter.setCustomParams(customParam);
        formView.getPageCache().put("CACHE_SINGLE_FLEX_PAGE_ID", showParameter.getPageId());
        showParameter.setStatus(formView.getFormShowParameter().getStatus());
        formView.showForm(showParameter);
    }

    public void openSingleFlexWithStatus(IFormView formView, Map<String, Object> customParam, DynamicObject billDy, String openFlexEntity, Set<String> unVisKey, OperationStatus status) {
        if (formView == null || HRStringUtils.isBlank((CharSequence)openFlexEntity)) {
            return;
        }
        if (!CollectionUtils.isEmpty(unVisKey)) {
            formView.setVisible(Boolean.FALSE, unVisKey.toArray(new String[0]));
        }
        if (customParam == null) {
            customParam = new HashMap<String, Object>(16);
        }
        customParam.putAll(this.convertBillAttr(billDy));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(SINGLE_FLEX);
        showParameter.setFormId(openFlexEntity);
        showParameter.setPageId(UUID.randomUUID().toString());
        showParameter.setCustomParams(customParam);
        formView.getPageCache().put("CACHE_SINGLE_FLEX_PAGE_ID", showParameter.getPageId());
        showParameter.setStatus(status);
        formView.showForm(showParameter);
    }

    public boolean sysSingleStyle(BillTypeEnum billTypeEnum) {
        return BillOpenStyleEnum.SINGLE == this.getSysBillStyle(billTypeEnum);
    }

    public BillOpenStyleEnum getSysBillStyle(BillTypeEnum billTypeEnum) {
        if (BillTypeEnum.VACATIONBILL == billTypeEnum) {
            String billStyleVa = SystemParamQueryUtil.getBillSystemParam().getBillStyleVa();
            return BillOpenStyleEnum.getByCode((String)billStyleVa);
        }
        if (BillTypeEnum.OVERTIMEBILL == billTypeEnum) {
            String billStyleOt = SystemParamQueryUtil.getBillSystemParam().getBillStyleOt();
            return BillOpenStyleEnum.getByCode((String)billStyleOt);
        }
        if (BillTypeEnum.EVECTIONBILL == billTypeEnum) {
            String billStyleTrip = SystemParamQueryUtil.getBillSystemParam().getBillStyleTrip();
            return BillOpenStyleEnum.getByCode((String)billStyleTrip);
        }
        return BillOpenStyleEnum.ERROR_STYLE;
    }

    public boolean isOpenSingleStyle(DynamicObject billDy) {
        if (billDy == null) {
            return false;
        }
        DataEntityPropertyCollection properties = billDy.getDataEntityType().getProperties();
        HashSet<String> propertiesSet = new HashSet<String>(16);
        for (IDataEntityProperty property : properties) {
            propertiesSet.add(property.getName());
        }
        if (propertiesSet.contains("billstyle")) {
            String billStyle = billDy.getString("billstyle");
            Log.info("BillStyleService_isOpenSingleStyle contains billstyle,val = {}", (Object)billStyle);
            return BillOpenStyleEnum.SINGLE.getCode().equals(billStyle);
        }
        Log.info("BillStyleService_isOpenSingleStyle is false");
        return false;
    }

    public void setModelVal(IFormView singleView, Map<String, Object> param, Set<String> unSetKey, int index) {
        if (unSetKey == null) {
            unSetKey = new HashSet<String>(16);
        }
        IDataModel model = singleView.getModel();
        DataEntityPropertyCollection properties = model.getDataEntity(true).getDataEntityType().getProperties();
        HashSet<String> keys = new HashSet<String>(16);
        for (IDataEntityProperty property : properties) {
            keys.add(property.getName());
        }
        for (Map.Entry<String, Object> keyVal : param.entrySet()) {
            String key = keyVal.getKey();
            Object value = keyVal.getValue();
            if (!keys.contains(key) || unSetKey.contains(key)) continue;
            model.setValue(key, value, index);
        }
    }

    public Map<String, Object> convertValToMap(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            Object val = dynamicObject.get(name);
            if (val instanceof DynamicObject) {
                result.put(name, ((DynamicObject)val).getPkValue());
                continue;
            }
            result.put(name, val);
        }
        return result;
    }

    private Map<String, Object> convertBillAttr(DynamicObject billDy) {
        if (billDy == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        if (billDy.get("attfile") != null) {
            param.put("attfile", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDy, (String)"attfile"));
        }
        if (billDy.get("attfilebasef7") != null) {
            param.put("attfilebasef7", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDy, (String)"attfilebasef7"));
        }
        if (billDy.get("org") != null) {
            param.put("org", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDy, (String)"org"));
        }
        return param;
    }

    private static class SingletonInstance {
        private static final BillStyleService SINGLETON = new BillStyleService();

        private SingletonInstance() {
        }
    }
}

