/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.model.CheckDimObjParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.bill.BillCommonConstants;
import kd.wtc.wtbs.common.concurrent.WTCMutexHelper;
import kd.wtc.wtbs.common.concurrent.WTCMutexLockInfo;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuthBase;
import kd.wtc.wtbs.common.model.attfileauth.AttFileInfo;
import kd.wtc.wtbs.common.model.attfileauth.AttPerson;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BillUnifyService
implements BillCommonConstants {
    private static final Log logger = LogFactory.getLog(BillUnifyService.class);
    private static final Log LOG = LogFactory.getLog(BillUnifyService.class);
    private static final ArrayList<String> ATTFILESTATUSLIST = Lists.newArrayList((Object[])new String[]{"1", "2"});
    public static final String STR_ZERO_ZERO = "00";
    public static final String STR_ZERO_ONE = "01";
    public static final String STR_ONE_ZERO = "10";
    public static final String STR_ELEVEN = "11";
    private static final Map<String, String> SLEFOTHERFORMMAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<String, Map<String, String>> FORMMAP = Maps.newHashMapWithExpectedSize((int)4);
    public static final Map<String, Map<String, String>> FORMMAP_UNMODIFY = Collections.unmodifiableMap(FORMMAP);
    private static final String QUERYPROP = WTCStringUtils.joinOnComma((String[])new String[]{"id", "applytyperadio", "billstatus", "personid", "creator", "org"});
    private static final String[] STATUS_TMP_HIDDEN_ITEM = new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_unsubmit2", "bar_submiteffect", "bar_discard", "bar_del", "updatebill"};

    private BillUnifyService() {
    }

    public static Long getUserId() {
        Map<String, Object> userInfo = HRPIMServiceImpl.getInstance().getPersonModelId();
        if (userInfo != null && ((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
            Map userData = (Map)userInfo.get("data");
            return (Long)userData.get("person");
        }
        return null;
    }

    public static Long getUserId(IFormView view) {
        if (view == null) {
            return BillUnifyService.getUserId();
        }
        FormShowParameter parameter = view.getFormShowParameter();
        String userIdStr = BillUnifyService.getUserIdStrFromShowParameter(parameter);
        if (userIdStr == null) {
            FormShowParameter parentParameter;
            IFormView parentView = view.getViewNoPlugin(parameter.getParentPageId());
            Long userId = parentView != null ? ((userIdStr = BillUnifyService.getUserIdStrFromShowParameter(parentParameter = parentView.getFormShowParameter())) == null ? BillUnifyService.getUserId() : Long.valueOf(Long.parseLong(userIdStr))) : BillUnifyService.getUserId();
            long personId = userId == null ? 0L : userId;
            parameter.setCustomParam("personid_cache", (Object)String.valueOf(personId));
            view.cacheFormShowParameter();
        }
        if ((userIdStr = BillUnifyService.getUserIdStrFromShowParameter(parameter)) == null || "0".equals(userIdStr)) {
            return null;
        }
        return Long.parseLong(userIdStr);
    }

    private static String getUserIdStrFromShowParameter(FormShowParameter parameter) {
        String userIdStr = null;
        Object customParam = parameter.getCustomParam("personid_cache");
        if (customParam != null) {
            userIdStr = String.valueOf(customParam);
        }
        return userIdStr;
    }

    public static void setOptionUserId(IFormView view, OperateOption option) {
        if (option != null) {
            Long userId = view != null ? BillUnifyService.getUserId(view) : BillUnifyService.getUserId(option);
            String userIdStr = userId == null ? "0" : String.valueOf(userId);
            option.setVariableValue("personid_cache", userIdStr);
        }
    }

    public static Long getUserId(OperateOption option) {
        if (option == null) {
            return BillUnifyService.getUserId();
        }
        if (option.containsVariable("personid_cache")) {
            String variableValue = option.getVariableValue("personid_cache");
            if ("0".equals(variableValue)) {
                return null;
            }
            return Long.parseLong(variableValue);
        }
        Long userId = BillUnifyService.getUserId();
        long personId = userId == null ? 0L : userId;
        option.setVariableValue("personid_cache", String.valueOf(personId));
        return userId;
    }

    @Deprecated
    public static Map<Long, Long> getUserIdBatch(Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)userIds.size());
        ArrayList userIdList = Lists.newArrayList(userIds);
        Map<String, Object> userInfo = HRPIMServiceImpl.getInstance().queryPersonInfoByUserIds(userIdList);
        if (userInfo != null && ((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
            Map userData = (Map)userInfo.get("data");
            for (Long userId : userIds) {
                HashMap data = (HashMap)userData.get(userId);
                if (data == null) continue;
                result.put(userId, (Long)data.get("person"));
            }
        }
        return result;
    }

    @Deprecated
    public static Long getUserId(IPageCache pageCache) {
        String userIdStr = pageCache.get("userId");
        if (HRStringUtils.isNotEmpty((String)userIdStr)) {
            return Long.parseLong(userIdStr);
        }
        Long userId = BillUnifyService.getUserId();
        if (userId != null) {
            pageCache.put("userId", userId.toString());
        }
        return userId;
    }

    @Deprecated
    public static List<Long> getAttFileBoIdByAttPersonId(Long attPersonId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties);
        attFileQueryParam.setAttPersonId(attPersonId.longValue());
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        List<DynamicObject> dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return dynamicObjects.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getAttFileBoIdByAttPersonId(Long attPersonId, String appNumber, String entityNumber, String propKey) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties);
        attFileQueryParam.setAttPersonId(attPersonId.longValue());
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAppId(appNumber);
        attFileQueryParam.setFormId(entityNumber);
        attFileQueryParam.setPermField(propKey);
        attFileQueryParam.setOrgAuthCheck(true);
        List<DynamicObject> dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        return dynamicObjects.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
    }

    public static void setPersonInfo(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject attfile = dataEntity.getDynamicObject("attfilebasef7");
        if (attfile == null) {
            view.setVisible(Boolean.FALSE, new String[]{"personinfo"});
        } else {
            String position;
            String adminorg;
            view.setVisible(Boolean.FALSE, new String[]{"personinfo"});
            StopWatch stopWatch = StopWatch.createStarted();
            DynamicObject dynamicObject = AttFileQueryServiceImpl.getInstance().queryOneAttFile("", attfile.getPkValue());
            stopWatch.stop();
            LOG.info("BillUnifyService.setPersonInfo query attfile end,begin init AttFileInfo,times:{}", (Object)stopWatch.getTime());
            if (dynamicObject == null) {
                return;
            }
            stopWatch = StopWatch.createStarted();
            Map<Long, AttPerson> attPersons = WTCAttFileService.getAttPersons(Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
            AttFileInfo attFileAuth = new AttFileInfo();
            attFileAuth.setAttFile(WTCAttFileService.getAttFile(dynamicObject));
            attFileAuth.setAttPerson(attPersons.get(dynamicObject.getLong("id")));
            stopWatch.stop();
            LOG.info("BillUnifyService.setPersonInfo query attfile end,times:{}", (Object)stopWatch.getTime());
            AttPerson attPerson = attFileAuth.getAttPerson();
            String name = dynamicObject.getString("textname");
            String headsculpture = attPerson.getHeadsculpture();
            String number = dynamicObject.getString("personnum");
            String gender = attPerson.getGenderName();
            AttFileAuthBase org = attFileAuth.getAttFile().getOrg();
            if ("0".equals(dataEntity.getString("applytyperadio"))) {
                model.setValue("org", (Object)org.getBoid());
            }
            long id = attPerson.getBoid();
            model.setValue("personid", (Object)id);
            long empPosOrgRelId = dynamicObject.getLong("empposorgrel.id");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_depempjob");
            DynamicObject depempjobDy = serviceHelper.loadSingle((Object)empPosOrgRelId);
            if (depempjobDy == null) {
                return;
            }
            String company = depempjobDy.getString("company.name");
            if (HRStringUtils.isEmpty((String)company)) {
                company = "-";
            }
            if (HRStringUtils.isEmpty((String)(adminorg = depempjobDy.getString("adminorg.name")))) {
                adminorg = "-";
            }
            if (HRStringUtils.isEmpty((String)(position = depempjobDy.getString("position.name")))) {
                position = "-";
            }
            AttFileAuthBase laborRelType = attPerson.getLaborRelType();
            String laborreltype = laborRelType.getName();
            Image imgHead = (Image)view.getControl("imahead");
            if (!HRStringUtils.isEmpty((String)headsculpture) && !headsculpture.equals("/images/pc/emotion/default_person_82_82.png")) {
                imgHead.setUrl(HRImageUrlUtil.getImageFullUrl((String)headsculpture));
            } else {
                imgHead.setUrl("/images/pc/emotion/default_person_82_82.png");
            }
            BillUnifyService.setPersonLabInfo(name, number, gender, company, laborreltype, position, adminorg, view);
            Long depId = dynamicObject.getLong("depemp.id");
            Long adminOrgId = dynamicObject.getLong("empposorgrel.adminorg.id");
            boolean haveSuperior = BillUnifyService.setSuperiorInfo(depId, view);
            boolean haveDepCharge = BillUnifyService.setMainChange(adminOrgId, view);
            if (haveSuperior) {
                view.setVisible(Boolean.TRUE, new String[]{"flexsuperior"});
                view.setVisible(Boolean.FALSE, new String[]{"depchargeap"});
            } else if (haveDepCharge) {
                view.setVisible(Boolean.FALSE, new String[]{"flexsuperior"});
                view.setVisible(Boolean.TRUE, new String[]{"depchargeap"});
            }
            view.setVisible(Boolean.valueOf(haveSuperior || haveDepCharge), new String[]{"personinfo"});
        }
    }

    private static boolean setMainChange(Long adminOrgId, IFormView view) {
        boolean haveDepCharge = true;
        StopWatch stopWatch = StopWatch.createStarted();
        List<Map<String, Object>> depChargeInfoList = HRPIMServiceImpl.getInstance().getMainChargeByOrg(Lists.newArrayList((Object[])new Long[]{adminOrgId}));
        stopWatch.stop();
        LOG.info("BillUnifyService.setPersonInfo setMainChange end,times:{}", (Object)stopWatch.getTime());
        if (depChargeInfoList == null) {
            haveDepCharge = false;
        } else if (CollectionUtils.isEmpty(depChargeInfoList = depChargeInfoList.stream().filter(item -> HRStringUtils.isNotEmpty((String)((String)item.get("name")))).collect(Collectors.toList()))) {
            haveDepCharge = false;
        }
        if (haveDepCharge) {
            Map<String, Object> depChargeMap = depChargeInfoList.get(0);
            String depChargeName = (String)depChargeMap.get("name");
            String headPic = (String)depChargeMap.get("headsculpture");
            headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : ("/images/pc/emotion/default_person_82_82.png".equals(headPic) ? headPic : HRImageUrlUtil.getImageFullUrl((String)headPic));
            Label depChargeNameLbl = (Label)view.getControl("depname");
            Image depChargeHeadPic = (Image)view.getControl("depimg");
            LOG.info("BillUnifyService.setMainChange depChargeNameLbl:{},depChargeHeadPic:{}", (Object)depChargeNameLbl);
            depChargeNameLbl.setText(depChargeName);
            if (!HRStringUtils.isEmpty((String)headPic)) {
                depChargeHeadPic.setUrl(headPic);
            }
            view.setVisible(Boolean.valueOf(depChargeInfoList.size() > 1), new String[]{"flexpanelap121"});
            BillUnifyService.setMainChangeCache(depChargeInfoList, view);
        } else {
            view.getPageCache().remove("showdepInfo");
        }
        return haveDepCharge;
    }

    private static void setMainChangeCache(List<Map<String, Object>> depChargeInfoList, IFormView view) {
        ArrayList<JSONObject> infoList = new ArrayList<JSONObject>(16);
        for (Map<String, Object> chargeInfoMap : depChargeInfoList) {
            String nameText = (String)chargeInfoMap.get("name");
            String headPic = (String)chargeInfoMap.get("headsculpture");
            headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : ("/images/pc/emotion/default_person_82_82.png".equals(headPic) ? headPic : HRImageUrlUtil.getImageFullUrl((String)headPic));
            JSONObject infoObject = new JSONObject();
            infoObject.put("headsculpture", (Object)headPic);
            infoObject.put("name", (Object)nameText);
            infoList.add(infoObject);
        }
        JSONObject superObject = new JSONObject();
        String title = ResManager.loadKDString((String)"\u90e8\u95e8\u8d1f\u8d23\u4eba", (String)"BillUnifyService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        superObject.put("titleInfo", (Object)title);
        superObject.put("detailInfo", infoList);
        view.getPageCache().put("showdepInfo", JSON.toJSONString((Object)superObject));
    }

    private static void setPersonLabInfo(String name, String number, String gender, String orgName, String laborreltype, String post, String adminOrg, IFormView view) {
        Label labelPersonaName = (Label)view.getControl("labname");
        Label labeNum = (Label)view.getControl("labnumber");
        Label labebor = (Label)view.getControl("labborreltype");
        Label labPost = (Label)view.getControl("labpost");
        Label laborg = (Label)view.getControl("labadminorg");
        Label labOrg = (Label)view.getControl("lab_org");
        labebor.setText(laborreltype);
        if (HRStringUtils.isEmpty((String)laborreltype)) {
            view.setVisible(Boolean.FALSE, new String[]{"labborreltype"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"labborreltype"});
        }
        labelPersonaName.setText(name);
        labeNum.setText(number);
        labPost.setText(post);
        laborg.setText(adminOrg);
        labOrg.setText(orgName);
        Label sex = (Label)view.getControl("sex");
        sex.setText(gender);
    }

    private static boolean setSuperiorInfo(long depId, IFormView view) {
        List<Map<String, Object>> dirSuperInfoList;
        boolean haveSuperior = true;
        StopWatch stopWatch = StopWatch.createStarted();
        Map<Long, List<Map<String, Object>>> dirSuperInfoMap = HRPIMServiceImpl.getInstance().getDirectSuperiorByDepempId(Lists.newArrayList((Object[])new Long[]{depId}));
        stopWatch.stop();
        LOG.info("BillUnifyService.setPersonInfo setSuperiorInfo end,times:{}", (Object)stopWatch.getTime());
        if (CollectionUtils.isEmpty(dirSuperInfoMap)) {
            haveSuperior = false;
        }
        if ((dirSuperInfoList = dirSuperInfoMap.get(depId)) == null) {
            haveSuperior = false;
        } else if (CollectionUtils.isEmpty(dirSuperInfoList = dirSuperInfoList.stream().filter(item -> HRStringUtils.isNotEmpty((String)((String)item.get("superior.name")))).collect(Collectors.toList()))) {
            haveSuperior = false;
        }
        if (haveSuperior) {
            Map<String, Object> dirSuperInfo = dirSuperInfoList.get(0);
            String superiorName1 = (String)dirSuperInfo.get("superior.name");
            LOG.info("BillUnifyService.setSuperiorInfo superiorName1:{}", (Object)superiorName1);
            String headPic = (String)dirSuperInfo.get("superior.headsculpture");
            headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : ("/images/pc/emotion/default_person_82_82.png".equals(headPic) ? headPic : HRImageUrlUtil.getImageFullUrl((String)headPic));
            Label labelSuperior = (Label)view.getControl("lableader1");
            Image labelSuperiorHeadImage = (Image)view.getControl("imaleader1");
            labelSuperior.setText(superiorName1);
            if (!HRStringUtils.isEmpty((String)headPic)) {
                labelSuperiorHeadImage.setUrl(headPic);
            }
            view.setVisible(Boolean.valueOf(dirSuperInfoList.size() > 1), new String[]{"flexpanelap121"});
            BillUnifyService.setDirSuperiorCache(dirSuperInfoList, view);
        } else {
            view.getPageCache().remove("showSuperInfo");
        }
        return haveSuperior;
    }

    private static void setDirSuperiorCache(List<Map<String, Object>> dirSuperInfoList, IFormView view) {
        ArrayList<JSONObject> infoList = new ArrayList<JSONObject>(16);
        for (Map<String, Object> supMap : dirSuperInfoList) {
            String nameText = (String)supMap.get("superior.name");
            if (HRStringUtils.isEmpty((String)nameText)) continue;
            String headPic = (String)supMap.get("superior.headsculpture");
            headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : ("/images/pc/emotion/default_person_82_82.png".equals(headPic) ? headPic : HRImageUrlUtil.getImageFullUrl((String)headPic));
            JSONObject infoObject = new JSONObject();
            infoObject.put("headsculpture", (Object)headPic);
            infoObject.put("name", (Object)nameText);
            infoList.add(infoObject);
        }
        if (!CollectionUtils.isEmpty(infoList)) {
            JSONObject superObject = new JSONObject();
            String title = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"BillUnifyService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            superObject.put("titleInfo", (Object)title);
            superObject.put("detailInfo", infoList);
            view.getPageCache().put("showSuperInfo", JSON.toJSONString((Object)superObject));
        }
    }

    @Deprecated
    public static List<Long> getCurrUserAttFileTop1Ver(Long attPersonId) {
        return BillUnifyService.getCurrUserAttFileTop1Ver(attPersonId, null, null, null);
    }

    public static List<Long> getCurrUserAttFileTop1Ver(Long attPersonId, String appNumber, String entityNumber, String propKey) {
        List<DynamicObject> attFiles = BillUnifyService.getAttFileByPerson(attPersonId, appNumber, entityNumber, propKey);
        LOG.info("getCurrUserAttFileTop1Ver.attFiles size:{}", (Object)attFiles.size());
        if (!CollectionUtils.isEmpty(attFiles)) {
            long pkVal = BillUnifyService.getAttFileId(attFiles);
            LOG.info("getCurrUserAttFileTop1Ver.attFiles pkVal:{}", (Object)pkVal);
            List<DynamicObject> dynamicObjects = BillUnifyService.getAttFileVersionByBoId(pkVal, appNumber, entityNumber, propKey);
            List<Long> idList = attFiles.stream().map(item -> item.getLong("boid")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(dynamicObjects)) {
                return new ArrayList<Long>(0);
            }
            Long attfile = dynamicObjects.get(0).getLong("id");
            if (idList.size() > 1) {
                idList.add(attfile);
                return idList;
            }
            return Lists.newArrayList((Object[])new Long[]{attfile});
        }
        return new ArrayList<Long>(0);
    }

    private static Long getAttFileId(List<DynamicObject> attFiles) {
        long pkVal;
        Date nowDate = new Date();
        Optional<DynamicObject> first = attFiles.stream().filter(item -> item.getDate("startdate").compareTo(nowDate) <= 0 && item.getDate("enddate").compareTo(nowDate) >= 0).findFirst();
        if (first.isPresent()) {
            pkVal = first.get().getLong("boid");
        } else {
            List sorted = attFiles.stream().sorted(Comparator.comparing(item -> item.getDate("startdate"))).collect(Collectors.toList());
            DynamicObject latest = (DynamicObject)sorted.get(sorted.size() - 1);
            pkVal = latest.getLong("boid");
        }
        return pkVal;
    }

    private static List<DynamicObject> getAttFileByPerson(Long attPersonId, String appNumber, String entityNumber, String propKey) {
        return BillUnifyService.getAttFileByPerson(attPersonId, appNumber, entityNumber, propKey, true);
    }

    private static List<DynamicObject> getAttFileByPerson(Long attPersonId, String appNumber, String entityNumber, String propKey, boolean excludeLeave) {
        if (attPersonId == null || attPersonId.intValue() == 0) {
            attPersonId = BillUnifyService.getUserId();
        }
        if (attPersonId == null || attPersonId.intValue() == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties("id,boid,startdate,enddate,bsed,bsled,datastatus");
        attFileQueryParam.setAttPersonId(attPersonId.longValue());
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAppId(appNumber);
        attFileQueryParam.setFormId(entityNumber);
        attFileQueryParam.setPermField(propKey);
        attFileQueryParam.setOrgAuthCheck(true);
        attFileQueryParam.setHisStatus((Set)Sets.newHashSet(ATTFILESTATUSLIST));
        if (excludeLeave) {
            QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(null, attPersonId, "boid");
            attFileQueryParam.setqFilter(excludeAttFileLevelFilter);
        }
        List<DynamicObject> dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        HashSet boidSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.size());
        return dynamicObjects.stream().filter(item -> boidSet.add(item.getLong("boid"))).collect(Collectors.toList());
    }

    private static List<DynamicObject> getAttFileVersionByBoId(Long boId, String appNumber, String entityNumber, String propKey) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties("id,boid");
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.TRUE);
        attFileQueryParam.setOrgAuthCheck(true);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAppId(appNumber);
        attFileQueryParam.setFormId(entityNumber);
        attFileQueryParam.setPermField(propKey);
        attFileQueryParam.setBoId(boId.longValue());
        Page<DynamicObject> dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileQueryParam, 0, 1);
        return dynamicObjectPage.getListRecords();
    }

    public static void handleBeforeClose(IFormView view) {
        ArrayList propList = Lists.newArrayList((Object[])new String[]{"personid", "attfile", "billno"});
        String changeCount = view.getPageCache().get("attfilebasef7_changecount");
        if ("0".equals(changeCount)) {
            propList.add("attfilebasef7");
        }
        DynamicObject dataEntity = view.getModel().getDataEntity();
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        String iD = "_id";
        for (String prop : propList) {
            IDataEntityProperty iDataEntityPropertyId;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
            if (iDataEntityProperty == null) continue;
            if (iDataEntityProperty instanceof DynamicComplexProperty && (iDataEntityPropertyId = (IDataEntityProperty)properties.get((Object)(prop + iD))) != null) {
                dataEntityState.setBizChanged(iDataEntityPropertyId.getOrdinal(), false);
            }
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }

    public static int initAttFileByDate(IFormView view, Long attPerson, String appNumber, String formId, String propKey, Date recordDate) {
        return BillUnifyService.initAttFileByDate(view, attPerson, appNumber, formId, propKey, recordDate, true);
    }

    public static int initAttFileByDate(IFormView view, Long attPerson, String appNumber, String formId, String propKey, Date recordDate, boolean excludeLeave) {
        List<DynamicObject> attFiles = BillUnifyService.getAttFileByPerson(attPerson, appNumber, formId, propKey, excludeLeave);
        Optional<DynamicObject> first = attFiles.stream().filter(item -> item.getDate("startdate").compareTo(recordDate) <= 0 && item.getDate("enddate").compareTo(recordDate) >= 0 && ATTFILESTATUSLIST.contains(item.getString("datastatus"))).findFirst();
        String errorTip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709{0}\u4e0b\u7684\u6863\u6848\u6743\u9650\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillUnifyService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        errorTip = MessageFormat.format(errorTip, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)recordDate));
        int boCount = 0;
        if (first.isPresent()) {
            DynamicObject dynamicObject = first.get();
            long boId = dynamicObject.getLong("boid");
            List<DynamicObject> attFileVersions = BillUnifyService.getAttFileVersionByBoId(boId, appNumber, formId, propKey);
            if (!CollectionUtils.isEmpty(attFileVersions)) {
                IDataModel model = view.getModel();
                boolean fromDatabase = model.getDataEntity().getDataEntityState().getFromDatabase();
                if (!fromDatabase) {
                    model.setValue("personid", (Object)attPerson);
                    model.setValue("attfilebasef7", (Object)attFileVersions.get(0).getLong("id"));
                    model.setValue("attfile", (Object)boId);
                }
                boCount = attFiles.size();
            } else {
                view.showTipNotification(errorTip);
            }
        } else {
            view.showTipNotification(errorTip);
        }
        if (!CollectionUtils.isEmpty(attFiles) && attFiles.size() > 1) {
            view.setVisible(Boolean.TRUE, new String[]{"lab_changeperson"});
        }
        return boCount;
    }

    public static int initAttFileTopVersion(IFormView view, Long attPerson, String appNumber, String formId, String propKey) {
        return BillUnifyService.initAttFileTopVersion(view, attPerson, appNumber, formId, propKey, true);
    }

    public static int initAttFileTopVersion(IFormView view, Long attPerson, String appNumber, String formId, String propKey, boolean excludeLeave) {
        List<DynamicObject> attFiles = BillUnifyService.getAttFileByPerson(attPerson, appNumber, formId, propKey, excludeLeave);
        int boCount = 0;
        if (!CollectionUtils.isEmpty(attFiles)) {
            Long boId = BillUnifyService.getAttFileId(attFiles);
            List<DynamicObject> attFileVersions = BillUnifyService.getAttFileVersionByBoId(boId, appNumber, formId, propKey);
            if (!CollectionUtils.isEmpty(attFileVersions)) {
                IDataModel model = view.getModel();
                boolean fromDatabase = model.getDataEntity().getDataEntityState().getFromDatabase();
                if (!fromDatabase) {
                    model.setValue("personid", (Object)attPerson);
                    model.setValue("attfilebasef7", (Object)attFileVersions.get(0).getLong("id"));
                    model.setValue("attfile", (Object)boId);
                }
                boCount = attFiles.size();
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u7ec4\u7ec7\u4e0b\u672a\u521b\u5efa\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u5148\u521b\u5efa\u8003\u52e4\u6863\u6848\u3002", (String)"BillUnifyService_13", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(attFiles) && attFiles.size() > 1) {
            view.setVisible(Boolean.TRUE, new String[]{"lab_changeperson"});
        }
        return boCount;
    }

    public static Tuple<Boolean, String> checkBillRight(String entityId, String operationKey, IFormView view) {
        FormOperate formOperation = (FormOperate)FormMetadataCache.getFormOperation((String)entityId, (String)operationKey);
        String permissionItemId = BillUnifyService.getTargetPermissionId(entityId, formOperation, view);
        String otherEntityId = SLEFOTHERFORMMAP.get(entityId);
        if (HRStringUtils.isNotEmpty((String)otherEntityId) && HRStringUtils.isNotEmpty((String)permissionItemId)) {
            List checkResultList;
            List<CheckDimObjParam> checkDimObjParamList;
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            String bizAppId = view.getFormShowParameter().getCheckRightAppId();
            long userId = RequestContext.get().getCurrUserId();
            if (view instanceof BillView) {
                DynamicObject dataEntity = view.getModel().getDataEntity();
                checkDimObjParamList = BillUnifyService.getCheckDimObjParam(new DynamicObject[]{dataEntity});
            } else {
                ListView listView = (ListView)view;
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
                HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityId);
                DynamicObject[] billDys = serviceHelper.queryOriginalArray("id,org,applytyperadio", qFilter.toArray());
                checkDimObjParamList = BillUnifyService.getCheckDimObjParam(billDys);
            }
            boolean hasRight = true;
            if (!(CollectionUtils.isEmpty(checkDimObjParamList) || (checkResultList = permissionService.checkPermissionBatch(Long.valueOf(userId), bizAppId, entityId, permissionItemId, checkDimObjParamList)) != null && checkResultList.isEmpty())) {
                hasRight = false;
            }
            if (!hasRight) {
                String otherCaption = FormMetadataCache.getFormConfig((String)otherEntityId).getCaption().toString();
                String permissionName = PermItemHelper.getPermItemNameById((String)permissionItemId);
                String msg = ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillUnifyService_14", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                msg = MessageFormat.format(msg, otherCaption, permissionName);
                return new Tuple((Object)Boolean.FALSE, (Object)msg);
            }
        }
        return new Tuple((Object)Boolean.TRUE, (Object)"");
    }

    private static List<CheckDimObjParam> getCheckDimObjParam(DynamicObject[] billDys) {
        ArrayList<CheckDimObjParam> checkDimObjParamList = new ArrayList<CheckDimObjParam>(1);
        for (DynamicObject dataEntity : billDys) {
            boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
            if (!fromDatabase) continue;
            CheckDimObjParam checkDimObjParam = new CheckDimObjParam();
            long orgId = WTCDynamicObjectUtils.getBaseDataId(dataEntity, "org");
            long billId = dataEntity.getLong("id");
            checkDimObjParam.setId((Object)billId);
            checkDimObjParam.setDimensionOrg(orgId);
            checkDimObjParamList.add(checkDimObjParam);
        }
        return checkDimObjParamList;
    }

    private static String getTargetPermissionId(String entityId, FormOperate formOperation, IFormView view) {
        String permissionItemId = formOperation.getPermissionItemId();
        String operateKey = formOperation.getOperateKey();
        if (HRStringUtils.isEmpty((String)permissionItemId) && "save".equals(operateKey)) {
            Set permissionItems = EntityMetadataCache.getPermissionItems((String)entityId);
            boolean fromDatabase = view.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                if (permissionItems.contains("47156aff000000ac")) {
                    permissionItemId = "47156aff000000ac";
                }
            } else if (permissionItems.contains("4715a0df000000ac")) {
                permissionItemId = "4715a0df000000ac";
            }
        }
        return permissionItemId;
    }

    public static String getBillListOpenFromId(IListView listView, BillShowParameter parameter, int listType) {
        DynamicObject dynamicObject;
        if (parameter == null || listView == null) {
            logger.warn("param can no be null");
            throw new KDBizException("param can no be null");
        }
        parameter.setCustomParam("billopenfrom", (Object)String.valueOf(listType));
        String formId = parameter.getFormId();
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)formId);
        DynamicObject emptyDy = serviceHelper.generateEmptyDynamicObject();
        String prop = QUERYPROP;
        boolean haveChangeBill = emptyDy.containsProperty("ischange");
        if (haveChangeBill) {
            prop = WTCStringUtils.joinOnComma((String[])new String[]{QUERYPROP, "ischange"});
        }
        if ((dynamicObject = serviceHelper.queryOriginalOne(prop, parameter.getPkId())) == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"BillUnifyService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            listView.showErrorNotification(msg);
            return parameter.getFormId();
        }
        String billStatus = dynamicObject.getString("billstatus");
        parameter.setCustomParam("billstatus", (Object)billStatus);
        parameter.setCustomParam("creator", (Object)String.valueOf(dynamicObject.getLong("creator")));
        boolean isChangeBill = haveChangeBill && dynamicObject.getBoolean("ischange");
        String changeBill = isChangeBill ? "1" : "0";
        String selfBill = dynamicObject.getString("applytyperadio");
        String billType = selfBill + changeBill;
        LOG.info("BillUnifyService_getBillListOpenFromId formId:{},changeBill:{},selfBill:{},billType:{}", new Object[]{formId, changeBill, selfBill, billType});
        Map<String, String> billTypeMap = FORMMAP_UNMODIFY.get(formId);
        ArrayList unModifyStatus = Lists.newArrayList((Object[])new String[]{"A", "G"});
        if (!CollectionUtils.isEmpty(billTypeMap)) {
            String toForm = billTypeMap.get(billType);
            LOG.info("BillUnifyService_getBillListOpenFromId toForm:{}", (Object)toForm);
            if (HRStringUtils.isNotEmpty((String)toForm)) {
                boolean isEditBillStatus;
                parameter.setFormId(toForm);
                parameter.setPermissionEntityId(toForm);
                if (listType == 1) {
                    if ("0".equals(selfBill) && unModifyStatus.contains(billStatus)) {
                        Long userId = BillUnifyService.getUserId((IFormView)listView);
                        long attPerson = dynamicObject.getLong("personid");
                        if (userId == null || attPerson != userId) {
                            parameter.setBillStatus(BillOperationStatus.VIEW);
                            parameter.setStatus(OperationStatus.VIEW);
                        }
                    }
                } else if ("1".equals(selfBill)) {
                    parameter.setBillStatus(BillOperationStatus.VIEW);
                    parameter.setStatus(OperationStatus.VIEW);
                    parameter.setHasRight(true);
                    parameter.setCustomParam("wtcbill_hasright", (Object)"1");
                }
                String bizAppId = BillUnifyService.getAppId((IFormView)listView);
                boolean isOtherListOpenSelfBill = 1 == listType && "0".equals(selfBill);
                boolean isOtherListOpenSelfBillNotWtam = isOtherListOpenSelfBill && !"wtam".equals(bizAppId);
                boolean bl = isEditBillStatus = "A".equals(billStatus) || "G".equals(billStatus);
                if ((isOtherListOpenSelfBillNotWtam || isChangeBill) && isEditBillStatus) {
                    PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                    long userId = RequestContext.get().getCurrUserId();
                    dynamicObject.getDataEntityState().setFromDatabase(true);
                    List<CheckDimObjParam> checkDimObjParam = BillUnifyService.getCheckDimObjParam(new DynamicObject[]{dynamicObject});
                    if (!CollectionUtils.isEmpty(checkDimObjParam)) {
                        List checkResultList = permissionService.checkPermissionBatch(Long.valueOf(userId), bizAppId, toForm, "4715a0df000000ac", checkDimObjParam);
                        if (checkResultList == null || !checkResultList.isEmpty()) {
                            parameter.setBillStatus(BillOperationStatus.VIEW);
                            parameter.setStatus(OperationStatus.VIEW);
                        } else {
                            parameter.setBillStatus(BillOperationStatus.EDIT);
                            parameter.setStatus(OperationStatus.EDIT);
                        }
                    }
                }
            }
        }
        parameter.setCustomParam("BILL_FORM_ID", (Object)listView.getBillFormId());
        String pageId = BillCommonService.generatePageIdForListOp((IFormView)listView, (FormShowParameter)parameter);
        parameter.setPageId(pageId);
        if (!unModifyStatus.contains(billStatus)) {
            parameter.setBillStatus(BillOperationStatus.VIEW);
            parameter.setStatus(OperationStatus.VIEW);
        }
        return parameter.getFormId();
    }

    public static Tuple<Boolean, OperationResult> opTargetBillForm(BeforeDoOperationEventArgs args, IListView listView, DynamicObject[] billDys) {
        if (args != null && !args.isCancel()) {
            FormOperate operate = (FormOperate)args.getSource();
            String opKey = operate.getOperateKey();
            String entityId = operate.getEntityId();
            return BillUnifyService.opTargetBillForm(entityId, opKey, operate.getOption(), listView, billDys);
        }
        OperationResult operationResult = BillUnifyService.initOperationResult("", true, ErrorLevel.Info);
        return new Tuple((Object)Boolean.FALSE, (Object)operationResult);
    }

    public static Tuple<Boolean, OperationResult> opTargetBillForm(String entityId, String opKey, OperateOption operateOption, IListView listView, DynamicObject[] billDys) {
        Tuple<Boolean, String> resultTuple;
        ArrayList unHandleOps = Lists.newArrayList((Object[])new String[]{"close", "refresh", "new"});
        if (unHandleOps.contains(opKey)) {
            OperationResult operationResult = BillUnifyService.initOperationResult("", true, ErrorLevel.Info);
            return new Tuple((Object)Boolean.FALSE, (Object)operationResult);
        }
        BillUnifyService.setOptionUserId((IFormView)listView, operateOption);
        String appId = BillUnifyService.getAppId((IFormView)listView);
        ArrayList handleOps = Lists.newArrayList((Object[])new String[]{"submit", "unsubmit", "viewflowchart"});
        LOG.info("BillUnifyService_opTargetBillForm entityId:{},opKey:{}", (Object)entityId, (Object)opKey);
        if (!handleOps.contains(opKey)) {
            OperationResult operationResult = BillUnifyService.initOperationResult("", true, ErrorLevel.Info);
            if (StringUtils.equalsAny((CharSequence)opKey, (CharSequence[])new CharSequence[]{"change", "update"}) && !operateOption.containsVariable("VERIFY_BILL_SOURCE_OP")) {
                operateOption.setVariableValue("VERIFY_BILL_SOURCE_OP", "VERIFY_BILL_SOURCE_OP_FALSE");
            }
            return new Tuple((Object)Boolean.FALSE, (Object)operationResult);
        }
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BillUnifyService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            OperationResult operationResult = BillUnifyService.initOperationResult(msg, false, ErrorLevel.Warning);
            return new Tuple((Object)Boolean.TRUE, (Object)operationResult);
        }
        long distinctCount = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().count();
        if ("viewflowchart".equals(opKey) && distinctCount > 1L) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BillUnifyService_10", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            OperationResult operationResult = BillUnifyService.initOperationResult(msg, false, ErrorLevel.Warning);
            return new Tuple((Object)Boolean.TRUE, (Object)operationResult);
        }
        if (billDys == null) {
            billDys = BillUnifyService.getBillDys(listView, entityId);
        }
        if (billDys == null || billDys.length == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"BillUnifyService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            OperationResult operationResult = BillUnifyService.initOperationResult(errorMsg, false, ErrorLevel.FatalError);
            return new Tuple((Object)Boolean.TRUE, (Object)operationResult);
        }
        Map<String, List<DynamicObject>> billTypesMap = BillUnifyService.getBillTypesMap(billDys);
        if (!"wtam".equals(appId) && !((Boolean)(resultTuple = BillUnifyService.preCheckBillRight(entityId, opKey, listView, billTypesMap)).getKey()).booleanValue()) {
            OperationResult operationResult = BillUnifyService.initOperationResult((String)resultTuple.getValue(), false, ErrorLevel.Info);
            return new Tuple((Object)Boolean.TRUE, (Object)operationResult);
        }
        Set<String> billTypes = BillUnifyService.getBillTypes(billDys);
        OperationResult operationResult = BillUnifyService.checkIsMixBill(billTypes, entityId, opKey);
        if (operationResult.isSuccess()) {
            Map<String, String> formMap = FORMMAP_UNMODIFY.get(entityId);
            String targetEntityId = "";
            if (!CollectionUtils.isEmpty(formMap)) {
                targetEntityId = formMap.get(Lists.newArrayList(billTypes).get(0));
            }
            if (HRStringUtils.isEmpty((String)targetEntityId) || targetEntityId.equals(entityId)) {
                operationResult = BillUnifyService.initOperationResult("", true, ErrorLevel.Info);
                return new Tuple((Object)Boolean.FALSE, (Object)operationResult);
            }
            BillUnifyService.initOperateOption(operateOption, (IFormView)listView);
            if ("viewflowchart".equals(opKey)) {
                Object billId = billDys[0].get("id");
                WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)listView.getPageId(), (String)targetEntityId, (Object)billId);
                operationResult = BillUnifyService.initOperationResult("", true, ErrorLevel.Info);
            } else {
                billDys = BillUnifyService.getBillDys(listView, targetEntityId);
                operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)targetEntityId, (DynamicObject[])billDys, (OperateOption)operateOption);
                BillUnifyService.refreshListData((IFormView)listView, operationResult);
            }
        }
        return new Tuple((Object)Boolean.TRUE, (Object)operationResult);
    }

    private static Tuple<Boolean, String> preCheckBillRight(String entityId, String opKey, IListView listView, Map<String, List<DynamicObject>> billTypeDataMap) {
        boolean hasRight = true;
        String permissionItemId = "";
        String targetEntityId = "";
        for (Map.Entry<String, List<DynamicObject>> entry : billTypeDataMap.entrySet()) {
            int result;
            String billType = entry.getKey();
            if (STR_ONE_ZERO.equals(billType)) continue;
            Map<String, String> formMap = FORMMAP_UNMODIFY.get(entityId);
            if (!CollectionUtils.isEmpty(formMap)) {
                targetEntityId = formMap.get(billType);
            }
            if (HRStringUtils.isEmpty((String)targetEntityId) || targetEntityId.equals(entityId)) continue;
            List<DynamicObject> billDys = entry.getValue();
            FormOperate formOperation = (FormOperate)FormMetadataCache.getFormOperation((String)targetEntityId, (String)opKey);
            if (formOperation == null || HRStringUtils.isEmpty((String)(permissionItemId = formOperation.getPermissionItemId()))) continue;
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            String bizAppId = BillUnifyService.getAppId((IFormView)listView);
            long userId = RequestContext.get().getCurrUserId();
            if (formOperation.needSelectData()) {
                List checkResultList;
                List<CheckDimObjParam> checkDimObjParamList = BillUnifyService.getCheckDimObjParam(billDys.toArray(new DynamicObject[0]));
                if (CollectionUtils.isEmpty(checkDimObjParamList) || (checkResultList = permissionService.checkPermissionBatch(Long.valueOf(userId), bizAppId, targetEntityId, permissionItemId, checkDimObjParamList)) != null && checkResultList.isEmpty()) continue;
                hasRight = false;
                break;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityId);
            PermissionControlType permissionControlType = mainEntityType.getPermissionControlType();
            String dimType = permissionControlType.getDimension();
            if (HRStringUtils.isEmpty((String)dimType)) {
                dimType = "DIM_ORG";
            }
            if ((result = permissionService.checkPermission(userId, dimType, 0L, bizAppId, targetEntityId, permissionItemId)) == 1) continue;
            hasRight = false;
            break;
        }
        String msg = "";
        if (!hasRight) {
            String otherCaption = FormMetadataCache.getFormConfig((String)targetEntityId).getCaption().toString();
            String permissionName = PermItemHelper.getPermItemNameById((String)permissionItemId);
            msg = ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillUnifyService_14", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            msg = MessageFormat.format(msg, otherCaption, permissionName);
        }
        return new Tuple((Object)hasRight, (Object)msg);
    }

    public static OperationResult checkIsMixBill(Set<String> billTypes, String entityId, String opKey) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(true);
        if ("submit".equals(opKey) || "unsubmit".equals(opKey)) {
            String opName = ((FormOperate)FormMetadataCache.getFormOperation((String)entityId, (String)opKey)).getOperateName().toString();
            String errorMsg = "";
            if ((billTypes.contains(STR_ZERO_ONE) || billTypes.contains(STR_ELEVEN)) && (billTypes.contains(STR_ZERO_ZERO) || billTypes.contains(STR_ONE_ZERO))) {
                errorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u540c\u65f6{0}\u53d8\u66f4\u548c\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"BillUnifyService_6", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            } else if (billTypes.contains(STR_ZERO_ZERO) && billTypes.contains(STR_ONE_ZERO)) {
                errorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u540c\u65f6{0}\u672c\u4eba\u7533\u8bf7\u548c\u4e3a\u4ed6\u4eba\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"BillUnifyService_7", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            } else if (billTypes.contains(STR_ZERO_ONE) && billTypes.contains(STR_ELEVEN)) {
                errorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u540c\u65f6{0}\u672c\u4eba\u53d8\u66f4\u548c\u4e3a\u4ed6\u4eba\u53d8\u66f4\u7684\u5355\u636e\u3002", (String)"BillUnifyService_8", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            }
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                errorMsg = MessageFormat.format(errorMsg, opName);
                operationResult = BillUnifyService.initOperationResult(errorMsg, false, ErrorLevel.Warning);
            }
        }
        return operationResult;
    }

    private static DynamicObject[] getBillDys(IListView listView, String entityId) {
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityId);
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    private static OperationResult initOperationResult(String errorMsg, boolean success, ErrorLevel errorLevel) {
        ValidateResult validateResult = new ValidateResult();
        ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", errorMsg, errorLevel);
        validateResult.addErrorInfo((OperateErrorInfo)info);
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(success);
        operationResult.getValidateResult().addValidateError("", validateResult);
        return operationResult;
    }

    private static void initOperateOption(OperateOption operateOption, IFormView formView) {
        if (operateOption == null) {
            operateOption = OperateOption.create();
        }
        if (!operateOption.containsVariable("VERIFY_BILL_SOURCE_OP")) {
            operateOption.setVariableValue("VERIFY_BILL_SOURCE_OP", "VERIFY_BILL_SOURCE_OP_FALSE");
        }
        String appId = BillUnifyService.getAppId(formView);
        if (!operateOption.containsVariable("appnumber")) {
            operateOption.setVariableValue("appnumber", appId);
        }
        if (!operateOption.containsVariable("currbizappid")) {
            operateOption.setVariableValue("currbizappid", appId);
        }
        operateOption.setVariableValue("ishasright", "true");
    }

    private static String getAppId(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String appId = formShowParameter.getCheckRightAppId();
        if (HRStringUtils.isEmpty((String)appId)) {
            appId = formShowParameter.getAppId();
        }
        return appId;
    }

    private static Map<String, List<DynamicObject>> getBillTypesMap(DynamicObject[] billDys) {
        HashMap billTypesMap = Maps.newHashMapWithExpectedSize((int)4);
        for (DynamicObject billDy : billDys) {
            String selfBill = billDy.getString("applytyperadio");
            String billType = "0".equals(selfBill) ? STR_ZERO_ZERO : STR_ONE_ZERO;
            List dys = billTypesMap.computeIfAbsent(billType, k -> new ArrayList(billDys.length));
            dys.add(billDy);
        }
        return billTypesMap;
    }

    private static Set<String> getBillTypes(DynamicObject[] billDys) {
        HashSet billTypes = Sets.newHashSetWithExpectedSize((int)4);
        for (DynamicObject billDy : billDys) {
            boolean haveChangeBill = billDy.containsProperty("ischange");
            boolean isChangeBill = haveChangeBill && billDy.getBoolean("ischange");
            String changeBill = isChangeBill ? "1" : "0";
            String selfBill = billDy.getString("applytyperadio");
            String billType = selfBill + changeBill;
            billTypes.add(billType);
        }
        return billTypes;
    }

    public static String getOpSuccessTip(String entityId, String opKey) {
        if ("viewflowchart".equals(opKey)) {
            return "";
        }
        Map operateMap = EntityMetadataCache.getDataEntityOperate((String)entityId, (String)opKey);
        String opName = LocaleString.fromMap((Map)((Map)operateMap.get("name"))).getLocaleValue();
        String msg = ResManager.loadKDString((String)"{0}\u6210\u529f\u3002", (String)"BillUnifyService_9", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        return MessageFormat.format(msg, opName);
    }

    public static void refreshListData(IFormView view, OperationResult operationResult) {
        List successPkIds;
        if (operationResult != null && operationResult.getValidateResult() != null && WTCCollections.isNotEmpty((Collection)(successPkIds = operationResult.getSuccessPkIds())) && !operationResult.isSuccess()) {
            BillUnifyService.refreshListData(view);
        }
    }

    public static void refreshAndCleanSelectListData(IFormView view) {
        BillList billList;
        if (view instanceof ListView && (billList = (BillList)view.getControl("billlistap")) != null) {
            billList.clearSelection();
            billList.refresh();
        }
    }

    public static void refreshListData(IFormView view) {
        BillList billList;
        if (view instanceof ListView && (billList = (BillList)view.getControl("billlistap")) != null) {
            billList.refresh();
        }
    }

    public static void preOpenForm(BillShowParameter showParameter) {
        String billOpenForm = (String)showParameter.getCustomParam("billopenfrom");
        if (!"1".equals(billOpenForm)) {
            return;
        }
        BillOperationStatus billStatus = showParameter.getBillStatus();
        if (BillOperationStatus.ADDNEW == billStatus) {
            return;
        }
        String creator = (String)showParameter.getCustomParam("creator");
        if (HRStringUtils.isEmpty((String)creator)) {
            return;
        }
        long currentUserId = RequestContext.get().getCurrUserId();
        if (currentUserId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237id\u3002", (String)"BillUnifyService_11", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        long creatorId = Long.parseLong(creator);
        if (currentUserId == creatorId) {
            return;
        }
        String status = (String)showParameter.getCustomParam("billstatus");
        if (HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)status, (String)"G")) {
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public static void customBillButton(IFormView view) {
        if (view == null) {
            return;
        }
        BillShowParameter showParameter = (BillShowParameter)view.getFormShowParameter();
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String applyType = dataEntity.getString("applytyperadio");
        if (BillApplyTypeEnum.BATCH.getCode().equals(applyType)) {
            view.setVisible(Boolean.FALSE, STATUS_TMP_HIDDEN_ITEM);
            view.setVisible(Boolean.FALSE, new String[]{"bar_viewflowchart"});
            view.setVisible(Boolean.FALSE, new String[]{"auditpage"});
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            return;
        }
        BillUnifyService.commonHandleViewFlowChar(view);
        if ("0".equals(showParameter.getCustomParam("billopenfrom"))) {
            BillUnifyService.customBillButtonSelf(view);
            return;
        }
        String appId = view.getFormShowParameter().getAppId();
        BillOperationStatus billStatus = showParameter.getBillStatus();
        if (HRStringUtils.equals((String)BillOperationStatus.ADDNEW.name(), (String)billStatus.name()) || billStatus.getValue() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2", "updatebill"});
            if ("wtss".equals(appId)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_submiteffect"});
            }
            return;
        }
        long currentUserId = RequestContext.get().getCurrUserId();
        if (currentUserId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237id\u3002", (String)"BillUnifyService_11", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        long creatorId = 0L;
        String status = (String)model.getValue("billstatus");
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        if (creator != null) {
            creatorId = creator.getLong("id");
        }
        long attPersonId = dataEntity.getLong("personid.id");
        Long userId = BillUnifyService.getUserId(view);
        long currAttPersonId = userId == null ? 0L : userId;
        logger.info("BillUnifyService_customBillButton currentUserId={},creatorId={}", (Object)currentUserId, (Object)creatorId);
        view.setVisible(Boolean.FALSE, new String[]{"updatebill"});
        view.setVisible(Boolean.TRUE, new String[]{"bar_unsubmit2"});
        switch (status) {
            case "G": {
                if (currentUserId == creatorId) {
                    view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2"});
                    view.setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                } else {
                    view.setVisible(Boolean.FALSE, STATUS_TMP_HIDDEN_ITEM);
                    view.setStatus(OperationStatus.VIEW);
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                }
                view.setVisible(Boolean.FALSE, new String[]{"bar_submiteffect", "bar_del"});
                break;
            }
            case "A": {
                if (currentUserId == creatorId) {
                    view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2"});
                    view.setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_del", "bar_submiteffect"});
                } else {
                    view.setVisible(Boolean.FALSE, STATUS_TMP_HIDDEN_ITEM);
                    view.setStatus(OperationStatus.VIEW);
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                }
                if (!"wtss".equals(appId) || creatorId != currentUserId) break;
                view.setVisible(Boolean.FALSE, new String[]{"bar_submiteffect"});
                break;
            }
            case "B": 
            case "D": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                if (attPersonId == currAttPersonId && creatorId != currentUserId) {
                    view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2"});
                }
                if (!"wtss".equals(appId) || creatorId == currentUserId) break;
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2"});
                break;
            }
            case "C": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit2"});
                if (attPersonId == currAttPersonId) break;
                view.setVisible(Boolean.TRUE, new String[]{"updatebill"});
                break;
            }
            case "E": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit2"});
                break;
            }
            case "F": {
                view.setVisible(Boolean.FALSE, STATUS_TMP_HIDDEN_ITEM);
            }
        }
    }

    public static void commonHandleViewFlowChar(IFormView view) {
        if (view == null) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        if (dataEntity.containsProperty("billstatus") && dataEntity.containsProperty("isexistsworkflow")) {
            String billStatus = dataEntity.getString("billstatus");
            boolean isExistsWF = dataEntity.getBoolean("isexistsworkflow");
            if ("C".equals(billStatus) || "E".equals(billStatus)) {
                view.setVisible(Boolean.valueOf(isExistsWF), new String[]{"bar_viewflowchart"});
            }
        }
    }

    private static void customBillButtonSelf(IFormView view) {
        BillShowParameter showParameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus billStatus = showParameter.getBillStatus();
        if (BillOperationStatus.ADDNEW.equals((Object)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2", "updatebill"});
            return;
        }
        long currentUserId = RequestContext.get().getCurrUserId();
        if (currentUserId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237id\u3002", (String)"BillUnifyService_11", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        long creatorId = 0L;
        IDataModel model = view.getModel();
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        if (creator != null) {
            creatorId = creator.getLong("id");
        }
        String status = (String)view.getModel().getValue("billstatus");
        view.setVisible(Boolean.FALSE, new String[]{"updatebill"});
        switch (status) {
            case "G": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                break;
            }
            case "A": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_unsubmit2"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_del"});
                break;
            }
            case "B": 
            case "D": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                if (creatorId != currentUserId) {
                    view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit2"});
                    break;
                }
                view.setVisible(Boolean.TRUE, new String[]{"bar_unsubmit2"});
                break;
            }
            case "C": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit2"});
                if (creatorId != currentUserId) break;
                view.setVisible(Boolean.TRUE, new String[]{"updatebill"});
                break;
            }
            case "E": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit2"});
                break;
            }
            case "F": {
                view.setVisible(Boolean.FALSE, STATUS_TMP_HIDDEN_ITEM);
            }
        }
    }

    public static String getOpName(String entityKey, String opKey) {
        Map dataEntityOperate;
        if (!(HRStringUtils.isEmpty((String)entityKey) || HRStringUtils.isEmpty((String)opKey) || CollectionUtils.isEmpty((Map)(dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityKey, (String)opKey))) || dataEntityOperate.get("permission") == null)) {
            return PermItemHelper.getPermItemNameById((String)String.valueOf(dataEntityOperate.get("permission")));
        }
        return "";
    }

    public static boolean verifyAttFileContainsCurrentUser(DynamicObject[] wtcBillDyList) {
        return BillUnifyService.verifyAttFileContainsCurrentUser(wtcBillDyList, null);
    }

    public static boolean verifyAttFileContainsCurrentUser(DynamicObject[] wtcBillDyList, IFormView view) {
        if (wtcBillDyList == null || wtcBillDyList.length == 0) {
            return false;
        }
        HashSet personIdFromBill = Sets.newHashSetWithExpectedSize((int)wtcBillDyList.length);
        for (DynamicObject billDy : wtcBillDyList) {
            DynamicObject attPerson;
            DynamicObject attFileDy = billDy.getDynamicObject("attfile");
            if (attFileDy == null || (attPerson = (DynamicObject)attFileDy.get("attperson")) == null) continue;
            personIdFromBill.add(attPerson.getLong("id"));
        }
        Long currentPersonId = BillUnifyService.getUserId(view);
        if (currentPersonId == null) {
            return false;
        }
        return personIdFromBill.contains(currentPersonId);
    }

    public static void handleHyperLinkViewFlowChar(IFormView view, HyperLinkClickArgs args) {
        Object source;
        String fieldName = args.getFieldName();
        if ("approverlistcolumnap".equals(fieldName) && (source = args.getHyperLinkClickEvent().getSource()) instanceof BillList) {
            String msg;
            String entityId = ((BillList)source).getEntityId();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (dataEntityType instanceof QueryEntityType) {
                entityId = ((QueryEntityType)dataEntityType).getEntityName();
            }
            if (HRStringUtils.isNotEmpty((String)(msg = BillUnifyService.checkBillListOpRight(view, entityId, "viewflowchart", true)))) {
                view.showErrorNotification(msg);
                args.setCancel(true);
            }
        }
    }

    public static String checkBillListOpRight(IFormView view, String entityId, String opKey, boolean isSingle) {
        List checkResultList;
        DynamicObject[] billDys;
        FormOperate formOperation = (FormOperate)FormMetadataCache.getFormOperation((String)entityId, (String)opKey);
        String permissionItemId = BillUnifyService.getTargetPermissionId(entityId, formOperation, view);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = view.getFormShowParameter().getCheckRightAppId();
        long userId = RequestContext.get().getCurrUserId();
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        ListSelectedRow currentSelectedRowInfo = ((IListView)view).getCurrentSelectedRowInfo();
        if (isSingle) {
            selectedRows.clear();
            selectedRows.add((Object)currentSelectedRowInfo);
        }
        if (selectedRows.getPrimaryKeyValues() == null || selectedRows.getPrimaryKeyValues().length < 1) {
            return "";
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityId);
        for (DynamicObject dy : billDys = serviceHelper.queryOriginalArray("id,org", qFilter.toArray())) {
            dy.getDataEntityState().setFromDatabase(true);
        }
        List<CheckDimObjParam> checkDimObjParam = BillUnifyService.getCheckDimObjParam(billDys);
        boolean hasRight = true;
        if (!(CollectionUtils.isEmpty(checkDimObjParam) || (checkResultList = permissionService.checkPermissionBatch(Long.valueOf(userId), bizAppId, entityId, permissionItemId, checkDimObjParam)) != null && checkResultList.isEmpty())) {
            hasRight = false;
        }
        String msg = "";
        if (!hasRight) {
            String otherCaption = FormMetadataCache.getFormConfig((String)entityId).getCaption().toString();
            String permissionName = PermItemHelper.getPermItemNameById((String)permissionItemId);
            msg = ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WTCBaseBillPlugin_4", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
            msg = MessageFormat.format(msg, otherCaption, permissionName);
        }
        return msg;
    }

    public static void isMutex(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        if (dataEntity != null && dataEntity.getDataEntityState().getFromDatabase()) {
            long pkId = dataEntity.getLong("id");
            BillShowParameter parameter = (BillShowParameter)view.getFormShowParameter();
            boolean isStrict = !parameter.isEnableUserReentrant();
            String entityId = view.getEntityId();
            WTCMutexLockInfo lockInfo = new WTCMutexLockInfo(view, String.valueOf(pkId), null, null, entityId, "modify", isStrict, "default", new StringBuilder());
            boolean isSuccess = WTCMutexHelper.require((WTCMutexLockInfo)lockInfo);
            if (!isSuccess) {
                return;
            }
            if (pkId > 0L && (OperationStatus.VIEW == parameter.getStatus() || BillOperationStatus.VIEW == parameter.getBillStatus())) {
                WTCMutexHelper.release((WTCMutexLockInfo)lockInfo);
            }
        }
    }

    public static void setBillFormStatus(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billStatus = dataEntity.getString("billstatus");
        ArrayList modifyStatus = Lists.newArrayList((Object[])new String[]{"A", "G"});
        FormShowParameter formShowParameter = view.getFormShowParameter();
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        if (BillOperationStatus.ADDNEW == billShowParameter.getBillStatus()) {
            return;
        }
        if (modifyStatus.contains(billStatus)) {
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        BillUnifyService.customBillButton(view);
        BillUnifyService.isMutex(view);
    }

    static {
        String PAGE_WTOM_OTSELFBILLCHANGE = "wtom_otselfbillchange";
        String PAGE_WTOM_OTBILLCHANGE = "wtom_otbillchange";
        SLEFOTHERFORMMAP.put("wtpm_supsignself", "wtpm_supsignpc");
        SLEFOTHERFORMMAP.put("wtpm_supsignpcchange", "wtpm_supsignpc");
        SLEFOTHERFORMMAP.put("wtpm_supsignselfchange", "wtpm_supsignpc");
        SLEFOTHERFORMMAP.put("wtam_busitripselfbill", "wtam_busitripbill");
        SLEFOTHERFORMMAP.put("wtam_busiselfbillchange", "wtam_busibillchange");
        SLEFOTHERFORMMAP.put("wtam_busibillchange", "wtam_busibillchange");
        SLEFOTHERFORMMAP.put("wtom_otbillself", "wtom_overtimeapplybill");
        SLEFOTHERFORMMAP.put(PAGE_WTOM_OTSELFBILLCHANGE, "wtom_overtimeapplybill");
        SLEFOTHERFORMMAP.put(PAGE_WTOM_OTBILLCHANGE, "wtom_overtimeapplybill");
        SLEFOTHERFORMMAP.put("wtabm_vaapplyself", "wtabm_vaapply");
        SLEFOTHERFORMMAP.put("wtabm_vaupdateself", "wtabm_vaapply");
        SLEFOTHERFORMMAP.put("wtabm_vaupdate", "wtabm_vaapply");
        SLEFOTHERFORMMAP.put("wts_swshiftselfbill", "wts_swshiftbill");
        HashMap adMap = Maps.newHashMapWithExpectedSize((int)1);
        adMap.put(STR_ZERO_ZERO, "wtpm_supsignself");
        adMap.put(STR_ZERO_ONE, "wtpm_supsignselfchange");
        adMap.put(STR_ELEVEN, "wtpm_supsignpcchange");
        FORMMAP.put("wtpm_supsignpc", adMap);
        HashMap adMapSelf = Maps.newHashMapWithExpectedSize((int)1);
        adMapSelf.put(STR_ONE_ZERO, "wtpm_supsignpc");
        adMapSelf.put(STR_ZERO_ONE, "wtpm_supsignselfchange");
        adMapSelf.put(STR_ELEVEN, "wtpm_supsignpcchange");
        FORMMAP.put("wtpm_supsignself", adMapSelf);
        HashMap tpMap = Maps.newHashMapWithExpectedSize((int)3);
        tpMap.put(STR_ZERO_ZERO, "wtam_busitripselfbill");
        tpMap.put(STR_ZERO_ONE, "wtam_busiselfbillchange");
        tpMap.put(STR_ELEVEN, "wtam_busibillchange");
        FORMMAP.put("wtam_busitripbill", tpMap);
        HashMap tpMapSelf = Maps.newHashMapWithExpectedSize((int)3);
        tpMapSelf.put(STR_ONE_ZERO, "wtam_busitripbill");
        tpMapSelf.put(STR_ZERO_ONE, "wtam_busiselfbillchange");
        tpMapSelf.put(STR_ELEVEN, "wtam_busibillchange");
        FORMMAP.put("wtam_busitripselfbill", tpMapSelf);
        HashMap otMap = Maps.newHashMapWithExpectedSize((int)3);
        otMap.put(STR_ZERO_ZERO, "wtom_otbillself");
        otMap.put(STR_ZERO_ONE, PAGE_WTOM_OTSELFBILLCHANGE);
        otMap.put(STR_ELEVEN, PAGE_WTOM_OTBILLCHANGE);
        FORMMAP.put("wtom_overtimeapplybill", otMap);
        HashMap otMapSelf = Maps.newHashMapWithExpectedSize((int)3);
        otMapSelf.put(STR_ONE_ZERO, "wtom_overtimeapplybill");
        otMapSelf.put(STR_ZERO_ONE, PAGE_WTOM_OTSELFBILLCHANGE);
        otMapSelf.put(STR_ELEVEN, PAGE_WTOM_OTBILLCHANGE);
        FORMMAP.put("wtom_otbillself", otMapSelf);
        HashMap vaMap = Maps.newHashMapWithExpectedSize((int)3);
        vaMap.put(STR_ZERO_ZERO, "wtabm_vaapplyself");
        vaMap.put(STR_ZERO_ONE, "wtabm_vaupdateself");
        vaMap.put(STR_ELEVEN, "wtabm_vaupdate");
        vaMap.put("21", "wtabm_vaupdate");
        FORMMAP.put("wtabm_vaapply", vaMap);
        HashMap vaMapSelf = Maps.newHashMapWithExpectedSize((int)3);
        vaMapSelf.put(STR_ONE_ZERO, "wtabm_vaapply");
        vaMapSelf.put(STR_ZERO_ONE, "wtabm_vaupdateself");
        vaMapSelf.put(STR_ELEVEN, "wtabm_vaupdate");
        FORMMAP.put("wtabm_vaapplyself", vaMapSelf);
        HashMap swsMap = Maps.newHashMapWithExpectedSize((int)1);
        swsMap.put(STR_ZERO_ZERO, "wts_swshiftselfbill");
        FORMMAP.put("wts_swshiftbill", swsMap);
        HashMap swsMapSelf = Maps.newHashMapWithExpectedSize((int)1);
        swsMapSelf.put(STR_ONE_ZERO, "wts_swshiftbill");
        FORMMAP.put("wts_swshiftselfbill", swsMapSelf);
    }
}

