/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.bill.IVaBillParseService;
import kd.wtc.wtbs.business.util.ShiftParseUtil;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityValidVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillParseParam;
import kd.wtc.wtbs.common.model.bill.va.VaBillSubEntryVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillWithTimeVo;
import kd.wtc.wtbs.common.model.bill.va.VaEntryValidTimeVo;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftParseVo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaBillService
implements IVaBillParseService {
    private static final Log LOG = LogFactory.getLog(VaBillService.class);

    public static VaBillService getInstance() {
        return Instance.vaBillService;
    }

    @Override
    public List<VaBillWithTimeVo> parseVaBillByShifts(VaBillParseParam params) {
        LOG.info("parseVaBillByShifts begin , params :{}", (Object)params);
        List vaBillVos = params.getVaBillVos();
        if (CollectionUtils.isEmpty((Collection)vaBillVos)) {
            return Collections.emptyList();
        }
        HashMap shiftMap = Maps.newHashMapWithExpectedSize((int)16);
        DutyShiftResponse dutyShiftResponse = params.getDutyShiftResponse();
        Date prevDate = WTCDateUtils.addDays((Date)params.getStartDate(), (int)-1);
        LOG.info("toShiftParseVo begin.");
        Date date = WTCDateUtils.getDayStart((Date)prevDate);
        while (!date.after(params.getEndDate())) {
            ShiftParseVo vo = this.toShiftParseVo(dutyShiftResponse, date, params.getAttFileBoid(), params.isExpandOffNonPllan());
            if (vo != null) {
                shiftMap.put(vo.getRosterDate(), vo);
            }
            date = WTCDateUtils.addDays((Date)date, (int)1);
        }
        ArrayList results = Lists.newArrayListWithExpectedSize((int)vaBillVos.size());
        for (VaBillVo vaBillVo : vaBillVos) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse vaBillVo:{}", (Object)vaBillVo);
            }
            VaBillWithTimeVo billWithTimeVo = new VaBillWithTimeVo();
            results.add(billWithTimeVo);
            billWithTimeVo.setId(vaBillVo.getId());
            billWithTimeVo.setBillNo(vaBillVo.getBillNo());
            billWithTimeVo.setAttFileBoId(vaBillVo.getAttFileBoId());
            billWithTimeVo.setAttPersonId(vaBillVo.getAttPersonId());
            billWithTimeVo.setAttFileVid(vaBillVo.getAttFileVid());
            billWithTimeVo.setParentId(vaBillVo.getParentId());
            List entryEntities = vaBillVo.getEntryEntities();
            List<VaBillEntryEntityValidVo> vaBillEntryEntityValidVos = this.parseVaBillEntries(params, entryEntities, shiftMap);
            billWithTimeVo.setEntryEntities(vaBillEntryEntityValidVos);
        }
        LOG.info("parseVaBillByShifts success.");
        return results;
    }

    private List<VaBillEntryEntityValidVo> parseVaBillEntries(VaBillParseParam params, List<VaBillEntryEntityVo> entryEntities, Map<Date, ShiftParseVo> shiftMap) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)entryEntities.size());
        for (VaBillEntryEntityVo entry : entryEntities) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parseVaBillEntries:{}", (Object)entry);
            }
            VaBillEntryEntityValidVo vo = new VaBillEntryEntityValidVo(entry);
            results.add(vo);
            List<Object> validTimeVos = Lists.newArrayListWithCapacity((int)10);
            String specialVaType = entry.getSpecialVaType();
            String startMethod = entry.getStartMethod();
            if (StringUtils.equals((CharSequence)SpecialVaTypeEnum.LACTATION_TYPE.vaType, (CharSequence)specialVaType)) {
                List vaSubEntryVoList = entry.getVaSubEntryVoList();
                validTimeVos = this.parseVaSubEntry(vaSubEntryVoList, shiftMap);
            } else if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)startMethod)) {
                List<VaEntryValidTimeVo> vaEntryValidTimeVos = this.parseValidTimeVo(entry.getStartDate(), entry.getEndDate(), shiftMap);
                if (!CollectionUtils.isEmpty(vaEntryValidTimeVos)) {
                    validTimeVos.addAll(vaEntryValidTimeVos);
                }
            } else {
                Date entryStartDate;
                String endMethod = entry.getEndMethod();
                Date entryEndDate = entry.getEndDate();
                Date vaDate = entryStartDate = entry.getStartDate();
                while (!vaDate.after(entryEndDate)) {
                    ShiftParseVo shiftParseVo = shiftMap.get(vaDate);
                    if (shiftParseVo != null) {
                        Date startDateTime = shiftParseVo.getStartDateTime();
                        Date endDateTime = shiftParseVo.getEndDateTime();
                        if (DateUtils.isSameDay((Date)entryStartDate, (Date)vaDate) && StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (CharSequence)startMethod)) {
                            startDateTime = shiftParseVo.getShiftMiddleDateTime();
                        }
                        if (DateUtils.isSameDay((Date)entryEndDate, (Date)vaDate) && StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (CharSequence)endMethod)) {
                            endDateTime = shiftParseVo.getShiftMiddleDateTime();
                        }
                        VaEntryValidTimeVo validTimeVo = new VaEntryValidTimeVo(startDateTime, endDateTime, shiftParseVo);
                        validTimeVos.add(validTimeVo);
                    }
                    vaDate = WTCDateUtils.addDays((Date)vaDate, (int)1);
                }
            }
            vo.setVaEntryValidTimeVoList((List)validTimeVos);
        }
        return results;
    }

    private List<VaEntryValidTimeVo> parseVaSubEntry(List<VaBillSubEntryVo> vaSubEntryVoList, Map<Date, ShiftParseVo> shiftMap) {
        ArrayList vos = Lists.newArrayListWithCapacity((int)vaSubEntryVoList.size());
        for (VaBillSubEntryVo subEntryVo : vaSubEntryVoList) {
            List<VaEntryValidTimeVo> vaEntryValidTimeVos = this.parseValidTimeVo(subEntryVo.getStartDateTime(), subEntryVo.getEndDateTime(), shiftMap);
            if (CollectionUtils.isEmpty(vaEntryValidTimeVos)) continue;
            vos.addAll(vaEntryValidTimeVos);
        }
        return vos;
    }

    private List<VaEntryValidTimeVo> parseValidTimeVo(Date startDateTime, Date endDateTime, Map<Date, ShiftParseVo> shiftMap) {
        ArrayList vos = Lists.newArrayListWithCapacity((int)10);
        LocalDate localDate = WTCDateUtils.toLocalDate((Date)startDateTime);
        LocalDate minStart = localDate.plusDays(-2L);
        LocalDate maxEnd = WTCDateUtils.toLocalDate((Date)endDateTime);
        ArrayList shiftList = Lists.newArrayListWithExpectedSize((int)shiftMap.size());
        LocalDate date = minStart;
        while (!date.isAfter(maxEnd)) {
            ShiftParseVo shiftParseVo = shiftMap.get(WTCDateUtils.toDate((LocalDate)localDate));
            if (shiftParseVo != null) {
                shiftList.add(shiftParseVo);
            }
            date = date.plusDays(1L);
        }
        ShiftParseVo prev = null;
        for (ShiftParseVo value : shiftList) {
            Date end;
            Date start;
            boolean offNoPlan = value.getOffNoPlan();
            if (offNoPlan) {
                Date offNoPlanStart = this.getOffNoPlanStart(value, prev);
                Date offNoPlanEnd = WTCDateUtils.addDays((Date)value.getRosterDate(), (int)1);
                start = WTCDateUtils.getMaxDate((Date)startDateTime, (Date)offNoPlanStart);
                end = WTCDateUtils.getMinDate((Date)endDateTime, (Date)offNoPlanEnd);
            } else {
                start = WTCDateUtils.getMaxDate((Date)startDateTime, (Date)value.getStartDateTime());
                end = WTCDateUtils.getMinDate((Date)endDateTime, (Date)value.getEndDateTime());
            }
            if (start.before(end)) {
                vos.add(new VaEntryValidTimeVo(start, end, value));
            }
            prev = value;
        }
        return vos;
    }

    private Date getOffNoPlanStart(ShiftParseVo shiftParseVo, ShiftParseVo prev) {
        if (prev == null) {
            return shiftParseVo.getRosterDate();
        }
        Date prevEndDateTime = prev.getEndDateTime();
        if (prev.getOffNoPlan()) {
            prevEndDateTime = WTCDateUtils.addDays((Date)prev.getEndDateTime(), (int)1);
        }
        return WTCDateUtils.getMaxDate((Date)prevEndDateTime, (Date)shiftParseVo.getRosterDate());
    }

    private ShiftParseVo toShiftParseVo(DutyShiftResponse shiftResponse, Date date, long attFileBoid, boolean expandOffNonPlan) {
        Optional dutyShiftOption = shiftResponse.getDutyShift(Long.valueOf(attFileBoid), date);
        ShiftParseVo vo = null;
        if (dutyShiftOption.isPresent()) {
            Date prevEndDate = date;
            Optional prevDutyShiftOption = shiftResponse.getDutyShift(Long.valueOf(attFileBoid), WTCDateUtils.addDays((Date)date, (int)-1));
            if (prevDutyShiftOption.isPresent()) {
                Shift prevShift;
                DutyShift prevDutyShift = (DutyShift)prevDutyShiftOption.get();
                Optional prevShiftHis = shiftResponse.getCurrShiftHis(Long.valueOf(attFileBoid), WTCDateUtils.addDays((Date)date, (int)-1));
                if (prevShiftHis.isPresent() && !(prevShift = (Shift)prevShiftHis.get()).getOffNonPlan()) {
                    prevEndDate = ShiftParseUtil.getRosterEndDate(prevShift, prevDutyShift.getRosterDate(), expandOffNonPlan);
                }
            }
            DutyShift dutyShift = (DutyShift)dutyShiftOption.get();
            Optional currShiftHis = shiftResponse.getCurrShiftHis(Long.valueOf(attFileBoid), date);
            if (currShiftHis.isPresent()) {
                vo = new ShiftParseVo();
                Shift shift = (Shift)currShiftHis.get();
                vo.setRosterDate(dutyShift.getRosterDate());
                vo.setOffNoPlan(shift.getOffNonPlan());
                if (!shift.getOffNonPlan() || expandOffNonPlan) {
                    Date rosterStartDate = ShiftParseUtil.getRosterStartDate(shift, dutyShift.getRosterDate(), prevEndDate);
                    Date rosterEndDate = ShiftParseUtil.getRosterEndDate(shift, dutyShift.getRosterDate(), expandOffNonPlan);
                    Date middleDate = ShiftParseUtil.getMiddleDate(shift, dutyShift.getRosterDate());
                    vo.setStartDateTime(rosterStartDate);
                    vo.setEndDateTime(rosterEndDate);
                    vo.setShiftMiddleDateTime(middleDate);
                }
            }
        }
        return vo;
    }

    private static class Instance {
        private static VaBillService vaBillService = new VaBillService();

        private Instance() {
        }
    }
}

