/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.common.bill.ApplyTimeTypeParam;
import kd.wtc.wtbs.common.enums.ApplicationTypeEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.wtctimerange.WtcTimeRangeArgsModel;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class WtcTimeRangeControlService {
    private static final Log LOG = LogFactory.getLog(WtcTimeRangeControlService.class);
    private static final List<Integer> START_METHOD_ORDER = Lists.newArrayList((Object[])new Integer[]{WtcTimeRangeBtnTypeEnum.DAY.code, WtcTimeRangeBtnTypeEnum.HALF_UP.code, WtcTimeRangeBtnTypeEnum.HALF_DOWN.code, WtcTimeRangeBtnTypeEnum.CUSTOM.code});
    private static final List<Integer> END_METHOD_ORDER = Lists.newArrayList((Object[])new Integer[]{WtcTimeRangeBtnTypeEnum.DAY.code, WtcTimeRangeBtnTypeEnum.HALF_DOWN.code, WtcTimeRangeBtnTypeEnum.HALF_UP.code, WtcTimeRangeBtnTypeEnum.CUSTOM.code});

    public static WtcTimeRangeControlService getInstance() {
        return Instance.INSTANCE;
    }

    public void setApplyTimeTypeData(ApplyTimeTypeParam applyTimeTypeData, WtcTimeRangeArgsModel argsModel) {
        int stepInt;
        HRBaseServiceHelper serviceHelper;
        if (applyTimeTypeData == null || argsModel == null) {
            return;
        }
        String entity = applyTimeTypeData.getEntity();
        String applyTimeTypeField = applyTimeTypeData.getApplyTimeTypeField();
        String jumpStepField = applyTimeTypeData.getJumpStepField();
        String queryField = WTCStringUtils.joinOnComma((String[])new String[]{applyTimeTypeField, jumpStepField});
        Long typeId = applyTimeTypeData.getTypeId();
        long attFileBoId = applyTimeTypeData.getAttFileBoId();
        Date oriStartTime = applyTimeTypeData.getOriStartTime();
        Date oriEndTime = applyTimeTypeData.getOriEndTime();
        WtcTimeRangeBtnTypeEnum oriStartBtnTypeEnum = applyTimeTypeData.getOriStartBtnTypeEnum();
        WtcTimeRangeBtnTypeEnum oriEndBtnTypeEnum = applyTimeTypeData.getOriEndBtnTypeEnum();
        String disableTip = applyTimeTypeData.getDisableTip();
        argsModel.setDisableTip(disableTip);
        argsModel.setDisabledCustomControl(typeId == null || typeId == 0L);
        if (argsModel.isDisabledCustomControl()) {
            return;
        }
        if (HRStringUtils.isEmpty((String)entity) || HRStringUtils.isEmpty((String)applyTimeTypeField) || HRStringUtils.isEmpty((String)jumpStepField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u4e0e\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"BillTimeRangeControlService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        String typeIdStr = typeId == null ? "" : typeId + "";
        argsModel.setTypeId(typeIdStr);
        ArrayList<String> timeApplyType = new ArrayList<String>(10);
        DynamicObject typeDy = null;
        if (typeId != null && (typeDy = (serviceHelper = new HRBaseServiceHelper(entity)).queryOne(queryField, (Object)typeId)) != null && HRStringUtils.isNotEmpty((String)typeDy.getString(applyTimeTypeField))) {
            String[] applyTimeTypes;
            for (String applyTimeType : applyTimeTypes = typeDy.getString(applyTimeTypeField).split(",")) {
                if (!HRStringUtils.isNotEmpty((String)applyTimeType)) continue;
                timeApplyType.add(applyTimeType);
            }
        }
        List<Integer> rangeBtn = new ArrayList<Integer>(10);
        if (WTCCollections.isNotEmpty(timeApplyType)) {
            for (String ap : timeApplyType) {
                rangeBtn.addAll(WtcTimeRangeBtnTypeEnum.getValByApplyTimeTypeEnum((ApplicationTypeEnum)ApplicationTypeEnum.getEnumByKey((String)ap)));
            }
            rangeBtn = this.sortApplyTimeTypeOrder(rangeBtn);
            argsModel.setApplyTimeType(rangeBtn);
        }
        int startCode = WtcTimeRangeBtnTypeEnum.DAY.code;
        int endBtnCode = WtcTimeRangeBtnTypeEnum.DAY.code;
        if (oriStartBtnTypeEnum != null) {
            startCode = oriStartBtnTypeEnum.code;
            argsModel.setOriStartMethod(oriStartBtnTypeEnum.code);
        }
        if (oriEndBtnTypeEnum != null) {
            endBtnCode = oriEndBtnTypeEnum.code;
            argsModel.setOriEndMethod(oriEndBtnTypeEnum.code);
        }
        argsModel.setStartMethod(startCode);
        argsModel.setEndMethod(endBtnCode);
        if (WTCCollections.isNotEmpty(rangeBtn)) {
            argsModel.setStartMethod(this.handleMethod(rangeBtn, startCode, START_METHOD_ORDER).intValue());
            argsModel.setEndMethod(this.handleMethod(rangeBtn, endBtnCode, END_METHOD_ORDER).intValue());
        } else {
            argsModel.setDisabledCustomControl(true);
        }
        Date defaultStart = oriStartTime == null ? new Date() : oriStartTime;
        Date defaultEnd = oriEndTime == null ? new Date() : oriEndTime;
        argsModel.setDefaultStartTime(WTCDateUtils.getDayStart((Date)defaultStart));
        argsModel.setDefaultEndTime(WTCDateUtils.getDayStart((Date)defaultEnd));
        if (argsModel.getStartMethod() == WtcTimeRangeBtnTypeEnum.CUSTOM.code) {
            Tuples.Tuple2<Date, Date> starAndEndByShift = this.getStarAndEndByShift(oriStartTime, oriEndTime, attFileBoId);
            Date setStart = (Date)starAndEndByShift.item1;
            Date setEnd = (Date)starAndEndByShift.item2;
            if (applyTimeTypeData.getOriStartBtnTypeEnum() == WtcTimeRangeBtnTypeEnum.CUSTOM) {
                setStart = oriStartTime == null ? (Date)starAndEndByShift.item1 : oriStartTime;
                setEnd = oriEndTime == null ? (Date)starAndEndByShift.item2 : oriEndTime;
            }
            argsModel.setDefaultStartTime(setStart);
            argsModel.setDefaultEndTime(setEnd);
        }
        int step = 1;
        if (argsModel.getApplyTimeType() != null && argsModel.getApplyTimeType().contains(WtcTimeRangeBtnTypeEnum.CUSTOM.code) && typeDy != null && HRStringUtils.isNotEmpty((String)applyTimeTypeData.getJumpStepField()) && (stepInt = typeDy.getInt(applyTimeTypeData.getJumpStepField())) >= 1 && stepInt <= 60) {
            step = stepInt;
        }
        argsModel.setMinuteStep(step);
    }

    private Integer handleMethod(List<Integer> rangeBtn, Integer oriMethod, List<Integer> defaultOrder) {
        if (oriMethod == null || WTCCollections.isEmpty(rangeBtn)) {
            return WtcTimeRangeBtnTypeEnum.DAY.code;
        }
        if (rangeBtn.contains(oriMethod)) {
            return oriMethod;
        }
        for (Integer method : defaultOrder) {
            if (!rangeBtn.contains(method)) continue;
            return method;
        }
        return WtcTimeRangeBtnTypeEnum.DAY.code;
    }

    private List<Integer> sortApplyTimeTypeOrder(List<Integer> btnEnumVal) {
        if (WTCCollections.isEmpty(btnEnumVal)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> resultByOrder = new ArrayList<Integer>(10);
        for (Integer orderVal : START_METHOD_ORDER) {
            if (!btnEnumVal.contains(orderVal)) continue;
            resultByOrder.add(orderVal);
        }
        return resultByOrder;
    }

    private Tuples.Tuple2<Date, Date> getStarAndEndByShift(Date oriStartTime, Date oriEndTime, long attFileBoId) {
        List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime;
        Date today = new Date();
        if (oriStartTime == null || oriEndTime == null) {
            oriStartTime = today;
            oriEndTime = today;
        }
        Date startTime = WTCDateUtils.getDayStart((Date)oriStartTime);
        Date endTime = WTCDateUtils.getDayEnd((Date)oriEndTime);
        DutyShiftResponse shift = ApplyUtil.getShift(Lists.newArrayList((Object[])new Long[]{attFileBoId}), startTime, endTime);
        if (shift == null) {
            return new Tuples.Tuple2((Object)WTCDateUtils.getDayStart((Date)oriStartTime), (Object)WTCDateUtils.getDayEnd((Date)today));
        }
        Date resultStart = WTCDateUtils.getDayStart((Date)oriStartTime);
        Date resultEnd = WTCDateUtils.getDayStart((Date)oriEndTime);
        Optional dutyShiftStart = shift.getDutyShift(Long.valueOf(attFileBoId), resultStart);
        Optional shiftStart = shift.getCurrShiftHis(Long.valueOf(attFileBoId), resultStart);
        Optional dutyShiftEnd = shift.getDutyShift(Long.valueOf(attFileBoId), resultEnd);
        Optional shiftEnd = shift.getCurrShiftHis(Long.valueOf(attFileBoId), resultEnd);
        if (dutyShiftStart.isPresent() && shiftStart.isPresent() && WTCCollections.isNotEmpty(shiftDetailAbsoluteTime = ApplyUtil.getShiftDetailAbsoluteTime((DutyShift)dutyShiftStart.get(), (Shift)shiftStart.get())) && shiftDetailAbsoluteTime.get((int)0).item2 != null) {
            startTime = (Date)shiftDetailAbsoluteTime.get((int)0).item2;
        }
        if (dutyShiftEnd.isPresent() && shiftEnd.isPresent() && WTCCollections.isNotEmpty(shiftDetailAbsoluteTime = ApplyUtil.getShiftDetailAbsoluteTime((DutyShift)dutyShiftEnd.get(), (Shift)shiftEnd.get())) && shiftDetailAbsoluteTime.get((int)(shiftDetailAbsoluteTime.size() - 1)).item3 != null) {
            endTime = (Date)shiftDetailAbsoluteTime.get((int)(shiftDetailAbsoluteTime.size() - 1)).item3;
        }
        return new Tuples.Tuple2((Object)startTime, (Object)endTime);
    }

    public String getDisableTip(String billName) {
        String tip = ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199{0}\u7c7b\u578b\u3002", (String)"BillTimeRangeControlService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        return MessageFormat.format(tip, billName);
    }

    public Tuples.Tuple2<Boolean, String> passCheckTime(DynamicObject checkDy, ApplyBillCheckEnum applyBillCheckEnum, String billName) {
        if (checkDy == null || applyBillCheckEnum == null) {
            return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
        }
        String startMethod = checkDy.getString(applyBillCheckEnum.getStartMethod());
        String endMethod = checkDy.getString(applyBillCheckEnum.getEndMethod());
        if (HRStringUtils.isEmpty((String)startMethod) || HRStringUtils.isEmpty((String)endMethod)) {
            return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
        }
        Date start = checkDy.getDate(applyBillCheckEnum.getStartDate());
        Date end = checkDy.getDate(applyBillCheckEnum.getEndDate());
        if (start == null || end == null) {
            return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
        }
        if (start.after(end)) {
            String tip = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"WtcTimeRangeControlService_6", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)tip);
        }
        if (WtcTimeRangeBtnTypeEnum.DAY.value.equals(startMethod)) {
            if (!WtcTimeRangeBtnTypeEnum.DAY.value.equals(endMethod)) {
                String tip = ResManager.loadKDString((String)"\u201c{0}\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201d\u7b49\u4e8e\u5168\u5929\u65f6\uff0c\u201c{1}\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u53ea\u53ef\u7b49\u4e8e\u5168\u5929\u3002", (String)"WtcTimeRangeControlService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)MessageFormat.format(tip, billName, billName));
            }
        } else {
            boolean endMethodIsNotHalf;
            boolean bl = endMethodIsNotHalf = !WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(endMethod) && !WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(endMethod);
            if (WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(startMethod)) {
                if (endMethodIsNotHalf) {
                    String tip = ResManager.loadKDString((String)"{0}\u201c\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201d\u7b49\u4e8e\u4e0a\u534a\u5929\u65f6\uff0c\u201c{1}\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u53ea\u53ef\u7b49\u4e8e\u4e0a\u534a\u5929/\u4e0b\u534a\u5929\u3002", (String)"WtcTimeRangeControlService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)MessageFormat.format(tip, billName, billName));
                }
            } else if (WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(startMethod)) {
                if (WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(endMethod)) {
                    Date startZero = WTCDateUtils.getZeroDate((Date)start);
                    Date endZero = WTCDateUtils.getZeroDate((Date)end);
                    if (startZero.getTime() >= endZero.getTime()) {
                        String tip = ResManager.loadKDString((String)"\u201c{0}\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201d\u7b49\u4e8e\u4e0b\u534a\u5929\u65f6\uff0c\u82e5{1}\u4e0d\u8de8\u5929\uff0c\u5219\u201c{2}\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u53ea\u53ef\u7b49\u4e8e\u4e0b\u534a\u5929\u3002", (String)"WtcTimeRangeControlService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                        return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)MessageFormat.format(tip, billName, billName, billName));
                    }
                } else if (endMethodIsNotHalf) {
                    String tip = ResManager.loadKDString((String)"\u201c{0}\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201d\u7b49\u4e8e\u4e0b\u534a\u5929\u65f6\uff0c\u82e5{1}\u8de8\u5929\uff0c\u5219\u201c{2}\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u53ea\u53ef\u7b49\u4e8e\u4e0a\u534a\u5929/\u4e0b\u534a\u5929\u3002", (String)"WtcTimeRangeControlService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)MessageFormat.format(tip, billName, billName, billName));
                }
            } else if (WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(startMethod) && !WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(endMethod)) {
                String tip = ResManager.loadKDString((String)"\u201c{0}\u65b9\u5f0f\uff08\u5f00\u59cb\uff09\u201d\u7b49\u4e8e\u65f6\u5206\uff0c\u201c{1}\u65b9\u5f0f\uff08\u7ed3\u675f\uff09\u201d\u53ea\u53ef\u7b49\u4e8e\u65f6\u5206\u3002", (String)"WtcTimeRangeControlService_5", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)MessageFormat.format(tip, billName, billName));
            }
        }
        return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
    }

    private static class Instance {
        private static WtcTimeRangeControlService INSTANCE = new WtcTimeRangeControlService();

        private Instance() {
        }
    }
}

