/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill.batchbill;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BatchBillUnifyService {
    private static final Log LOG = LogFactory.getLog(BatchBillUnifyService.class);
    private static BatchBillUnifyService INSTANCE = new BatchBillUnifyService();
    private static final Map<String, List<String>> BILLSTATUSBUTTON = new HashMap<String, List<String>>(16);
    private static final List<String> ALLBUTTON = Lists.newArrayList((Object[])new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_unsubmit2", "bar_submiteffect", "bar_discard", "bar_del", "bar_change"});
    private static final Map<String, String> changeEntityMap;

    public static BatchBillUnifyService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BatchBillUnifyService();
        }
        return INSTANCE;
    }

    public void customBatchBillButton(IFormView view) {
        if (view == null) {
            return;
        }
        BillShowParameter showParameter = (BillShowParameter)view.getFormShowParameter();
        if (showParameter.getBillStatus() == BillOperationStatus.ADDNEW || showParameter.getStatus() == OperationStatus.ADDNEW) {
            List<String> addNewButtons = BILLSTATUSBUTTON.get("new");
            this.setButtonVisible(view, addNewButtons);
            return;
        }
        BillUnifyService.commonHandleViewFlowChar(view);
        DynamicObject dataEntity = view.getModel().getDataEntity();
        long createUserId = WTCDynamicObjectUtils.getBaseDataId(dataEntity, "creator");
        long currUserId = RequestContext.get().getCurrUserId();
        if (createUserId != currUserId) {
            this.setButtonVisible(view, Lists.newArrayList());
            return;
        }
        String billStatus = dataEntity.getString("billstatus");
        List<String> billStatusButtons = BILLSTATUSBUTTON.get(billStatus);
        this.setButtonVisible(view, billStatusButtons);
    }

    private void setButtonVisible(IFormView view, List<String> visibleButtons) {
        List<String> notVisibleButtons = ALLBUTTON.stream().filter(item -> !visibleButtons.contains(item)).collect(Collectors.toList());
        view.setVisible(Boolean.TRUE, visibleButtons.toArray(new String[0]));
        if (WTCCollections.isNotEmpty(notVisibleButtons)) {
            view.setVisible(Boolean.FALSE, notVisibleButtons.toArray(new String[0]));
        }
    }

    public void openAddChangeBill(IFormView view, DynamicObject billDyn, String formId) {
        String changeBillEntity = changeEntityMap.get(formId);
        if (WTCStringUtils.isNotEmpty((String)changeBillEntity)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(changeBillEntity);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            billShowParameter.setCustomParam("parent", (Object)String.valueOf(billDyn.getLong("id")));
            billShowParameter.setCustomParam("ischangebill", (Object)"1");
            billShowParameter.setCustomParam("billopenfrom", view.getFormShowParameter().getCustomParam("billopenfrom"));
            view.showForm((FormShowParameter)billShowParameter);
        }
    }

    public void loadHisBill(IFormView formView, DynamicObject dy, String entityNumber, boolean isList) {
        if (dy == null || formView == null || WTCStringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        long originalId = dy.getLong("originalid");
        long parentId = dy.getLong("parent");
        if (originalId == 0L || parentId == 0L) {
            return;
        }
        DynamicObject[] bills = HRBaseServiceHelper.create((String)entityNumber).query("id,parent,islatestbill,originalid", new QFilter("originalid", "=", (Object)originalId).toArray());
        ArrayList<Long> billIds = new ArrayList<Long>();
        this.findHisBillId(bills, dy.getLong("id"), parentId, billIds);
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        QFilter filter = new QFilter("id", "in", billIds);
        fParameter.setFilter(filter);
        lsp.setBillFormId(entityNumber);
        lsp.setListFilterParameter(fParameter);
        lsp.setHasRight(true);
        if (isList) {
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setFormId("wtbs_listborderless");
            OpenStyle openStyle = lsp.getOpenStyle();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1050px");
            styleCss.setHeight("400px");
            openStyle.setInlineStyleCss(styleCss);
        } else {
            lsp.getOpenStyle().setShowType(ShowType.InContainer);
            lsp.setFormId("wtbs_rimlesslist");
            lsp.getOpenStyle().setTargetKey("flexformhis");
            lsp.setCustomParam("billno", (Object)dy.getString("billno"));
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            lsp.setCustomParam("wtcbill_hasright", formShowParameter.getCustomParam("wtcbill_hasright"));
        }
        formView.showForm((FormShowParameter)lsp);
    }

    private void findHisBillId(DynamicObject[] bills, long billId, long parentId, List<Long> result) {
        Map<Long, DynamicObject> billMap = Arrays.stream(bills).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        this.findParent(billMap, parentId, result);
        result.add(billId);
    }

    private void findParent(Map<Long, DynamicObject> billMap, long parentId, List<Long> result) {
        DynamicObject parentDy = billMap.get(parentId);
        if (parentDy != null) {
            result.add(parentId);
            if (!Objects.equals(parentDy.getLong("id"), parentDy.getLong("originalid"))) {
                this.findParent(billMap, parentDy.getLong("parent"), result);
            }
        }
    }

    private void findChild(Map<Long, List<DynamicObject>> childMap, long billId, List<Long> result) {
        List<DynamicObject> childDy = childMap.get(billId);
        if (WTCCollections.isNotEmpty(childDy)) {
            for (DynamicObject child : childDy) {
                long childBillId = child.getLong("id");
                result.add(childBillId);
                this.findChild(childMap, childBillId, result);
            }
        }
    }

    public String handleBatchBillFailMsg(DynamicObject billDy, String failMsg, String perMsg) {
        if (billDy != null) {
            DynamicObject attFileDy = billDy.getDynamicObject("attfilebasef7");
            Tuple<String, String> attFileNameNumber = this.getAttFileNameNumber(attFileDy);
            failMsg = MessageFormat.format(perMsg, attFileNameNumber.getKey(), attFileNameNumber.getValue()) + failMsg;
        }
        return failMsg;
    }

    public Tuple<String, String> getAttFileNameNumber(DynamicObject attFileDy) {
        if (attFileDy != null) {
            String number = attFileDy.getString("number");
            String name = attFileDy.getString("textname");
            return new Tuple((Object)name, (Object)number);
        }
        return new Tuple((Object)"", (Object)"");
    }

    public FormShowParameter getBatchBillCheckResultForm(Object opSource, OperationResult operationResult, IPageCache pageCache, int totalCount) {
        String notCheckBizAllFail;
        FormOperate formOperate;
        OperateOption option;
        List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
        if (WTCCollections.isEmpty((Collection)allErrorInfo)) {
            return null;
        }
        if (opSource instanceof FormOperate && (option = (formOperate = (FormOperate)opSource).getOption()).containsVariable("not_check_biz_allfail") && "1".equals(notCheckBizAllFail = option.getVariableValue("not_check_biz_allfail"))) {
            return null;
        }
        int errorSize = allErrorInfo.size();
        ArrayList<String> errorMsg = new ArrayList<String>(allErrorInfo.size());
        for (int index = 0; index < 5 && index < errorSize; ++index) {
            errorMsg.add(((IOperateInfo)allErrorInfo.get(index)).getMessage());
        }
        DataEntitySerializerOption option2 = new DataEntitySerializerOption();
        option2.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option2);
        pageCache.put("operationresult", serialResult);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtbs_operationresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int successCount = totalCount - errorSize;
        String title = BatchBillKDString.checkResultTip((int)successCount, (int)errorSize);
        showParameter.setCustomParam("title", (Object)title);
        showParameter.setCustomParam("errorMsg", errorMsg);
        showParameter.setCustomParam("hasMore", (Object)(errorSize > 5 ? 1 : 0));
        showParameter.setCustomParam("message", (Object)"");
        return showParameter;
    }

    public int batchVaDateRange() {
        String maxDateRangeStr = SystemParamQueryUtil.getAppCustomParameter((String)"batchbill_va_maxdaterange");
        int maxDateRange = 60;
        if (HRStringUtils.isNotEmpty((String)maxDateRangeStr)) {
            try {
                maxDateRange = Integer.parseInt(maxDateRangeStr);
            }
            catch (Exception ex) {
                LOG.warn("BatchBillUnifyService.batchVaDateRange maxDateRangeStr error", (Throwable)ex);
            }
        }
        return maxDateRange;
    }

    public int batchVaMaxEntry() {
        String maxEntryStr = SystemParamQueryUtil.getAppCustomParameter((String)"batchbill_va_maxentry");
        int maxEntry = 1000;
        if (HRStringUtils.isNotEmpty((String)maxEntryStr)) {
            try {
                maxEntry = Integer.parseInt(maxEntryStr);
            }
            catch (Exception ex) {
                LOG.warn("BatchBillUnifyService.batchVaMaxEntry maxEntryStr error", (Throwable)ex);
            }
        }
        return maxEntry;
    }

    public static boolean batchVaIsShowInList() {
        String shoInList = SystemParamQueryUtil.getAppCustomParameter((String)"batchbill_va_showinlist");
        boolean isShow = true;
        if (HRStringUtils.isNotEmpty((String)shoInList)) {
            isShow = "false".equals(shoInList) || "0".equals(shoInList);
        }
        LOG.info("BatchBillUnifyService.batchVaIsShowInList shoInList:{}", (Object)isShow);
        return isShow;
    }

    public static List<String> batchVaShowBillStatus() {
        String showBillStatus = SystemParamQueryUtil.getAppCustomParameter((String)"batchbill_va_showbillstatus");
        ArrayList billStatus = Lists.newArrayList((Object[])new String[]{"B", "D", "C"});
        if (HRStringUtils.isNotEmpty((String)showBillStatus)) {
            billStatus = Lists.newArrayList((Object[])showBillStatus.split(","));
        }
        LOG.info("BatchBillUnifyService.batchVaShowBillStatus billStatus:{}", (Object)showBillStatus);
        return billStatus;
    }

    public boolean isNeedCheck(DynamicObject vaBillDy, UnifyCallChainEnum callChainEnum) {
        if (vaBillDy.containsProperty("isnotleave") && vaBillDy.containsProperty("applytyperadio")) {
            boolean isNotVa = vaBillDy.getBoolean("isnotleave");
            String applyType = vaBillDy.getString("applytyperadio");
            LOG.info("BatchBillUnifyService.isNeedCheck isNotVa:{},applyType:{}", (Object)isNotVa, (Object)applyType);
            if ("2".equals(applyType)) {
                return !isNotVa;
            }
        }
        LOG.info("BatchBillUnifyService.isNeedCheck true");
        return true;
    }

    public List<ExtendedDataEntity> getSuccessDataEntities(ExtendedDataEntity[] dataEntities, List<ValidateResult> validateErrors) {
        HashSet pkSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                long pkValue = (Long)operateErrorInfo.getPkValue();
                pkSet.add(pkValue);
            }
        }
        if (dataEntities.length == pkSet.size()) {
            return new ArrayList<ExtendedDataEntity>(0);
        }
        ArrayList<ExtendedDataEntity> dynamicObjects = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (pkSet.contains(dataEntity.getDataEntity().getLong("id"))) continue;
            dynamicObjects.add(dataEntity);
        }
        return dynamicObjects;
    }

    public Tuple<QFilter, Boolean> addBatchVaShowFilter(Supplier<Boolean> isShowFunc, Supplier<List<String>> showBillStatusFunc) {
        boolean batchVaIsShowInList = isShowFunc.get();
        if (!batchVaIsShowInList) {
            QFilter filter = new QFilter("applytyperadio", "!=", (Object)"2");
            return new Tuple((Object)filter, (Object)false);
        }
        List<String> billStatus = showBillStatusFunc.get();
        QFilter batchQFilter = new QFilter("applytyperadio", "=", (Object)"2");
        QFilter filter = batchQFilter.and("billstatus", "in", billStatus);
        return new Tuple((Object)filter, (Object)true);
    }

    static {
        BILLSTATUSBUTTON.put("A", Lists.newArrayList((Object[])new String[]{"bar_save", "bar_submit", "bar_submiteffect", "bar_discard", "bar_del"}));
        BILLSTATUSBUTTON.put("B", Lists.newArrayList((Object[])new String[]{"bar_unsubmit2"}));
        BILLSTATUSBUTTON.put("D", Lists.newArrayList((Object[])new String[]{"bar_unsubmit2"}));
        BILLSTATUSBUTTON.put("C", Lists.newArrayList((Object[])new String[]{"bar_change"}));
        BILLSTATUSBUTTON.put("E", Lists.newArrayList());
        BILLSTATUSBUTTON.put("F", Lists.newArrayList());
        BILLSTATUSBUTTON.put("G", Lists.newArrayList((Object[])new String[]{"bar_save", "bar_submit", "bar_discard"}));
        BILLSTATUSBUTTON.put("new", Lists.newArrayList((Object[])new String[]{"bar_save", "bar_submit", "bar_submiteffect"}));
        changeEntityMap = new HashMap<String, String>();
        changeEntityMap.put("wtabm_batchvaapply", "wtabm_batchvaupdate");
        changeEntityMap.put("wtabm_batchvaupdate", "wtabm_batchvaupdate");
    }
}

