/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.bill.batchbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.batchbill.DataEntityPropInfo;
import kd.wtc.wtbs.common.util.WTCCollections;

public class BillPropertyHelper {
    private IDataModel targetModel;
    private DynamicObject targetDy;
    private DynamicObject sourceDy;
    private int selectToEditIndex;
    private int writeToIndex;
    private Map<String, String> propertyMap;

    public BillPropertyHelper(IDataModel targetModel, DynamicObject sourceDy) {
        this.targetModel = targetModel;
        this.targetDy = targetModel.getDataEntity();
        this.sourceDy = sourceDy;
        this.selectToEditIndex = -1;
        this.writeToIndex = -1;
    }

    public BillPropertyHelper(IDataModel targetModel, DynamicObject sourceDy, int selectToEditIndex) {
        this.targetModel = targetModel;
        this.targetDy = targetModel.getDataEntity();
        this.sourceDy = sourceDy;
        this.selectToEditIndex = selectToEditIndex;
        this.writeToIndex = -1;
    }

    public void setPropertyMap(Map<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public void setWriteToIndex(int writeToIndex) {
        this.writeToIndex = writeToIndex;
    }

    public void setModelDataValue() {
        ArrayList<DataEntityPropInfo> targetPropInfos = new ArrayList<DataEntityPropInfo>(16);
        this.collectProps(this.targetDy.getDataEntityType(), targetPropInfos);
        ArrayList<DataEntityPropInfo> sourcePropInfos = new ArrayList<DataEntityPropInfo>(16);
        this.collectProps(this.sourceDy.getDataEntityType(), sourcePropInfos);
        this.setValueRelationShip(targetPropInfos, sourcePropInfos);
        this.checkValueRelationShip(targetPropInfos);
        this.setBillModelValue(targetPropInfos);
    }

    private void setBillModelValue(List<DataEntityPropInfo> propInfos) {
        ArrayList<DataEntityPropInfo> modelProps = new ArrayList<DataEntityPropInfo>(propInfos.size());
        ArrayList<DataEntityPropInfo> entryProps = new ArrayList<DataEntityPropInfo>(propInfos.size());
        ArrayList<DataEntityPropInfo> subEntryProps = new ArrayList<DataEntityPropInfo>(propInfos.size());
        for (DataEntityPropInfo propInfo : propInfos) {
            if (!propInfo.isEntry() && !propInfo.isSubEntry()) {
                modelProps.add(propInfo);
                continue;
            }
            if (propInfo.isEntry()) {
                entryProps.add(propInfo);
                continue;
            }
            if (!propInfo.isSubEntry()) continue;
            subEntryProps.add(propInfo);
        }
        if (this.selectToEditIndex >= 0) {
            this.setModelValueIndex(modelProps);
            this.setEntryValueIndex(entryProps);
            this.setSubEntryIndex(subEntryProps);
        } else {
            this.setModelValue(modelProps);
            this.setEntryValue(entryProps);
            this.setSubEntry(subEntryProps);
        }
    }

    private void setModelValueIndex(List<DataEntityPropInfo> modelProps) {
        for (DataEntityPropInfo propInfo : modelProps) {
            DynamicObject entryDy;
            DynamicObjectCollection entryColl;
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null) continue;
            if (!valueProp.isEntry() && !valueProp.isSubEntry()) {
                this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()));
                continue;
            }
            if (this.selectToEditIndex < 0) continue;
            if (valueProp.isEntry()) {
                entryColl = this.sourceDy.getDynamicObjectCollection(valueProp.getParent());
                entryDy = (DynamicObject)entryColl.get(this.selectToEditIndex);
                this.targetModel.setValue(propInfo.getPropName(), entryDy.get(valueProp.getPropName()));
                continue;
            }
            if (!valueProp.isSubEntry()) continue;
            entryColl = this.sourceDy.getDynamicObjectCollection(valueProp.getParentParent());
            entryDy = (DynamicObject)entryColl.get(this.selectToEditIndex);
            DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection(valueProp.getParent());
            this.targetModel.setValue(propInfo.getPropName(), ((DynamicObject)subEntryColl.get(0)).get(valueProp.getPropName()));
        }
    }

    private void setEntryValueIndex(List<DataEntityPropInfo> entryProps) {
        entryProps.removeIf(item -> item.getValueProp() == null || !item.getValueProp().isEntry() && !item.getValueProp().isSubEntry());
        if (WTCCollections.isEmpty(entryProps)) {
            return;
        }
        Optional<DataEntityPropInfo> any = entryProps.stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getParent())).findAny();
        if (!any.isPresent()) {
            return;
        }
        this.targetModel.createNewEntryRow(any.get().getParent());
        for (DataEntityPropInfo propInfo : entryProps) {
            DynamicObjectCollection entryColl;
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null) continue;
            if (valueProp.isEntry()) {
                entryColl = this.sourceDy.getDynamicObjectCollection(valueProp.getParent());
                this.targetModel.setValue(propInfo.getPropName(), ((DynamicObject)entryColl.get(this.selectToEditIndex)).get(valueProp.getPropName()), 0);
                continue;
            }
            if (!valueProp.isSubEntry()) continue;
            entryColl = this.sourceDy.getDynamicObjectCollection(valueProp.getParentParent());
            DynamicObject entryDy = (DynamicObject)entryColl.get(this.selectToEditIndex);
            DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection(valueProp.getParent());
            this.targetModel.setValue(propInfo.getPropName(), ((DynamicObject)subEntryColl.get(0)).get(valueProp.getPropName()), 0);
        }
    }

    private void setSubEntryIndex(List<DataEntityPropInfo> subEntryProps) {
        subEntryProps.removeIf(item -> item.getValueProp() == null || !item.getValueProp().isSubEntry());
        if (WTCCollections.isEmpty(subEntryProps) || this.selectToEditIndex < 0) {
            return;
        }
        DataEntityPropInfo propInfo0 = subEntryProps.get(0);
        DataEntityPropInfo valueProp0 = propInfo0.getValueProp();
        this.targetModel.setEntryCurrentRowIndex(propInfo0.getParentParent(), 0);
        DynamicObjectCollection entryColl = this.sourceDy.getDynamicObjectCollection(valueProp0.getParentParent());
        DynamicObject entryDy = (DynamicObject)entryColl.get(this.selectToEditIndex);
        DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection(valueProp0.getParent());
        this.targetModel.batchCreateNewEntryRow(propInfo0.getParent(), subEntryColl.size());
        for (DataEntityPropInfo propInfo : subEntryProps) {
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null) continue;
            for (int index = 0; index < subEntryColl.size(); ++index) {
                DynamicObject valueEntry = (DynamicObject)subEntryColl.get(index);
                if (!valueProp.isSubEntry()) continue;
                this.targetModel.setValue(propInfo.getPropName(), valueEntry.get(valueProp.getPropName()), index, 0);
            }
        }
    }

    private void setModelValue(List<DataEntityPropInfo> modelProps) {
        for (DataEntityPropInfo propInfo : modelProps) {
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null || valueProp.isEntry() || valueProp.isSubEntry()) continue;
            this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()));
        }
    }

    private void setEntryValue(List<DataEntityPropInfo> entryProps) {
        int startIndex;
        if (WTCCollections.isEmpty(entryProps)) {
            return;
        }
        List<DataEntityPropInfo> fromEntryProps = entryProps.stream().filter(item -> item.getValueProp() != null && item.getValueProp().isEntry()).collect(Collectors.toList());
        boolean isCreatedRow = this.setEntryFromEntry(fromEntryProps);
        int valueEntrySize = 0;
        if (!isCreatedRow && this.writeToIndex < 0) {
            startIndex = this.targetModel.getEntryRowCount(entryProps.get(0).getParent());
            this.targetModel.createNewEntryRow(entryProps.get(0).getParent());
        } else {
            valueEntrySize = this.sourceDy.getDynamicObjectCollection(fromEntryProps.get(0).getParent()).size();
            int modelEntrySize = this.targetModel.getEntryRowCount(entryProps.get(0).getParent());
            startIndex = modelEntrySize - valueEntrySize;
        }
        for (DataEntityPropInfo propInfo : entryProps) {
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null || valueProp.isEntry() || valueProp.isSubEntry()) continue;
            if (this.writeToIndex < 0) {
                if (!isCreatedRow) {
                    this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()), startIndex);
                    continue;
                }
                for (int index = 0; index < valueEntrySize; ++index) {
                    this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()), startIndex + index);
                }
                continue;
            }
            this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()), this.writeToIndex);
        }
    }

    private boolean setEntryFromEntry(List<DataEntityPropInfo> fromEntryProps) {
        if (WTCCollections.isEmpty(fromEntryProps)) {
            return false;
        }
        boolean isCreatedRow = false;
        int entrySize = 0;
        for (DataEntityPropInfo propInfo : fromEntryProps) {
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null || !valueProp.isEntry()) continue;
            DynamicObjectCollection valueEntryEntity = this.sourceDy.getDynamicObjectCollection(valueProp.getParent());
            DynamicObjectCollection billEntryEntity = this.targetModel.getEntryEntity(propInfo.getParent());
            if (!isCreatedRow && this.writeToIndex < 0) {
                entrySize = billEntryEntity.size();
                this.targetModel.batchCreateNewEntryRow(propInfo.getParent(), valueEntryEntity.size());
                isCreatedRow = true;
            }
            if (this.writeToIndex < 0) {
                for (int index = 0; index < valueEntryEntity.size(); ++index) {
                    this.targetModel.setValue(propInfo.getPropName(), ((DynamicObject)valueEntryEntity.get(index)).get(valueProp.getPropName()), entrySize + index);
                }
                continue;
            }
            this.targetModel.setValue(propInfo.getPropName(), ((DynamicObject)valueEntryEntity.get(0)).get(valueProp.getPropName()), this.writeToIndex);
        }
        return isCreatedRow;
    }

    private void setSubEntry(List<DataEntityPropInfo> subEntryProps) {
        if (WTCCollections.isEmpty(subEntryProps)) {
            return;
        }
        int entrySize = this.targetModel.getEntryEntity("entryentity").size();
        DynamicObjectCollection valueEntryEntity = this.sourceDy.getDynamicObjectCollection("entryentity");
        int valueEntrySize = valueEntryEntity.size();
        int startSize = entrySize - valueEntrySize;
        List<DataEntityPropInfo> fromSubEntryProps = subEntryProps.stream().filter(item -> item.getValueProp() != null && item.getValueProp().isSubEntry()).collect(Collectors.toList());
        boolean isCreatedRow = this.setSubEntryFromSubEntry(fromSubEntryProps);
        if (!isCreatedRow && this.writeToIndex < 0) {
            DataEntityPropInfo propInfo = subEntryProps.get(0);
            for (int index = 0; index < valueEntryEntity.size(); ++index) {
                this.targetModel.setEntryCurrentRowIndex(propInfo.getParentParent(), startSize + index);
                this.targetModel.createNewEntryRow(propInfo.getParent());
            }
        }
        for (DataEntityPropInfo propInfo : subEntryProps) {
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null) continue;
            if (this.writeToIndex < 0) {
                for (int index = 0; index < valueEntryEntity.size(); ++index) {
                    this.targetModel.setEntryCurrentRowIndex(propInfo.getParentParent(), startSize + index);
                    DynamicObject valueEntry = (DynamicObject)valueEntryEntity.get(index);
                    int subEntrySize = 0;
                    if (!isCreatedRow) {
                        if (!valueProp.isEntry() && !valueProp.isSubEntry()) {
                            this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()), 0, startSize + index);
                            continue;
                        }
                        if (!valueProp.isEntry()) continue;
                        this.targetModel.setValue(propInfo.getPropName(), valueEntry.get(valueProp.getPropName()), 0, startSize + index);
                        continue;
                    }
                    DynamicObjectCollection valueSubEntry = valueEntry.getDynamicObjectCollection(fromSubEntryProps.size());
                    subEntrySize = valueSubEntry.size();
                    for (int ii = 0; ii < subEntrySize; ++ii) {
                        if (!valueProp.isEntry() && !valueProp.isSubEntry()) {
                            this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()), ii, startSize + index);
                            continue;
                        }
                        if (!valueProp.isEntry()) continue;
                        this.targetModel.setValue(propInfo.getPropName(), valueEntry.get(valueProp.getPropName()), ii, startSize + index);
                    }
                }
                continue;
            }
            if (!valueProp.isEntry() && !valueProp.isSubEntry()) {
                this.targetModel.setValue(propInfo.getPropName(), this.sourceDy.get(valueProp.getPropName()), 0, this.writeToIndex);
                continue;
            }
            if (!valueProp.isEntry()) continue;
            this.targetModel.setValue(propInfo.getPropName(), ((DynamicObject)valueEntryEntity.get(0)).get(valueProp.getPropName()), 0, this.writeToIndex);
        }
    }

    private boolean setSubEntryFromSubEntry(List<DataEntityPropInfo> fromSubEntryProps) {
        if (WTCCollections.isEmpty(fromSubEntryProps)) {
            return false;
        }
        int entrySize = this.targetModel.getEntryEntity("entryentity").size();
        DynamicObjectCollection valueEntryEntity = this.sourceDy.getDynamicObjectCollection("entryentity");
        int valueEntrySize = valueEntryEntity.size();
        int startSize = entrySize - valueEntrySize;
        for (DataEntityPropInfo propInfo : fromSubEntryProps) {
            DataEntityPropInfo valueProp = propInfo.getValueProp();
            if (valueProp == null || !valueProp.isSubEntry()) continue;
            boolean isCreatedRow = false;
            for (int index = 0; index < valueEntryEntity.size(); ++index) {
                this.targetModel.setEntryCurrentRowIndex("entryentity", startSize + index);
                DynamicObject valueEntry = (DynamicObject)valueEntryEntity.get(index);
                DynamicObjectCollection valueSubEntry = valueEntry.getDynamicObjectCollection(valueProp.getParent());
                int subEntrySize = valueSubEntry.size();
                if (!isCreatedRow) {
                    this.targetModel.batchCreateNewEntryRow(propInfo.getParent(), subEntrySize);
                    isCreatedRow = true;
                }
                if (this.writeToIndex < 0) {
                    for (int ii = 0; ii < subEntrySize; ++ii) {
                        this.targetModel.setValue(propInfo.getParent(), ((DynamicObject)valueSubEntry.get(ii)).get(valueProp.getPropName()), ii, startSize + index);
                    }
                    continue;
                }
                this.targetModel.setValue(propInfo.getParent(), ((DynamicObject)valueSubEntry.get(0)).get(valueProp.getPropName()), 0, this.writeToIndex);
            }
        }
        return true;
    }

    private void collectProps(IDataEntityType dataEntityType, List<DataEntityPropInfo> propInfos) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                this.collectProps(((EntryProp)property).getItemType(), propInfos);
                continue;
            }
            if (property.getName().equals("id") || property.getName().equals("seq") || property.getName().endsWith("_id")) continue;
            DataEntityPropInfo propInfo = new DataEntityPropInfo();
            propInfo.setParent(property.getParent().getName());
            propInfo.setPropName(property.getName());
            propInfo.setEntry(property.getParent() instanceof EntryType && !(property.getParent() instanceof SubEntryType));
            propInfo.setSubEntry(property.getParent() instanceof SubEntryType);
            if (propInfo.isSubEntry()) {
                propInfo.setParentParent(property.getParent().getParent().getName());
            }
            propInfos.add(propInfo);
        }
    }

    private void setValueRelationShip(List<DataEntityPropInfo> propInfos, List<DataEntityPropInfo> valuePropInfos) {
        block0: for (DataEntityPropInfo propInfo : propInfos) {
            for (DataEntityPropInfo valuePropInfo : valuePropInfos) {
                if (valuePropInfo.getPropName().contains("_kxt") && propInfo.getPropName().startsWith(valuePropInfo.getPropName())) {
                    propInfo.setValueProp(valuePropInfo);
                    continue block0;
                }
                String propName = propInfo.getPropName();
                String sourcePropName = this.propertyMap.get(propName);
                if (!HRStringUtils.isNotEmpty((String)sourcePropName) || !valuePropInfo.getPropName().equals(sourcePropName)) continue;
                propInfo.setValueProp(valuePropInfo);
                continue block0;
            }
        }
    }

    private void checkValueRelationShip(List<DataEntityPropInfo> propInfos) {
        propInfos.removeIf(item -> item.getValueProp() == null);
    }
}

