/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.calreport;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.report.calreport.TieReportLevel;

public class CalReportParaHolder {
    private DynamicObject reportParaDy;

    public CalReportParaHolder(String category) {
        this.init(category);
    }

    private void init(String category) {
        this.reportParaDy = this.getReportParaDy(category);
    }

    private DynamicObject getReportParaDy(String category) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskpara");
        QFilter qFilter = new QFilter("category", "=", (Object)category);
        return serviceHelper.queryOne("genreport,costsort,level,linelimit,concurrencyctrl,timeout,retrytimes", new QFilter[]{qFilter});
    }

    public boolean isDisable() {
        return !this.isEnable();
    }

    public boolean isEnable() {
        DynamicObject reportPara = this.reportParaDy;
        if (null == reportPara) {
            return false;
        }
        return reportPara.getBoolean("genreport");
    }

    public boolean isEnableTaskConcurrencyCtrl() {
        DynamicObject reportPara = this.reportParaDy;
        if (null == reportPara) {
            return true;
        }
        return reportPara.getBoolean("concurrencyctrl");
    }

    public boolean isSort() {
        DynamicObject reportPara = this.reportParaDy;
        if (null == reportPara) {
            return false;
        }
        return reportPara.getBoolean("costsort");
    }

    public int getReportLineLimit() {
        DynamicObject reportPara = this.reportParaDy;
        if (null == reportPara) {
            return 100;
        }
        return reportPara.getInt("linelimit");
    }

    public int getTimeOut() {
        DynamicObject reportPara = this.reportParaDy;
        if (null == reportPara) {
            return 5;
        }
        int timeout = reportPara.getInt("timeout");
        if (timeout <= 0) {
            timeout = 5;
        }
        return timeout;
    }

    public int getRetryTimes() {
        DynamicObject reportPara = this.reportParaDy;
        if (null == reportPara) {
            return 3;
        }
        int retryTimes = reportPara.getInt("retrytimes");
        if (retryTimes <= 0) {
            retryTimes = 3;
        }
        return retryTimes;
    }

    public boolean isDebug() {
        return this.getLevel() == TieReportLevel.DEBUG;
    }

    public TieReportLevel getLevel() {
        DynamicObject reportPara = this.reportParaDy;
        String level = null == reportPara ? "info" : reportPara.getString("level");
        return TieReportLevel.of(level);
    }
}

