/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.caltask.converter;

import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.tie.TieCalTaskDetail;
import kd.wtc.wtbs.business.caltask.common.tie.TieDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.converter.std.WTCTaskConverterStd;

public class QTTieTaskConverter
extends WTCTaskConverterStd {
    @Override
    public WTCCalTaskDetailEntity generateTaskDetail() {
        return new TieCalTaskDetail();
    }

    @Override
    public void afterTransferTaskDetailDynAttribute(WTCCalTaskDetailEntity taskDetail, DynamicObject taskDetailDyn) {
        this.setDynTieStatus(taskDetail, taskDetailDyn);
    }

    @Override
    public void afterTransferTaskDetailDynInfoAttribute(WTCCalTaskDetailEntity taskDetail, DynamicObject taskDetailDyn) {
        this.setDynTieStatus(taskDetail, taskDetailDyn);
    }

    @Override
    public void afterConvert2TaskDetailDyn(WTCCalTaskDetailEntity taskDetail, DynamicObject taskDetailDyn) {
        this.setDynTieStatus(taskDetail, taskDetailDyn);
    }

    @Override
    public void afterConvert2TaskDetail(DynamicObject taskDetailDyn, WTCCalTaskDetailEntity taskDetail) {
        TieCalTaskDetail tieDetail = (TieCalTaskDetail)taskDetail;
        tieDetail.setTieStatus(this.getTieDetailStatus(taskDetailDyn.getString("tiestatus")));
    }

    @Override
    public void afterConvert2TaskDetail(Object shardingDetail, WTCCalTaskDetailEntity taskDetail) {
        super.afterConvert2TaskDetail(shardingDetail, taskDetail);
        this.setTieDetailStatus(taskDetail);
    }

    private void setDynTieStatus(WTCCalTaskDetailEntity taskDetail, DynamicObject taskDetailDyn) {
        this.setTieDetailStatus(taskDetail);
        TieCalTaskDetail tieDetail = (TieCalTaskDetail)taskDetail;
        taskDetailDyn.set("tiestatus", (Object)tieDetail.getTieStatus().code);
    }

    private TieDetailStatus getTieDetailStatus(String code) {
        if (TieDetailStatus.FAIL.code.equals(code)) {
            return TieDetailStatus.FAIL;
        }
        if (TieDetailStatus.SUCCESS.code.equals(code)) {
            return TieDetailStatus.SUCCESS;
        }
        if (TieDetailStatus.ACCOUNTING.code.equals(code)) {
            return TieDetailStatus.ACCOUNTING;
        }
        return TieDetailStatus.STATELESS;
    }

    private void setTieDetailStatus(WTCCalTaskDetailEntity taskDetail) {
        TieCalTaskDetail tieDetail = (TieCalTaskDetail)taskDetail;
        WTCTaskDetailStatus taskDetailState = taskDetail.getTaskDetailState();
        if (taskDetailState == null) {
            return;
        }
        if (WTCTaskDetailStatus.FAIL == taskDetailState) {
            tieDetail.setTieStatus(TieDetailStatus.FAIL);
        } else if (WTCTaskDetailStatus.SUCCESS == taskDetailState) {
            tieDetail.setTieStatus(TieDetailStatus.SUCCESS);
        } else if (WTCTaskDetailStatus.ACCOUNTING == taskDetailState) {
            tieDetail.setTieStatus(TieDetailStatus.ACCOUNTING);
        } else {
            tieDetail.setTieStatus(TieDetailStatus.STATELESS);
        }
    }
}

