/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.cirenum;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.business.cirenum.CircleUnitEnum;
import kd.wtc.wtbs.common.MultiLangEnumBridge;

public enum ChangeDayEnum {
    CHANGE_DAY_A(new MultiLangEnumBridge("\u5411\u8fc7\u53bb\u8c03\u6574", "ChangeDayEnum_0", "wtc-wtbs-business"), "A"),
    CHANGE_DAY_B(new MultiLangEnumBridge("\u5411\u672a\u6765\u8c03\u6574", "ChangeDayEnum_1", "wtc-wtbs-business"), "B");

    private final MultiLangEnumBridge name;
    private final String nameCode;

    private ChangeDayEnum(MultiLangEnumBridge name, String nameCode) {
        this.name = name;
        this.nameCode = nameCode;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getNameCode() {
        return this.nameCode;
    }

    public static ChangeDayEnum getByNameCode(String nameCode) {
        for (ChangeDayEnum value : ChangeDayEnum.values()) {
            if (!value.getNameCode().equals(nameCode)) continue;
            return value;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u65f6\u957f\u8c03\u6574\u914d\u7f6e\u9519\u8bef\u3002", (String)"ChangeDayEnum_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
    }

    public static Date getChangeDate(ChangeDayEnum changeType, Date date, String unit, Integer value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CircleUnitEnum circleUnit = CircleUnitEnum.getByNameCode(unit);
        Integer cirDays = ChangeDayEnum.getCirDays(circleUnit, calendar, value);
        if (CHANGE_DAY_A == changeType) {
            calendar.add(5, -cirDays.intValue());
        } else if (CHANGE_DAY_B == changeType) {
            calendar.add(5, cirDays);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u7167\u65e5\u671f\u8c03\u6574\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChangeDayEnum_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        return calendar.getTime();
    }

    private static Integer getCirDays(CircleUnitEnum circleUnitEnum, Calendar calendar, int value) {
        Integer cirDays = 0;
        if (CircleUnitEnum.CIRCLE_UNIT_DAY == circleUnitEnum) {
            cirDays = value;
        } else if (CircleUnitEnum.CIRCLE_UNIT_MONTH == circleUnitEnum) {
            Calendar cirDate = Calendar.getInstance();
            cirDate.setTime(calendar.getTime());
            for (int i = 1; i <= value; ++i) {
                int monthDay = calendar.getActualMaximum(5);
                cirDays = cirDays + monthDay;
                cirDate.add(5, monthDay);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u7167\u65e5\u671f\u8c03\u6574\u5355\u4f4d\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ChangeDayEnum_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        return cirDays;
    }
}

