/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.daterange;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.lang.NotNull;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.cache.IWTCAppCache;
import kd.wtc.wtbs.common.cache.relate.WTCAppCache;
import kd.wtc.wtbs.common.enums.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtbs.common.enums.TimeBucketPositionEnum;
import kd.wtc.wtbs.common.model.TimeInterval;
import kd.wtc.wtbs.common.model.TimeIntervalResult;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class DateRangeServiceImpl
implements IDateRangeService {
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
    private static HRBaseServiceHelper service = new HRBaseServiceHelper("wtbd_datetypeper");
    private static final Log logger = LogFactory.getLog(DateRangeServiceImpl.class);
    private static final String I_SHIFT_SPLIT_SERVICE = "IShiftSplitService";
    private static final IWTCAppCache appCache = WTCAppCache.get((String)"wtbd_daterange");
    private static final String SHIFT_SPLIT_SIMPLE = "shiftSplitSimple";

    private static void putMap(ConditionDto dto, String bucketProp, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        String value = dto.getValue();
        logger.debug("name ={} , bucketProp = {}, value = {}", new Object[]{name, bucketProp, value});
        switch (operators) {
            case "==": {
                map.put(name, HRStringUtils.equals((String)value, (String)bucketProp));
                break;
            }
            case "!=": {
                map.put(name, !HRStringUtils.equals((String)value, (String)bucketProp));
                break;
            }
            case "in": {
                List<String> list = DateRangeServiceImpl.transformer2List(value);
                map.put(name, list.contains(bucketProp));
                break;
            }
            case "not_in": {
                List<String> list = DateRangeServiceImpl.transformer2List(value);
                map.put(name, !list.contains(bucketProp));
                break;
            }
            case "is_null": {
                map.put(name, HRStringUtils.isEmpty((String)bucketProp));
                break;
            }
            case "is_not_null": {
                map.put(name, HRStringUtils.isNotEmpty((String)bucketProp));
            }
        }
    }

    private static List<String> transformer2List(String value) {
        String[] split = value.split(",");
        return Arrays.stream(split).collect(Collectors.toList());
    }

    @Override
    public Boolean isSatisfyDateRange(Long dateType, String dateAttribute, String metaNumber, Long pk) {
        String conditionJson = (String)appCache.get(metaNumber + pk, String.class);
        if (HRStringUtils.isEmpty((String)conditionJson)) {
            DynamicObject dynamicObject = serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metaNumber), new QFilter("basedataid", "=", (Object)pk)});
            if (dynamicObject == null) {
                return Boolean.TRUE;
            }
            conditionJson = dynamicObject.getString("conditions");
            appCache.put(metaNumber + pk, (Object)conditionJson);
        }
        return this.matchDateRange(dateType, dateAttribute, conditionJson, null);
    }

    @Override
    public Boolean isContentDateRange(List<String> contentCondition, String thisCondition) {
        AccessDto selectedDto = null;
        AccessDto thisDto = null;
        try {
            thisDto = (AccessDto)SerializationUtils.fromJsonString((String)thisCondition, AccessDto.class);
            List<ConditionDto> thisConditionList = thisDto.getConditionList();
            String thisExpressStr = thisDto.getConditionExpressStr();
            for (ConditionDto dto : thisConditionList) {
                String name = dto.getName();
                String param = dto.getParam();
                String operator = dto.getOperators();
                String value = dto.getValue();
                thisExpressStr = thisExpressStr.trim().replace(name, param + operator + value);
            }
            List<String> thisExpresslist = Arrays.asList(thisExpressStr.split(""));
            Iterator<String> iterator = contentCondition.iterator();
            if (iterator.hasNext()) {
                String condition = iterator.next();
                selectedDto = (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
                List<ConditionDto> selectedConditionList = selectedDto.getConditionList();
                String selectedExpressStr = selectedDto.getConditionExpressStr();
                for (ConditionDto dto : selectedConditionList) {
                    String name = dto.getName();
                    String param = dto.getParam();
                    String operator = dto.getOperators();
                    String value = dto.getValue();
                    selectedExpressStr = selectedExpressStr.trim().replace(name, param + operator + value);
                }
                if (thisExpressStr.length() != selectedExpressStr.length()) {
                    return Boolean.FALSE;
                }
                return HRStringUtils.equals((String)thisExpressStr, (String)selectedExpressStr);
            }
        }
        catch (Exception e) {
            logger.error("JsonProcessingException:", (Object)e.getMessage());
        }
        return Boolean.FALSE;
    }

    @Override
    public Map<Long, String> queryDateRangeCondition(String pageNumber, Collection<Long> pkIdColl) {
        DynamicObject[] dataRangeDys = serviceHelper.query("basedataid,conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)pageNumber), new QFilter("basedataid", "in", pkIdColl)});
        return Arrays.stream(dataRangeDys).collect(Collectors.toMap(dy -> dy.getLong("basedataid"), dy -> dy.getString("conditions"), (o1, o2) -> o2));
    }

    @Override
    public Boolean isSatisfyDateRange(Long dateType, String dateAttribute, String conditionJson) {
        return this.matchDateRange(dateType, dateAttribute, conditionJson, null);
    }

    @Override
    public Boolean isSatisfyDateRange(Long dateType, String dateAttribute, AccessDto accessDto) {
        return this.matchDateRange(dateType, dateAttribute, accessDto, null);
    }

    @Override
    public Boolean isSatisfyDateRange(Long dateType, String dateAttribute, Boolean isoff, AccessDto accessDto) {
        if (accessDto == null) {
            return Boolean.TRUE;
        }
        List<ConditionDto> conditionList = accessDto.getConditionList();
        String conditionExpressStr = accessDto.getConditionExpressStr();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (ConditionDto dto : conditionList) {
            map.put(dto.getName(), Boolean.TRUE);
            if (dto.getParam().contains("datetype") && dateType != null && dateType != 0L) {
                DateRangeServiceImpl.putMap(dto, String.valueOf(dateType), map);
            }
            if (dto.getParam().contains("dateattribute") && HRStringUtils.isNotEmpty((String)dateAttribute)) {
                DateRangeServiceImpl.putMap(dto, dateAttribute, map);
            }
            if (!dto.getParam().contains("off")) continue;
            DateRangeServiceImpl.putMap(dto, String.valueOf(isoff), map);
        }
        return DateRangeServiceImpl.getResult(conditionExpressStr, map);
    }

    @NotNull
    private Boolean matchDateRange(Long dateType, String dateAttribute, String conditionJson, String timeBucketPosition) {
        AccessDto accessDto = null;
        try {
            accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
        }
        catch (Exception e) {
            logger.error("JsonProcessingException:", (Object)e.getMessage());
        }
        return this.matchDateRange(dateType, dateAttribute, accessDto, timeBucketPosition);
    }

    @NotNull
    private Boolean matchDateRange(Long dateType, String dateAttribute, AccessDto accessDto, String timeBucketPosition) {
        if (accessDto == null) {
            return Boolean.TRUE;
        }
        List<ConditionDto> conditionList = accessDto.getConditionList();
        String conditionExpressStr = accessDto.getConditionExpressStr();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (ConditionDto dto : conditionList) {
            map.put(dto.getName(), Boolean.TRUE);
            String param = dto.getParam();
            if (HRStringUtils.isEmpty((String)param)) continue;
            if (dto.getParam().contains("datetype") && dateType != null && dateType != 0L) {
                DateRangeServiceImpl.putMap(dto, String.valueOf(dateType), map);
            }
            if (dto.getParam().contains("dateattribute") && HRStringUtils.isNotEmpty((String)dateAttribute)) {
                DateRangeServiceImpl.putMap(dto, dateAttribute, map);
            }
            if (!dto.getParam().contains("timebucketposition")) continue;
            DateRangeServiceImpl.putMap(dto, timeBucketPosition, map);
        }
        return DateRangeServiceImpl.getResult(conditionExpressStr, map);
    }

    public static boolean getResult(String str, Map<String, Boolean> params) {
        str = str.replaceAll(" +", "").replaceAll("and", "&").replace("or", "|");
        Set<Map.Entry<String, Boolean>> entrySet = params.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            str = str.replace(entry.getKey(), entry.getValue() != false ? "1" : "0");
        }
        int pro = DateRangeServiceImpl.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    public static boolean get(String str) {
        int pro = DateRangeServiceImpl.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    private static int pro(char[] arr, int beginIdx) {
        int idx;
        int culResult = 0x8000000;
        int preSign = 38;
        int len = arr.length;
        for (idx = beginIdx; idx < len; ++idx) {
            int c = arr[idx];
            if (c == 41) {
                return idx | culResult;
            }
            if (c == 40) {
                int pro = DateRangeServiceImpl.pro(arr, idx + 1);
                int subAns = pro & 0x8000000;
                int newIdx = pro & 0xF7FFFFFF;
                c = subAns == 0 ? 48 : 49;
                idx = newIdx;
            }
            if (c == 124) {
                preSign = c;
                if (culResult == 0) continue;
                idx = DateRangeServiceImpl.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (c == 38) {
                preSign = c;
                if (culResult != 0) continue;
                idx = DateRangeServiceImpl.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (c == 49) {
                if (preSign != 124) continue;
                culResult = 0x8000000;
                continue;
            }
            if (c != 48 || preSign != 38) continue;
            culResult = 0;
        }
        return idx | culResult;
    }

    private static int getIdx4CurLevel(char[] arr, int beginIdx) {
        int idx;
        int len = arr.length;
        int count = 0;
        for (idx = beginIdx; idx < len; ++idx) {
            char c = arr[idx];
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != ')') continue;
            if (count == 0) {
                return idx;
            }
            --count;
        }
        return idx;
    }

    @Override
    public Boolean isSatisfyDateRange(String matchSource, TimeInterval interval, String metaNumber, Long pkId) {
        if (!this.valiteParam(interval, metaNumber, pkId)) {
            return Boolean.FALSE;
        }
        Optional<String> option = DateRangeServiceImpl.getConditions(metaNumber, pkId);
        if (!option.isPresent()) {
            return Boolean.FALSE;
        }
        logger.debug("metaNumber = {}, pkId = {}, option = {}", new Object[]{metaNumber, pkId, option.get()});
        return this.isSatisfyDateRange(matchSource, interval, option.get());
    }

    @Override
    public Boolean isSatisfyDateRange(String matchSource, TimeInterval interval, String condition) {
        if (interval == null || HRStringUtils.isEmpty((String)condition)) {
            return Boolean.FALSE;
        }
        List timeIntervalResultList = Lists.newArrayListWithExpectedSize((int)16);
        logger.info("DateRangeServiceImpl.isSatisfyDateRange matchSource={}, getStartDate={}, getEndDate={}, getOtStartDate={} ,getOtEndDate={}", new Object[]{matchSource, interval.getStartDate(), interval.getEndDate(), interval.getOtStartDate(), interval.getOtEndDate()});
        if (!this.isNeedQueryShiftSplitSimple(interval, condition)) {
            logger.info("DateRangeServiceImpl.isSatisfyDateRange isNeedQueryShiftSplitSimple = false,matchSource={} ", (Object)matchSource);
            TimeIntervalResult timeIntervalResult = new TimeIntervalResult();
            Shift shiftSpec = interval.getShiftSpec();
            timeIntervalResult.setShiftSpec(shiftSpec);
            timeIntervalResult.setDateType(interval.getDateType());
            timeIntervalResult.setDateAttribute(interval.getDateAttribute());
            if (shiftSpec.getOffNonPlan() && shiftSpec.isOff()) {
                timeIntervalResult.setTimeBucketPosition(TimeBucketPositionEnum.NON_PLAN_TIME.getCode());
                timeIntervalResult.setShiftTimeBucketProperty(ShiftTimeBucketPropertyEnum.NON_PLAN_TIME.getCode());
            }
            timeIntervalResultList.add(timeIntervalResult);
        } else {
            if (interval.getStartDate() == null || interval.getEndDate() == null || interval.getOtStartDate() == null && interval.getOtEndDate() == null) {
                return Boolean.FALSE;
            }
            logger.info("timeIntervalResultList invoke:matchSource = {} ,rosterDate={}, shiftId = {}, dateType = {}, dateAttribute = {}, startDate = {}, endDate = {}, otStartDate = {}, otEndDate = {}, condition={}", new Object[]{matchSource, interval.getRosterDate(), interval.getShiftSpec().getId(), interval.getDateType(), interval.getDateAttribute(), interval.getStartDate(), interval.getEndDate(), interval.getOtStartDate(), interval.getOtEndDate(), condition});
            timeIntervalResultList = (List)WTCServiceHelper.invokeBizService("wtc", "wtes", I_SHIFT_SPLIT_SERVICE, SHIFT_SPLIT_SIMPLE, interval);
        }
        if (CollectionUtils.isEmpty((Collection)timeIntervalResultList)) {
            return Boolean.FALSE;
        }
        for (TimeIntervalResult timeIntervalResult : timeIntervalResultList) {
            logger.info("timeIntervalResult.getTimeBucketPosition = {}", (Object)timeIntervalResult.getTimeBucketPosition());
        }
        List<TimeIntervalResult> afterFilterOTTime = this.filterNotInOTTime(timeIntervalResultList, interval);
        if (HRStringUtils.equals((String)matchSource, (String)"1")) {
            return this.matchBaseDate(afterFilterOTTime, interval, condition);
        }
        return this.matchCalculRule(afterFilterOTTime, interval, condition);
    }

    private List<TimeIntervalResult> filterNotInOTTime(List<TimeIntervalResult> timeIntervalResultList, TimeInterval interval) {
        ArrayList intervalResults = Lists.newArrayListWithExpectedSize((int)10);
        intervalResults.addAll(timeIntervalResultList);
        Date otStartDate = interval.getOtStartDate();
        Date otEndDate = interval.getOtEndDate();
        Iterator iterator = intervalResults.iterator();
        while (iterator.hasNext()) {
            TimeIntervalResult timeIntervalResult = (TimeIntervalResult)iterator.next();
            Date startDate = timeIntervalResult.getIntervalStartDate();
            Date endDate = timeIntervalResult.getIntervalEndDate();
            if (startDate == null || endDate == null || endDate.getTime() > otStartDate.getTime() && startDate.getTime() < otEndDate.getTime()) continue;
            iterator.remove();
        }
        return intervalResults;
    }

    private boolean isNeedQueryShiftSplitSimple(TimeInterval interval, String conditionJson) {
        if (interval.getStartDate() == null || interval.getEndDate() == null || interval.getOtStartDate() == null && interval.getOtEndDate() == null) {
            return false;
        }
        logger.info("DateRangeServiceImpl.isNeedQueryShiftSplitSimple conditionJson={} ", (Object)conditionJson);
        Optional<AccessDto> optional = this.getAccessDto(conditionJson);
        if (!optional.isPresent()) {
            logger.info("DateRangeServiceImpl.isNeedQueryShiftSplitSimple optional.isPresent() = false ");
            return false;
        }
        List<ConditionDto> conditionList = optional.get().getConditionList();
        List result = conditionList.stream().filter(dto -> dto.getParam().contains("timebucketposition") || dto.getParam().contains("shifttimebucketproperty")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            logger.info("DateRangeServiceImpl.isNeedQueryShiftSplitSimple result.isEmpty = true ");
            return false;
        }
        return true;
    }

    private boolean valiteParam(TimeInterval interval, String metaNumber, Long pkId) {
        if (interval == null) {
            return false;
        }
        Optional<String> option = DateRangeServiceImpl.getConditions(metaNumber, pkId);
        if (!option.isPresent()) {
            return false;
        }
        if (interval.getShiftSpec() == null) {
            return false;
        }
        logger.debug("input param:rosterDate={}, shiftId = {}, dateType = {}, dateAttribute = {}, startDate = {}, endDate = {}, otStartDate = {}, otEndDate = {}, metaNumber={} ,pkId = {}", new Object[]{interval.getRosterDate(), interval.getShiftSpec().getId(), interval.getDateType(), interval.getDateAttribute(), interval.getStartDate(), interval.getEndDate(), interval.getOtStartDate(), interval.getOtEndDate(), metaNumber, pkId});
        return true;
    }

    private boolean matchBaseDate(List<TimeIntervalResult> timeIntervalResultList, TimeInterval interval, String conditionJson) {
        for (TimeIntervalResult timeIntervalResult : timeIntervalResultList) {
            logger.debug("matchBaseDate query result:timeBucketPosition = {}", (Object)timeIntervalResult.getTimeBucketPosition());
            boolean isMatch = this.matchDateRange(interval.getDateType(), interval.getDateAttribute(), conditionJson, timeIntervalResult.getTimeBucketPosition());
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private boolean matchCalculRule(List<TimeIntervalResult> timeIntervalResultList, TimeInterval interval, String conditionJson) {
        Optional<AccessDto> optional = this.getAccessDto(conditionJson);
        if (!optional.isPresent()) {
            logger.info("DateRangeServiceImpl.matchCalculRule ioptional.isPresent() = false ");
            return false;
        }
        Map<String, Boolean> timebucketPositionMap = this.matchTimebucketPosition(optional.get(), interval);
        for (TimeIntervalResult timeIntervalResult : timeIntervalResultList) {
            logger.debug("matchCalculRule query result:timeBucketPosition = {}, shiftTimeBucketProperty = {}", (Object)timeIntervalResult.getTimeBucketPosition(), (Object)timeIntervalResult.getShiftTimeBucketProperty());
            boolean isMatch = this.matchDateRange(timeIntervalResult, optional.get(), timebucketPositionMap, interval);
            if (!isMatch) continue;
            return true;
        }
        logger.info("DateRangeServiceImpl.matchCalculRule result = false ");
        return false;
    }

    private static Optional<String> getConditions(String metaNumber, Long pkId) {
        String conditionJson = (String)appCache.get(metaNumber + pkId, String.class);
        if (HRStringUtils.isEmpty((String)conditionJson)) {
            DynamicObject dynamicObject = serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metaNumber), new QFilter("basedataid", "=", (Object)pkId)});
            if (dynamicObject == null) {
                return Optional.empty();
            }
            conditionJson = dynamicObject.getString("conditions");
            appCache.put(metaNumber + pkId, (Object)conditionJson);
        }
        return Optional.of(conditionJson);
    }

    private Boolean matchDateRange(TimeIntervalResult intervalResult, AccessDto accessDto, Map<String, Boolean> timebucketPositionMap, TimeInterval interval) {
        List<ConditionDto> conditionList = accessDto.getConditionList();
        String conditionExpressStr = accessDto.getConditionExpressStr();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        Long dateType = interval.getDateType();
        String dateAttribute = interval.getDateAttribute();
        String timeBucketPosition = intervalResult.getTimeBucketPosition();
        String shiftTimeBucketProperty = intervalResult.getShiftTimeBucketProperty();
        Shift shiftSpec = interval.getShiftSpec();
        String isOff = shiftSpec == null ? Boolean.FALSE.toString() : Boolean.valueOf(shiftSpec.isOff()).toString();
        for (ConditionDto dto : conditionList) {
            map.put(dto.getName(), Boolean.TRUE);
            if (dto.getParam().contains("datetype") && dateType != null && dateType != 0L) {
                DateRangeServiceImpl.putMap(dto, String.valueOf(dateType), map);
            }
            if (dto.getParam().contains("dateattribute") && HRStringUtils.isNotEmpty((String)dateAttribute)) {
                DateRangeServiceImpl.putMap(dto, dateAttribute, map);
            }
            if (dto.getParam().contains("datetypepattern")) {
                map.put(dto.getName(), timebucketPositionMap.get(dto.getName()));
            }
            if (dto.getParam().contains("off") && shiftSpec != null) {
                DateRangeServiceImpl.putMap(dto, isOff, map);
            }
            if (dto.getParam().contains("shiftspec") && shiftSpec != null && shiftSpec.getId() != 0L) {
                DateRangeServiceImpl.putMap(dto, String.valueOf(shiftSpec.getBoId()), map);
            }
            if (dto.getParam().contains("timebucketposition")) {
                DateRangeServiceImpl.putMap(dto, timeBucketPosition, map);
            }
            if (!dto.getParam().contains("shifttimebucketproperty")) continue;
            DateRangeServiceImpl.putMap(dto, shiftTimeBucketProperty, map);
        }
        return DateRangeServiceImpl.getResult(conditionExpressStr, map);
    }

    private Map<String, Boolean> matchTimebucketPosition(AccessDto accessDto, TimeInterval interval) {
        List<ConditionDto> conditionList = accessDto.getConditionList();
        List result = conditionList.stream().filter(dto -> dto.getParam().contains("datetypepattern")).collect(Collectors.toList());
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (ConditionDto conditionDto : result) {
            if (!conditionDto.getParam().contains("datetypepattern")) continue;
            this.putTimebucketPositionMap(map, conditionDto, WTCDateUtils.toLocalDate((Date)interval.getRosterDate()), WTCDateUtils.toLocalDateTime((Date)interval.getOtStartDate()), WTCDateUtils.toLocalDateTime((Date)interval.getOtEndDate()));
        }
        return map;
    }

    private Optional<AccessDto> getAccessDto(String conditionJson) {
        try {
            logger.info("DateRangeServiceImpl.getAccessDto conditionJson = {} ", (Object)conditionJson);
            return Optional.of(SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class));
        }
        catch (Exception e) {
            logger.error("JsonProcessingException:", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private void putTimebucketPositionMap(Map<String, Boolean> map, ConditionDto dto, LocalDate shiftDate, LocalDateTime startTime, LocalDateTime endTime) {
        Boolean flag = Boolean.FALSE;
        String value = dto.getValue();
        DynamicObject dynamicObject = service.loadDynamicObject(new QFilter("id", "=", (Object)Long.parseLong(value)));
        if (dynamicObject == null) {
            return;
        }
        logger.debug("dynamicObject.id = {}", dynamicObject.get("id"));
        String datatype = dynamicObject.getString("datatype");
        if (HRStringUtils.equals((String)datatype, (String)"2")) {
            flag = this.fixIntersect(startTime, endTime, shiftDate, dynamicObject);
        } else if (HRStringUtils.equals((String)datatype, (String)"3")) {
            flag = this.weekIntersect(startTime, endTime, shiftDate, dynamicObject);
        }
        map.put(dto.getName(), flag);
    }

    private boolean fixIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDate shiftDate, DynamicObject dynamicObject) {
        boolean flag = false;
        DynamicObjectCollection fixtimeentity = dynamicObject.getDynamicObjectCollection("fixtimeentity");
        for (DynamicObject fixtime : fixtimeentity) {
            String stagdate = fixtime.getString("stagdate");
            int begintime = fixtime.getInt("begintime");
            String etagdate = fixtime.getString("etagdate");
            int endtime = fixtime.getInt("endtime");
            LocalDateTime enableStart = shiftDate.atStartOfDay().plusSeconds(begintime);
            LocalDateTime enableEnd = shiftDate.atStartOfDay().plusSeconds(endtime);
            if (stagdate.equals("C")) {
                enableStart = enableStart.plusDays(1L);
            } else if (stagdate.equals("Q")) {
                enableStart = enableStart.plusDays(-1L);
            }
            if (etagdate.equals("C")) {
                enableEnd = enableEnd.plusDays(1L);
            } else if (etagdate.equals("Q")) {
                enableEnd = enableEnd.plusDays(-1L);
            }
            logger.debug("enableStart={}, enableEnd={}, startTime={}, endTime{}", new Object[]{enableStart, enableEnd, startTime, endTime});
            flag = this.timeIntersect(enableStart, enableEnd, startTime, endTime);
            if (!flag) continue;
            break;
        }
        return flag;
    }

    private boolean weekIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDate shiftDate, DynamicObject dynamicObject) {
        boolean flag = false;
        DayOfWeek dayOfWeek = shiftDate.getDayOfWeek();
        DynamicObjectCollection weekentry = dynamicObject.getDynamicObjectCollection("weekentry");
        List dayenable = weekentry.stream().filter(e -> e.getBoolean("dayenable") && e.getString("weekday").equals(String.valueOf(dayOfWeek.getValue()))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dayenable)) {
            DynamicObject currentWeekDay = (DynamicObject)dayenable.get(0);
            String timetype = currentWeekDay.getString("timetype");
            if (timetype.equals("1")) {
                LocalDateTime enableStart = shiftDate.atStartOfDay();
                LocalDateTime enableEnd = WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getDayLastDate((Date)WTCDateUtils.toDate((LocalDate)shiftDate)));
                flag = this.timeIntersect(enableStart, enableEnd, startTime, endTime);
            } else {
                flag = this.defineIntersect(startTime, endTime, shiftDate, currentWeekDay);
            }
        }
        return flag;
    }

    private boolean defineIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDate shiftDate, DynamicObject currentWeekDay) {
        boolean flag = false;
        for (int i = 1; i <= 5; ++i) {
            LocalDateTime enableEnd;
            LocalDateTime enableStart;
            int startSecond = currentWeekDay.getInt("start" + i);
            int endSecond = currentWeekDay.getInt("end" + i);
            if ((startSecond > 0 || endSecond > 0) && (flag = this.timeIntersect(enableStart = shiftDate.atTime(startSecond / 3600, startSecond % 3600 / 60, startSecond % 3600 % 60), enableEnd = shiftDate.atTime(endSecond / 3600, endSecond % 3600 / 60, endSecond % 3600 % 60), startTime, endTime))) break;
        }
        return flag;
    }

    private boolean timeIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDateTime otStartTime, LocalDateTime otendTime) {
        return startTime != null && endTime != null && otStartTime != null && otendTime != null && startTime.isBefore(otendTime) && !endTime.isBefore(otStartTime);
    }
}

