/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.helper;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.converter.std.WTCCalTaskConverter;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class WTCTaskServiceHelper {
    private static final Log LOG = WTCLogFactory.getLog(WTCTaskServiceHelper.class);

    public static void updateTaskSub(String taskCategory, WTCSubTaskEntity wtcSubTaskEntity) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        WTCSubTaskStatus subTaskStatus = wtcSubTaskEntity.getSubTaskStatus();
        if (subTaskStatus != null) {
            WTCTaskStateTransfer.transferToSpecialStateSub((Long)wtcSubTaskEntity.getId(), (Long)wtcSubTaskEntity.getTaskId(), wtcSubTaskEntity, taskCategory);
        } else {
            repository.updateSubTask(wtcSubTaskEntity);
        }
    }

    public static boolean transferToSpecialStateSub(Long subTaskId, Long taskId, WTCSubTaskStatus wtcSubTaskStatus, String taskCategory) {
        return WTCTaskStateTransfer.transferToSpecialStateSub(subTaskId, taskId, wtcSubTaskStatus, taskCategory);
    }

    public static WTCCalTaskEntity loadTaskByTaskId(String taskCategory, long taskId, QFilter customCondition) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(taskCategory);
        return (WTCCalTaskEntity)repository.loadTaskByTaskId(taskId, customCondition);
    }

    public static WTCTaskBusinessStatusEnum getWTCTaskBusinessStatusEnumByTaskId(String taskCategory, long taskId) {
        WTCTaskBusinessStatusEnum wtcTaskBusinessStatusEnum;
        WTCCalTaskEntity wtcCalTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId(taskCategory, taskId, null);
        if (WTCTaskStatus.ALL_ERROR == wtcCalTaskEntity.getTaskStatus()) {
            wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.UNEXECUTED;
        } else if (WTCTaskStatus.RUNNING == wtcCalTaskEntity.getTaskStatus()) {
            wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.RUNNING;
        } else {
            int totalAttPerson = wtcCalTaskEntity.getTotalAttPerson();
            int notRunAttPerson = wtcCalTaskEntity.getNotRunAttPerson();
            int succeedAttPerson = wtcCalTaskEntity.getSucceedAttPerson();
            int failedAttPerson = wtcCalTaskEntity.getFailedAttPerson();
            if (totalAttPerson == notRunAttPerson) {
                wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.UNEXECUTED;
            } else if (totalAttPerson == succeedAttPerson) {
                wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.SUCCEED;
            } else if (totalAttPerson == notRunAttPerson + failedAttPerson) {
                wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.FAILED;
            } else if (totalAttPerson == notRunAttPerson + failedAttPerson + succeedAttPerson) {
                wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.HALFSUCCEED;
            } else {
                LOG.info("No wtcTaskBusinessStatusEnum can match the status, wtcCalTaskEntity {} ", (Object)wtcCalTaskEntity.toString());
                wtcTaskBusinessStatusEnum = WTCTaskBusinessStatusEnum.FAILED;
            }
        }
        return wtcTaskBusinessStatusEnum;
    }

    public static void sumAttPersonCalSubTask(List<? extends WTCCalTaskDetailEntity> calTaskDetailEntityList, WTCCalSubTaskEntity wtcCalSubTaskEntity) {
        if (wtcCalSubTaskEntity == null) {
            LOG.info("sumAttPersonCalSubTask wtcCalSubTaskEntity is null");
            return;
        }
        if (CollectionUtils.isEmpty(calTaskDetailEntityList)) {
            LOG.info("sumAttPersonCalSubTask calTaskDetailEntityList isEmpty,subTaskId {}", (Object)wtcCalSubTaskEntity.getId());
            return;
        }
        int taskDetailsSize = calTaskDetailEntityList.size();
        HashSet totalPersonIds = Sets.newHashSetWithExpectedSize((int)taskDetailsSize);
        HashSet runPersonIds = Sets.newHashSetWithExpectedSize((int)taskDetailsSize);
        HashSet successPersonIds = Sets.newHashSetWithExpectedSize((int)taskDetailsSize);
        HashSet totalFileIds = Sets.newHashSetWithExpectedSize((int)taskDetailsSize);
        HashSet notRunFileIds = Sets.newHashSetWithExpectedSize((int)taskDetailsSize);
        HashSet failFileIds = Sets.newHashSetWithExpectedSize((int)taskDetailsSize);
        Map<Long, List<WTCCalTaskDetailEntity>> collect = calTaskDetailEntityList.stream().collect(Collectors.groupingBy(WTCCalTaskDetailEntity::getAttPersonId));
        for (Map.Entry<Long, List<WTCCalTaskDetailEntity>> entries : collect.entrySet()) {
            List<WTCCalTaskDetailEntity> value = entries.getValue();
            Long attPersonId = entries.getKey();
            totalPersonIds.add(attPersonId);
            int successFileSize = 0;
            for (WTCCalTaskDetailEntity calTaskDetail : value) {
                long attFileId = calTaskDetail.getAttFileId();
                totalFileIds.add(attFileId);
                WTCTaskDetailStatus taskDetailState = calTaskDetail.getTaskDetailState();
                if (WTCTaskDetailStatus.NOT_ACCOUNT == taskDetailState) {
                    notRunFileIds.add(attFileId);
                    continue;
                }
                if (WTCTaskDetailStatus.SUCCESS == taskDetailState) {
                    runPersonIds.add(attPersonId);
                    ++successFileSize;
                    continue;
                }
                failFileIds.add(attFileId);
                runPersonIds.add(attPersonId);
            }
            if (successFileSize != value.size()) continue;
            successPersonIds.add(attPersonId);
        }
        if (wtcCalSubTaskEntity.getStartDate() == null) {
            wtcCalSubTaskEntity.setStartDate(new Date());
        }
        int totalAttPerson = totalPersonIds.size();
        int runAttPerson = runPersonIds.size();
        int successAttPerson = successPersonIds.size();
        int totalAttFile = totalFileIds.size();
        int notRunAttFile = notRunFileIds.size();
        int failAttFile = failFileIds.size();
        wtcCalSubTaskEntity.setTotalAttPerson(totalAttPerson);
        wtcCalSubTaskEntity.setRunAttPerson(runAttPerson);
        wtcCalSubTaskEntity.setFailedAttPerson(runAttPerson - successAttPerson);
        wtcCalSubTaskEntity.setNotRunAttPerson(totalAttPerson - runAttPerson);
        wtcCalSubTaskEntity.setSucceedAttPerson(successAttPerson);
        wtcCalSubTaskEntity.setTotalAttFile(totalAttFile);
        wtcCalSubTaskEntity.setNotRunAttFile(notRunAttFile);
        wtcCalSubTaskEntity.setFailedAttFile(failAttFile);
        wtcCalSubTaskEntity.setRunAttFile(totalAttFile - notRunAttFile);
        wtcCalSubTaskEntity.setSucceedAttFile(totalAttFile - notRunAttFile - failAttFile);
        if (wtcCalSubTaskEntity.getSucceedAttPerson() < 0 || wtcCalSubTaskEntity.getNotRunAttPerson() < 0 || wtcCalSubTaskEntity.getRunAttFile() < 0 || wtcCalSubTaskEntity.getSucceedAttFile() < 0) {
            LOG.info("subTask sum error,There is data less than zero, subTaskId {},successAttPerson {},notRunAttPerson {},runAttFile {},successAttFile {}", new Object[]{wtcCalSubTaskEntity.getId(), wtcCalSubTaskEntity.getSucceedAttPerson(), wtcCalSubTaskEntity.getNotRunAttPerson(), wtcCalSubTaskEntity.getRunAttFile(), wtcCalSubTaskEntity.getSucceedAttFile()});
            throw new KDBizException("settleSubTask sum error");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sumAttPersonCalSubTask.wtcCalSubTaskEntity {}", (Object)wtcCalSubTaskEntity.toString());
        }
    }

    public static WTCCalSubTaskEntity loadSubTaskById(String taskCategory, long subTaskId) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(taskCategory);
        return (WTCCalSubTaskEntity)repository.loadSubTaskByTaskId(subTaskId);
    }

    public static List<WTCCalSubTaskEntity> batchLoadSubTaskByTaskId(String taskCategory, long taskId, QFilter customCondition) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(taskCategory);
        List<WTCSubTaskEntity> subTaskList = repository.batchLoadSubTaskByTaskId(taskId, customCondition);
        return subTaskList.stream().map(subTask -> (WTCCalSubTaskEntity)subTask).collect(Collectors.toList());
    }

    public static List<WTCCalTaskDetailEntity> batchLoadTaskDetailByTaskIdAndSubTaskId(String taskCategory, long taskId, long subTaskId, QFilter customCondition) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        repository.setWTCTaskConverter(WTCTaskInstanceHelper.getConverter(taskCategory));
        return repository.batchLoadTaskDetailByTaskIdAndSubTaskId(taskId, subTaskId, customCondition);
    }

    public static List<DynamicObject> batchLoadTaskDetailDyn(String taskCategory, String selectKey, long taskId, long subTaskId, QFilter customCondition, String orderBys) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        repository.setWTCTaskConverter(WTCTaskInstanceHelper.getConverter(taskCategory));
        return repository.batchLoadTaskDetailDyn(selectKey, taskId, subTaskId, customCondition, orderBys);
    }

    public static WTCCalTaskDetailEntity loadWTCCalTaskDetailEntity(String taskCategory, long detailId) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        List<WTCCalTaskDetailEntity> detailList = repository.batchLoadTaskDetailByPK(new Object[]{detailId});
        if (detailList.size() == 0) {
            return null;
        }
        return detailList.get(0);
    }

    public static List<Map<String, Object>> batchTaskDetailByTaskIdToMap(String taskCategory, long taskId) {
        List<WTCCalTaskDetailEntity> taskDetails = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId(taskCategory, taskId, 0L, WTCTaskRepository.NO_CUSTOM_CONDITION);
        return taskDetails.stream().map(tieTaskDetail -> {
            HashMap reqMap = Maps.newHashMap();
            reqMap.put("attPersonId", tieTaskDetail.getAttPersonId());
            reqMap.put("attFileId", tieTaskDetail.getAttFileId());
            reqMap.put("attFileBoId", tieTaskDetail.getAttFileBoId());
            reqMap.put("attTagId", tieTaskDetail.getAttTagId());
            reqMap.put("position", tieTaskDetail.getPositionId());
            reqMap.put("job", tieTaskDetail.getJobId());
            reqMap.put("managingScopeId", tieTaskDetail.getManagingScopeId());
            reqMap.put("company", tieTaskDetail.getCompanyId());
            reqMap.put("adminorg", tieTaskDetail.getAdminOrgId());
            reqMap.put("agreedWorkplace", tieTaskDetail.getAgreedLocationId());
            reqMap.put("org", tieTaskDetail.getOrgId());
            reqMap.put("affiliateAdminOrg", tieTaskDetail.getAffiliateAdminOrgId());
            reqMap.put("empGroup", tieTaskDetail.getEmpGroupId());
            reqMap.put("dependency", tieTaskDetail.getDependencyId());
            reqMap.put("dependencyType", tieTaskDetail.getDependencyTypeId());
            reqMap.put("workplace", tieTaskDetail.getWorkplaceId());
            return reqMap;
        }).collect(Collectors.toList());
    }

    public static DynamicObject[] batchLoadTaskDetailDynByPK(String taskCategory, Object[] pks) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        return repository.batchLoadTaskDetailDynByPK(pks);
    }

    private static WTCCalTaskRepository getCalTaskRepository(String taskCategory) {
        WTCCalTaskRepository repository = (WTCCalTaskRepository)WTCTaskInstanceHelper.getRepository(taskCategory);
        repository.setWTCCalTaskConverter((WTCCalTaskConverter)WTCTaskInstanceHelper.getConverter(taskCategory));
        return repository;
    }

    public static void batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(List<WTCCalTaskDetailEntity> taskDetailList, String taskCategory) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        repository.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(taskDetailList);
    }

    public static void batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(List<WTCCalTaskDetailEntity> taskDetailList, String taskCategory) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        repository.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(taskDetailList);
    }

    public static void batchUpdateTaskDetailById(List<WTCCalTaskDetailEntity> taskDetailList, String taskCategory) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        repository.batchUpdateTaskDetailById(taskDetailList);
    }

    public static Map<WTCTaskDetailStatus, Integer> countTaskDetailState(String taskCategory, long taskId, long subTaskId) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        return repository.countTaskDetailState(taskId, subTaskId);
    }

    public static Map<String, Integer> taskDetailStateCount(String taskCategory, long taskId, long subTaskId) {
        WTCCalTaskRepository repository = WTCTaskServiceHelper.getCalTaskRepository(taskCategory);
        return repository.taskDetailStateCount(taskId, subTaskId);
    }

    @Deprecated
    public static WTCCalTaskEntity loadTaskByTaskId(String taskCategory, long taskId) {
        return WTCTaskServiceHelper.loadTaskByTaskId(taskCategory, taskId, null);
    }

    @Deprecated
    public static void updateTaskDetailBySubTaskIdAndAttFileBoId(WTCCalTaskDetailEntity taskDetail, String taskCategory) {
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(Collections.singletonList(taskDetail), taskCategory);
    }
}

