/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.history.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationListBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.wtc.wtbs.common.model.his.HisEvent;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCCommonHisService {
    private static final Log LOGGER = LogFactory.getLog(WTCCommonHisService.class);
    private static final String BUSIEVENT_SELECT_PROPERTIES = "boid,event,sourceentity,createtime";
    private static final String EVENT_SELECT_PROPERTIES = "id,createtime,eventbatchtype";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HisResponse<VersionChangeRespData> saveTimeHisModelData(DynamicObject[] hisDys, String entityNumber, Long eventId, Boolean resetId) {
        HisModelController instance = HisModelController.getInstance();
        if (resetId.booleanValue()) {
            long[] ids = ORM.create().genLongIds(entityNumber, hisDys.length);
            for (int i = 0; i < hisDys.length; ++i) {
                DynamicObject dynamicObject = hisDys[i];
                dynamicObject.set("id", (Object)ids[i]);
            }
        }
        HisVersionParamBo hisVersionParamBo = WTCCommonHisService.getHisVersionParamBo(hisDys, entityNumber);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEventId(eventId);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            HisResponse hisResponse = instance.hisVersionChange(hisVersionParamBo);
            return hisResponse;
        }
        catch (KDBizException kdBizException) {
            try {
                tx.markRollback();
                throw kdBizException;
                catch (Exception throwable2) {
                    tx.markRollback();
                    LOGGER.error((Throwable)throwable2);
                    String msg = ResManager.loadKDString((String)"\u65f6\u5e8f\u6027\u5386\u53f2\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WTCCommonHisService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    throw new KDBizException((Throwable)throwable2, new ErrorCode("", msg), new Object[0]);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HisResponse<VersionChangeRespData> saveTimeHisModelData(DynamicObject[] hisDys, String entityNumber, Long eventId, boolean resetId, boolean cancelNotSupported) {
        HisModelController instance = HisModelController.getInstance();
        if (resetId) {
            long[] ids = ORM.create().genLongIds(entityNumber, hisDys.length);
            for (int i = 0; i < hisDys.length; ++i) {
                DynamicObject dynamicObject = hisDys[i];
                dynamicObject.set("id", (Object)ids[i]);
            }
        }
        HisVersionParamBo hisVersionParamBo = WTCCommonHisService.getHisVersionParamBo(hisDys, entityNumber);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEventId(eventId);
        hisVersionParamBo.setCancel_notSupported(cancelNotSupported);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            HisResponse hisResponse = instance.hisVersionChange(hisVersionParamBo);
            return hisResponse;
        }
        catch (KDBizException kdBizException) {
            try {
                tx.markRollback();
                throw kdBizException;
                catch (Exception throwable2) {
                    tx.markRollback();
                    LOGGER.error((Throwable)throwable2);
                    String msg = ResManager.loadKDString((String)"\u65f6\u5e8f\u6027\u5386\u53f2\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WTCCommonHisService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    throw new KDBizException((Throwable)throwable2, new ErrorCode("", msg), new Object[0]);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private static HisVersionParamBo getHisVersionParamBo(DynamicObject[] hisDys, String entityNumber) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setAtomicTrans(false);
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setEventId(Long.valueOf(ID.genLongId()));
        hisVersionParamBo.setHisDyns(hisDys);
        return hisVersionParamBo;
    }

    public static HisResponse<VersionChangeRespData> saveNotTimeHisModelData(DynamicObject[] hisDys, String entityNumber) {
        HisResponse response;
        HisModelController instance = HisModelController.getInstance();
        HisVersionParamBo hisVersionParamBo = WTCCommonHisService.getHisVersionParamBo(hisDys, entityNumber);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setEventId(Long.valueOf(ID.genLongId()));
        try (TXHandle h = TX.required();){
            try {
                response = instance.noLineTimeHisVersionChange(hisVersionParamBo);
            }
            catch (KDBizException kdBizException) {
                h.markRollback();
                throw kdBizException;
            }
            catch (Exception throwable) {
                h.markRollback();
                LOGGER.error((Throwable)throwable);
                String msg = ResManager.loadKDString((String)"\u975e\u65f6\u5e8f\u6027\u5386\u53f2\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WTCCommonHisService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)throwable, new ErrorCode("", msg), new Object[0]);
            }
        }
        return response;
    }

    public static void saveNotTimeHisModelData(List<DynamicObject> newCollection, List<DynamicObject> editCollection, String entityNumber) {
        WTCCommonHisService.saveNotTimeHisModelData(newCollection, editCollection, entityNumber, 0L);
    }

    public static void saveNotTimeHisModelData(List<DynamicObject> newCollection, List<DynamicObject> editCollection, String entityNumber, Long eventId) {
        ArrayList hisDysList = Lists.newArrayListWithExpectedSize((int)16);
        if (newCollection != null && !newCollection.isEmpty()) {
            hisDysList.addAll(newCollection);
        }
        if (editCollection != null && !editCollection.isEmpty()) {
            hisDysList.addAll(editCollection);
        }
        if (!hisDysList.isEmpty()) {
            HisModelController instance = HisModelController.getInstance();
            HisVersionParamBo hisVersionParamBo = WTCCommonHisService.getHisVersionParamBo(hisDysList.toArray(new DynamicObject[0]), entityNumber);
            if (eventId == null || eventId == 0L) {
                hisVersionParamBo.setEventId(Long.valueOf(ID.genLongId()));
            } else {
                hisVersionParamBo.setEventId(eventId);
            }
            hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
            try (TXHandle h = TX.required();){
                try {
                    instance.noLineTimeHisVersionChange(hisVersionParamBo);
                }
                catch (Throwable throwable) {
                    h.markRollback();
                    LOGGER.error(throwable);
                    String msg = ResManager.loadKDString((String)"\u975e\u65f6\u5e8f\u6027\u5386\u53f2\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WTCCommonHisService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    throw new KDBizException(throwable, new ErrorCode("", msg), new Object[0]);
                }
            }
        }
    }

    public static void batchSaveTimeHisModelData(List<HisVersionParamBo> listHisVersionParamBo, Long eventId) {
        HisModelController instance = HisModelController.getInstance();
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setEventId(eventId);
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        try (TXHandle h = TX.required();){
            try {
                instance.batchHisVersionChange(hisVersionParamListBo);
            }
            catch (Throwable throwable) {
                h.markRollback();
                LOGGER.error(throwable);
                String msg = ResManager.loadKDString((String)"\u65f6\u5e8f\u6027\u5386\u53f2\u6279\u91cf\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WTCCommonHisService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                throw new KDBizException(throwable, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    public static void deleteBo(String entityNumber, List<Long> boIdList) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIdList);
        HisModelController instance = HisModelController.getInstance();
        try (TXHandle h = TX.required();){
            try {
                instance.deleteBo(hisBaseBo);
            }
            catch (Throwable throwable) {
                h.markRollback();
                LOGGER.error(throwable);
                String msg = ResManager.loadKDString((String)"\u5386\u53f2\u6a21\u578b\u5220\u9664\u5931\u8d25\u3002", (String)"WTCCommonHisService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                throw new KDBizException(throwable, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    public static HrApiResponse<HisVersionReviseResultBo> reviseVersion(DynamicObject[] hisDys, String entityNumber) {
        HisModelController instance = HisModelController.getInstance();
        HisVersionReviseParamBo hisVersionReviseParamBo = new HisVersionReviseParamBo();
        hisVersionReviseParamBo.setEntityNumber(entityNumber);
        hisVersionReviseParamBo.setReviseDys(hisDys);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            HrApiResponse hrApiResponse = instance.reviseVersion(hisVersionReviseParamBo);
            return hrApiResponse;
        }
        catch (Throwable throwable2) {
            try {
                tx.markRollback();
                LOGGER.error(throwable2);
                String msg = ResManager.loadKDString((String)"\u5386\u53f2\u6a21\u578b\u7248\u672c\u4fee\u8ba2\u5931\u8d25\u3002", (String)"WTCCommonHisService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                throw new KDBizException(throwable2, new ErrorCode("", msg), new Object[0]);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    @Deprecated
    public static Map<Long, List<HisEvent>> getEventListByBoId(Set<Long> boIdSet, Set<String> eventTypeSet) {
        HRBaseServiceHelper eventHelper = new HRBaseServiceHelper("wtbs_eventtpl");
        HRBaseServiceHelper businessEventHelper = new HRBaseServiceHelper("wtbs_busieventreltpl");
        QFilter businessEventQFilter = new QFilter("boid", "in", boIdSet).and("status", "=", (Object)"1");
        DataSet businessEventDataSet = businessEventHelper.queryDataSet("wtbs_busieventreltpl", BUSIEVENT_SELECT_PROPERTIES, businessEventQFilter.toArray());
        List eventIdList = Arrays.stream(businessEventHelper.query("event", businessEventQFilter.toArray())).map(dy -> dy.getLong("event")).collect(Collectors.toList());
        QFilter eventFilter = new QFilter("eventtype", "in", eventTypeSet).and("id", "in", eventIdList);
        DataSet eventDataSet = eventHelper.queryDataSet("wtbs_eventtpl", EVENT_SELECT_PROPERTIES, eventFilter.toArray());
        JoinDataSet join = eventDataSet.join(businessEventDataSet);
        join.on("id", "event");
        join.select(new String[]{"createtime"}, new String[]{"boid", "event", "sourceentity"});
        DataSet finish = join.finish();
        HashMap attFileBoIdEventMap = Maps.newHashMapWithExpectedSize((int)16);
        while (finish.hasNext()) {
            Row row = finish.next();
            List eventList = (List)attFileBoIdEventMap.get(row.getLong("boid"));
            HisEvent hisEvent = new HisEvent(row.getDate("createtime"), row.getLong("event").longValue(), row.getString("sourceentity"));
            if (eventList == null) {
                eventList = Lists.newArrayListWithExpectedSize((int)16);
                attFileBoIdEventMap.put(row.getLong("boid"), eventList);
            }
            eventList.add(hisEvent);
        }
        return attFileBoIdEventMap;
    }

    public static Map<Long, List<HisEvent>> getEventList(Set<Long> eventIdSet, Set<Long> boIdSet, Set<String> sourceEntitySet) {
        if (WTCCollections.isEmpty(sourceEntitySet) || WTCCollections.isEmpty(eventIdSet) && WTCCollections.isEmpty(boIdSet)) {
            return Collections.emptyMap();
        }
        HRBaseServiceHelper businessEventHelper = new HRBaseServiceHelper("wtbs_busieventreltpl");
        QFilter businessEventQFilter = new QFilter("status", "=", (Object)"1");
        businessEventQFilter.and(new QFilter("sourceentity", "in", sourceEntitySet));
        if (WTCCollections.isNotEmpty(boIdSet)) {
            businessEventQFilter.and(new QFilter("boid", "in", boIdSet));
        }
        if (WTCCollections.isNotEmpty(eventIdSet)) {
            businessEventQFilter.and(new QFilter("event", "in", eventIdSet));
        }
        DataSet businessEventDataSet = businessEventHelper.queryDataSet("wtbs_busieventreltpl", BUSIEVENT_SELECT_PROPERTIES, businessEventQFilter.toArray());
        QFilter eventFilter = new QFilter("id", "in", eventIdSet);
        HRBaseServiceHelper eventHelper = new HRBaseServiceHelper("wtbs_eventtpl");
        DataSet eventDataSet = eventHelper.queryDataSet("wtbs_eventtpl", EVENT_SELECT_PROPERTIES, eventFilter.toArray());
        JoinDataSet join = eventDataSet.join(businessEventDataSet);
        join.on("id", "event");
        join.select(new String[]{"eventbatchtype"}, new String[]{"boid", "event", "sourceentity", "createtime"});
        DataSet finish = join.finish();
        ArrayList tempData = Lists.newArrayListWithExpectedSize((int)10);
        while (finish.hasNext()) {
            Row row = finish.next();
            HisEvent hisEvent = new HisEvent(row.getDate("createtime"), row.getLong("event").longValue(), row.getLong("boid").longValue(), row.getString("sourceentity"));
            tempData.add(hisEvent);
        }
        businessEventDataSet.close();
        finish.close();
        return tempData.stream().sorted(Comparator.comparing(HisEvent::getCreatedTime).reversed()).collect(Collectors.groupingBy(HisEvent::getEventId, LinkedHashMap::new, Collectors.toList()));
    }

    public static void revertEvent(Long eventId, Map<String, List<Long>> entityBoIdMap, String resisterEventGroupAppId) {
        HisModelController instance = HisModelController.getInstance();
        HisTransRevocationListBo hisTransRevocationListBo = new HisTransRevocationListBo();
        hisTransRevocationListBo.setEventId(eventId);
        if (WTCCollections.isNotEmpty(entityBoIdMap)) {
            ArrayList listHisTransRevocationBoList = Lists.newArrayListWithExpectedSize((int)entityBoIdMap.size());
            entityBoIdMap.forEach((entityNumber, boIdList) -> {
                HisTransRevocationBo hisTransRevocationBo = new HisTransRevocationBo();
                hisTransRevocationBo.setBoId(boIdList);
                hisTransRevocationBo.setEntityNumber(entityNumber);
                listHisTransRevocationBoList.add(hisTransRevocationBo);
            });
            hisTransRevocationListBo.setListHisTransRevocationBo((List)listHisTransRevocationBoList);
            hisTransRevocationListBo.setResisterEventGroupAppId(resisterEventGroupAppId);
        }
        instance.revocationEvent(hisTransRevocationListBo);
    }

    public static void revertEvent(Long eventId, List<HisEvent> hisEventList, String resisterEventGroupAppId) {
        HisModelController instance = HisModelController.getInstance();
        HisTransRevocationListBo hisTransRevocationListBo = new HisTransRevocationListBo();
        hisTransRevocationListBo.setEventId(eventId);
        if (WTCCollections.isNotEmpty(hisEventList)) {
            ArrayList listHisTransRevocationBoList = Lists.newArrayListWithExpectedSize((int)hisEventList.size());
            Map<String, List<HisEvent>> collect = hisEventList.stream().collect(Collectors.groupingBy(HisEvent::getSourceEntity));
            for (Map.Entry<String, List<HisEvent>> entries : collect.entrySet()) {
                List boIdList = entries.getValue().stream().filter(d -> d.getBoId() != 0L).map(HisEvent::getBoId).collect(Collectors.toList());
                HisTransRevocationBo hisTransRevocationBo = new HisTransRevocationBo();
                hisTransRevocationBo.setBoId(boIdList);
                hisTransRevocationBo.setEntityNumber(entries.getKey());
                listHisTransRevocationBoList.add(hisTransRevocationBo);
            }
            hisTransRevocationListBo.setListHisTransRevocationBo((List)listHisTransRevocationBoList);
            hisTransRevocationListBo.setResisterEventGroupAppId(resisterEventGroupAppId);
        }
        instance.revocationEvent(hisTransRevocationListBo);
    }
}

