/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.history.service;

import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.SummaryServiceHelper;
import kd.wtc.wtbs.common.enums.SummaryLabelType;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCHisService {
    public static void show(IFormView view, String ... controlKeys) {
        view.setVisible(Boolean.TRUE, controlKeys);
    }

    public static void hide(IFormView view, String ... controlKeys) {
        view.setVisible(Boolean.FALSE, controlKeys);
    }

    public static String getString(String field, IDataModel model) {
        return model.getDataEntity().getString(field);
    }

    public static void showSummary(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        OperationStatus operationStatus = view.getFormShowParameter().getStatus();
        String status = (String)view.getModel().getValue("status");
        if (operationStatus == OperationStatus.ADDNEW) {
            SummaryServiceHelper.showAddSummary(view, WtbsBusinessUtils.getMainEntityDisplayName(view.getFormShowParameter().getFormId()));
        } else {
            SummaryLabelType labelType = SummaryLabelType.DEFAULT;
            boolean isAudit = HisModelEditAuditTool.getNeedAuditForBillEdit((IDataModel)view.getModel(), (IFormView)view);
            if (!isAudit) {
                labelType = SummaryLabelType.HIDE_STATUS;
            }
            if ("C".equals(status) && view.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"firstbsed") && (customParams.containsKey("boid") || view.getModel().getValue("firstbsed") != null) && !customParams.containsKey("newHisStatus")) {
                SummaryServiceHelper.showAuditedViewSummary(view, labelType);
            } else if ("insertdata_his".equals(customParams.get("option")) && "C".equals(customParams.get("newHisStatus"))) {
                SummaryServiceHelper.showAddSummary(view, WtbsBusinessUtils.getMainEntityDisplayName(view.getFormShowParameter().getFormId()));
            } else {
                SummaryServiceHelper.showViewSummary(view, labelType);
            }
        }
    }

    public static String getHisAction(FormShowParameter parameter) {
        String hisAction = (String)parameter.getCustomParam("his_action");
        if (hisAction == null) {
            hisAction = "fromHisAction".equals(parameter.getCustomParam("fromPage")) && OperationStatus.EDIT == parameter.getStatus() ? "open_edit_data_page" : (StringUtils.isNotBlank((CharSequence)((CharSequence)parameter.getCustomParam("fromPage"))) ? (String)parameter.getCustomParam("fromPage") : "");
        }
        return hisAction;
    }

    public static boolean isNonHisAddNewOrEdit(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        return (parameter.getStatus() == OperationStatus.ADDNEW || parameter.getStatus() == OperationStatus.EDIT) && StringUtils.isEmpty((CharSequence)WTCHisService.getHisAction(parameter));
    }

    public static void updateRealBillStatus(IFormView view) {
        WTCHisService.setRealBillStatus(view);
    }

    public static void setRealBillStatus(IFormView view) {
        String status = view.getModel().getDataEntity().getString("status");
        String fromPage = (String)view.getFormShowParameter().getCustomParams().get("fromPage");
        BillOperationStatus i = WTCHisService.getBillOperationStatus(status);
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            i = BillOperationStatus.EDIT;
        }
        view.getPageCache().put("realBillStatus", String.valueOf(i.getValue()));
    }

    private static BillOperationStatus getBillOperationStatus(String status) {
        BillOperationStatus i;
        switch (status) {
            case "A": {
                i = BillOperationStatus.EDIT;
                break;
            }
            case "B": {
                i = BillOperationStatus.SUBMIT;
                break;
            }
            case "C": {
                i = BillOperationStatus.AUDIT;
                break;
            }
            default: {
                i = BillOperationStatus.ADDNEW;
            }
        }
        return i;
    }

    public static boolean isLock(IFormView view) {
        String saveed;
        String fromPage;
        WTCHisService.updateRealBillStatus(view);
        String realBillStatusVal = view.getPageCache().get("realBillStatus");
        BillOperationStatus billOperationStatus = BillOperationStatus.ADDNEW;
        if (!HRStringUtils.isEmpty((String)realBillStatusVal)) {
            billOperationStatus = BillOperationStatus.forValue((int)Integer.parseInt(realBillStatusVal));
        }
        if (HRStringUtils.equals((String)(fromPage = (String)view.getFormShowParameter().getCustomParams().get("fromPage")), (String)"revise")) {
            billOperationStatus = BillOperationStatus.EDIT;
        }
        if (HRStringUtils.equals((String)(saveed = view.getPageCache().get("saveed")), (String)"true")) {
            billOperationStatus = BillOperationStatus.AUDIT;
        }
        return billOperationStatus.getValue() > 1;
    }

    public static BillOperationStatus transStatusToBillStaus(String status) {
        return WTCHisService.getBillOperationStatus(status);
    }
}

