/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.history.service;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.api.revise.HisReviseRecordParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.revise.HisReviseRecordReturnParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class WTCHisServiceHelper {
    private WTCHisServiceHelper() {
    }

    public static Date getNowDate() {
        ZonedDateTime zonedDateTime = LocalDate.now().atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date getMaxEndDate() {
        LocalDate localDate = LocalDate.of(2999, 12, 31);
        Date endDate = Date.from(localDate.atStartOfDay().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        return endDate;
    }

    public static Date getMinEndDate() {
        LocalDate localDate = LocalDate.of(1900, 12, 31);
        Date endDate = Date.from(localDate.atStartOfDay().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        return endDate;
    }

    public static String getCurrentBoName(String hisName) {
        StringBuilder stringBuilder = new StringBuilder(hisName);
        StringBuilder currentName = stringBuilder.delete(stringBuilder.length() - 3, stringBuilder.length());
        return currentName.toString();
    }

    public static Set<String> getHisIgnoreKeysSet() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)25);
        set.add("id");
        set.add("iscurrentversion");
        set.add("firstbsed");
        set.add("createtime");
        return set;
    }

    public static QFilter statusInQFilter(String key, String ... status) {
        return new QFilter(key, "in", (Object)status);
    }

    public static QFilter statusNotInQFilter(String key, String ... status) {
        return new QFilter(key, "not in", (Object)status);
    }

    public static long genLongId() {
        return ID.genLongId();
    }

    public static QFilter isCurrentVersion(boolean isCurrentVersion) {
        return new QFilter("iscurrentversion", "=", (Object)isCurrentVersion);
    }

    public static QFilter boQFilter(Long boId) {
        return new QFilter("boid", "=", (Object)boId);
    }

    public static QFilter boQFilter(Collection<Long> boId) {
        return new QFilter("boid", "in", boId);
    }

    public static QFilter validQFilter() {
        QFilter qFilter = WTCHisServiceHelper.statusValidQFilter();
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        return qFilter;
    }

    public static QFilter validWithoutEnableQFilter() {
        QFilter qFilter = WTCHisServiceHelper.statusValidWithoutEnableQFilter();
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        return qFilter;
    }

    public static QFilter validQFilterByBo(Long boId) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter(boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.statusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        return qFilter;
    }

    public static QFilter validQFilterByBo(Long boId, Date bsed, Date bsled) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter(boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.statusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        qFilter.and(WTCHisServiceHelper.getScheduleDateFileters(bsed, bsled));
        return qFilter;
    }

    public static QFilter validQFilterByBo(Long boId, Date date) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter(boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.statusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        Date dayStartTime = WTCDateUtils.getDayStartTime((Date)date);
        qFilter.and(new QFilter("bsed", "<=", (Object)dayStartTime));
        qFilter.and(new QFilter("bsled", ">=", (Object)dayStartTime));
        return qFilter;
    }

    private static QFilter getScheduleDateFileters(Object beginDate, Object endDate) {
        QFilter qFilters = new QFilter("bsed", "<=", beginDate).and(new QFilter("bsled", ">=", endDate));
        qFilters.or(new QFilter("bsed", "<=", beginDate).and(new QFilter("bsled", ">=", beginDate)));
        qFilters.or(new QFilter("bsed", "<=", endDate).and(new QFilter("bsled", ">=", endDate)));
        return qFilters;
    }

    public static QFilter validQFilterByBo(Collection<Long> boId) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter(boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.statusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        return qFilter;
    }

    public static QFilter validQFilterByBoNoStatus(Long boId) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter(boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        return qFilter;
    }

    public static QFilter validQFilterByBoNoStatus(Collection<Long> boId) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter(boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        return qFilter;
    }

    public static QFilter dataStatusValidQFilter() {
        return WTCHisServiceHelper.statusInQFilter("datastatus", "0", "1", "2");
    }

    public static QFilter statusValidQFilter() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        return qFilter.and(new QFilter("enable", "=", (Object)"1"));
    }

    public static QFilter statusValidWithoutEnableQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    public static QFilter getDateQFilter(Date startDate, Date endDate) {
        return WTCHisServiceHelper.getDateQFilter(startDate, endDate, "bsed", "bsled");
    }

    public static QFilter getAttFileDateQFilter(Date startDate, Date endDate) {
        if (startDate == null) {
            startDate = WTCHisServiceHelper.getMinEndDate();
        }
        if (endDate == null) {
            endDate = WTCHisServiceHelper.getMaxEndDate();
        }
        if (startDate.compareTo(endDate) > 0) {
            return null;
        }
        startDate = WTCDateUtils.getZeroDate((Date)startDate);
        endDate = WTCDateUtils.getZeroDate((Date)endDate);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate);
        dateFilter.and(new QFilter("enddate", ">=", (Object)startDate));
        dateFilter.and(new QFilter("bsed", "<=", (Object)endDate));
        dateFilter.and(new QFilter("bsled", ">=", (Object)startDate));
        return dateFilter;
    }

    public static QFilter getDateQFilter(Date startDate, Date endDate, String startDateStr, String endDateStr) {
        if (startDate == null || endDate == null) {
            return null;
        }
        startDate = WTCDateUtils.getZeroDate((Date)startDate);
        endDate = WTCDateUtils.getZeroDate((Date)endDate);
        QFilter beginFilter = new QFilter(startDateStr, "<=", (Object)endDate);
        beginFilter.and(new QFilter(endDateStr, ">=", (Object)startDate));
        return beginFilter;
    }

    public static QFilter getDateQFilter(Date date) {
        QFilter qFilter = new QFilter("id", "!=", (Object)0);
        if (date == null) {
            return qFilter;
        }
        date = WTCDateUtils.getZeroDate((Date)date);
        qFilter.and(new QFilter("bsed", "<=", (Object)date));
        qFilter.and(new QFilter("bsled", ">=", (Object)date));
        return qFilter;
    }

    public static Map<Long, List<DynamicObject>> queryHisVersionDyMap(String entityNum, Collection<Long> boIds, QFilter qFilter, String selectProps) {
        QFilter hisQFilter = WTCHisServiceHelper.validQFilterByBoNoStatus(boIds);
        if (qFilter != null) {
            hisQFilter.and(hisQFilter);
        }
        if (selectProps != null) {
            String selectField = "id,number,boid,bsed,bsled,firstbsed," + selectProps;
            selectField = Arrays.stream(selectField.split(",")).distinct().collect(Collectors.joining(","));
            DynamicObjectCollection dyColl = QueryServiceHelper.query((String)entityNum, (String)selectField, (QFilter[])hisQFilter.toArray());
            return dyColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        DynamicObject[] dyArray = helper.loadDynamicObjectArray(new QFilter[]{hisQFilter});
        return Arrays.stream(dyArray).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public static Map<Long, List<DynamicObject>> queryHisVersionDyMap(String entityNum, Collection<Long> boIds, Date startDate, Date endDate, String selectProps) {
        String selectField = "id,number,boid,bsed,bsled,firstbsed";
        if (selectProps != null) {
            selectField = selectField + ',' + selectProps;
            selectField = Arrays.stream(selectField.split(",")).distinct().collect(Collectors.joining(","));
        }
        QFilter hisQFilter = WTCHisServiceHelper.validQFilterByBoNoStatus(boIds);
        hisQFilter.and(WTCHisServiceHelper.getDateQFilter(startDate, endDate));
        DynamicObjectCollection dyColl = QueryServiceHelper.query((String)entityNum, (String)selectField, (QFilter[])hisQFilter.toArray());
        return dyColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public static DynamicObject getCurrVersionDy(Map<Long, List<DynamicObject>> sourceDataMap, long boId, Date date) {
        List<DynamicObject> hisVersionDys = sourceDataMap.get(boId);
        if (WTCCollections.isEmpty(hisVersionDys)) {
            return null;
        }
        return WTCHisServiceHelper.getHisVersionDy(date, hisVersionDys);
    }

    public static DynamicObject getHisVersionDy(Date date, List<DynamicObject> hisVersionDys) {
        for (DynamicObject hisVersionDy : hisVersionDys) {
            if (!WTCDateUtils.betweenDay((Date)date, (Date)hisVersionDy.getDate("bsed"), (Date)hisVersionDy.getDate("bsled"))) continue;
            return hisVersionDy;
        }
        return null;
    }

    public static HrApiResponse<List<HisReviseRecordReturnParamBo>> getReviseRecord(String entityNumber, Long boId, List<Long> versionIds) {
        HisReviseRecordParamBo hisReviseRecordParamBo = new HisReviseRecordParamBo();
        hisReviseRecordParamBo.setBoId(boId);
        hisReviseRecordParamBo.setEntityNumber(entityNumber);
        hisReviseRecordParamBo.setVersionIds(versionIds);
        return HisModelController.getInstance().getReviseRecord(hisReviseRecordParamBo);
    }
}

