/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.history.service;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCSnapService {
    private static final Log LOG = LogFactory.getLog(WTCSnapService.class);

    public static boolean checkNumber(String number) {
        if (number.trim().length() == 0) {
            return false;
        }
        number = number.replaceAll("_", "");
        String patternMac = "[a-z0-9A-Z]*";
        return Pattern.compile(patternMac).matcher(number).matches();
    }

    public static void setStatusLabel(String status, IFormView formView, String statusName) {
        LabelAp statusLabel = new HRLabelAp.Builder(statusName).setFontSize(16).build();
        String color = "#e5e5e5";
        if ("A".equals(status)) {
            color = "#666666";
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u6682\u5b58", (String)"WTCSnapService_0", (String)"wtc-wtbs-business", (Object[])new Object[0])));
        }
        if ("B".equals(status)) {
            color = "#5797ff";
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838\u4e2d", (String)"WTCSnapService_1", (String)"wtc-wtbs-business", (Object[])new Object[0])));
        }
        if ("C".equals(status)) {
            color = "#26B175";
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"WTCSnapService_2", (String)"wtc-wtbs-business", (Object[])new Object[0])));
        }
        WTCSnapService.setLabelStyle(color, statusLabel);
        statusLabel.setForeColor(color);
        formView.updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
    }

    public static void setEnableLabel(String enable, IFormView formView, String enableName) {
        LabelAp statusLabel = new HRLabelAp.Builder(enableName).setFontSize(16).build();
        String color = "#e5e5e5";
        if ("0".equals(enable)) {
            color = "#E1453E";
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u7981\u7528", (String)"WTCSnapService_3", (String)"wtc-wtbs-business", (Object[])new Object[0])));
        }
        if ("1".equals(enable)) {
            color = "#26B175";
            statusLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u53ef\u7528", (String)"WTCSnapService_4", (String)"wtc-wtbs-business", (Object[])new Object[0])));
        }
        WTCSnapService.setLabelStyle(color, statusLabel);
        statusLabel.setForeColor(color);
        formView.updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
    }

    public static void setLabelStyle(String color, LabelAp statusLabel) {
        String lineStyle = "1px_solid_";
        Style style = new Style();
        Border border = new Border();
        border.setTop(lineStyle + color);
        border.setBottom(lineStyle + color);
        border.setLeft(lineStyle + color);
        border.setRight(lineStyle + color);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("15px");
        padding.setBottom("0px");
        padding.setTop("0px");
        padding.setRight("15px");
        style.setPadding(padding);
        statusLabel.setStyle(style);
    }

    public static Map<Long, Long> snapHisSave(MainEntityType hisEntityType, HRBaseServiceHelper hisHelper, DynamicObjectCollection currentCollection) {
        return WTCSnapService.snapHisSaveAssignBoField(hisEntityType, hisHelper, currentCollection, null);
    }

    private static Map<Long, Long> snapHisSaveAssignBoField(MainEntityType hisEntityType, HRBaseServiceHelper hisHelper, DynamicObjectCollection currentCollection, String boFieldName) {
        if (WTCStringUtils.isEmpty((String)boFieldName)) {
            boFieldName = "bo";
        }
        Date date = new Date();
        String selects = "status, datastatus,enable,modifytime";
        Set boIdsSet = currentCollection.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        QFilter[] qFilters = new QFilter[]{new QFilter(boFieldName, "in", boIdsSet), new QFilter("datastatus", "=", (Object)"1")};
        DynamicObject[] hisObjects = hisHelper.query(selects, qFilters);
        if (hisObjects != null && hisObjects.length > 0) {
            Arrays.stream(hisObjects).forEach(d -> {
                d.set("datastatus", (Object)"2");
                d.set("modifytime", (Object)date);
            });
            hisHelper.save(hisObjects);
        }
        DynamicObjectCollection hisSaveCollection = new DynamicObjectCollection();
        int size = currentCollection.size();
        HashMap fidSnapIdMap = Maps.newHashMapWithExpectedSize((int)size);
        long[] longs = ID.genLongIds((int)size);
        DataEntityPropertyCollection properties = hisEntityType.getProperties();
        boolean hasCreatTime = properties.containsKey((Object)"createtime");
        boolean hasModifyTime = properties.containsKey((Object)"modifytime");
        boolean hasCreator = properties.containsKey((Object)"creator");
        boolean hasModifier = properties.containsKey((Object)"modifier");
        long currUserId = RequestContext.get().getCurrUserId();
        for (int index = 0; index < size; ++index) {
            DynamicObject dataEntity = (DynamicObject)currentCollection.get(index);
            DynamicObject hisObject = new DynamicObject((DynamicObjectType)hisEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)hisObject);
            hisObject.set("datastatus", (Object)"1");
            hisObject.set(boFieldName, dataEntity.get("id"));
            if (hasCreatTime) {
                hisObject.set("createtime", (Object)date);
            }
            if (hasModifyTime) {
                hisObject.set("modifytime", (Object)date);
            }
            if (hasCreator) {
                hisObject.set("creator", (Object)currUserId);
            }
            if (hasModifier) {
                hisObject.set("modifier", (Object)currUserId);
            }
            hisObject.set("id", (Object)longs[index]);
            hisSaveCollection.add((Object)hisObject);
            fidSnapIdMap.put(hisObject.getLong(boFieldName), longs[index]);
        }
        hisHelper.save(hisSaveCollection);
        return fidSnapIdMap;
    }

    public static Map<Long, Long> snapHisSaveAssignBoField(HRBaseServiceHelper hisHelper, DynamicObjectCollection currentCollection, String boFieldName) {
        MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)hisHelper.getEntityName());
        return WTCSnapService.snapHisSaveAssignBoField(hisEntityType, hisHelper, currentCollection, boFieldName);
    }

    public static Map<Long, Long> snapHisAndCurrentSaveAssignBoField(HRBaseServiceHelper currentHelper, HRBaseServiceHelper hisHelper, DynamicObjectCollection currentCollection, String boFieldName) {
        HashMap fidSnapIdMap = Maps.newHashMapWithExpectedSize((int)currentCollection.size());
        try (TXHandle tx = TX.required();){
            try {
                MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)hisHelper.getEntityName());
                currentHelper.save(currentCollection);
                Map<Long, Long> longLongMap = WTCSnapService.snapHisSaveAssignBoField(hisEntityType, hisHelper, currentCollection, boFieldName);
                fidSnapIdMap.putAll(longLongMap);
            }
            catch (Exception ex) {
                tx.markRollback();
                LOG.error("snapHisAndCurrentSave.Exception");
                throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
            }
        }
        return fidSnapIdMap;
    }
}

