/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.license;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.WTCCertCommonHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ListUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class CertService {
    private static int MAX_ERRORMSGNUM = 5;
    private static int MAX_ERRORMSGLENGTH = 300;
    private static final Log LOG = LogFactory.getLog(CertService.class);

    public static Map<String, Object> certControlOfAttPerson(String appNumber, String formNumber, Set<Long> attPersonIds, CertControlType type) {
        LOG.info("CertService.certControlOfAttPerson.param:{},{},{},{}", new Object[]{appNumber, formNumber, attPersonIds.size(), type});
        Map<Long, Long> attId2uniqueId = WTCCertCommonHelper.convertPersonId(Lists.newArrayList(attPersonIds));
        return CertService.certControl(appNumber, formNumber, Lists.newArrayList(attId2uniqueId.values()), type);
    }

    public static Map<String, Object> certControl(String appNumber, String formNumber, List<Long> uniqueIds, CertControlType type) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        LOG.info("CertService.certControlOfAttPerson.param:{},{},{},{}", new Object[]{appId, formNumber, uniqueIds.size(), type});
        Map map = HRCertCommonHelper.verifyCertCount((String)appId, (String)formNumber);
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)5);
        if (StringUtils.equals((CharSequence)((CharSequence)map.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap = CertService.packageCertCountErrorInfo(uniqueIds, map, resultMap);
        } else {
            String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formNumber);
            Set<Long> hasCertPid = WTCCertCommonHelper.checkForged(appId, formNumber, uniqueIds, groupId);
            switch (type) {
                case VALIDATORANDAPPLYCHECK: {
                    if (hasCertPid.size() == uniqueIds.size()) {
                        CertService.packageCertInfo(map, resultMap);
                        break;
                    }
                    CertService.packageCertApplyInfo(uniqueIds, resultMap, groupId, hasCertPid);
                    break;
                }
                case VALIDATORANDAPPLIED: {
                    CertService.packageCertAppliedInfo(appId, formNumber, resultMap, uniqueIds, groupId, hasCertPid);
                    break;
                }
                case VALIDATORANDRELEASE: {
                    WTCCertCommonHelper.deleteCertDetail(groupId, Lists.newArrayList(hasCertPid));
                    break;
                }
                default: {
                    if (hasCertPid.size() == uniqueIds.size()) {
                        CertService.packageCertInfo(map, resultMap);
                        break;
                    }
                    CertService.packageCertValFailInfo(uniqueIds, map, resultMap, hasCertPid);
                }
            }
        }
        LOG.info("CertService.certControlCheck.resultMap:{}", (Object)JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    public static Map<String, Set<Long>> genCertAttpersonMap(Set<Long> attPersonIds, Set<Long> attFileBoIds) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)2);
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setProperties("attperson.id,atttag.attendstatus,startdate,enddate,bsed,bsled");
        queryParam.setAttPersonSetIds(attPersonIds);
        queryParam.setSetBoIds(attFileBoIds);
        List<DynamicObject> files = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        files = AttFileQueryServiceImpl.getInstance().filterAttFileByDateRange(files, WTCDateUtils.getDayBegin(), null);
        Set allAttPersonIds = files.stream().map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet());
        Set efftiveAttPersonIds = files.stream().filter(file -> HRStringUtils.equals((String)"1", (String)file.getString("atttag.attendstatus"))).map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet());
        res.put("effectIds", efftiveAttPersonIds);
        allAttPersonIds.removeAll(efftiveAttPersonIds);
        res.put("disabledIds", allAttPersonIds);
        return res;
    }

    public static Map<String, Object> packageCertAppliedInfo(String appId, String formId, Map<String, Object> resultMap, List<Long> uniqueIds, String groupId, Set<Long> hasCertPid) {
        List collection = ListUtils.removeAll(uniqueIds, hasCertPid);
        ArrayList leftPidForApply = Lists.newArrayList((Iterable)collection);
        Map map = HRCertCommonHelper.updateUsedCertCount((String)appId, (String)formId, (int)collection.size());
        WTCCertCommonHelper.generateCertDetail(groupId, leftPidForApply, true);
        resultMap.put("result", Boolean.TRUE);
        resultMap.put("datas", Collections.emptyList());
        resultMap.put("msg", map);
        map.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
        resultMap.put("isforbidden", Boolean.FALSE);
        return resultMap;
    }

    public static Map<String, Object> packageCertApplyInfo(List<Long> uniqueIds, Map<String, Object> resultMap, String groupId, Set<Long> hasCertPid) {
        List collection = ListUtils.removeAll(uniqueIds, hasCertPid);
        Map checkCountMap = HRCertCommonHelper.verifyCertCount((String)groupId, (int)collection.size());
        boolean forbidden = StringUtils.equals((CharSequence)((CharSequence)checkCountMap.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
        resultMap.put("result", !forbidden);
        resultMap.put("datas", collection);
        resultMap.put("msg", checkCountMap);
        checkCountMap.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)checkCountMap.get("infoType")));
        resultMap.put("isforbidden", forbidden);
        return resultMap;
    }

    public static Map<String, Object> packageCertValFailInfo(List<Long> uniqueIds, Map<String, String> map, Map<String, Object> resultMap, Set<Long> hasCertPid) {
        List collection = ListUtils.removeAll(uniqueIds, hasCertPid);
        resultMap.put("result", Boolean.FALSE);
        resultMap.put("datas", collection);
        map.put("showMessageType", "1");
        resultMap.put("messageOfCertList", ResManager.loadKDString((String)"\u5458\u5de5\uff08%1$s\uff09\u65e0\u6709\u6548\u8bb8\u53ef\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"WTCCertCommonHelper_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        map.put("showMessage", "true");
        resultMap.put("msg", map);
        resultMap.put("isforbidden", Boolean.TRUE);
        return resultMap;
    }

    public static Map<String, Object> packageCertInfo(Map<String, String> map, Map<String, Object> resultMap) {
        resultMap.put("result", Boolean.TRUE);
        resultMap.put("datas", Collections.emptyList());
        map.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType(map.get("infoType")));
        resultMap.put("msg", map);
        resultMap.put("isforbidden", Boolean.FALSE);
        return resultMap;
    }

    public static Map<String, Object> packageCertCountErrorInfo(List<Long> attPersonIds, Map<String, String> map, Map<String, Object> resultMap) {
        resultMap.put("result", Boolean.FALSE);
        resultMap.put("datas", attPersonIds);
        resultMap.put("msg", map);
        map.put("showMessageType", "1");
        resultMap.put("isforbidden", Boolean.TRUE);
        return resultMap;
    }

    public static List<DynamicObject> getAttFileQueryRes(Set<Long> personIds, String properties) {
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setBeCurrent(Boolean.FALSE);
        if (HRStringUtils.isNotEmpty((String)properties)) {
            queryParam.setProperties(properties);
        }
        queryParam.setAttPersonSetIds(personIds);
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        return AttFileQueryServiceImpl.getInstance().filterAttFileByDateRange(attFiles, WTCDateUtils.getDayBegin(), null);
    }

    public static boolean checkEfftive(ChangeData changeData, IFormView formView, IDataModel dataModel) {
        boolean check = true;
        Object newValue = changeData.getNewValue();
        long personId = 0L;
        if (newValue instanceof DynamicObject) {
            personId = ((DynamicObject)newValue).getLong("person.id");
        }
        if (personId == 0L) {
            return false;
        }
        Map<String, Object> checkMap = CertService.certControlOfAttPerson("wtp", "wtp_attfilebase", Collections.singleton(personId), CertControlType.VALIDATORANDAPPLYCHECK);
        if (checkMap.get("isforbidden") == Boolean.TRUE || HRStringUtils.equals((String)String.valueOf(checkMap.get("result")), (String)"false")) {
            Map msgMap = (Map)checkMap.get("msg");
            formView.showErrorNotification(String.valueOf(msgMap.get("message")));
            dataModel.setValue("selectperson", null);
            check = false;
        }
        return check;
    }

    public static Map<String, List<Long>> getCertIdMap(List<DynamicObject> attfiles) {
        Set attpersonIds = attfiles.stream().map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet());
        attfiles = AttFileQueryServiceImpl.getInstance().filterAttFileByDateRange(attfiles, WTCDateUtils.getDayBegin(), null);
        Map<String, List<Long>> certCheckIdMap = CertService.getCertCheckIdMap(attfiles);
        List<Long> effectIds = certCheckIdMap.get("effectIds");
        attpersonIds.removeAll(effectIds);
        List<Long> disableIds = certCheckIdMap.get("disabledIds");
        disableIds.addAll(attpersonIds);
        return certCheckIdMap;
    }

    public static Map<String, List<Long>> getIdsMapByPersonIds(Set<Long> personIds, boolean checkAuth) {
        AttFileQueryParam queryParamOfPerson = new AttFileQueryParam(false);
        queryParamOfPerson.setProperties(AttFileQueryParam.baseProperties + "," + "attperson.id,attperson.number,attperson.name,attperson.laborrelstatus.id,attperson.laborrelstatus.number,attperson.laborrelstatus.name,attperson.gender.id,attperson.gender.number,attperson.gender.name,attperson.laborreltype.id,attperson.laborreltype.number,attperson.laborreltype.name,attperson.agreedlocation.id,attperson.agreedlocation.number,attperson.agreedlocation.name" + "," + "usablestatus");
        queryParamOfPerson.setAttPersonSetIds(personIds);
        queryParamOfPerson.setBeCurrent(Boolean.FALSE);
        queryParamOfPerson.setAuthCheck(Boolean.valueOf(checkAuth));
        List<DynamicObject> allAttFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParamOfPerson);
        return CertService.getCertIdMap(allAttFiles);
    }

    public static Map<String, List<Long>> getCertCheckIdMap(List<DynamicObject> allAttFiles) {
        Map<Long, List<DynamicObject>> id2Attfiles = allAttFiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attperson.id")));
        ArrayList disabledIds = Lists.newArrayList();
        ArrayList effectIds = Lists.newArrayList();
        id2Attfiles.forEach((id, values) -> {
            List ids = values.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("atttag.attendstatus"), (String)"1") && HRStringUtils.equals((String)"0", (String)dyn.getString("usablestatus"))).collect(Collectors.toList());
            if (ids.size() > 0) {
                effectIds.add(id);
            } else {
                disabledIds.add(id);
            }
        });
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>(2);
        idMap.put("effectIds", effectIds);
        idMap.put("disabledIds", disabledIds);
        return idMap;
    }

    public static Map<String, Object> checkCertByPersonIds(Set<Long> personIds, boolean checkAuth, boolean onlyHasCert) {
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        Map map = HRCertCommonHelper.verifyCertCount((String)"1C8H4/N38LCY", (String)"wtte_evaluationlog");
        if (StringUtils.equals((CharSequence)((CharSequence)map.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            res.put("result", Boolean.FALSE);
            res.put("failureIds", personIds);
            res.put("msg", map);
            return res;
        }
        Map<String, List<Long>> idsMapByPersonIds = CertService.getIdsMapByPersonIds(personIds, checkAuth);
        List<Long> effectIds = idsMapByPersonIds.get("effectIds");
        List<Long> disabledIds = idsMapByPersonIds.get("disabledIds");
        Map<String, Object> checkMap = WTCCertCommonHelper.certCheckNoAddByAttPerson("1C8H4/N38LCY", "wtte_evaluationlog", effectIds);
        Map msg = (Map)checkMap.get("msg");
        res.put("msg", msg);
        res.put("result", Boolean.TRUE);
        if (Boolean.TRUE.equals(checkMap.get("isforbidden"))) {
            res.put("result", Boolean.FALSE);
            List ids = (List)checkMap.get("datas");
            effectIds.removeAll(ids);
        }
        WTCCertCommonHelper.certFakeCheckByAttPerson("1C8H4/N38LCY", "wtte_evaluationlog", disabledIds);
        if (!onlyHasCert) {
            effectIds.addAll(disabledIds);
        }
        res.put("successIds", effectIds);
        res.put("failureIds", checkMap.get("datas"));
        return res;
    }

    public static String getFailureMsg(Map<String, Object> checkMap) {
        List ids = (List)checkMap.get("datas");
        HRBaseServiceHelper help = new HRBaseServiceHelper("wtp_attendperson");
        DynamicObject[] query = help.query("name,number", new QFilter[]{new QFilter("id", "in", (Object)ids)});
        ArrayList msgs = Lists.newArrayListWithCapacity((int)MAX_ERRORMSGNUM);
        for (int i = 0; i < query.length && i < MAX_ERRORMSGNUM; ++i) {
            msgs.add(String.format(String.valueOf(checkMap.get("messageOfCertList")), query[i].getString("number")));
        }
        StringBuilder message = new StringBuilder(String.join((CharSequence)"\r\n", msgs));
        if (query.length > 5) {
            if (message.length() > MAX_ERRORMSGLENGTH - 5) {
                return String.valueOf(message).substring(0, MAX_ERRORMSGLENGTH - 5) + ".....";
            }
            return message + "\r\n" + "...";
        }
        if (message.length() > MAX_ERRORMSGLENGTH) {
            return String.valueOf(message).substring(0, MAX_ERRORMSGLENGTH - 5) + ".....";
        }
        return String.valueOf(message);
    }

    public static void showErrorInfoByCertMsg(Map<String, Object> checkInfo, IFormView view) {
        Map msg = (Map)checkInfo.get("msg");
        if (Boolean.TRUE.equals(checkInfo.get("isforbidden"))) {
            List datas = (List)checkInfo.get("datas");
            if (CollectionUtils.isEmpty((Collection)datas)) {
                String message = (String)msg.get("message");
                view.showErrorNotification(message);
            } else {
                view.showMessage(CertService.getFailureMsg(checkInfo));
            }
        }
    }

    public static void showWarnInfoByCertMsg(Map<String, Object> checkInfo, IFormView view) {
        Map msg = (Map)checkInfo.get("msg");
        if (HRStringUtils.equals((String)String.valueOf(msg.get("showMessage")), (String)"true") && HRStringUtils.equals((String)String.valueOf(msg.get("showMessageType")), (String)"2")) {
            view.showTipNotification((String)msg.get("message"));
        }
    }
}

