/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class CertSyncTask
extends AbstractTask {
    private static Integer BATCH_SIZE = 1000;
    private static final Log logger = LogFactory.getLog(CertSyncTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List actualBatch;
        logger.info("CertSyncTask requestContext:{} ,map:{}", (Object)requestContext, map);
        ArrayList totalBatch = Lists.newArrayListWithExpectedSize((int)100000);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attendperson");
        try (DataSet dataSet = null;){
            dataSet = helper.queryDataSet(((Object)((Object)this)).getClass().getName() + ".wtcCertRefresh", "id", new QFilter[0]);
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                totalBatch.add(next.getLong("id"));
            }
        }
        logger.info("CertSyncTask totalSize:{}", (Object)totalBatch.size());
        ArrayList<List<Long>> needAddCertIds = new ArrayList<List<Long>>(100);
        for (int index = 0; totalBatch.size() > index; index += actualBatch.size()) {
            int numActual = totalBatch.size() - index > BATCH_SIZE ? BATCH_SIZE : totalBatch.size() - index;
            actualBatch = WTCCollections.subList((List)totalBatch, (int)index, (int)(index + numActual));
            logger.info("CertSyncTask actualBatchSize:{}", (Object)actualBatch.size());
            logger.info("CertSyncTask verifyListCertReturnNeed startTime:{}", (Object)System.currentTimeMillis());
            Map<String, List<Long>> idsMap = CertService.getIdsMapByPersonIds(new HashSet<Long>(actualBatch), false);
            needAddCertIds.add(idsMap.get("effectIds"));
            CertService.certControlOfAttPerson("wtp", "wtp_attfilebase", new HashSet<Long>((Collection)idsMap.get("disabledIds")), CertControlType.VALIDATORANDRELEASE);
            logger.info("CertSyncTask verifyListCertReturnNeed endTime:{}", (Object)System.currentTimeMillis());
        }
        int num = HRCertCommonHelper.getUsableCount((String)"1O9FOLRY18YW", (String)"wtp_attfilebase");
        if (num > 0) {
            logger.info("CertSyncTask verifyListCerAdd needAddCertIds:{},certNum:{}", (Object)needAddCertIds.size(), (Object)num);
            for (List list : needAddCertIds) {
                CertService.certControlOfAttPerson("wtp", "wtp_attfilebase", new HashSet<Long>(list), CertControlType.VALIDATORANDAPPLIED);
                logger.info("CertSyncTask verifyListCerAdd needAddCertId:{}", (Object)list.size());
            }
        }
    }
}

