/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.license;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRBizCertSignHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ListUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public final class WTCCertCommonHelper {
    private static final Log LOG = LogFactory.getLog(WTCCertCommonHelper.class);
    public static final String WORKHOUR_CERTENTITY = "wtbs_certdetail";
    private static final String SALT_PATTEN = "{0}-{1}-{2}";

    public static Map<String, Object> verifyCert(String appId, String formId, List<Long> pids) {
        WTCCertCommonHelper.checkWhiteList(true);
        Map map = HRCertCommonHelper.verifyCertCount((String)appId, (String)formId);
        LOG.info("verifyCert: " + JSON.toJSONString((Object)map));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        Set<Long> hasCertPid = WTCCertCommonHelper.checkForged(appId, formId, pids, groupId);
        HashSet<Long> allPids = new HashSet<Long>(pids);
        if (hasCertPid.size() == allPids.size()) {
            resultMap.put("result", Boolean.TRUE);
            resultMap.put("datas", Collections.emptyList());
            map.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
            resultMap.put("msg", map);
            resultMap.put("isforbidden", Boolean.FALSE);
        } else {
            Set<Long> needCertIds = WTCCertCommonHelper.checkAttUsableStatusEff4NoCertPerson(hasCertPid, allPids);
            if (needCertIds.size() > 0) {
                resultMap.put("result", Boolean.FALSE);
                resultMap.put("datas", new ArrayList<Long>(needCertIds));
                map.put("showMessageType", "1");
                resultMap.put("messageOfCertList", ResManager.loadKDString((String)"\u5458\u5de5\uff08%1$s\uff09\u65e0\u6709\u6548\u8bb8\u53ef\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"WTCCertCommonHelper_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
                map.put("showMessage", "true");
                resultMap.put("msg", map);
                resultMap.put("isforbidden", Boolean.TRUE);
            } else {
                resultMap.put("result", Boolean.TRUE);
                resultMap.put("datas", Collections.emptyList());
                map.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
                resultMap.put("msg", map);
                resultMap.put("isforbidden", Boolean.FALSE);
            }
        }
        LOG.info("verifyCertresultMap2: " + JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    private static Set<Long> checkAttUsableStatusEff4NoCertPerson(Set<Long> hasCertPids, Set<Long> allPids) {
        Set noCertPids = allPids.stream().filter(pid -> !hasCertPids.contains(pid)).collect(Collectors.toSet());
        if (WTCCollections.isEmpty(noCertPids)) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(16);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setAttPersonSetIds(noCertPids);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        Date now = WTCDateUtils.getDayBegin();
        attFileQueryParam.setStartDate(now);
        attFileQueryParam.setEndDate(now);
        attFileQueryParam.setProperties("id,attperson.id,atttag.attendstatus,startdate,enddate,bsed,bsled,usablestatus");
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        attFiles = AttFileQueryServiceImpl.getInstance().filterAttFileByDateRange(attFiles, now, now);
        Map<Long, List<DynamicObject>> id2Attfiles = attFiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attperson.id")));
        id2Attfiles.forEach((id, files) -> {
            Set ids = files.stream().filter(file -> HRStringUtils.equals((String)"1", (String)file.getString("atttag.attendstatus")) && HRStringUtils.equals((String)"0", (String)file.getString("usablestatus"))).collect(Collectors.toSet());
            if (ids.size() > 0) {
                result.add((Long)id);
            }
        });
        return result;
    }

    public static Map<String, Object> verifyCertForApply(String appId, String formId, List<Long> pids) {
        WTCCertCommonHelper.checkWhiteList(true);
        Map map = HRCertCommonHelper.verifyCertCount((String)appId, (String)formId);
        LOG.info("verifyCertForApply1: " + JSON.toJSONString((Object)map));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        if (StringUtils.equals((CharSequence)((CharSequence)map.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap.put("result", Boolean.FALSE);
            resultMap.put("datas", pids);
            resultMap.put("msg", map);
            map.put("showMessageType", "1");
            resultMap.put("isforbidden", Boolean.TRUE);
            LOG.info("verifyCertForApplyresultMap1: " + JSON.toJSONString((Object)resultMap));
            return resultMap;
        }
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        Set<Long> hasCertPid = WTCCertCommonHelper.checkForged(appId, formId, pids, groupId);
        List collection = ListUtils.removeAll(pids, hasCertPid);
        if (collection.size() == 0) {
            resultMap.put("result", Boolean.TRUE);
            resultMap.put("datas", collection);
            resultMap.put("msg", map);
            map.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
            resultMap.put("isforbidden", Boolean.FALSE);
            LOG.info("verifyCertForApplyresultMap2: " + JSON.toJSONString((Object)resultMap));
            return resultMap;
        }
        Map checkCountMap = HRCertCommonHelper.verifyCertCount((String)groupId, (int)collection.size());
        LOG.info("verifyCertForApply2: " + JSON.toJSONString((Object)checkCountMap));
        boolean forbidden = StringUtils.equals((CharSequence)((CharSequence)checkCountMap.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
        resultMap.put("result", !forbidden);
        resultMap.put("datas", collection);
        resultMap.put("msg", checkCountMap);
        checkCountMap.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)checkCountMap.get("infoType")));
        resultMap.put("isforbidden", forbidden);
        LOG.info("verifyCertForApplyresultMap3: " + JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    public static List<Long> verifyListCertReturnNeed(String appId, String formId, List<Long> pids) {
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        Set<Long> hasCertPid = WTCCertCommonHelper.checkForged(appId, formId, pids, groupId);
        List collection = ListUtils.removeAll(pids, hasCertPid);
        return collection;
    }

    public static Map<String, Object> verifySize(String appId, String formId, int size) {
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        Map checkCountMap = HRCertCommonHelper.verifyCertCount((String)groupId, (int)size);
        LOG.info("verifyCertForApply2: " + JSON.toJSONString((Object)checkCountMap));
        boolean forbidden = StringUtils.equals((CharSequence)((CharSequence)checkCountMap.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
        resultMap.put("result", !forbidden);
        resultMap.put("datas", new ArrayList());
        resultMap.put("msg", checkCountMap);
        checkCountMap.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)checkCountMap.get("infoType")));
        resultMap.put("isforbidden", forbidden);
        LOG.info("verifyCertForApplyresultMap3: " + JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    public static void verifyFakeCert(String appId, String formId, List<Long> pids) {
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        WTCCertCommonHelper.checkForged(appId, formId, pids, groupId);
    }

    public static Map<String, Object> updateCert(String appId, String formId, List<Long> pids) {
        WTCCertCommonHelper.checkWhiteList(true);
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        Set<Long> hasCertPid = WTCCertCommonHelper.checkForged(appId, formId, pids, groupId);
        List collection = ListUtils.removeAll(pids, hasCertPid);
        ArrayList leftPidForApply = Lists.newArrayList((Iterable)collection);
        Map map = HRCertCommonHelper.updateUsedCertCount((String)appId, (String)formId, (int)collection.size());
        LOG.info("updateCert: " + JSON.toJSONString((Object)map));
        WTCCertCommonHelper.generateCertDetail(groupId, leftPidForApply, true);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)5);
        resultMap.put("result", Boolean.TRUE);
        resultMap.put("datas", Collections.emptyList());
        resultMap.put("msg", map);
        map.put("showMessageType", WTCCertCommonHelper.calcShowMessageTypeWithInfoType((String)map.get("infoType")));
        resultMap.put("isforbidden", Boolean.FALSE);
        LOG.info("updateCertresultMap: " + JSON.toJSONString((Object)resultMap));
        return resultMap;
    }

    public static void releaseCert(String appId, String formId, List<Long> pids) {
        WTCCertCommonHelper.checkWhiteList(true);
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        WTCCertCommonHelper.deleteCertDetail(groupId, pids);
    }

    public static Set<Long> checkForged(String appId, String formId, List<Long> pids, String groupId) {
        DynamicObject[] details = WTCCertCommonHelper.queryCertDetail(appId, formId, pids);
        boolean isForged = false;
        String accountId = RequestContext.get().getAccountId();
        HashSet hasCertPid = Sets.newHashSetWithExpectedSize((int)pids.size());
        for (DynamicObject detail : details) {
            long pid = detail.getLong("pid");
            String pidStr = String.valueOf(pid);
            String shaStr = detail.getString("shastr");
            String salt = WTCCertCommonHelper.generalSaltKey(pidStr, groupId, accountId);
            if (StringUtils.isEmpty((CharSequence)shaStr) || !StringUtils.equals((CharSequence)HRBizCertSignHelper.getSignData((String)pidStr, (String)salt), (CharSequence)shaStr)) {
                isForged = true;
                break;
            }
            hasCertPid.add(pid);
        }
        if (isForged) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u52a0\u5bc6\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u8ba1\u7b97\u3002\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"WTCCertCommonHelper_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        return hasCertPid;
    }

    public static String calcShowMessageTypeWithInfoType(String infoType) {
        String showMessageType = "2";
        if (StringUtils.equals((CharSequence)infoType, (CharSequence)HRCertPromptInfoTypeEnum.WARNING.getName()) || StringUtils.equals((CharSequence)infoType, (CharSequence)HRCertPromptInfoTypeEnum.EXCEED.getName())) {
            showMessageType = "2";
        }
        if (StringUtils.equals((CharSequence)infoType, (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            showMessageType = "1";
        }
        return showMessageType;
    }

    public static DynamicObject[] generateCertDetail(String groupId, List<Long> pids, boolean save) {
        QFilter qFilterIds = new QFilter("personindexid", "in", pids);
        QFilter qFilterVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] personObjs = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid", (QFilter[])new QFilter[]{qFilterIds, qFilterVersion});
        Map<Long, Long> personindexid = Arrays.stream(personObjs).collect(Collectors.groupingBy(dyn -> dyn.getLong("personindexid"), Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getLong("id") : 0L)));
        List<DynamicObject> rows = WTCCertCommonHelper.packageCertDyn(groupId, pids, personindexid);
        DynamicObject[] dynamicObjects = rows.toArray(new DynamicObject[0]);
        if (save) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        return rows.toArray(new DynamicObject[0]);
    }

    private static List<DynamicObject> packageCertDyn(String groupId, List<Long> pids, Map<Long, Long> personindexid) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)WORKHOUR_CERTENTITY);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)pids.size());
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        for (Long pid : pids) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entityType);
            String pidStr = String.valueOf(pid);
            String salt = WTCCertCommonHelper.generalSaltKey(pidStr, groupId, accountId);
            String signData = HRBizCertSignHelper.getSignData((String)pidStr, (String)salt);
            row.set("pid", (Object)pid);
            row.set("shastr", (Object)signData);
            row.set("groupid", (Object)groupId);
            row.set("personid", (Object)personindexid.get(pid));
            rows.add(row);
        }
        return rows;
    }

    public static void deleteCertDetail(String groupId, List<Long> pids) {
        QFilter pidFilter = new QFilter("pid", "in", pids);
        QFilter groupFilter = new QFilter("groupid", "=", (Object)groupId);
        DeleteServiceHelper.delete((String)WORKHOUR_CERTENTITY, (QFilter[])new QFilter[]{pidFilter, groupFilter});
    }

    public static DynamicObject[] queryCertDetail(String appId, String formId, List<Long> pids) {
        LOG.info("WTCCertCommonHelper.queryCertDetail:{}", (Object)System.currentTimeMillis());
        String groupId = HRCertCommonHelper.getGroupIdByBizObjID((String)appId, (String)formId);
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        QFilter pidFilter = new QFilter("pid", "in", pids);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)WORKHOUR_CERTENTITY, (String)"id,pid,shastr,", (QFilter[])new QFilter[]{groupFilter, pidFilter});
        LOG.info("WTCCertCommonHelper.queryCertDetail:{}", (Object)System.currentTimeMillis());
        return objects;
    }

    private static void checkWhiteList(boolean ignore) {
        if (ignore) {
            return;
        }
        ArrayList whiteList = Lists.newArrayList();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Set stackClass = Arrays.stream(stackTrace).map(StackTraceElement::getClassName).collect(Collectors.toSet());
        boolean exist = false;
        for (String s : whiteList) {
            if (!stackClass.contains(s)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            throw new KDBizException(ResManager.loadKDString((String)"HRLicenseManage error: current call is not allowed.", (String)"WTCCertCommonHelper_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    public static Map<String, Object> certCheckNoAddByAttPerson(String appid, String formId, List<Long> attpersonIds) {
        Map<Long, Long> att2HrPersonId = WTCCertCommonHelper.convertPersonId(attpersonIds);
        Map<String, Object> res = WTCCertCommonHelper.verifyCert(appid, formId, Lists.newArrayList(att2HrPersonId.values()));
        List datas = (List)res.get("datas");
        if (datas != null && datas.size() > 0) {
            ArrayList attPersonIds = new ArrayList(datas.size());
            for (Long data : datas) {
                att2HrPersonId.forEach((key, value) -> {
                    if (value.equals(data)) {
                        attPersonIds.add(key);
                    }
                });
            }
            res.put("datas", attPersonIds);
        }
        return res;
    }

    public static Map<String, Object> certCheckByAttPerson(String appid, String formId, List<Long> attpersonIds) {
        Map<Long, Long> att2HrPersonId = WTCCertCommonHelper.convertPersonId(attpersonIds);
        return WTCCertCommonHelper.verifyCertForApply(appid, formId, Lists.newArrayList(att2HrPersonId.values()));
    }

    public static void certFakeCheckByAttPerson(String appid, String formId, List<Long> attpersonIds) {
        Map<Long, Long> att2HrPersonId = WTCCertCommonHelper.convertPersonId(attpersonIds);
        WTCCertCommonHelper.verifyFakeCert(appid, formId, Lists.newArrayList(att2HrPersonId.values()));
    }

    @Deprecated
    public static Map<String, Object> CertAddByAttPerson(String appid, String formId, List<Long> attpersonIds) {
        return WTCCertCommonHelper.certAddByAttPersonIds(appid, formId, attpersonIds);
    }

    public static Map<String, Object> certAddByAttPersonIds(String appid, String formId, List<Long> attpersonIds) {
        Map<Long, Long> att2HrPersonId = WTCCertCommonHelper.convertPersonId(attpersonIds);
        return WTCCertCommonHelper.updateCert(appid, formId, Lists.newArrayList(att2HrPersonId.values()));
    }

    @Deprecated
    public static void CertDeleteByAttPerson(String appid, String formId, List<Long> attpersonIds) {
        WTCCertCommonHelper.certDeleteByAttPersonIds(appid, formId, attpersonIds);
    }

    public static void certDeleteByAttPersonIds(String appid, String formId, List<Long> attpersonIds) {
        Map<Long, Long> att2HrPersonId = WTCCertCommonHelper.convertPersonId(attpersonIds);
        WTCCertCommonHelper.releaseCert(appid, formId, Lists.newArrayList(att2HrPersonId.values()));
    }

    public static Map<Long, Long> convertPersonId(List<Long> attpersonIds) {
        LOG.info("convertPersonId start:{}", (Object)System.currentTimeMillis());
        QFilter qFilter = new QFilter("id", "in", attpersonIds);
        DynamicObject[] hrpiPeople = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> personindexid = Arrays.stream(hrpiPeople).collect(Collectors.groupingBy(dyn -> dyn.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getLong("personindexid") : 0L)));
        LOG.info("convertPersonId after:{}", (Object)System.currentTimeMillis());
        return personindexid;
    }

    private static String generalSaltKey(String pidStr, String groupId, String accountId) {
        return MessageFormat.format(SALT_PATTEN, pidStr, groupId, accountId);
    }

    public static DynamicObject[] queryCertDetailByGroupId(String groupId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(WORKHOUR_CERTENTITY);
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        DynamicObject[] objects = baseServiceHelper.query("id,pid,shastr", new QFilter[]{groupFilter});
        return objects;
    }

    public static void updateCertInfoShaStr(String groupId) {
        Map map = HRCertCommonHelper.verifyCertCount((String)groupId);
        if (null == map || StringUtils.equals((CharSequence)((CharSequence)map.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            LOG.info("verifyCertCount return is FORBIDDEN");
            return;
        }
        DynamicObject[] dynamicObjects = WTCCertCommonHelper.queryCertDetailByGroupId(groupId);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        String accountId = RequestContext.get().getAccountId();
        for (DynamicObject detail : dynamicObjects) {
            String salt;
            String pidStr = detail.getString("pid");
            String correctShaStr = HRBizCertSignHelper.getSignData((String)pidStr, (String)(salt = WTCCertCommonHelper.generalSaltKey(pidStr, groupId, accountId)));
            if (StringUtils.equals((CharSequence)correctShaStr, (CharSequence)detail.getString("shastr"))) continue;
            detail.set("shastr", (Object)correctShaStr);
            rows.add(detail);
        }
        if (!rows.isEmpty()) {
            WTCCertCommonHelper.updateCertInfo(rows.toArray(new DynamicObject[0]));
            LOG.info("total updateCertInfoShaStr number is {}", (Object)rows.size());
        }
    }

    private static void updateCertInfo(DynamicObject[] dynamicObjects) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(WORKHOUR_CERTENTITY);
        baseServiceHelper.updateDatas(dynamicObjects);
    }

    public static boolean checkGroupExist(String groupId) {
        return HRCertCommonHelper.getPurchaseCount((String)groupId) >= 1;
    }
}

