/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.log;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.log.WTCAppLogInfo;

public class WTCAppOperationLog {
    private static final Log LOG = LogFactory.getLog(WTCAppOperationLog.class);

    public static void addOperateLog(WTCAppLogInfo wtcAppLogInfo) {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            OpLogAppInfo logInfo = WTCAppOperationLog.buildLogInfo(wtcAppLogInfo);
            logService.addLog((AppLogInfo)logInfo);
        }
        catch (Exception ex) {
            LOG.info("WTCAppOperationLog.addOperateLog error");
        }
    }

    private static OpLogAppInfo buildLogInfo(WTCAppLogInfo wtcAppLogInfo) {
        AppInfo appInfo;
        OpLogAppInfo logInfo = new OpLogAppInfo();
        RequestContext requestContext = RequestContext.get();
        logInfo.setUserID(Long.valueOf(requestContext.getCurrUserId()));
        String appId = "";
        String appNumber = wtcAppLogInfo.getAppNumber();
        if (HRStringUtils.isNotEmpty((String)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        logInfo.setBizAppID(appId);
        String entityNumber = wtcAppLogInfo.getEntityNumber();
        logInfo.setBizObjID(entityNumber);
        logInfo.setOrgID(Long.valueOf(requestContext.getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType("web");
        String loginIP = wtcAppLogInfo.getLoginIp();
        logInfo.setClientIP(loginIP);
        String opKey = wtcAppLogInfo.getOpKey();
        AbstractOperate abstractOperate = (AbstractOperate)FormMetadataCache.getFormOperation((String)entityNumber, (String)opKey);
        if (abstractOperate != null) {
            logInfo.setOpName(abstractOperate.getOperateKey(), abstractOperate.getOperateName().getLocaleValue_zh_CN());
        } else {
            logInfo.setOpName(opKey);
        }
        String msg = wtcAppLogInfo.getLog();
        logInfo.setOpDescription(msg);
        return logInfo;
    }
}

