/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.match.MatchService;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionHelper;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.business.personfilter.utils.WTCBooleanPareUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class MatchServiceImpl
implements MatchService {
    private static final Log LOG = LogFactory.getLog(MatchServiceImpl.class);

    @Override
    public JudgeResult judge(LinkedHashMap<Long, Map<String, Object>> datas, String conditionJson) {
        if (datas == null || datas.size() == 0) {
            return null;
        }
        RuleConditionInfo accessDto = this.getRuleCondition(conditionJson);
        if (accessDto == null) {
            return null;
        }
        ArrayList mathedList = Lists.newArrayList();
        List conditionList = accessDto.getConditionList();
        Set<Map.Entry<Long, Map<String, Object>>> entries = datas.entrySet();
        for (Map.Entry<Long, Map<String, Object>> entry : entries) {
            Long id = entry.getKey();
            Map<String, Object> params = entry.getValue();
            this.parseAndJudge(params, mathedList, id, accessDto, conditionList);
        }
        return MatchServiceImpl.packageJudgeResult(mathedList);
    }

    @Override
    public JudgeResult judgeBySingle(Map<String, Object> data, String conditionJson) {
        if (data == null || data.size() == 0) {
            return null;
        }
        RuleConditionInfo accessDto = this.getRuleCondition(conditionJson);
        if (accessDto == null) {
            return null;
        }
        ArrayList mathedList = Lists.newArrayList();
        List conditionList = accessDto.getConditionList();
        Long id = 0L;
        this.parseAndJudge(data, mathedList, id, accessDto, conditionList);
        return MatchServiceImpl.packageJudgeResult(mathedList);
    }

    @Override
    public JudgeResult judgeByData(LinkedHashMap<Long, String> conditions, Map<String, Object> data) {
        ArrayList mathedList = Lists.newArrayList();
        conditions.forEach((id, condition) -> {
            RuleConditionInfo accessDto = this.getRuleCondition((String)condition);
            if (accessDto == null) {
                return;
            }
            List conditionList = accessDto.getConditionList();
            this.parseAndJudge(data, mathedList, (Long)id, accessDto, conditionList);
        });
        return MatchServiceImpl.packageJudgeResult(mathedList);
    }

    @Override
    public QFilter buildQFilterByCondition(RuleConditionInfo accessDto, String prefix) {
        Map<String, QFilter> map = JudgeConditionService.packageQFilter(accessDto, prefix);
        QFilter qFilter = JudgeConditionService.parseQFilter(map, accessDto.getConditionExpressStr());
        return qFilter;
    }

    public void parseAndJudge(Map<String, Object> data, List<Long> mathedList, Long id, RuleConditionInfo accessDto, List<ConditionInfo> conditionList) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)data.size());
        if (conditionList == null || conditionList.size() == 0) {
            mathedList.add(id);
            return;
        }
        conditionList.forEach(conditionDto -> JudgeConditionHelper.judgeCondition(data, resultMap, conditionDto));
        StringBuilder expressStr = MatchServiceImpl.getExpressStr(resultMap, accessDto.getConditionExpressList());
        try {
            if (WTCBooleanPareUtils.dealBrackets(String.valueOf(expressStr))) {
                mathedList.add(id);
            }
        }
        catch (Exception e) {
            LOG.error("JudgeConditionService dealBrackets error id:{},expressStr:{},error{}", new Object[]{id, expressStr, e});
        }
    }

    private static JudgeResult packageJudgeResult(List<Long> mathedList) {
        JudgeResult judgeResult = new JudgeResult();
        if (mathedList.size() > 0) {
            judgeResult.setMatched(true);
            judgeResult.setMatchedList(mathedList);
        } else {
            judgeResult.setMatched(false);
        }
        return judgeResult;
    }

    public static StringBuilder getExpressStr(Map<String, Boolean> resultMap, List<ConditionExpressInfo> conditionExpressList) {
        StringBuilder sb = new StringBuilder();
        for (ConditionExpressInfo conditionExpressInfo : conditionExpressList) {
            Boolean result;
            String leftBracket = conditionExpressInfo.getLeftBracket();
            String name = conditionExpressInfo.getName();
            String rightBracket = conditionExpressInfo.getRightBracket();
            String logical = conditionExpressInfo.getLogical();
            if (WTCStringUtils.isNotEmpty((String)leftBracket)) {
                sb.append(leftBracket);
            }
            if ((result = resultMap.get(name)) == null) {
                result = Boolean.FALSE;
            }
            sb.append(result);
            if (WTCStringUtils.isNotEmpty((String)rightBracket)) {
                sb.append(rightBracket);
            }
            if (!WTCStringUtils.isNotEmpty((String)logical)) continue;
            if (WTCStringUtils.equals((String)"and", (String)(logical = logical.replaceAll(" ", "")))) {
                sb.append('&');
                continue;
            }
            sb.append('|');
        }
        return sb;
    }

    public static Map<String, Object> checkConfigJson(String configJson) {
        HashMap resMap = Maps.newHashMap();
        resMap.put("isSucess", Boolean.TRUE);
        boolean checkRes = true;
        try {
            RuleConditionInfo accessDto = (RuleConditionInfo)SerializationUtils.fromJsonString((String)configJson, RuleConditionInfo.class);
            List conditionExpressList = accessDto.getConditionExpressList();
            List conditionList = accessDto.getConditionList();
            for (ConditionInfo conditionDto : conditionList) {
                boolean emptyCheck;
                String value = conditionDto.getValue();
                String param = conditionDto.getParam();
                String operators = conditionDto.getOperators();
                boolean needCheckNull = RuleOperatorEnum.IS_NULL.getValue().equals(operators) || RuleOperatorEnum.IS_NOT_NULL.getValue().equals(operators);
                boolean bl = emptyCheck = HRStringUtils.isEmpty((String)value) || HRStringUtils.isEmpty((String)param) || HRStringUtils.isEmpty((String)operators);
                if (needCheckNull && HRStringUtils.isEmpty((String)param)) {
                    checkRes = false;
                    continue;
                }
                if (needCheckNull || !emptyCheck) continue;
                checkRes = false;
                break;
            }
            block3: for (ConditionExpressInfo expressType : conditionExpressList) {
                String rightBracket;
                String leftBracket = expressType.getLeftBracket();
                if (HRStringUtils.isNotEmpty((String)leftBracket)) {
                    for (int i = 0; i < leftBracket.length(); ++i) {
                        if (leftBracket.charAt(i) == '(' || leftBracket.charAt(i) == ' ') continue;
                        checkRes = false;
                        break;
                    }
                }
                if (!HRStringUtils.isNotEmpty((String)(rightBracket = expressType.getRightBracket()))) continue;
                for (int i = 0; i < rightBracket.length(); ++i) {
                    if (rightBracket.charAt(i) == ')' || rightBracket.charAt(i) == ' ') continue;
                    checkRes = false;
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            LOG.error("JsonProcessingException:", (Throwable)e);
            checkRes = false;
        }
        if (!checkRes) {
            resMap.put("isSucess", Boolean.FALSE);
            resMap.put("errorMsg", ResManager.loadKDString((String)"\u6761\u4ef6\u9879\u4e0d\u5b8c\u6574\u6216\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JudgeConditionService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        return resMap;
    }

    @Override
    public RuleConditionInfo getRuleCondition(String conditionJson) {
        RuleConditionInfo accessDto = null;
        try {
            accessDto = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class);
        }
        catch (Exception e) {
            LOG.warn("JsonProcessingException", (Throwable)e);
        }
        return accessDto;
    }

    @Override
    public JudgeResult judgeForCycle(LinkedHashMap<Long, Map<String, Object>> datas, RuleConditionInfo accessDto) {
        if (datas == null || datas.size() == 0 || accessDto == null) {
            return null;
        }
        ArrayList mathedList = Lists.newArrayList();
        List conditionList = accessDto.getConditionList();
        Set<Map.Entry<Long, Map<String, Object>>> entries = datas.entrySet();
        for (Map.Entry<Long, Map<String, Object>> entry : entries) {
            Long id = entry.getKey();
            Map<String, Object> params = entry.getValue();
            this.parseAndJudge(params, mathedList, id, accessDto, conditionList);
        }
        return MatchServiceImpl.packageJudgeResult(mathedList);
    }

    public static QFilter parseQFilter(Map<String, QFilter> params, String pattern) {
        String str = pattern.replaceAll(" +", "").replaceAll("and", "&").replace("or", "|");
        char[] charArr = str.toCharArray();
        Stack<Object> stack = new Stack<Object>();
        int idx = 0;
        int len = charArr.length;
        while (idx < len) {
            QFilter qFilter2;
            char cc = charArr[idx];
            if (cc == '|' || cc == '&' || cc == '(') {
                stack.add(Character.valueOf(cc));
                ++idx;
                continue;
            }
            if (cc == 'T') {
                int tEnd = MatchServiceImpl.findTEnd(charArr, idx);
                qFilter2 = params.get(new String(charArr, idx, tEnd - idx));
                MatchServiceImpl.pushQFilter(stack, qFilter2);
                idx = tEnd;
                continue;
            }
            if (cc != ')') continue;
            Stack<QFilter> tmp = new Stack<QFilter>();
            while (!stack.isEmpty()) {
                Object pop = stack.pop();
                if (pop instanceof Character) {
                    if (((Character)pop).charValue() != '(') continue;
                    break;
                }
                tmp.add((QFilter)pop);
            }
            qFilter2 = null;
            while (!tmp.isEmpty()) {
                qFilter2 = qFilter2 == null ? (QFilter)tmp.pop() : qFilter2.or((QFilter)tmp.pop());
            }
            MatchServiceImpl.pushQFilter(stack, qFilter2);
            ++idx;
        }
        List allQFilter = stack.stream().filter(obj -> obj instanceof QFilter).map(qFilter -> (QFilter)qFilter).collect(Collectors.toList());
        QFilter res = null;
        for (QFilter qFilter3 : allQFilter) {
            if (res == null) {
                res = qFilter3;
                continue;
            }
            res.or(qFilter3);
        }
        return res;
    }

    private static void pushQFilter(Stack<Object> stack, QFilter qFilter) {
        Character peek;
        if (!stack.isEmpty() && (peek = (Character)stack.peek()).charValue() == '&') {
            stack.pop();
            qFilter = ((QFilter)stack.pop()).and(qFilter);
        }
        stack.add(qFilter);
    }

    private static int findTEnd(char[] arr, int beginIdx) {
        int end;
        for (end = beginIdx + 1; end < arr.length && arr[end] >= '0' && arr[end] <= '9'; ++end) {
        }
        return end;
    }
}

