/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.match.MatchService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCMatchingUtils {
    private static final Log LOG = LogFactory.getLog(WTCMatchingUtils.class);
    private static MatchService matchBean = (MatchService)WTCAppContextHelper.getBean((String)"kd.wtc.wtbs.business.match.MatchServiceImpl", MatchService.class);

    public static JudgeResult matchDataByCondition(LinkedHashMap<Long, Map<String, Object>> datas, String conditionJson) {
        LOG.debug("WTCMatchingUtils.matchDataByCondition:{}", (Object)conditionJson);
        JudgeResult res = matchBean.judge(datas, conditionJson);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WTCMatchingUtils.matchDataByCondition.result:{}", (Object)res);
        }
        return res;
    }

    public static JudgeResult matchDataByConditionForCycle(LinkedHashMap<Long, Map<String, Object>> datas, RuleConditionInfo accessDto) {
        LOG.debug("WTCMatchingUtils.matchDataByCondition:{}", (Object)accessDto);
        JudgeResult res = matchBean.judgeForCycle(datas, accessDto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WTCMatchingUtils.matchDataByCondition.result:{}", (Object)res);
        }
        return res;
    }

    public static JudgeResult matchConditionByData(LinkedHashMap<Long, String> conditions, Map<String, Object> data) {
        LOG.debug("WTCMatchingUtils.matchConditionByData:{}", conditions);
        JudgeResult res = matchBean.judgeByData(conditions, data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WTCMatchingUtils.matchDataByCondition.result:{}", (Object)res);
        }
        return res;
    }

    public static QFilter buildQFilterByCondition(RuleConditionInfo accessDto, String prefix) {
        LOG.debug("WTCMatchingUtils.buildQFilterByCondition:{},{}", (Object)accessDto, (Object)prefix);
        QFilter qFilter = matchBean.buildQFilterByCondition(accessDto, prefix);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WTCMatchingUtils.buildQFilterByCondition.result:{}", (Object)(qFilter == null ? "" : qFilter.toString()));
        }
        return qFilter;
    }

    public static LinkedHashMap<Long, Map<String, Object>> dyn2matchData(List<DynamicObject> dynamicObjects, String conditionJson) {
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return new LinkedHashMap<Long, Map<String, Object>>();
        }
        RuleConditionInfo accessDto = matchBean.getRuleCondition(conditionJson);
        if (accessDto == null) {
            return null;
        }
        List conditionList = accessDto.getConditionList();
        HashMap param2Column = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        for (ConditionInfo conditionInfo : conditionList) {
            String param = conditionInfo.getParam();
            String paramType = conditionInfo.getParamType();
            if (HRStringUtils.equals((String)paramType, (String)"dynamicObject")) {
                String[] split = param.split("\\.");
                ArrayList columns = Lists.newArrayListWithExpectedSize((int)split.length);
                for (int i = 2; i < split.length; ++i) {
                    columns.add(split[i]);
                }
                param2Column.put(param, String.join((CharSequence)".", columns));
                continue;
            }
            String column = param.substring(param.lastIndexOf(46) + 1);
            param2Column.put(param, column);
        }
        LinkedHashMap<Long, Map<String, Object>> res = new LinkedHashMap<Long, Map<String, Object>>(dynamicObjects.size());
        dynamicObjects.forEach(dyn -> {
            Set entries = param2Column.entrySet();
            Iterator iterator = entries.iterator();
            HashMap data = new HashMap(entries.size());
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String column = (String)next.getValue();
                Object value = dyn.get(column);
                if (value == null && column.contains(".")) {
                    column = column.substring(0, column.indexOf(46));
                    value = dyn.get(column);
                }
                data.put(next.getKey(), value);
            }
            res.put(dyn.getLong("id"), data);
        });
        return res;
    }

    public static JudgeResult matchDataBySingleCondition(List<DynamicObject> dynamicObjects, String conditionJson) {
        LOG.debug("WTCMatchingUtils.matchDataBySingleCondition:{}", (Object)conditionJson);
        LinkedHashMap<Long, Map<String, Object>> linkedHashMap = WTCMatchingUtils.dyn2matchData(dynamicObjects, conditionJson);
        JudgeResult res = matchBean.judge(linkedHashMap, conditionJson);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WTCMatchingUtils.matchDataBySingleCondition.result:{}", (Object)res);
        }
        return res;
    }
}

