/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.mobile;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.bill.BillApplyTypePlusEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BillButtonHiddenService {
    private static final Log logger = LogFactory.getLog(BillButtonHiddenService.class);

    public static BillButtonHiddenService getInstance() {
        return Instance.INSTANCE;
    }

    private BillButtonHiddenService() {
    }

    public void showButton(boolean pcClient, IFormView view, Map<BillButtonNameEnum, String> buttonMap) {
        logger.info("BillButtonHiddenService.showButton,entityid:{}", (Object)view.getFormShowParameter().getFormId());
        DynamicObject dy = view.getModel().getDataEntity();
        String applyType = dy.getString("applytyperadio");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (BillApplyTypeEnum.BATCH.getCode().equals(applyType)) {
            view.setVisible(Boolean.FALSE, buttonMap.values().toArray(new String[0]));
            view.setVisible(Boolean.FALSE, new String[]{"approvalflex"});
            formShowParameter.setStatus(OperationStatus.VIEW);
            return;
        }
        Map customParams = formShowParameter.getCustomParams();
        String sourceApp = (String)customParams.get("sourceApp");
        ButtonVisibleScheme buttonVisibleScheme = this.getButtonStatus(pcClient, sourceApp, dy, view);
        if (buttonVisibleScheme != null) {
            buttonMap.forEach((buttonKey, buttonValue) -> view.setVisible(Boolean.valueOf(this.isShow((BillButtonNameEnum)((Object)buttonKey), buttonVisibleScheme)), new String[]{buttonValue}));
        }
    }

    private ButtonVisibleScheme getButtonStatus(boolean pcClient, String sourceApp, DynamicObject billDy, IFormView view) {
        if (StringUtils.isBlank((CharSequence)sourceApp) || billDy == null) {
            return null;
        }
        String billStatus = billDy.getString("billstatus");
        Long userId = BillUnifyService.getUserId(view);
        return new ButtonVisibleScheme(pcClient, sourceApp, billStatus, BillCommonService.getInstance().getBillApplyTypePlus(billDy, userId));
    }

    private boolean isShow(BillButtonNameEnum buttonNameEnum, ButtonVisibleScheme buttonVisibleScheme) {
        boolean show = false;
        switch (buttonNameEnum) {
            case SAVE: {
                show = buttonVisibleScheme.showSave();
                break;
            }
            case SUBMIT: {
                show = buttonVisibleScheme.showSubmit();
                break;
            }
            case SUBMIT_EFFECT: {
                show = buttonVisibleScheme.showSubmitEffect();
                break;
            }
            case MODIFY: {
                show = buttonVisibleScheme.showModify();
                break;
            }
            case UNSUBMIT: {
                show = buttonVisibleScheme.showUnSubmit();
                break;
            }
            case CHANGE: {
                show = buttonVisibleScheme.showChange();
                break;
            }
            case DELETE: {
                show = buttonVisibleScheme.showDelete();
                break;
            }
            case FLOW_CHART: {
                show = buttonVisibleScheme.showViewFlowChart();
                break;
            }
            case CLOSE: {
                show = buttonVisibleScheme.showClose();
            }
        }
        return show;
    }

    public static enum BillButtonNameEnum {
        SAVE,
        SUBMIT,
        SUBMIT_EFFECT,
        MODIFY,
        UNSUBMIT,
        CHANGE,
        DELETE,
        FLOW_CHART,
        CLOSE;

    }

    private static class ButtonVisibleScheme {
        private boolean save;
        private boolean submit;
        private boolean submitEffect;
        private boolean modify;
        private boolean unSubmit;
        private boolean change;
        private boolean delete;
        private boolean viewFlowChart;
        private boolean close;

        private ButtonVisibleScheme(boolean pcClint, String sourceApp, String billStatus, BillApplyTypePlusEnum applyType) {
            if (!pcClint) {
                if ("myTime".equals(sourceApp)) {
                    this.buildForMyTime(billStatus, applyType);
                } else if ("teamTime".equals(sourceApp)) {
                    this.buildForTeamTime(billStatus, applyType);
                } else {
                    this.buildForThirdParty(billStatus, applyType);
                }
            }
        }

        private void buildForMyTime(String billStatus, BillApplyTypePlusEnum applyTypeEnum) {
            List<BillApplyTypePlusEnum> myCreate = Arrays.asList(BillApplyTypePlusEnum.ME_FOR_SELF, BillApplyTypePlusEnum.ME_FOR_OTHER);
            switch (billStatus) {
                case "A": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.submit = true;
                    this.modify = true;
                    this.delete = true;
                    break;
                }
                case "D": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.unSubmit = true;
                    break;
                }
                case "C": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.change = true;
                    break;
                }
                case "G": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.submit = true;
                    this.modify = true;
                }
            }
        }

        private void buildForTeamTime(String billStatus, BillApplyTypePlusEnum applyTypeEnum) {
            List<BillApplyTypePlusEnum> myCreate = Arrays.asList(BillApplyTypePlusEnum.ME_FOR_SELF, BillApplyTypePlusEnum.ME_FOR_OTHER);
            switch (billStatus) {
                case "A": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.submit = true;
                    this.modify = true;
                    this.delete = true;
                    break;
                }
                case "D": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.unSubmit = true;
                    break;
                }
                case "C": {
                    if (!Arrays.asList(BillApplyTypePlusEnum.OTHER_FOR_HERSELF, BillApplyTypePlusEnum.OTHER_FOR_OTHER, BillApplyTypePlusEnum.ME_FOR_OTHER).contains(applyTypeEnum)) break;
                    this.change = true;
                    break;
                }
                case "G": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.submit = true;
                    this.modify = true;
                }
            }
        }

        private void buildForThirdParty(String billStatus, BillApplyTypePlusEnum applyTypeEnum) {
            List<BillApplyTypePlusEnum> myCreate = Arrays.asList(BillApplyTypePlusEnum.ME_FOR_SELF, BillApplyTypePlusEnum.ME_FOR_OTHER);
            switch (billStatus) {
                case "A": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.submit = true;
                    this.modify = true;
                    this.delete = true;
                    break;
                }
                case "D": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.unSubmit = true;
                    break;
                }
                case "C": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.change = true;
                    break;
                }
                case "G": {
                    if (!myCreate.contains(applyTypeEnum)) break;
                    this.submit = true;
                    this.modify = true;
                }
            }
        }

        public boolean showSave() {
            return this.save;
        }

        public boolean showSubmit() {
            return this.submit;
        }

        public boolean showSubmitEffect() {
            return this.submitEffect;
        }

        public boolean showModify() {
            return this.modify;
        }

        public boolean showUnSubmit() {
            return this.unSubmit;
        }

        public boolean showChange() {
            return this.change;
        }

        public boolean showDelete() {
            return this.delete;
        }

        public boolean showViewFlowChart() {
            return this.viewFlowChart;
        }

        public boolean showClose() {
            return this.close;
        }
    }

    private static class Instance {
        private static BillButtonHiddenService INSTANCE = new BillButtonHiddenService();

        private Instance() {
        }
    }
}

