/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.mobile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.mobile.BillContainerKDStringHelper;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BillContainerService {
    private static final Set<String> TEAM_SET = Sets.newHashSetWithExpectedSize((int)2);
    private static final Set<String> MYSELF_SET = Sets.newHashSetWithExpectedSize((int)2);

    public static BillContainerService getInstance() {
        return Instance.INSTANCE;
    }

    public void openContainer(String appId, Map<String, Object> customParams, String formId, IFormView view) {
        this.openContainer(appId, null, customParams, formId, view, null);
    }

    public void openContainer(String appId, Long pkId, Map<String, Object> customParams, String formId, IFormView view, IFormPlugin plugin) {
        boolean changeRightAppId;
        if (customParams == null) {
            customParams = new HashMap<String, Object>(4);
        }
        customParams.putIfAbsent("billType", this.getBillType(formId));
        customParams.putIfAbsent("isChange", Boolean.FALSE);
        customParams.putIfAbsent("billapplyType", 0);
        if (pkId != null && pkId != 0L) {
            customParams.put("billpkid", String.valueOf(pkId));
        }
        if (HRStringUtils.isNotEmpty((String)formId)) {
            customParams.put("billformid", formId);
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("wtbs_billcontainer");
        boolean otherFormId = MobileCommonServiceHelper.getInstance().isOtherFormId(formId);
        boolean bl = changeRightAppId = HRStringUtils.isEmpty((String)appId) || HRStringUtils.equals((String)"hssc", (String)appId) || HRStringUtils.equals((String)"wtss", (String)appId);
        if (otherFormId && changeRightAppId) {
            showParameter.setAppId("wtam");
            showParameter.setCustomParam("checkRightAppId", (Object)"wtam");
            appId = "wtam";
        }
        customParams.put("billappid", appId);
        showParameter.setHasRight(Boolean.TRUE.booleanValue());
        if (plugin != null) {
            showParameter.setCloseCallBack(new CloseCallBack(plugin, "actionid_billcontainer"));
        }
        customParams.forEach((kk, vv) -> showParameter.setCustomParam(kk, vv));
        view.showForm((FormShowParameter)showParameter);
    }

    public String checkRight(FormShowParameter formShowParameter) {
        long userId;
        int result;
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return null;
        }
        Integer billType = (Integer)customParams.get("billType");
        Boolean isChange = (Boolean)customParams.get("isChange");
        Integer applyType = (Integer)customParams.get("billapplyType");
        String targetEntityId = this.getBillTypePage(billType, isChange, applyType);
        String pkIdStr = (String)customParams.get("billpkid");
        String permissionItemId = HRStringUtils.isNotEmpty((String)pkIdStr) ? "47150e89000000ac" : "47156aff000000ac";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityId);
        PermissionControlType permissionControlType = mainEntityType.getPermissionControlType();
        String dimType = permissionControlType.getDimension();
        if (HRStringUtils.isEmpty((String)dimType)) {
            dimType = "DIM_ORG";
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String checkRightAppId = (String)formShowParameter.getCustomParam("checkRightAppId");
        if (HRStringUtils.isEmpty((String)checkRightAppId)) {
            checkRightAppId = (String)customParams.get("billappid");
        }
        if ((result = permissionService.checkPermission(userId = RequestContext.get().getCurrUserId(), dimType, 0L, checkRightAppId, targetEntityId, permissionItemId)) != 1) {
            String otherCaption = EntityMetadataCache.getDataEntityType((String)targetEntityId).getDisplayName().getLocaleValue();
            String permissionName = PermItemHelper.getPermItemNameById((String)permissionItemId);
            return BillContainerKDStringHelper.notRight(otherCaption, permissionName);
        }
        return null;
    }

    public String getCaption(FormShowParameter formShowParameter) {
        String caption = "";
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return caption;
        }
        Object obj = customParams.get("billcaption");
        if (!HRObjectUtils.isEmpty(obj)) {
            return (String)obj;
        }
        Integer billType = (Integer)customParams.get("billType");
        Boolean isChange = (Boolean)customParams.get("isChange");
        Integer applyType = (Integer)customParams.get("billapplyType");
        return this.getBillCaption(billType, isChange, applyType);
    }

    public void openBill(IFormView view) {
        String pkIdStr;
        BillUnifyService.getUserId(view);
        Map customParams = view.getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("billformid");
        MobileBillShowParameter showParameter = this.getDefaultMobileBill(formId);
        showParameter.setHasRight(true);
        if (HRStringUtils.isNotEmpty((String)formId)) {
            customParams.remove("billformid");
        }
        if (HRStringUtils.isNotEmpty((String)(pkIdStr = (String)customParams.get("billpkid")))) {
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setPkId((Object)Long.parseLong(pkIdStr));
            customParams.remove("billpkid");
        }
        customParams.forEach((kk, vv) -> showParameter.setCustomParam(kk, vv));
        view.showForm((FormShowParameter)showParameter);
    }

    @Deprecated
    public void OpenDetailPageOfSave(IFormView billView, String targetFormId, long pkId, Map<String, Object> customParams) {
        this.openBill(billView, targetFormId, pkId, customParams, BillOperationStatus.VIEW);
    }

    public void openDetailPageOfSave(IFormView billView, String targetFormId, long pkId, Map<String, Object> customParams) {
        this.openBill(billView, targetFormId, pkId, customParams, BillOperationStatus.VIEW);
    }

    public void openSuccessPage(IFormView billView, String applyName, String applyFormId, long applyPkId) {
        IFormView containerView = billView.getViewNoPlugin(billView.getFormShowParameter().getParentPageId());
        if (containerView == null) {
            return;
        }
        MobileFormShowParameter showParameter = this.getDefaultMobileForm("wtbs_submitfeedback", billView);
        showParameter.setCustomParam("wtc_mob_target_open_page_type", (Object)this.judeSource(billView));
        showParameter.setCustomParam("name", (Object)applyName);
        showParameter.setCustomParam("applyPkid", (Object)String.valueOf(applyPkId));
        showParameter.setCustomParam("applyFormId", (Object)applyFormId);
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        showParameter.setCaption(applyName);
        this.setCustomParam(billView, showParameter);
        containerView.showForm((FormShowParameter)showParameter);
        billView.sendFormAction(containerView);
    }

    public void returnHome(IFormView billView) {
        if (billView == null) {
            return;
        }
        IFormView bilContainView = billView.getViewNoPlugin(billView.getFormShowParameter().getParentPageId());
        if (bilContainView != null && HRStringUtils.equals((String)"wtbs_billcontainer", (String)bilContainView.getFormShowParameter().getFormId())) {
            Stack<IFormView> stack = new Stack<IFormView>();
            HashSet<String> homeSet = new HashSet<String>(2);
            homeSet.add("wtss_teamhomepage_m");
            homeSet.add("wtss_mobilehomepage");
            for (IFormView parentView = billView; parentView != null && !homeSet.contains(parentView.getFormShowParameter().getFormId()); parentView = parentView.getParentView()) {
                stack.push(parentView);
            }
            while (!stack.empty()) {
                IFormView pop = (IFormView)stack.pop();
                pop.close();
                billView.sendFormAction(pop);
            }
            return;
        }
        if (bilContainView != null) {
            bilContainView.close();
            billView.sendFormAction(bilContainView);
        }
    }

    public void openDetailPageOfView(IFormView successPageView) {
        IFormView containerView = successPageView.getViewNoPlugin(successPageView.getFormShowParameter().getParentPageId());
        if (containerView == null) {
            return;
        }
        Map customParams = successPageView.getFormShowParameter().getCustomParams();
        String applyFormId = (String)customParams.get("applyFormId");
        String applyPkId = (String)customParams.get("applyPkid");
        MobileBillShowParameter showParameter = this.getDefaultMobileBill(applyFormId, successPageView);
        showParameter.setPkId((Object)applyPkId);
        showParameter.setCustomParam("flagWorkFlow", (Object)Boolean.FALSE);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        this.setCustomParam(successPageView, showParameter, applyFormId);
        containerView.showForm((FormShowParameter)showParameter);
        successPageView.sendFormAction(containerView);
    }

    public void openChangePage(IFormView billView, String targetFormId, Map<String, Object> customParams) {
        IFormView containerView = billView.getViewNoPlugin(billView.getFormShowParameter().getParentPageId());
        if (containerView == null) {
            return;
        }
        MobileBillShowParameter showParameter = this.getDefaultMobileBill(targetFormId, billView);
        if (customParams != null && !customParams.isEmpty()) {
            customParams.forEach((kk, vv) -> showParameter.setCustomParam(kk, vv));
        }
        this.setCustomParam(billView, showParameter, targetFormId);
        containerView.showForm((FormShowParameter)showParameter);
        billView.sendFormAction(containerView);
    }

    public void openEditPage(IFormView billView, String targetFormId, long pkId, Map<String, Object> customParams) {
        this.openBill(billView, targetFormId, pkId, customParams, BillOperationStatus.EDIT);
    }

    public void returnSource(IFormView billView) {
        String parentFormId;
        if (billView == null) {
            return;
        }
        IFormView billContainView = billView.getViewNoPlugin(billView.getFormShowParameter().getParentPageId());
        if (billContainView != null && HRStringUtils.equals((String)"wtbs_billcontainer", (String)(parentFormId = billContainView.getFormShowParameter().getFormId()))) {
            billContainView.close();
            billView.sendFormAction(billContainView);
        }
    }

    public void openDetailPage(IFormView billView, String targetFormId, long pkId, Map<String, Object> customParams) {
        this.openBill(billView, targetFormId, pkId, customParams, BillOperationStatus.VIEW);
    }

    private String getBillTypePage(Integer bileType, boolean isChange, Integer applyType) {
        boolean isChangePage = (bileType == 1 || bileType == 2 || bileType == 3) && isChange;
        String formIdOfPC = "";
        if (isChangePage) {
            if (1 == bileType && 0 == applyType) {
                formIdOfPC = "wtam_busiselfbillchange";
            } else if (2 == bileType && 0 == applyType) {
                formIdOfPC = "wtabm_vaupdateself";
            } else if (3 == bileType && 0 == applyType) {
                formIdOfPC = "wtom_otselfbillchange";
            } else if (1 == bileType && 1 == applyType) {
                formIdOfPC = "wtam_busibillchange";
            } else if (2 == bileType && (1 == applyType || 2 == applyType)) {
                formIdOfPC = "wtabm_vaupdate";
            } else if (3 == bileType && 1 == applyType) {
                formIdOfPC = "wtom_otbillchange";
            }
        } else if (1 == bileType && 0 == applyType) {
            formIdOfPC = "wtam_busitripselfbill";
        } else if (2 == bileType && 0 == applyType) {
            formIdOfPC = "wtabm_vaapplyself";
        } else if (3 == bileType && 0 == applyType) {
            formIdOfPC = "wtom_otbillself";
        } else if (4 == bileType && 0 == applyType) {
            formIdOfPC = "wtpm_supsignself";
        } else if (5 == bileType && 0 == applyType) {
            formIdOfPC = "wts_swshiftselfbill";
        } else if (1 == bileType && 1 == applyType) {
            formIdOfPC = "wtam_busitripbill";
        } else if (2 == bileType && (1 == applyType || 2 == applyType)) {
            formIdOfPC = "wtabm_vaapply";
        } else if (3 == bileType && 1 == applyType) {
            formIdOfPC = "wtom_overtimeapplybill";
        } else if (4 == bileType && 1 == applyType) {
            formIdOfPC = "wtpm_supsignpcqueryconf";
        } else if (5 == bileType && 1 == applyType) {
            formIdOfPC = "wts_swshiftbill";
        }
        return formIdOfPC;
    }

    private String judeSource(IFormView view) {
        IFormView parentView;
        String targetPageType = "0";
        if (parentView == null) {
            return targetPageType;
        }
        for (parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId()); parentView != null; parentView = parentView.getViewNoPlugin(parentView.getFormShowParameter().getParentPageId())) {
            String parentViewFormId = parentView.getFormShowParameter().getFormId();
            if (TEAM_SET.contains(parentViewFormId)) {
                targetPageType = "1";
                break;
            }
            if (!MYSELF_SET.contains(parentViewFormId)) continue;
            targetPageType = "0";
            break;
        }
        return targetPageType;
    }

    private int getBillType(String formId) {
        String appNumber = StringUtils.substring((String)formId, (int)0, (int)StringUtils.indexOf((CharSequence)formId, (CharSequence)"_"));
        int billType = 0;
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            billType = 1;
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            billType = 2;
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            billType = 3;
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            billType = 4;
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wts")) {
            billType = 5;
        }
        return billType;
    }

    private void setCustomParam(IFormView billView, MobileFormShowParameter showParameter) {
        String source;
        String wf;
        String checkRightAppId = (String)billView.getFormShowParameter().getCustomParam("checkRightAppId");
        if (HRStringUtils.isNotEmpty((String)checkRightAppId)) {
            showParameter.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        }
        if (HRStringUtils.isNotEmpty((String)(wf = (String)billView.getFormShowParameter().getCustomParam("SOURCE")))) {
            showParameter.setCustomParam("SOURCE", (Object)wf);
        }
        if (HRStringUtils.isNotEmpty((String)(source = (String)billView.getFormShowParameter().getCustomParam("sourceApp")))) {
            showParameter.setCustomParam("sourceApp", (Object)source);
        }
    }

    private void setCustomParam(IFormView billView, MobileBillShowParameter showParameter, String targetFormId) {
        String source;
        boolean otherFormId;
        String wf;
        String checkRightAppId = (String)billView.getFormShowParameter().getCustomParam("checkRightAppId");
        if (HRStringUtils.isNotEmpty((String)checkRightAppId)) {
            showParameter.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        }
        if (HRStringUtils.isNotEmpty((String)(wf = (String)billView.getFormShowParameter().getCustomParam("SOURCE")))) {
            showParameter.setCustomParam("SOURCE", (Object)wf);
        }
        if (otherFormId = MobileCommonServiceHelper.getInstance().isOtherFormId(targetFormId)) {
            showParameter.setCustomParam("checkRightAppId", (Object)"wtam");
        }
        if (HRStringUtils.isNotEmpty((String)(source = (String)billView.getFormShowParameter().getCustomParam("sourceApp")))) {
            showParameter.setCustomParam("sourceApp", (Object)source);
        }
    }

    private void openBill(IFormView billView, String targetFormId, long pkId, Map<String, Object> customParams, BillOperationStatus status) {
        IFormView containerView = billView.getViewNoPlugin(billView.getFormShowParameter().getParentPageId());
        if (containerView == null) {
            return;
        }
        MobileBillShowParameter showParameter = this.getDefaultMobileBill(targetFormId, billView);
        showParameter.setPkId((Object)pkId);
        if (BillOperationStatus.VIEW == status) {
            showParameter.setBillStatus(status);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        } else if (BillOperationStatus.EDIT == status) {
            showParameter.setBillStatus(status);
            showParameter.setStatus(OperationStatus.EDIT);
        }
        if (customParams != null && !customParams.isEmpty()) {
            customParams.forEach((kk, vv) -> showParameter.setCustomParam(kk, vv));
        }
        this.setCustomParam(billView, showParameter, targetFormId);
        containerView.showForm((FormShowParameter)showParameter);
        billView.sendFormAction(containerView);
    }

    private MobileBillShowParameter getDefaultMobileBill(String targetFormId) {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap_bill");
        showParameter.setFormId(targetFormId);
        return showParameter;
    }

    private MobileBillShowParameter getDefaultMobileBill(String targetFormId, IFormView curView) {
        OpenStyle openStyle = curView.getFormShowParameter().getOpenStyle();
        ShowType showType = openStyle.getShowType();
        String targetKey = openStyle.getTargetKey();
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(targetFormId);
        return showParameter;
    }

    private MobileFormShowParameter getDefaultMobileForm(String targetFormId, IFormView billView) {
        OpenStyle openStyle = billView.getFormShowParameter().getOpenStyle();
        ShowType showType = openStyle.getShowType();
        String targetKey = openStyle.getTargetKey();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(targetFormId);
        return showParameter;
    }

    private String getBillCaption(Integer bileType, boolean isChange, Integer applyType) {
        boolean isChangePage;
        String formIdOfPC = "";
        if (2 == applyType && bileType == 2) {
            formIdOfPC = isChange ? BatchBillKDString.batchVaChange() : BatchBillKDString.batchVa();
            return formIdOfPC;
        }
        boolean bl = isChangePage = (bileType == 1 || bileType == 2 || bileType == 3 || bileType == 4) && isChange;
        if (isChangePage) {
            formIdOfPC = HRStringUtils.equals((String)BillApplyTypeEnum.OTHER.getCode(), (String)(applyType + "")) ? BillContainerKDStringHelper.billChangeOther() : BillContainerKDStringHelper.billChange();
        } else if (1 == bileType && 0 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.tpBill();
        } else if (2 == bileType && 0 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.vaBill();
        } else if (3 == bileType && 0 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.otBill();
        } else if (4 == bileType && 0 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.adBill();
        } else if (5 == bileType && 0 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.swBill();
        } else if (1 == bileType && 1 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.tpOtherBill();
        } else if (2 == bileType && 1 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.vaOtherBill();
        } else if (3 == bileType && 1 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.otOtherBill();
        } else if (4 == bileType && 1 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.adOtherBill();
        } else if (5 == bileType && 1 == applyType) {
            formIdOfPC = BillContainerKDStringHelper.swOtherBill();
        }
        return formIdOfPC;
    }

    static {
        TEAM_SET.add("wtss_teamhomepage_m");
        TEAM_SET.add("wtss_mobileotherbill");
        MYSELF_SET.add("wtss_mobilehomepage");
        MYSELF_SET.add("wtss_mobilebill");
    }

    private static class Instance {
        private static BillContainerService INSTANCE = new BillContainerService();

        private Instance() {
        }
    }
}

