/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.mobile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class MobileCommonServiceHelper {
    private static final Log logger = LogFactory.getLog(MobileCommonServiceHelper.class);

    private MobileCommonServiceHelper() {
    }

    public static MobileCommonServiceHelper getInstance() {
        return Instance.INSTANCE;
    }

    public Long getUserId() {
        Map<String, Object> userInfo = HRPIMServiceImpl.getInstance().getPersonModelId();
        if (userInfo != null) {
            logger.debug("mobileHome getUserId success:{} message:{}", userInfo.get("success"), userInfo.get("message"));
            if (((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
                Map userData = (Map)userInfo.get("data");
                Long userId = (Long)userData.get("person");
                logger.debug("mobileHome getUserId userId:{}", (Object)userId);
                return userId;
            }
        }
        return null;
    }

    public Long getEmployeeId() {
        Map<String, Object> userInfo = HRPIMServiceImpl.getInstance().getPersonModelId();
        if (userInfo != null) {
            logger.debug("mobileHome getEmployeeId success:{} message:{}", userInfo.get("success"), userInfo.get("message"));
            if (((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
                Map userData = (Map)userInfo.get("data");
                Long employeeId = (Long)userData.get("employee");
                logger.debug("mobileHome getEmployeeId EmployeeId:{}", (Object)employeeId);
                return employeeId;
            }
        }
        return null;
    }

    public Long getEmployeeIdByPersonId(Long personId) {
        Map<String, Object> userInfo = HRPIMServiceImpl.getInstance().queryUserInfoByPersonId(personId);
        if (userInfo != null) {
            Map userData;
            Map user;
            logger.debug("mobileHome getEmployeeIdByPersonId success:{} message:{}", userInfo.get("success"), userInfo.get("message"));
            if (((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null && (user = (Map)(userData = (Map)userInfo.get("data")).get(personId)) != null && WTCMaps.isNotEmpty((Map)user)) {
                Long employeeId = (Long)user.get("employee");
                logger.debug("mobileHome getEmployeeIdByPersonId EmployeeId:{}", (Object)employeeId);
                return employeeId;
            }
        }
        return null;
    }

    public List<Map<String, String>> getAttFile(Long attPersonId) {
        if (null == attPersonId || attPersonId == 0L) {
            return Collections.emptyList();
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(true);
        attFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        attFileQueryParam.setAttPersonId(attPersonId.longValue());
        attFileQueryParam.setProperties(this.getF7DefaultProperties());
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(null, attPersonId, "boid");
        attFileQueryParam.setqFilter(excludeAttFileLevelFilter);
        List<DynamicObject> allAttFileF7Version = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll(allAttFileF7Version);
        return this.getFileF7Result(dynamicObjectCollection);
    }

    private String getF7DefaultProperties() {
        return "name,org,org.name,id,boid,adminorg,adminorg.name,attperson,attperson.number,attperson.id";
    }

    private List<Map<String, String>> getFileF7Result(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
        if (!dynamicObjectCollection.isEmpty()) {
            for (DynamicObject fileF7 : dynamicObjectCollection) {
                HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
                resultMap.put("attperson.id", fileF7.getString("attperson.id"));
                resultMap.put("attperson.name", fileF7.getString("name"));
                resultMap.put("attperson.number", fileF7.getString("attperson.number"));
                resultMap.put("attperson.headsculpture", "");
                resultMap.put("id", fileF7.getString("id"));
                resultMap.put("boid", fileF7.getString("boid"));
                resultMap.put("org.name", fileF7.getString("org.name"));
                resultMap.put("adminorg.name", fileF7.getString("adminorg.name"));
                result.add(resultMap);
            }
        }
        return result;
    }

    @Deprecated
    public void toSubmitFeedbackPage(IFormView view, String applyName, String applyFormId, long applyPkid) {
    }

    public List<Map<String, String>> getExInfoByPersonDay(Long personId, String chooseDate, Set<Long> abnormalConfig) {
        return (List)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IExRecordService", (String)"getExInfoByPersonDay", (Object[])new Object[]{personId, chooseDate, abnormalConfig});
    }

    public List<Map<String, String>> getExInfoByAttFileBidDay(Long attFileBid, String chooseDate, Set<Long> abnormalConfig) {
        return (List)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IExRecordService", (String)"getExInfoByAttFileBidDay", (Object[])new Object[]{attFileBid, chooseDate, abnormalConfig});
    }

    public List<Map<String, String>> getExInfoByPersonDay(Long personId, String chooseDate, String abnormalConfig) {
        return (List)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IExRecordService", (String)"getExInfoByPersonDay", (Object[])new Object[]{personId, chooseDate, abnormalConfig});
    }

    public boolean isEditable(IDataModel dataModel) {
        if (dataModel.getValue("creator") == null || dataModel.getValue("billstatus") == null) {
            return false;
        }
        DynamicObject creator = (DynamicObject)dataModel.getValue("creator");
        long userId = RequestContext.get().getCurrUserId();
        return (StringUtils.equals((CharSequence)((String)dataModel.getValue("billstatus")), (CharSequence)"G") || StringUtils.equals((CharSequence)((String)dataModel.getValue("billstatus")), (CharSequence)"A")) && creator.getLong("id") == userId;
    }

    public Map<String, Object> generateMobOrgSelectParam(String otherFilters) {
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("isMulti", Boolean.FALSE);
        customMap.put("mustInput", Boolean.TRUE);
        customMap.put("_F7Style_", 0);
        customMap.put("isOnlyDisplayOrgLeaves", Boolean.FALSE);
        customMap.put("islookup", Boolean.TRUE);
        customMap.put("orgFuncId", "26");
        customMap.put("entityId", "bos_org");
        customMap.put("islockfunc", Boolean.TRUE);
        customMap.put("isOrgBaseAdmin", Boolean.FALSE);
        if (HRStringUtils.isNotEmpty((String)otherFilters)) {
            customMap.put("_otherFilters_", otherFilters);
        }
        return customMap;
    }

    @Deprecated
    public void toSavedAndViewPage(IFormView view, String formId, Object pkValue, String appId, Boolean isFromMyBill) {
        if (HRStringUtils.isEmpty((String)appId)) {
            appId = "wtss";
        }
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId(formId);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId(pkValue);
        showParameter.setCustomParam("flagWorkFlow", (Object)Boolean.FALSE);
        showParameter.setCustomParam("flagFromMyBill", (Object)isFromMyBill);
        showParameter.setAppId(appId);
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    public String getBillAppId(String formId, IFormView view) {
        if (view == null) {
            return null;
        }
        return view.getFormShowParameter().getAppId();
    }

    public boolean isOtherFormId(String formId) {
        HashSet<String> otherBills = new HashSet<String>(Arrays.asList("wtom_otbillother_m", "wtom_otapplyotherdetail", "wtabm_vaapplymob", "wtabm_vaapplyappro", "wtabm_vaupdateappro", "wtam_busitripbillmob", "wtam_busitripdetail", "wtam_busibillchangdeta", "wtpm_supsignpc_addm", "wtpm_supsignpc_tempm", "wtom_otbillchange_md", "wtpm_supsignpcchan_tempm", "wtpm_supsignpcchan_m", "wts_swshiftbill_m", "wts_swshiftbill_mv"));
        return otherBills.contains(formId);
    }

    public void preOpenForm(PreOpenFormEventArgs ee) {
        FormShowParameter formShowParameter = ee.getFormShowParameter();
        BillCommonService.getInstance().getAuthAppIdForFormPlugin(formShowParameter);
    }

    public boolean judgeAttFile(IFormView view, String billName) {
        DynamicObject attFileDy = view.getModel().getDataEntity(true).getDynamicObject("attfile");
        if (attFileDy == null) {
            view.showTipNotification(BillUnifyKDStringHelper.emptyAttFile(billName));
            return false;
        }
        HashSet set = Sets.newHashSetWithExpectedSize((int)1);
        set.add(attFileDy.getLong("id"));
        Map<Long, String> discardAttFileBoIdMap = BillCommonService.getInstance().getAttFileBoDyList(set);
        String attFileNumber = discardAttFileBoIdMap.get(attFileDy.getLong("id"));
        if (HRStringUtils.isNotEmpty((String)attFileNumber)) {
            view.showTipNotification(BillUnifyKDStringHelper.notEffAttFile(billName, attFileNumber));
            return false;
        }
        return true;
    }

    private static class Instance {
        private static final MobileCommonServiceHelper INSTANCE = new MobileCommonServiceHelper();

        private Instance() {
        }
    }
}

