/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.mobile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.wtc.wtbs.business.model.attendperson.HRPIEntityPropertyConst;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class MobilePersonInfoHelper {
    public static Page<Map<String, String>> getPersonInfo(List<Long> personId, int pageStart, int pageSize) {
        if (personId.size() == 0) {
            ArrayList perSonInfoList = new ArrayList(0);
            return new Page(pageSize, pageStart, perSonInfoList);
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(true);
        attFileQueryParam.setAttStatus(null);
        HashSet<Long> delPersons = new HashSet<Long>(1);
        delPersons.add(0L);
        attFileQueryParam.setAttPersonDelSetIds(delPersons);
        attFileQueryParam.setPersonSetIds(new HashSet<Long>(personId));
        attFileQueryParam.setProperties("name,org,org.name,id,boid,adminorg,adminorg.name,attperson,attperson.name,attperson.number,attperson.id,position,position.name,job,job.name,number");
        Page<DynamicObject> dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7(attFileQueryParam, pageStart, pageSize);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll((Collection)dynamicObjectPage.getListRecords());
        List<Map<String, String>> fileF7List = MobilePersonInfoHelper.getFileF7Result(dynamicObjectCollection);
        List<Map<String, String>> perSonInfoList = MobilePersonInfoHelper.getHeadInfoByAttFileDys(fileF7List);
        Page personInfo = new Page(pageSize, pageStart, perSonInfoList);
        personInfo.setTotalPage(dynamicObjectPage.getTotalPage());
        personInfo.setTotalRecord(dynamicObjectPage.getTotalRecord());
        return personInfo;
    }

    public static List<Map<String, String>> getFileF7Result(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
        if (!dynamicObjectCollection.isEmpty()) {
            for (DynamicObject fileF7 : dynamicObjectCollection) {
                HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
                resultMap.put("attperson.id", fileF7.getString("attperson.id"));
                resultMap.put("attperson.name", fileF7.getString("attperson.name"));
                resultMap.put("attperson.number", fileF7.getString("attperson.number"));
                resultMap.put("attfile.number", fileF7.getString("number"));
                resultMap.put("attperson.headsculpture", "");
                resultMap.put("id", fileF7.getString("id"));
                resultMap.put("boid", fileF7.getString("boid"));
                resultMap.put("org.name", fileF7.getString("org.name"));
                resultMap.put("adminorg.name", fileF7.getString("adminorg.name"));
                resultMap.put("position.name", fileF7.getString("position.name"));
                resultMap.put("job.name", fileF7.getString("job.name"));
                result.add(resultMap);
            }
        }
        return result;
    }

    public static List<Map<String, String>> getHeadInfoByAttFileDys(List<Map<String, String>> attFileDys) {
        List<Long> personIdList = attFileDys.stream().mapToLong(dy -> Long.parseLong((String)dy.get("attperson.id"))).boxed().collect(Collectors.toList());
        List<DynamicObject> personBaseInfo = HRPIMServiceImpl.getInstance().listFieldsFilterInfoBatch("id", personIdList, StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.PERSON_SELECT_FIELDS), (String)","), null, "hrpi_person");
        HashMap personIdAndPic = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : personBaseInfo) {
            personIdAndPic.put(dynamicObject.getString("id"), dynamicObject.getString("headsculpture"));
        }
        for (Map map : attFileDys) {
            map.put("attperson.headsculpture", personIdAndPic.get(map.get("attperson.id")));
        }
        return attFileDys;
    }
}

