/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.mobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.UserCustomParam;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class MobilePersonSelHelper {
    private static final Log LOGGER = LogFactory.getLog(MobilePersonSelHelper.class);

    private MobilePersonSelHelper() {
    }

    public static MobilePersonSelHelper getInstance() {
        return Instance.INSTANCE;
    }

    public Page<DynamicObject> getAttFileF7ByName(UserCustomParam userCustomParam) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam(true);
        String userId = userCustomParam.getUserId();
        if (HRStringUtils.isNotEmpty((String)userId) && Long.parseLong(userCustomParam.getUserId()) != 0L) {
            long attPersonId = Long.parseLong(userCustomParam.getUserId());
            attFileQueryParam.setAttPersonId(attPersonId);
            String searchType = userCustomParam.getSearchType();
            if ("0".equals(searchType)) {
                QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(null, attPersonId, "boid");
                attFileQueryParam.setqFilter(excludeAttFileLevelFilter);
            }
        }
        this.beContainCurrentUser(userCustomParam.getView(), userCustomParam.isContainCurrentUser(), (AttFileQueryParam)attFileQueryParam);
        attFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        if (!HRStringUtils.isEmpty((String)userCustomParam.getSearchContent())) {
            attFileQueryParam.setFuzzyQueryValue(userCustomParam.getSearchContent());
            attFileQueryParam.setFuzzyQueryProperties(new String[]{"attperson.name", "attperson.number", "number"});
        }
        attFileQueryParam.setProperties(this.getF7DefaultProperties());
        attFileQueryParam.setAppId(userCustomParam.getAppId());
        String authEntity = userCustomParam.getAuthEntity();
        if ("wtpm_supsignpc".equals(authEntity)) {
            authEntity = "wtpm_supsignpcqueryconf";
        }
        attFileQueryParam.setFormId(authEntity);
        attFileQueryParam.setPermField(userCustomParam.getAuthField());
        attFileQueryParam.setAuthCheck(Boolean.TRUE);
        attFileQueryParam.setOrgAuthCheck(true);
        if (userCustomParam.getAffiliateAdminOrgId() != null && userCustomParam.getAffiliateAdminOrgId() != 0L) {
            attFileQueryParam.setAffiliateAdminOrgId(userCustomParam.getAffiliateAdminOrgId().longValue());
        }
        if (userCustomParam.getStartDate() != null && userCustomParam.getEndDate() != null) {
            attFileQueryParam.setStartDate(userCustomParam.getStartDate());
            attFileQueryParam.setEndDate(userCustomParam.getEndDate());
        }
        return AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileQueryParam, userCustomParam.getPageNum(), userCustomParam.getPageSize());
    }

    private String getF7DefaultProperties() {
        return "name,org,org.name,id,boid,adminorg,adminorg.name,attperson,attperson.number,attperson.id";
    }

    private void beContainCurrentUser(IFormView view, boolean containCurrentUser, AttFileQueryParam attFileQueryParam) {
        Long personId;
        if (!containCurrentUser && (personId = BillUnifyService.getUserId(view)) != null && personId != 0L) {
            attFileQueryParam.setAttPersonDelSetIds(Collections.singleton(personId));
        }
    }

    public List<Map<String, String>> getFileF7Result(List<DynamicObject> fileDyList) {
        if (CollectionUtils.isEmpty(fileDyList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)fileDyList.size());
        for (DynamicObject fileF7 : fileDyList) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put("attperson.id", fileF7.getString("attperson.id"));
            resultMap.put("attperson.name", fileF7.getString("name"));
            resultMap.put("attperson.number", fileF7.getString("attperson.number"));
            resultMap.put("attperson.headsculpture", "");
            resultMap.put("id", fileF7.getString("id"));
            resultMap.put("boid", fileF7.getString("boid"));
            resultMap.put("org.name", fileF7.getString("org.name"));
            resultMap.put("adminorg.name", fileF7.getString("adminorg.name"));
            result.add(resultMap);
        }
        return result;
    }

    private static class Instance {
        private static final MobilePersonSelHelper INSTANCE = new MobilePersonSelHelper();

        private Instance() {
        }
    }
}

