/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.mobile;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtbs.business.mobilescheme.ISchemeMatchPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.business.util.WTCBrmSceneHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class MobileSchemeServiceHelper {
    private static HRBaseServiceHelper schemeServiceHelper = new HRBaseServiceHelper("wtp_mobilescheme");
    private static final Log logger = LogFactory.getLog(MobileSchemeServiceHelper.class);
    private static final int batch_size = 5000;

    @Deprecated
    public static LinkedHashMap<Long, String> getAllMobileScheme() {
        QFilter filter = WTCHisServiceHelper.statusValidQFilter();
        DynamicObject[] schemes = schemeServiceHelper.query("attfilebaserange", filter.toArray(), "createtime desc");
        LinkedHashMap<Long, String> allMobileScheme = new LinkedHashMap<Long, String>(16);
        for (DynamicObject scheme : schemes) {
            allMobileScheme.put(scheme.getLong("id"), scheme.getString("attfilebaserange"));
        }
        return allMobileScheme;
    }

    public static LinkedHashMap<Long, String> getAllMobileSchemeWithWorkspace(String workspace) {
        QFilter filter = WTCHisServiceHelper.statusValidQFilter();
        filter.and(new QFilter("workspace", "=", (Object)workspace));
        DynamicObject[] schemes = schemeServiceHelper.query("attfilebaserange", filter.toArray(), "createtime desc");
        LinkedHashMap<Long, String> allMobileScheme = new LinkedHashMap<Long, String>(16);
        for (DynamicObject scheme : schemes) {
            allMobileScheme.put(scheme.getLong("id"), scheme.getString("attfilebaserange"));
        }
        return allMobileScheme;
    }

    @Deprecated
    public static Long getFinalMobileScheme(Map<String, Object> data) {
        LinkedHashMap<Long, String> allMobileScheme = MobileSchemeServiceHelper.getAllMobileScheme();
        if (logger.isDebugEnabled()) {
            logger.info("MobileSchemeServiceHelper.getFinalMobileScheme.data:{}", data);
            logger.info("MobileSchemeServiceHelper.getFinalMobileScheme.allMobileScheme:{}", allMobileScheme);
        }
        JudgeResult judgeResult = JudgeConditionService.judgeByData(allMobileScheme, data);
        return judgeResult.getFisrtMatched();
    }

    @Deprecated
    public static Long getFinalMobileSchemeWithWorkspace(Map<String, Object> data, String workspace) {
        LinkedHashMap<Long, String> allMobileScheme = MobileSchemeServiceHelper.getAllMobileSchemeWithWorkspace(workspace);
        if (logger.isDebugEnabled()) {
            logger.info("MobileSchemeServiceHelper.getFinalMobileScheme.data:{}", data);
            logger.info("MobileSchemeServiceHelper.getFinalMobileScheme.allMobileScheme:{}", allMobileScheme);
        }
        JudgeResult judgeResult = JudgeConditionService.judgeByData(allMobileScheme, data);
        return judgeResult.getFisrtMatched();
    }

    public static Map<Long, Long> batchMatchMobileScheme(List<DynamicObject> attFiles, String workSpace) {
        if (WTCCollections.isEmpty(attFiles)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(attFiles.size());
        int batchSize = attFiles.size() / 5000;
        if (attFiles.size() % 5000 > 0) {
            ++batchSize;
        }
        for (int index = 0; index < batchSize; ++index) {
            List batchDys = WTCCollections.subList(attFiles, (int)(index * 5000), (int)((index + 1) * 5000));
            if (WTCCollections.isEmpty((Collection)batchDys)) continue;
            resultMap.putAll(MobileSchemeServiceHelper.matchMobileSchemeExecute(batchDys, workSpace));
        }
        return resultMap;
    }

    public static Map<Long, Long> matchMobileSchemeExecute(List<DynamicObject> attFiles, String workSpace) {
        if (WTCCollections.isEmpty(attFiles)) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<Long, String> allMobileScheme = MobileSchemeServiceHelper.getAllMobileSchemeWithWorkspace(workSpace);
        if (logger.isDebugEnabled()) {
            logger.info("MobileSchemeServiceHelper.batchMatchMobileScheme.attFileSize:{}", (Object)attFiles.size());
            logger.info("MobileSchemeServiceHelper.matchMobileScheme.allMobileSchemeSize:{}", (Object)allMobileScheme.size());
        }
        HashMap sceneDataMap = new HashMap();
        attFiles.forEach(fileDy -> sceneDataMap.put(fileDy.getLong("id"), MobileSchemeServiceHelper.getAttFileMatchSchemeMap(fileDy)));
        WTCPluginProxy<ISchemeMatchPlugin> pluginProxy = WTCPluginProxyFactory.create(ISchemeMatchPlugin.class, "kd.sdk.wtc.wtbs.business.mobilescheme.ISchemeMatchPlugin");
        if (pluginProxy.hasPlugin()) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry entry : sceneDataMap.entrySet()) {
                resultMap.put(entry.getKey(), MobileSchemeServiceHelper.getSchemeIdListWithWorkspace((Map)entry.getValue(), allMobileScheme));
            }
            return WTCBrmSceneHelper.matchSchemeExt(pluginProxy, resultMap, "wtc_scene_mobilescheme", allMobileScheme);
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : sceneDataMap.entrySet()) {
            resultMap.put(entry.getKey(), MobileSchemeServiceHelper.getSchemeIdWithWorkspace((Map)entry.getValue(), allMobileScheme));
        }
        return resultMap;
    }

    public static Map<String, String> getAttFileMatchSchemeMap(DynamicObject fileDy) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        resultMap.put("id", fileDy.getString("id"));
        resultMap.put("boid", fileDy.getString("boid"));
        resultMap.put("affiliateadminorg", String.valueOf(fileDy.getLong("affiliateadminorg.id")));
        resultMap.put("managescope", String.valueOf(fileDy.getLong("cmpemp.managingscope.id")));
        resultMap.put("dependency", String.valueOf(fileDy.getLong("dependency.id")));
        resultMap.put("empgroup", String.valueOf(fileDy.getLong("empgroup.id")));
        resultMap.put("workplace", String.valueOf(fileDy.getLong("workplace.id")));
        resultMap.put("org", String.valueOf(fileDy.getLong("org.id")));
        resultMap.put("adminorg", String.valueOf(fileDy.getLong("adminorg.id")));
        return resultMap;
    }

    public static long getSchemeIdWithWorkspace(Map<String, String> attFiles, LinkedHashMap<Long, String> allMobileScheme) {
        HashMap<String, Object> mobileSchemeMap = new HashMap<String, Object>(16);
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.workplace.id", attFiles.get("workplace"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.affiliateadminorg.id", attFiles.get("affiliateadminorg"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.empgroup.id", attFiles.get("empgroup"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.dependency.id", attFiles.get("dependency"));
        mobileSchemeMap.put("managingscope.hrpi_cmpemp.managingscope.id", attFiles.get("managescope"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.org.id", attFiles.get("org"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.adminorg.id", attFiles.get("adminorg"));
        JudgeResult judgeResult = JudgeConditionService.judgeByData(allMobileScheme, mobileSchemeMap);
        return judgeResult.getFisrtMatched();
    }

    public static List<Long> getSchemeIdListWithWorkspace(Map<String, String> attFiles, LinkedHashMap<Long, String> allMobileScheme) {
        HashMap<String, Object> mobileSchemeMap = new HashMap<String, Object>(16);
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.workplace.id", attFiles.get("workplace"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.affiliateadminorg.id", attFiles.get("affiliateadminorg"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.empgroup.id", attFiles.get("empgroup"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.dependency.id", attFiles.get("dependency"));
        mobileSchemeMap.put("managingscope.hrpi_cmpemp.managingscope.id", attFiles.get("managescope"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.org.id", attFiles.get("org"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.adminorg.id", attFiles.get("adminorg"));
        JudgeResult judgeResult = JudgeConditionService.judgeByData(allMobileScheme, mobileSchemeMap);
        return judgeResult.getMatchedList();
    }
}

