/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.cirenum.AssignTypeEnum;
import kd.wtc.wtbs.business.cirenum.AssignUnitEnum;
import kd.wtc.wtbs.business.cirenum.CircleBeginDateTypeEnum;
import kd.wtc.wtbs.business.cirenum.CircleTypeEnum;
import kd.wtc.wtbs.business.cirenum.CircleUnitEnum;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;

public class CircleConfigVo
implements Serializable {
    private static final long serialVersionUID = -4708584711650330640L;
    private static final Log log = WTCLogFactory.getLog(CircleConfigVo.class);
    private Long id;
    private Long attPeronId;
    private String name;
    private CircleBeginDateTypeEnum beginDateType;
    private long beginDateId;
    private DynamicObject cycDate;
    private Date beginDate;
    private Date endDate;
    private Date selDate;
    private Integer count;
    private CircleTypeEnum circleType;
    private CircleUnitEnum circleUnit;
    private String cirValueStr;
    private List<Integer> cirValue;
    private boolean appointDate;
    private Integer weekDate;
    private Integer monthDate;
    private String yearDate;
    private Integer month;
    private Integer date;
    private String intervalStr;
    private List<Integer> interval;
    private CircleUnitEnum intervalUnit;
    private boolean assign;
    private AssignTypeEnum assignType;
    private AssignUnitEnum assignUnit;
    private List<PerAttPeriod> perAttPeriods;
    private boolean qtCalCall = false;
    private Date qtCalEndDate;

    public void checkParam() {
        if (this.beginDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (this.count == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5faa\u73af\u6b21\u6570\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(this.cirValue)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5faa\u73af\u503c\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (this.appointDate) {
            if (this.circleUnit == CircleUnitEnum.CIRCLE_UNIT_WEEK) {
                if (this.circleWeekCheck()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5230\u5468\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
                }
            } else if (this.circleUnit == CircleUnitEnum.CIRCLE_UNIT_MONTH) {
                if (this.circleMonthCheck()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5230\u6708\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
                }
            } else if (this.circleUnit == CircleUnitEnum.CIRCLE_UNIT_YEAR && this.circleYearCheck()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5230\u5e74\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_5", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
        }
        if ((CircleTypeEnum.CIRCLE_TYPE_B == this.circleType || CircleTypeEnum.CIRCLE_TYPE_D == this.circleType) && CollectionUtils.isEmpty(this.interval)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u95f4\u9694\u503c\u914d\u7f6e\u9519\u8bef\u3002", (String)"CircleConfigVo_6", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (CircleTypeEnum.CIRCLE_TYPE_D == this.circleType && CircleUnitEnum.CIRCLE_UNIT_PERIOD == this.circleUnit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u95f4\u9694\u4e0d\u5b9a\u671f\u5faa\u73af,\u65e0\u6cd5\u914d\u7f6e\u8003\u52e4\u671f\u95f4\u7c7b\u578b\u7684\u5faa\u73af\u3002", (String)"CircleConfigVo_7", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (CircleUnitEnum.CIRCLE_UNIT_PERIOD == this.circleUnit && null == this.attPeronId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4eba\u5458\u7684\u8003\u52e4\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u8003\u52e4\u6863\u6848\u7684\u8003\u52e4\u671f\u95f4\u914d\u7f6e\u3002", (String)"CircleConfigVo_8", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    private boolean circleWeekCheck() {
        return null == this.weekDate || this.weekDate > 7 || this.weekDate < 0;
    }

    private boolean circleMonthCheck() {
        return null == this.monthDate || this.monthDate > 28 || this.monthDate < -1 || this.monthDate == 0;
    }

    private boolean circleYearCheck() {
        return null == this.month || null == this.date;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CircleBeginDateTypeEnum getBeginDateType() {
        return this.beginDateType;
    }

    public void setBeginDateType(CircleBeginDateTypeEnum beginDateType) {
        this.beginDateType = beginDateType;
    }

    public Long getBeginDateId() {
        return this.beginDateId;
    }

    public void setBeginDateId(Long beginDateId) {
        this.beginDateId = beginDateId;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate == null ? WTCHisServiceHelper.getMaxEndDate() : endDate;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public CircleTypeEnum getCircleType() {
        return this.circleType;
    }

    public void setCircleType(CircleTypeEnum circleType) {
        this.circleType = circleType;
    }

    public CircleUnitEnum getCircleUnit() {
        return this.circleUnit;
    }

    public void setCircleUnit(CircleUnitEnum circleUnit) {
        this.circleUnit = circleUnit;
    }

    public String getCirValueStr() {
        return this.cirValueStr;
    }

    public void setCirValueStr(String cirValueStr) {
        this.cirValueStr = cirValueStr;
    }

    public List<Integer> getCirValue() {
        return this.cirValue;
    }

    public void setCirValue(List<Integer> cirValue) {
        this.cirValue = cirValue;
    }

    public boolean getAppointDate() {
        return this.appointDate;
    }

    public void setAppointDate(boolean appointDate) {
        this.appointDate = appointDate;
    }

    public Integer getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(Integer weekDate) {
        this.weekDate = weekDate;
    }

    public Integer getMonthDate() {
        return this.monthDate;
    }

    public void setMonthDate(Integer monthDate) {
        this.monthDate = monthDate;
    }

    public String getYearDate() {
        return this.yearDate;
    }

    public void setYearDate(String yearDate) {
        this.yearDate = yearDate;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getDate() {
        return this.date;
    }

    public void setDate(Integer date) {
        this.date = date;
    }

    public String getIntervalStr() {
        return this.intervalStr;
    }

    public void setIntervalStr(String intervalStr) {
        this.intervalStr = intervalStr;
    }

    public List<Integer> getInterval() {
        return this.interval;
    }

    public void setInterval(List<Integer> interval) {
        this.interval = interval;
    }

    public CircleUnitEnum getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(CircleUnitEnum intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public boolean getAssign() {
        return this.assign;
    }

    public void setAssign(boolean assign) {
        this.assign = assign;
    }

    public AssignTypeEnum getAssignType() {
        return this.assignType;
    }

    public void setAssignType(AssignTypeEnum assignType) {
        this.assignType = assignType;
    }

    public AssignUnitEnum getAssignUnit() {
        return this.assignUnit;
    }

    public void setAssignUnit(AssignUnitEnum assignUnit) {
        this.assignUnit = assignUnit;
    }

    public Date getSelDate() {
        return this.selDate;
    }

    public void setSelDate(Date selDate) {
        this.selDate = selDate;
    }

    public Long getAttPeronId() {
        return this.attPeronId;
    }

    public List<PerAttPeriod> getPerAttPeriods() {
        return this.perAttPeriods;
    }

    public void setAttPeronId(Long attPeronId) {
        this.attPeronId = attPeronId;
        if (CircleUnitEnum.CIRCLE_UNIT_PERIOD == this.circleUnit && null != attPeronId) {
            this.setAttPeriod();
        }
    }

    private void setAttPeriod() {
        PerAttPeriodQueryServiceImpl instance = PerAttPeriodQueryServiceImpl.getInstance();
        Date queryEndDate = null == this.endDate ? WTCHisServiceHelper.getMaxEndDate() : this.endDate;
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttPersonIdSet(Collections.singleton(this.attPeronId));
        queryParam.setStartDate(this.beginDate);
        queryParam.setEndDate(queryEndDate);
        List<PerAttPeriod> perAttPeriod = instance.queryPerAttPeriodEntity(queryParam);
        if (WTCCollections.isNotEmpty(perAttPeriod)) {
            perAttPeriod.sort(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
        }
        this.perAttPeriods = perAttPeriod;
    }

    public DynamicObject getCycDate() {
        return this.cycDate;
    }

    public void setCycDate(DynamicObject cycDate) {
        this.cycDate = cycDate;
    }

    public void setCycDateByQuery() {
        if (0L != this.beginDateId && null == this.cycDate) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_cycdateset");
            this.cycDate = serviceHelper.queryOne((Object)this.getBeginDateId());
        }
    }

    public boolean isQtCalCall() {
        return this.qtCalCall;
    }

    public void setQtCalCall(boolean qtCalCall) {
        this.qtCalCall = qtCalCall;
    }

    public Date getQtCalEndDate() {
        return this.qtCalEndDate;
    }

    public void setQtCalEndDate(Date qtCalEndDate) {
        this.qtCalEndDate = qtCalEndDate;
    }
}

