/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.model.attendperson;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.EmpJobRel;
import kd.wtc.wtbs.business.model.attendperson.EmpPosOrgRel;
import kd.wtc.wtbs.business.model.attendperson.Employee;
import kd.wtc.wtbs.business.model.attendperson.FertilityInfo;
import kd.wtc.wtbs.business.model.attendperson.PerNonTsProp;
import kd.wtc.wtbs.business.model.attendperson.PerTsProp;
import kd.wtc.wtbs.business.model.attendperson.Person;
import kd.wtc.wtbs.business.model.attendperson.TrialPeriod;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class AttendPerson
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean initSuccess;
    private Person person;
    private Date earliestAttendDate;
    private Date latestAttendDate;
    private PerNonTsProp perNonTsProp;
    private FertilityInfo fertilityInfo;
    private List<FertilityInfo> fertilityInfoList;
    @Deprecated
    private TimeSeqBo<ContrWorkLoc> contrWorkLocList;
    @Deprecated
    private TimeSeqBo<Employee> employeeList;
    private Map<Long, TimeSeqBo<Employee>> employeeMap;
    private TimeSeqBo<PerTsProp> perTsPropList;
    @Deprecated
    private TimeSeqBo<EmpEntRel> empEntRelList;
    @Deprecated
    private TimeSeqBo<TrialPeriod> trialPeriodList;
    @Deprecated
    private Map<Long, TimeSeqBo<EmpJobRel>> empJobRelMap;
    private Map<Long, TimeSeqBo<CmpEmp>> cmpEmpMap;
    private Map<Long, Map<Long, TimeSeqBo<EmpPosOrgRel>>> empPosOrgRelMap;

    public PerNonTsProp getPerNonTsProp() {
        return this.perNonTsProp;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public FertilityInfo getFertilityInfo() {
        return this.fertilityInfo;
    }

    public void setFertilityInfo(FertilityInfo fertilityInfo) {
        this.fertilityInfo = fertilityInfo;
    }

    public void setPerNonTsProp(PerNonTsProp perNonTsProp) {
        this.perNonTsProp = perNonTsProp;
    }

    public TimeSeqBo<Employee> getEmployeeList() {
        return this.employeeList;
    }

    public void setEmployeeList(TimeSeqBo<Employee> employeeList) {
        this.employeeList = employeeList;
    }

    public TimeSeqBo<PerTsProp> getPerTsPropList() {
        return this.perTsPropList;
    }

    public void setPerTsPropList(TimeSeqBo<PerTsProp> perTsPropList) {
        this.perTsPropList = perTsPropList;
    }

    public TimeSeqBo<EmpEntRel> getEmpEntRelList() {
        return this.empEntRelList;
    }

    public void setEmpEntRelList(TimeSeqBo<EmpEntRel> empEntRelList) {
        this.empEntRelList = empEntRelList;
    }

    public TimeSeqBo<TrialPeriod> getTrialPeriodList() {
        return this.trialPeriodList;
    }

    public void setTrialPeriodList(TimeSeqBo<TrialPeriod> trialPeriodList) {
        this.trialPeriodList = trialPeriodList;
    }

    public Map<Long, TimeSeqBo<EmpJobRel>> getEmpJobRelMap() {
        return this.empJobRelMap;
    }

    public void setEmpJobRelMap(Map<Long, TimeSeqBo<EmpJobRel>> empJobRelMap) {
        this.empJobRelMap = empJobRelMap;
    }

    public Map<Long, TimeSeqBo<CmpEmp>> getCmpEmpMap() {
        return this.cmpEmpMap;
    }

    public void setCmpEmpMap(Map<Long, TimeSeqBo<CmpEmp>> cmpEmpMap) {
        this.cmpEmpMap = cmpEmpMap;
    }

    public Map<Long, Map<Long, TimeSeqBo<EmpPosOrgRel>>> getEmpPosOrgRelMap() {
        return this.empPosOrgRelMap;
    }

    public void setEmpPosOrgRelMap(Map<Long, Map<Long, TimeSeqBo<EmpPosOrgRel>>> empPosOrgRelMap) {
        this.empPosOrgRelMap = empPosOrgRelMap;
    }

    public TimeSeqBo<ContrWorkLoc> getContrWorkLocList() {
        return this.contrWorkLocList;
    }

    public void setContrWorkLocList(TimeSeqBo<ContrWorkLoc> contrWorkLocList) {
        this.contrWorkLocList = contrWorkLocList;
    }

    public AttendPerson() {
    }

    public AttendPerson(Boolean initSuccess) {
        this.initSuccess = initSuccess;
    }

    public Boolean getInitSuccess() {
        return this.initSuccess;
    }

    public void setInitSuccess(Boolean initSuccess) {
        this.initSuccess = initSuccess;
    }

    public Date getEarliestAttendDate() {
        return this.earliestAttendDate;
    }

    public void setEarliestAttendDate(Date earliestAttendDate) {
        this.earliestAttendDate = earliestAttendDate;
    }

    public Date getLatestAttendDate() {
        return this.latestAttendDate;
    }

    public void setLatestAttendDate(Date latestAttendDate) {
        this.latestAttendDate = latestAttendDate;
    }

    public Map<Long, TimeSeqBo<Employee>> getEmployeeMap() {
        return this.employeeMap;
    }

    public void setEmployeeMap(Map<Long, TimeSeqBo<Employee>> employeeMap) {
        this.employeeMap = employeeMap;
    }

    public List<FertilityInfo> getFertilityInfoList() {
        return this.fertilityInfoList;
    }

    public void setFertilityInfoList(List<FertilityInfo> fertilityInfoList) {
        this.fertilityInfoList = fertilityInfoList;
    }

    public Employee getEmployee(long employeeId, LocalDate localDate) {
        Map<Long, TimeSeqBo<Employee>> employeeMap = this.employeeMap;
        TimeSeqBo<Employee> employeeTimeSeqBo = employeeMap.get(employeeId);
        return employeeTimeSeqBo != null ? employeeTimeSeqBo.getVersionByDate(localDate) : null;
    }

    public Employee getLastEmployee(LocalDate localDate) {
        return this.employeeMap != null ? (Employee)this.employeeMap.values().stream().map(employeeTimeSeqBo -> (Employee)employeeTimeSeqBo.getVersionByDate(localDate)).filter(Objects::nonNull).filter(employee -> employee.getStartDate() != null).max(Comparator.comparing(Employee::getStartDate)).orElse(null) : null;
    }

    public FertilityInfo getFertilityInfo(LocalDate localDate) {
        return CollectionUtils.isEmpty(this.fertilityInfoList) ? null : (FertilityInfo)this.fertilityInfoList.stream().filter(Objects::nonNull).filter(fertilityInfo -> fertilityInfo.getBirthday() != null).filter(fertilityInfo -> localDate != null && localDate.compareTo(WTCDateUtils.toLocalDate((Date)fertilityInfo.getBirthday())) >= 0).max(Comparator.comparing(FertilityInfo::getBirthday)).orElse(null);
    }
}

