/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.model.attendperson;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.EmpJobRel;
import kd.wtc.wtbs.business.model.attendperson.TrialPeriod;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;

public class Employee
extends AbstractTimeSeqVersion
implements Serializable {
    private static final Log logger = LogFactory.getLog(Employee.class);
    private static final long serialVersionUID = -2474807716710909036L;
    private Date startDate;
    private Date endDate;
    private Date sysEndDate;
    private Long enterPrise;
    private Date lastWorkDate;
    private Long laborRelType;
    private Long laborRelStatus;
    private String empNumber;
    private Long firstEmployeeBid;
    private TimeSeqBo<EmpEntRel> empEntRelList;
    private Map<Long, TimeSeqBo<EmpEntRel>> empEntRelMap;
    private TimeSeqBo<TrialPeriod> trialPeriodList;
    private Map<Long, TimeSeqBo<TrialPeriod>> trialPeriodMap;
    private TrialPeriod trialPeriod;
    private TimeSeqBo<ContrWorkLoc> contrWorkLocList;
    private Map<Long, TimeSeqBo<ContrWorkLoc>> contrWorkLocMap;
    private Map<Long, TimeSeqBo<EmpJobRel>> empJobRelMap;

    private Employee() {
    }

    protected Employee(TimeSeqInfo timeSeqEntity) {
        super(timeSeqEntity);
    }

    public static Builder withTimeSeq(TimeSeqInfoImpl timeSeqEntity) {
        return new Builder(new Employee(timeSeqEntity));
    }

    public TimeSeqBo<EmpEntRel> getEmpEntRelList() {
        return this.empEntRelList;
    }

    public void setEmpEntRelList(TimeSeqBo<EmpEntRel> empEntRelList) {
        this.empEntRelList = empEntRelList;
    }

    public TimeSeqBo<TrialPeriod> getTrialPeriodList() {
        return this.trialPeriodList;
    }

    public void setTrialPeriodList(TimeSeqBo<TrialPeriod> trialPeriodList) {
        this.trialPeriodList = trialPeriodList;
    }

    public TimeSeqBo<ContrWorkLoc> getContrWorkLocList() {
        return this.contrWorkLocList;
    }

    public void setContrWorkLocList(TimeSeqBo<ContrWorkLoc> contrWorkLocList) {
        this.contrWorkLocList = contrWorkLocList;
    }

    public Map<Long, TimeSeqBo<EmpJobRel>> getEmpJobRelMap() {
        return this.empJobRelMap;
    }

    public void setEmpJobRelMap(Map<Long, TimeSeqBo<EmpJobRel>> empJobRelMap) {
        this.empJobRelMap = empJobRelMap;
    }

    public TrialPeriod getTrialPeriod() {
        return this.trialPeriod;
    }

    public void setTrialPeriod(TrialPeriod trialPeriod) {
        this.trialPeriod = trialPeriod;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getSysEndDate() {
        return this.sysEndDate;
    }

    public Long getEnterPrise() {
        return this.enterPrise;
    }

    public Date getLastWorkDate() {
        return this.lastWorkDate;
    }

    public Long getLaborRelType() {
        return this.laborRelType;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Long getLaborRelStatus() {
        return this.laborRelStatus;
    }

    public String getEmpNumber() {
        return this.empNumber;
    }

    public Map<Long, TimeSeqBo<EmpEntRel>> getEmpEntRelMap() {
        return this.empEntRelMap;
    }

    public Map<Long, TimeSeqBo<TrialPeriod>> getTrialPeriodMap() {
        return this.trialPeriodMap;
    }

    public Map<Long, TimeSeqBo<ContrWorkLoc>> getContrWorkLocMap() {
        return this.contrWorkLocMap;
    }

    public void setEmpEntRelMap(Map<Long, TimeSeqBo<EmpEntRel>> empEntRelMap) {
        this.empEntRelMap = empEntRelMap;
    }

    public void setTrialPeriodMap(Map<Long, TimeSeqBo<TrialPeriod>> trialPeriodMap) {
        this.trialPeriodMap = trialPeriodMap;
    }

    public void setContrWorkLocMap(Map<Long, TimeSeqBo<ContrWorkLoc>> contrWorkLocMap) {
        this.contrWorkLocMap = contrWorkLocMap;
    }

    public EmpEntRel getEmpEntRel(LocalDate localDate, Long boId) {
        return (EmpEntRel)this.getTimeSeqBoEntity(localDate, this.empEntRelMap, boId);
    }

    public TrialPeriod getTrialPeriod(LocalDate localDate, Long boId) {
        return (TrialPeriod)this.getTimeSeqBoEntity(localDate, this.trialPeriodMap, boId);
    }

    public ContrWorkLoc getContrWorkLoc(LocalDate localDate, Long boId) {
        return (ContrWorkLoc)this.getTimeSeqBoEntity(localDate, this.contrWorkLocMap, boId);
    }

    public EmpJobRel getEmpJobRel(LocalDate localDate, Long boId) {
        return (EmpJobRel)this.getTimeSeqBoEntity(localDate, this.empJobRelMap, boId);
    }

    private <T extends AbstractTimeSeqVersion> T getTimeSeqBoEntity(LocalDate localDate, Map<Long, TimeSeqBo<T>> timeSeqBoMap, Long boId) {
        if (localDate == null) {
            throw new KDBizException("Employee.getEmpEntRelTimeSeqBo localDate is null.");
        }
        if (timeSeqBoMap == null) {
            return null;
        }
        return (T)((AbstractTimeSeqVersion)timeSeqBoMap.values().stream().map(timeSeqBo -> (AbstractTimeSeqVersion)timeSeqBo.getVersionByDate(localDate)).filter(Objects::nonNull).max(Comparator.comparing(timeSeqBo -> timeSeqBo.getTimeSeqInfo().getBsed())).orElse(null));
    }

    public Long getFirstEmployeeBid() {
        return this.firstEmployeeBid;
    }

    public void setFirstEmployeeBid(Long firstEmployeeBid) {
        this.firstEmployeeBid = firstEmployeeBid;
    }

    public String toString() {
        return "Employee{startDate=" + this.startDate + ", endDate=" + this.endDate + ", sysEndDate=" + this.sysEndDate + ", enterPrise=" + this.enterPrise + ", laborRelStatus=" + this.laborRelStatus + ", empNumber=" + this.empNumber + ", lastWorkDate=" + this.lastWorkDate + ", laborRelType=" + this.laborRelType + '}';
    }

    public static class Builder {
        private Employee Employee;

        protected Builder(Employee Employee2) {
            this.Employee = Employee2;
        }

        public Builder enterPrise(Long enterPrise) {
            this.Employee.enterPrise = enterPrise;
            return this;
        }

        public Builder lastWorkDate(Date lastWorkDate) {
            this.Employee.lastWorkDate = lastWorkDate;
            return this;
        }

        public Builder laborRelType(Long laborRelType) {
            this.Employee.laborRelType = laborRelType;
            return this;
        }

        public Builder laborRelStatus(Long laborRelStatus) {
            this.Employee.laborRelStatus = laborRelStatus;
            return this;
        }

        public Builder empNumber(String empNumber) {
            this.Employee.empNumber = empNumber;
            return this;
        }

        public Builder startDate(Date startDate) {
            this.Employee.startDate = startDate;
            return this;
        }

        public Builder sysEndDate(Date sysEndDate) {
            this.Employee.sysEndDate = sysEndDate;
            return this;
        }

        public Builder endDate(Date endDate) {
            this.Employee.endDate = endDate;
            return this;
        }

        public Builder firstEmployeeBid(Long firstEmployeeBid) {
            this.Employee.firstEmployeeBid = firstEmployeeBid;
            return this;
        }

        public Employee build() {
            Employee tmp = this.Employee;
            this.Employee = null;
            return tmp;
        }
    }
}

