/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.personfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.IPersonFilterService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionHelper;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.personfilter.utils.WTCBooleanPareUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.tuple.MutablePair;
import kd.wtc.wtbs.common.util.third.tuple.Pair;

public class PersonFilterServiceImpl
implements IPersonFilterService {
    private static final Log logger = LogFactory.getLog(PersonFilterServiceImpl.class);
    private static final PersonFilterServiceImpl PERSON_FILTER_SERVICE = new PersonFilterServiceImpl();
    private static HRBaseServiceHelper CONFIG_HELPER = new HRBaseServiceHelper("wtbd_perfilterconfig");
    private static HRBaseServiceHelper ATTPERSON_HELPER = new HRBaseServiceHelper("wtp_attendperson");
    private static String ATTFILE_PREFIX = "attfile.wtp_attfilebase.";
    private static String ATTPERSON_PREFIX = "attperson.wtp_attendperson.";
    private static Integer BATCH_SIZE = 5000;
    private static String ATT_PERSON = "attperson";

    private PersonFilterServiceImpl() {
    }

    public static PersonFilterServiceImpl getInstance() {
        return PERSON_FILTER_SERVICE;
    }

    @Override
    public Map<String, Object> getFilterInfo(Long baseDataId, String entityNumber, Set<Long> personIds) {
        boolean containAttFile;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        if (baseDataId == null || entityNumber == null || personIds == null) {
            return resultMap;
        }
        RuleConditionInfo accessDto = this.queryConfig(entityNumber, baseDataId);
        if (accessDto == null) {
            return resultMap;
        }
        List conditionList = accessDto.getConditionList();
        List<String> selectPropertiesOfPerson = this.getStrDelPrefix(conditionList, ATTPERSON_PREFIX);
        boolean containPerson = !selectPropertiesOfPerson.isEmpty();
        logger.info("PersonFilterServiceImpl.getFilterInfo selectPropertiesOfPerson={}", selectPropertiesOfPerson);
        List<String> selectPropertiesOfAttFile = this.getStrDelPrefix(conditionList, ATTFILE_PREFIX);
        boolean bl = containAttFile = !selectPropertiesOfAttFile.isEmpty();
        if (selectPropertiesOfAttFile.size() > 0) {
            selectPropertiesOfAttFile.add(ATT_PERSON);
            for (String personKey : selectPropertiesOfPerson) {
                selectPropertiesOfAttFile.add("attperson." + personKey);
            }
            selectPropertiesOfAttFile.add("id");
            selectPropertiesOfAttFile.add("bsed");
            selectPropertiesOfAttFile.add("bsled");
        }
        logger.info("PersonFilterServiceImpl.judgeConditionOfAttFile selectPropertiesOfAttFile={}", selectPropertiesOfAttFile);
        ArrayList<Long> totalBatch = new ArrayList<Long>(personIds);
        HashMap attFileAndDateMap = Maps.newHashMapWithExpectedSize((int)totalBatch.size());
        this.processInBatches(totalBatch, actualBatch -> {
            if (containPerson && !containAttFile) {
                List<Long> result = this.judgeConditionOfPerson((List<Long>)actualBatch, accessDto, selectPropertiesOfPerson, conditionList);
                this.setValue(resultMap, "attperson", result);
            } else if (containAttFile) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)actualBatch.size());
                List<Long> result = this.judgeConditionOfAttFile((List<Long>)actualBatch, accessDto, selectPropertiesOfAttFile, conditionList, map);
                this.setValue(resultMap, "attfile", result);
                if (!map.isEmpty()) {
                    attFileAndDateMap.putAll(map);
                }
            }
        });
        if (!attFileAndDateMap.isEmpty()) {
            resultMap.put("attfile_effdate", attFileAndDateMap);
        }
        return resultMap;
    }

    private <T> void processInBatches(List<T> dataList, Consumer<List<T>> consumer) {
        for (int start = 0; start < dataList.size(); start += BATCH_SIZE.intValue()) {
            int end = Math.min(start + BATCH_SIZE, dataList.size());
            ArrayList<T> batch = new ArrayList<T>(dataList.subList(start, end));
            consumer.accept(batch);
        }
    }

    private List<Long> judgeConditionOfAttFile(List<Long> personIds, RuleConditionInfo accessDto, List<String> selectPropertiesOfAttFile, List<ConditionInfo> conditionList, Map<Long, Pair<Date, Date>> map) {
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setProperties(String.join((CharSequence)",", selectPropertiesOfAttFile));
        queryParam.setBeCurrent(Boolean.FALSE);
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setAttStatus(null);
        queryParam.setAttPersonSetIds(new HashSet<Long>(personIds));
        List<DynamicObject> attFileDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        HashMap packAgeDataMap = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        if (attFileDyList.isEmpty()) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        logger.info("PersonFilterServiceImpl.judgeConditionOfAttFile getAttFile.size()={}", (Object)attFileDyList.size());
        List collect = conditionList.stream().map(ConditionInfo::getParam).collect(Collectors.toList());
        logger.info("PersonFilterServiceImpl.judgeConditionOfAttFile collect={}", collect);
        for (DynamicObject attFileDy : attFileDyList) {
            HashMap packAgeData = Maps.newHashMapWithExpectedSize((int)16);
            for (String conditionKey : collect) {
                String key;
                if (conditionKey.startsWith(ATTPERSON_PREFIX)) {
                    key = WTCStringUtils.delPrefixWithIgnoreCase((String)conditionKey, (String)ATTPERSON_PREFIX);
                    packAgeData.put(conditionKey, attFileDy.get("attperson." + key));
                    continue;
                }
                if (!conditionKey.startsWith(ATTFILE_PREFIX)) continue;
                key = WTCStringUtils.delPrefixWithIgnoreCase((String)conditionKey, (String)ATTFILE_PREFIX);
                packAgeData.put(conditionKey, attFileDy.get(key));
            }
            packAgeDataMap.put(attFileDy.getLong("id"), packAgeData);
        }
        List<Long> attFileIdList = this.judgeByFillData(accessDto, packAgeDataMap, conditionList);
        if (attFileIdList.isEmpty()) {
            return attFileIdList;
        }
        for (DynamicObject attFileDy : attFileDyList) {
            long attFileId = attFileDy.getLong("id");
            if (!attFileIdList.contains(attFileId)) continue;
            map.put(attFileId, (Pair<Date, Date>)new MutablePair((Object)attFileDy.getDate("bsed"), (Object)attFileDy.getDate("bsled")));
        }
        return attFileIdList;
    }

    private List<Long> judgeConditionOfPerson(List<Long> personIds, RuleConditionInfo accessDto, List<String> selectPropertiesOfPerson, List<ConditionInfo> conditionList) {
        List<DynamicObject> personList = this.getAttperson(personIds, String.join((CharSequence)",", selectPropertiesOfPerson));
        if (personList.isEmpty()) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        HashMap packAgeDataMap = Maps.newHashMapWithExpectedSize((int)personList.size());
        List collect = conditionList.stream().map(ConditionInfo::getParam).collect(Collectors.toList());
        for (DynamicObject personDy : personList) {
            HashMap packAgeData = Maps.newHashMapWithExpectedSize((int)selectPropertiesOfPerson.size());
            for (String conditionKey : collect) {
                String key = WTCStringUtils.delPrefixWithIgnoreCase((String)conditionKey, (String)ATTPERSON_PREFIX);
                packAgeData.put(conditionKey, personDy.get(key));
            }
            packAgeDataMap.put(personDy.getLong("id"), packAgeData);
        }
        return this.judgeByFillData(accessDto, packAgeDataMap, conditionList);
    }

    private void setValue(Map<String, Object> resultMap, String key, List<Long> value) {
        Set set = (Set)resultMap.get(key);
        if (set == null) {
            set = Sets.newHashSetWithExpectedSize((int)16);
        }
        if (value == null || value.isEmpty()) {
            resultMap.put(key, set);
            return;
        }
        set.addAll(value);
        resultMap.put(key, set);
    }

    @Override
    public List<Long> filterByPersonIds(Long baseDataId, String entityNumber, Set<Long> personIds) {
        if (baseDataId == null || entityNumber == null || personIds == null) {
            return personIds == null ? Lists.newArrayList() : new ArrayList<Long>(personIds);
        }
        logger.info("PersonFilterServiceImpl into param :baseDataId:{},entityNumber:{},personIds.size:{},personIds.size:{}", new Object[]{baseDataId, entityNumber, personIds.size(), personIds});
        RuleConditionInfo accessDto = this.queryConfig(entityNumber, baseDataId);
        if (accessDto == null) {
            return new ArrayList<Long>(personIds);
        }
        List conditionList = accessDto.getConditionList();
        List<String> paramsOfPerson = this.getStrDelPrefix(conditionList, ATTPERSON_PREFIX);
        List<String> paramsOfFile = this.getStrDelPrefix(conditionList, ATTFILE_PREFIX);
        if (paramsOfFile.size() > 0) {
            paramsOfFile.add(ATT_PERSON);
        }
        ArrayList<Long> totalBatch = new ArrayList<Long>(personIds);
        ArrayList res = Lists.newArrayList();
        while (totalBatch.size() > 0) {
            List actualBatch = WTCCollections.subList(totalBatch, (int)0, (int)(totalBatch.size() > BATCH_SIZE ? BATCH_SIZE.intValue() : totalBatch.size()));
            List<Long> batchRes = this.judgeCondition(actualBatch, accessDto, paramsOfPerson, paramsOfFile);
            res.addAll(batchRes);
            totalBatch.removeAll(actualBatch);
        }
        return res;
    }

    @Override
    public Map<String, Object> saveConfig(String entityNumber, String configJson, Long baseDataId) {
        Map<String, Object> resMap = JudgeConditionService.checkConfigJson(configJson);
        if (resMap.get("isSucess") == Boolean.FALSE) {
            return resMap;
        }
        if (HRStringUtils.isEmpty((String)entityNumber) || baseDataId == null) {
            resMap.put("isSucess", Boolean.FALSE);
            resMap.put("errorMsg", ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u8981\u6c42\u4f20\u5165\u53c2\u6570", (String)"PersonFilterServiceImpl_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            return resMap;
        }
        DynamicObject configDyn = CONFIG_HELPER.generateEmptyDynamicObject();
        configDyn.set("metanumber", (Object)entityNumber);
        configDyn.set("basedataid", (Object)baseDataId);
        configDyn.set("conditions", (Object)configJson);
        DynamicObject res = (DynamicObject)CONFIG_HELPER.saveOne(configDyn);
        if (res != null) {
            resMap.put("isSucess", Boolean.TRUE);
            resMap.put("pkid", res.getPkValue());
        }
        return resMap;
    }

    @Override
    public Map<String, Object> updateConfig(String entityNumber, String configJson, Long baseDataId) {
        Map<String, Object> resMap = JudgeConditionService.checkConfigJson(configJson);
        if (resMap.get("isSucess") == Boolean.FALSE) {
            return resMap;
        }
        QFilter qFilter = new QFilter("metanumber", "=", (Object)entityNumber);
        QFilter qFilter1 = new QFilter("basedataid", "=", (Object)baseDataId);
        DynamicObject configDyn = CONFIG_HELPER.loadDynamicObject(new QFilter[]{qFilter, qFilter1});
        if (configDyn == null) {
            return this.saveConfig(entityNumber, configJson, baseDataId);
        }
        configDyn.set("conditions", (Object)configJson);
        DynamicObject res = (DynamicObject)CONFIG_HELPER.updateOne(configDyn);
        if (res != null) {
            resMap.put("isSucess", Boolean.TRUE);
            resMap.put("pkid", res.getPkValue());
        }
        return resMap;
    }

    @Override
    public String queryConfig(Long pkid) {
        DynamicObject dyn = CONFIG_HELPER.queryOne((Object)pkid);
        return dyn == null ? "" : dyn.getString("conditions");
    }

    private List<Long> judgeCondition(List<Long> personIds, RuleConditionInfo accessDto, List<String> paramsOfPerson, List<String> paramsOfFile) {
        HashMap packAgeDatas = Maps.newHashMapWithExpectedSize((int)personIds.size());
        List conditionList = accessDto.getConditionList();
        Map<Object, Object> personIdMap = Maps.newHashMap();
        if (paramsOfPerson.size() > 0) {
            List<DynamicObject> persons = this.getAttperson(personIds, String.join((CharSequence)",", paramsOfPerson));
            personIdMap = this.getId2DynObjMap(persons, "id");
        }
        Map<Object, Object> fileOfPersonIdMap = Maps.newHashMap();
        if (paramsOfFile.size() > 0) {
            List<DynamicObject> files = this.getActiveAttFile(personIds, String.join((CharSequence)",", paramsOfFile));
            fileOfPersonIdMap = this.getId2DynObjMap(files, ATT_PERSON);
        }
        for (Long personId : personIds) {
            HashMap packAgeData = Maps.newHashMapWithExpectedSize((int)(paramsOfPerson.size() + paramsOfFile.size()));
            DynamicObject person = (DynamicObject)personIdMap.get(personId);
            DynamicObject file = (DynamicObject)fileOfPersonIdMap.get(personId);
            this.fillPackAgeData(packAgeData, person, paramsOfPerson, ATTPERSON_PREFIX);
            this.fillPackAgeData(packAgeData, file, paramsOfFile, ATTFILE_PREFIX);
            packAgeDatas.put(personId, packAgeData);
        }
        logger.info("PersonFilterServiceImpl judgeByFillData packAgeDatas:{}", (Object)packAgeDatas);
        List<Long> filterPersonIds = this.judgeByFillData(accessDto, packAgeDatas, conditionList);
        logger.info("PersonFilterServiceImpl expressStr:{}, filterPersonIds.size:{}, filterPersonIds:{} ", new Object[]{accessDto.getConditionExpressStr(), filterPersonIds.size(), filterPersonIds});
        return filterPersonIds;
    }

    private List<Long> judgeByFillData(RuleConditionInfo accessDto, Map<Long, Map<String, Object>> packAgeDatas, List<ConditionInfo> conditionList) {
        ArrayList filterPersonIds = Lists.newArrayListWithCapacity((int)packAgeDatas.size());
        packAgeDatas.forEach((personId, data) -> {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)data.size());
            conditionList.forEach(conditionDto -> {
                try {
                    JudgeConditionHelper.judgeCondition(data, resultMap, conditionDto);
                }
                catch (Exception e) {
                    logger.error("PersonFilterServiceImpl judgeCondition error personId:{},data:{},error{}", new Object[]{personId, data, e});
                }
            });
            StringBuilder expressStr = JudgeConditionService.getExpressStr(resultMap, accessDto.getConditionExpressList());
            try {
                if (WTCBooleanPareUtils.dealBrackets(String.valueOf(expressStr))) {
                    filterPersonIds.add(personId);
                }
            }
            catch (Exception e) {
                logger.error("PersonFilterServiceImpl dealBrackets error personId:{},expressStr:{},error{}", new Object[]{personId, expressStr, e});
            }
        });
        return filterPersonIds;
    }

    private List<String> getStrDelPrefix(List<ConditionInfo> conditionList, String prefix) {
        List prefixStrs = conditionList.stream().map(ConditionInfo::getParam).filter(param -> param.startsWith(prefix)).collect(Collectors.toList());
        ArrayList params = Lists.newArrayListWithCapacity((int)prefixStrs.size());
        for (String prefixStr : prefixStrs) {
            params.add(WTCStringUtils.delPrefixWithIgnoreCase((String)prefixStr, (String)prefix));
        }
        return params.stream().distinct().collect(Collectors.toList());
    }

    private Map<Long, DynamicObject> getId2DynObjMap(List<DynamicObject> dynamicObjects, String idColumn) {
        Map<Object, Object> personIdMap = Maps.newHashMap();
        if (dynamicObjects != null) {
            personIdMap = dynamicObjects.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong(idColumn), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        }
        return personIdMap;
    }

    private void fillPackAgeData(Map<String, Object> packAgeData, DynamicObject dynamicObject, List<String> params, String prefix) {
        if (dynamicObject == null) {
            return;
        }
        for (String param : params) {
            packAgeData.put(prefix + param, dynamicObject.get(param));
        }
    }

    private List<DynamicObject> getAttperson(List<Long> personIds, String columns) {
        QFilter qFilter = new QFilter("id", "in", personIds);
        return Arrays.asList(ATTPERSON_HELPER.query(columns, new QFilter[]{qFilter}));
    }

    private List<DynamicObject> getActiveAttFile(List<Long> personIds, String columns) {
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setProperties(columns);
        queryParam.setBeCurrent(Boolean.TRUE);
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setAttPersonSetIds(new HashSet<Long>(personIds));
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
    }

    private RuleConditionInfo queryConfig(String entityNumber, Long baseDataId) {
        DynamicObject query = CONFIG_HELPER.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)entityNumber), new QFilter("basedataid", "=", (Object)baseDataId)});
        if (query == null) {
            logger.warn("PersonFilterServiceImpl_queryConfig query result is null,entityNumber = {},baseDataId = {}", (Object)entityNumber, (Object)baseDataId);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u6ee4\u914d\u7f6e\u4e0d\u5b58\u5728\u3002", (String)"PersonFilterServiceImpl_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        String conditions = query.getString("conditions");
        try {
            return (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        }
        catch (Exception e) {
            logger.error("JsonProcessingException:", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public List<DynamicObject> batchQueryConfig(String entityNumber, List<Long> baseDataId) {
        return Arrays.asList(CONFIG_HELPER.query("conditions,basedataid,metanumber", new QFilter[]{new QFilter("metanumber", "=", (Object)entityNumber), new QFilter("basedataid", "in", baseDataId)}));
    }
}

