/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.personfilter.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.business.rulecondition.RuleConditionResultMatchService;
import kd.wtc.wtbs.business.rulecondition.ThreeFunction;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class JudgeConditionHelper {
    public static final Log log = LogFactory.getLog(JudgeConditionHelper.class);

    public static void judgeCondition(Map<String, Object> data, Map<String, Boolean> resultMap, ConditionInfo conditionDto) {
        String paramName = conditionDto.getParam().toLowerCase();
        JudgeConditionHelper.judgeCondition(data, resultMap, conditionDto, paramName);
    }

    public static void judgeConditionOriginalParam(Map<String, Object> data, Map<String, Boolean> resultMap, ConditionInfo conditionDto) {
        String paramType = conditionDto.getParamType();
        ThreeFunction<ConditionDto, Object, Map<String, Boolean>> paramMatchFunc = RuleConditionResultMatchService.getParamMatchFunc(paramType);
        String paramName = conditionDto.getParam();
        Object value = data.get(paramName);
        paramMatchFunc.apply(JudgeConditionHelper.toConditionDto(conditionDto), value, resultMap);
    }

    private static ConditionDto toConditionDto(ConditionInfo conditionInfo) {
        ConditionDto conditionDto = new ConditionDto();
        conditionDto.setOperators(conditionInfo.getOperators());
        conditionDto.setValue(conditionInfo.getValue());
        conditionDto.setParamType(conditionInfo.getParamType());
        conditionDto.setDisplayParam(conditionInfo.getDisplayParam());
        conditionDto.setParam(conditionInfo.getParam());
        conditionDto.setDisplayValue(conditionInfo.getDisplayValue());
        conditionDto.setDateFormat(conditionInfo.getDateFormat());
        conditionDto.setIndex(conditionInfo.getIndex());
        conditionDto.setName(conditionInfo.getName());
        conditionDto.setValueDateFormat(conditionInfo.getValueDateFormat());
        conditionDto.setValueType(conditionInfo.getValueType());
        conditionDto.setObjectId(conditionInfo.getObjectId());
        conditionDto.setObjectNumber(conditionInfo.getObjectNumber());
        conditionDto.setTarget(Boolean.toString(conditionInfo.isTarget()));
        return conditionDto;
    }

    private static void judgeCondition(Map<String, Object> data, Map<String, Boolean> resultMap, ConditionInfo conditionDto, String paramName) {
        Object value = conditionDto.getValue();
        if (WTCStringUtils.equals((String)conditionDto.getValueType(), (String)"1")) {
            value = ((String)value).toLowerCase();
            value = data.get(value);
        }
        Object paramValue = data.get(paramName);
        String operators = conditionDto.getOperators();
        String paramType = conditionDto.getParamType();
        RuleParamTypeEnum typeEnum = RuleParamTypeEnum.getEnum(paramType);
        RuleOperatorEnum operatorEnum = RuleOperatorEnum.getEnum(operators);
        boolean isFit = false;
        switch (typeEnum) {
            case BOOLEAN: {
                isFit = JudgeConditionHelper.judgeBooleanCondition(value, paramValue, operatorEnum);
                break;
            }
            case DATE: {
                isFit = JudgeConditionHelper.judgeDateCondition(value, paramValue, operatorEnum);
                break;
            }
            case STRING: {
                isFit = JudgeConditionHelper.judgeStringCondition(value, paramValue, operatorEnum);
                break;
            }
            case NUMBER: {
                isFit = JudgeConditionHelper.judgeNumberCondition(value, paramValue, operatorEnum);
                break;
            }
            case ENUM: {
                isFit = JudgeConditionHelper.judgeEnumCondition(value, paramValue, operatorEnum);
                break;
            }
            case DYNAMICOBJECT: {
                isFit = JudgeConditionHelper.judgeObjCondition(value, paramValue, operatorEnum);
                break;
            }
        }
        resultMap.put(conditionDto.getName(), isFit);
    }

    public static boolean judgeBooleanCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudgeConditionHelper.booleanEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudgeConditionHelper.booleanNotEquals(value, paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean booleanNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !WTCStringUtils.equals((String)paramValue.toString(), (String)value.toString());
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean booleanEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = WTCStringUtils.equals((String)paramValue.toString(), (String)value.toString());
        }
        return isFit;
    }

    public static boolean judgeDateCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudgeConditionHelper.dateEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudgeConditionHelper.dateNotEquals(value, paramValue);
                break;
            }
            case IS_NULL: {
                isFit = paramValue == null;
                break;
            }
            case IS_NOT_NULL: {
                isFit = paramValue != null;
                break;
            }
            case LESS_THAN: {
                isFit = JudgeConditionHelper.dateLessThan(value, paramValue);
                break;
            }
            case LESS_OR_EQUAL: {
                isFit = JudgeConditionHelper.dateLessOrEqual(value, paramValue);
                break;
            }
            case GREATER_THAN: {
                isFit = JudgeConditionHelper.dateGreaterThan(value, paramValue);
                break;
            }
            case GREATER_OR_EQUAL: {
                isFit = JudgeConditionHelper.dateGreaterOrEqual(value, paramValue);
                break;
            }
            case TODAY: {
                isFit = JudgeConditionHelper.dateToday(paramValue);
                break;
            }
            case YESTERDAY: {
                isFit = JudgeConditionHelper.dateYesterday(paramValue);
                break;
            }
            case TOMORROW: {
                isFit = JudgeConditionHelper.dateTomorrow(paramValue);
                break;
            }
            case THIS_WEEK: {
                isFit = JudgeConditionHelper.dateThisWeek(paramValue);
                break;
            }
            case LAST_WEEK: {
                isFit = JudgeConditionHelper.dateLastWeek(paramValue);
                break;
            }
            case NEXT_WEEK: {
                isFit = JudgeConditionHelper.dateNextWeek(paramValue);
                break;
            }
            case THIS_MONTH: {
                isFit = JudgeConditionHelper.dateThisMonth(paramValue);
                break;
            }
            case LAST_MONTH: {
                isFit = JudgeConditionHelper.dateLastMonth(paramValue);
                break;
            }
            case NEXT_MONTH: {
                isFit = JudgeConditionHelper.dateNextMonth(paramValue);
                break;
            }
            case LAST3MONTH: {
                isFit = JudgeConditionHelper.dateLast3Month(paramValue);
                break;
            }
            case NEXT3MONTH: {
                isFit = JudgeConditionHelper.dateNext3Month(paramValue);
                break;
            }
            case THIS_QUARTER: {
                isFit = JudgeConditionHelper.dateThisQuarter(paramValue);
                break;
            }
            case LAST_QUARTER: {
                isFit = JudgeConditionHelper.dateLastQuarter(paramValue);
                break;
            }
            case NEXT_QUARTER: {
                isFit = JudgeConditionHelper.dateNextQuarter(paramValue);
                break;
            }
            case THIS_YEAR: {
                isFit = JudgeConditionHelper.dateThisYear(paramValue);
                break;
            }
            case LAST_YEAR: {
                isFit = JudgeConditionHelper.dateLastYear(paramValue);
                break;
            }
            case NEXT_YEAR: {
                isFit = JudgeConditionHelper.dateNextYear(paramValue);
                break;
            }
            case LESS_THAN_DAY: {
                isFit = JudgeConditionHelper.dateLessThanDay(value, paramValue);
                break;
            }
            case GREATER_THAN_DAY: {
                isFit = JudgeConditionHelper.dateGreaterThanDay(value, paramValue);
                break;
            }
            case LESS_OR_EQUAL_DAY: {
                isFit = JudgeConditionHelper.dateLessOrEqualDay(value, paramValue);
                break;
            }
            case GREATER_OR_EQUAL_DAY: {
                isFit = JudgeConditionHelper.dateGreateROrEqualDay(value, paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean dateEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            value = JudgeConditionHelper.tranStrToDate(value);
            paramValue = JudgeConditionHelper.tranStrToDate(paramValue);
            isFit = value.equals(paramValue);
        }
        return isFit;
    }

    public static boolean dateNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !(value = JudgeConditionHelper.tranStrToDate(value)).equals(paramValue = JudgeConditionHelper.tranStrToDate(paramValue));
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean dateLessThan(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudgeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            isFit = paramValueDate.before(valueDate);
        }
        return isFit;
    }

    public static boolean dateLessOrEqual(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudgeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            isFit = !paramValueDate.after(valueDate);
        }
        return isFit;
    }

    public static boolean dateGreaterThan(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudgeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            isFit = paramValueDate.after(valueDate);
        }
        return isFit;
    }

    public static boolean dateGreaterOrEqual(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            Date valueDate = JudgeConditionHelper.tranStrToDate(value);
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            isFit = !paramValueDate.before(valueDate);
        }
        return isFit;
    }

    public static boolean dateToday(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date today = JudgeConditionHelper.tranStrToDate(new Date());
            isFit = paramValueDate.equals(today);
        }
        return isFit;
    }

    public static boolean dateYesterday(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            Date yesterday = JudgeConditionHelper.tranStrToDate(calendar.getTime());
            isFit = paramValueDate.equals(yesterday);
        }
        return isFit;
    }

    public static boolean dateTomorrow(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, 1);
            Date tomorrow = JudgeConditionHelper.tranStrToDate(calendar.getTime());
            isFit = paramValueDate.equals(tomorrow);
        }
        return isFit;
    }

    public static boolean dateThisWeek(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekStart((int)0));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastWeek(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekStart((int)-1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextWeek(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekStart((int)1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheWeekEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateThisMonth(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthStart((int)0));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastMonth(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthStart((int)-1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextMonth(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthStart((int)1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheMonthEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLast3Month(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(2, -3);
            Date startDate = JudgeConditionHelper.tranStrToDate(calendar.getTime());
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.addDays((Date)new Date(), (int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNext3Month(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(2, 3);
            Date endDate = JudgeConditionHelper.tranStrToDate(calendar.getTime());
            Date startDate = JudgeConditionHelper.tranStrToDate(new Date());
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateThisQuarter(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterStart((int)0));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastQuarter(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterStart((int)-1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextQuarter(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterStart((int)1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheQuarterEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateThisYear(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheYearStart((int)0));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheYearEnd((int)0));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLastYear(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheYearStart((int)-1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheYearEnd((int)-1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateNextYear(Object paramValue) {
        boolean isFit = false;
        if (paramValue != null) {
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            Date startDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheYearStart((int)1));
            Date endDate = JudgeConditionHelper.tranStrToDate(KDDateUtils.getTheYearEnd((int)1));
            isFit = !paramValueDate.before(startDate) && paramValueDate.before(endDate);
        }
        return isFit;
    }

    public static boolean dateLessThanDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudgeConditionHelper.tranStrToDate(value);
                valueDay = WTCDateUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = WTCDateUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay < valueDay;
        }
        return isFit;
    }

    public static boolean dateGreaterThanDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudgeConditionHelper.tranStrToDate(value);
                valueDay = WTCDateUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = WTCDateUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay > valueDay;
        }
        return isFit;
    }

    public static boolean dateLessOrEqualDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudgeConditionHelper.tranStrToDate(value);
                valueDay = WTCDateUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = WTCDateUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay <= valueDay;
        }
        return isFit;
    }

    public static boolean dateGreateROrEqualDay(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            int valueDay;
            if (value instanceof String) {
                valueDay = Integer.parseInt((String)value);
            } else {
                Date valueDate = JudgeConditionHelper.tranStrToDate(value);
                valueDay = WTCDateUtils.getDay((Date)valueDate);
            }
            Date paramValueDate = JudgeConditionHelper.tranStrToDate(paramValue);
            int paramValueDay = WTCDateUtils.getDay((Date)paramValueDate);
            isFit = paramValueDay >= valueDay;
        }
        return isFit;
    }

    public static Date tranStrToDate(Object value) {
        if (value instanceof String) {
            try {
                value = WTCDateUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                log.error("\u65f6\u95f4\u8f6c\u5316\u62a5\u9519:{}", (Object)e.getMessage());
            }
        } else if (value instanceof Date) {
            value = WTCDateUtils.getDayStartTime((Date)((Date)value));
        }
        return (Date)value;
    }

    public static boolean judgeStringCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudgeConditionHelper.stringEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudgeConditionHelper.stringNotEquals(value, paramValue);
                break;
            }
            case IN: {
                isFit = JudgeConditionHelper.stringIn((String)value, (String)paramValue);
                break;
            }
            case NOT_IN: {
                isFit = JudgeConditionHelper.stringNotIn((String)value, (String)paramValue);
                break;
            }
            case IS_NULL: {
                isFit = WTCStringUtils.isEmpty((String)((String)paramValue));
                break;
            }
            case IS_NOT_NULL: {
                isFit = WTCStringUtils.isNotEmpty((String)((String)paramValue));
                break;
            }
            case CONTAINS: {
                isFit = JudgeConditionHelper.stringContains((String)value, (String)paramValue);
                break;
            }
            case NOT_CONTAINS: {
                isFit = JudgeConditionHelper.stringNotContains((String)value, (String)paramValue);
                break;
            }
            case STARTS_WITH: {
                isFit = JudgeConditionHelper.stringStartsWith((String)value, (String)paramValue);
                break;
            }
            case ENDS_WITH: {
                isFit = JudgeConditionHelper.stringEndsWith((String)value, (String)paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean judgeNumberCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudgeConditionHelper.numberEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudgeConditionHelper.numberNotEquals(value, paramValue);
                break;
            }
            case LESS_THAN: {
                isFit = JudgeConditionHelper.numberLessThanEquals(value, paramValue);
                break;
            }
            case GREATER_THAN: {
                isFit = JudgeConditionHelper.numberGreaterThanEquals(value, paramValue);
                break;
            }
            case LESS_OR_EQUAL: {
                isFit = JudgeConditionHelper.numberLessOrEquals(value, paramValue);
                break;
            }
            case GREATER_OR_EQUAL: {
                isFit = JudgeConditionHelper.numberGreaterOrEquals(value, paramValue);
                break;
            }
        }
        return isFit;
    }

    public static boolean judgeEnumCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudgeConditionHelper.stringEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudgeConditionHelper.stringNotEquals(value, paramValue);
                break;
            }
            case IN: {
                isFit = JudgeConditionHelper.stringIn((String)value, (String)paramValue);
                break;
            }
            case NOT_IN: {
                isFit = JudgeConditionHelper.stringNotIn((String)value, (String)paramValue);
                break;
            }
            case IS_NULL: {
                isFit = WTCStringUtils.isEmpty((String)((String)paramValue));
                break;
            }
            case IS_NOT_NULL: {
                isFit = WTCStringUtils.isNotEmpty((String)((String)paramValue));
                break;
            }
        }
        return isFit;
    }

    public static boolean judgeObjCondition(Object value, Object paramValue, RuleOperatorEnum operatorEnum) {
        boolean isFit = false;
        switch (operatorEnum) {
            case EQUAL: {
                isFit = JudgeConditionHelper.objEquals(value, paramValue);
                break;
            }
            case NOT_EQUAL: {
                isFit = JudgeConditionHelper.objNotEquals(value, paramValue);
                break;
            }
            case IN: {
                isFit = JudgeConditionHelper.objIn(value, paramValue);
                break;
            }
            case NOT_IN: {
                isFit = JudgeConditionHelper.objNotIn(value, paramValue);
                break;
            }
            case IS_NULL: {
                isFit = paramValue == null || WTCStringUtils.equals((String)paramValue.toString(), (String)"0");
                break;
            }
            case IS_NOT_NULL: {
                isFit = paramValue != null && !WTCStringUtils.equals((String)paramValue.toString(), (String)"0");
                break;
            }
        }
        return isFit;
    }

    public static boolean stringEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = WTCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        }
        return isFit;
    }

    public static boolean stringNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !WTCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean stringIn(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            for (String str : strs = value.split(",")) {
                if (!WTCStringUtils.equals((String)str, (String)paramValue)) continue;
                isFit = true;
                break;
            }
        }
        return isFit;
    }

    public static boolean stringNotIn(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            isFit = true;
            for (String str : strs = value.split(",")) {
                if (!WTCStringUtils.equals((String)str, (String)paramValue)) continue;
                isFit = false;
                break;
            }
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean stringNotContains(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !paramValue.contains(value);
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean stringContains(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = paramValue.contains(value);
        }
        return isFit;
    }

    public static boolean stringStartsWith(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = paramValue.startsWith(value);
        }
        return isFit;
    }

    public static boolean stringEndsWith(String value, String paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = paramValue.endsWith(value);
        }
        return isFit;
    }

    public static boolean numberEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalParamValue;
            BigDecimal decimalValue = new BigDecimal(value.toString());
            isFit = decimalValue.compareTo(decimalParamValue = new BigDecimal(paramValue.toString())) == 0;
        }
        return isFit;
    }

    public static boolean numberNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalParamValue;
            BigDecimal decimalValue = new BigDecimal(value.toString());
            isFit = decimalValue.compareTo(decimalParamValue = new BigDecimal(paramValue.toString())) != 0;
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean numberLessThanEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) < 0;
        }
        return isFit;
    }

    public static boolean numberGreaterThanEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) > 0;
        }
        return isFit;
    }

    public static boolean numberLessOrEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) <= 0;
        }
        return isFit;
    }

    public static boolean numberGreaterOrEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            BigDecimal decimalValue = new BigDecimal(value.toString());
            BigDecimal decimalParamValue = new BigDecimal(paramValue.toString());
            isFit = decimalParamValue.compareTo(decimalValue) >= 0;
        }
        return isFit;
    }

    public static boolean objEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = WTCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        }
        return isFit;
    }

    public static boolean objNotEquals(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            isFit = !WTCStringUtils.equals((String)value.toString(), (String)paramValue.toString());
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }

    public static boolean objIn(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            String valueStr = value.toString();
            for (String str : strs = valueStr.split(",")) {
                if (!WTCStringUtils.equals((String)str, (String)paramValue.toString())) continue;
                isFit = true;
                break;
            }
        }
        return isFit;
    }

    public static boolean objNotIn(Object value, Object paramValue) {
        boolean isFit = false;
        if (paramValue != null && value != null) {
            String[] strs;
            isFit = true;
            String valueStr = value.toString();
            for (String str : strs = valueStr.split(",")) {
                if (!WTCStringUtils.equals((String)str, (String)paramValue.toString())) continue;
                isFit = false;
                break;
            }
        } else if (paramValue != null && value == null) {
            isFit = true;
        }
        return isFit;
    }
}

