/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.plugin;

import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.web.pluginmgt.PluginManagementService;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class PluginServiceHelper {
    private static PluginServiceHelper pluginServiceHelper = new PluginServiceHelper();
    private static final Log logger = LogFactory.getLog(PluginServiceHelper.class);

    private PluginServiceHelper() {
    }

    public static PluginServiceHelper getInstance() {
        return pluginServiceHelper;
    }

    public static <T> T getObject(Class<T> classType, String classPath) {
        try {
            Class<?> newClass = Class.forName(classPath);
            Object obj = newClass.newInstance();
            if (classType.isInstance(obj)) {
                return (T)obj;
            }
            logger.info("{} is not implements {}", (Object)classPath, (Object)classType.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("ClassNotFound : {}", (Object)classPath);
        }
        catch (IllegalAccessException e) {
            logger.error("ClassNotPublic : {}", (Object)classPath);
        }
        catch (InstantiationException e) {
            logger.error("Class Can't newInstance : {}", (Object)classPath);
        }
        return null;
    }

    public static <T> T getPluginObject(Class<T> classType, Long pluginId) {
        String classPath = PluginServiceHelper.getPluginPathById(classType.getName(), pluginId);
        T object = PluginServiceHelper.getObject(classType, classPath);
        return object;
    }

    public static String getPluginPathById(String className, Long pluginId) {
        String cacheKey;
        DistributeSessionlessCache cache = WTCCacheUtils.getCache();
        String classPath = (String)cache.get(cacheKey = WTCCacheUtils.getKey((String)"wtbs", (String)(className + "_" + pluginId)));
        if (WTCStringUtils.isEmpty((String)classPath)) {
            QFilter qf = new QFilter("id", "=", (Object)pluginId);
            DynamicObject pluginObj = PluginManagementService.pluginRegisterService.queryOne(new QFilter[]{qf});
            classPath = pluginObj.getString("classpath");
            if (WTCStringUtils.isNotEmpty((String)classPath)) {
                cache.put(cacheKey, (Object)classPath);
            }
        }
        return classPath;
    }
}

